/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractCoalescingBufferQueue;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public class DefaultHttp2ConnectionEncoder
implements Http2ConnectionEncoder,
Http2SettingsReceivedConsumer {
    private final Http2FrameWriter frameWriter;
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Queue<Http2Settings> outstandingLocalSettingsQueue = new ArrayDeque<Http2Settings>(4);
    private Queue<Http2Settings> outstandingRemoteSettingsQueue;

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2ConnectionEncoder(Http2Connection connection, Http2FrameWriter frameWriter) {
        void var2_2;
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this.frameWriter = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)var2_2, (String)"frameWriter");
        if (connection.remote().flowController() == null) {
            void var1_1;
            connection.remote().flowController(new DefaultHttp2RemoteFlowController((Http2Connection)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        void var1_1;
        this.lifecycleManager = (Http2LifecycleManager)ObjectUtil.checkNotNull((Object)var1_1, (String)"lifecycleManager");
    }

    @Override
    public Http2FrameWriter frameWriter() {
        return this.frameWriter;
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2RemoteFlowController flowController() {
        return this.connection().remote().flowController();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remoteSettings(Http2Settings settings) throws Http2Exception {
        Integer initialWindowSize;
        Integer maxFrameSize;
        Long maxHeaderListSize;
        Long headerTableSize;
        Long maxConcurrentStreams;
        Boolean pushEnabled = settings.pushEnabled();
        Http2FrameWriter.Configuration config = this.configuration();
        Http2HeadersEncoder.Configuration outboundHeaderConfig = config.headersConfiguration();
        Http2FrameSizePolicy outboundFrameSizePolicy = config.frameSizePolicy();
        if (pushEnabled != null) {
            if (!this.connection.isServer() && pushEnabled.booleanValue()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client received a value of ENABLE_PUSH specified to other than 0", new Object[0]);
            }
            this.connection.remote().allowPushTo(pushEnabled);
        }
        if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
            this.connection.local().maxActiveStreams((int)Math.min(maxConcurrentStreams, Integer.MAX_VALUE));
        }
        if ((headerTableSize = settings.headerTableSize()) != null) {
            outboundHeaderConfig.maxHeaderTableSize(headerTableSize);
        }
        if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
            outboundHeaderConfig.maxHeaderListSize(maxHeaderListSize);
        }
        if ((maxFrameSize = settings.maxFrameSize()) != null) {
            void var2_2;
            void var3_3;
            var3_3.maxFrameSize(var2_2.intValue());
        }
        if ((initialWindowSize = settings.initialWindowSize()) != null) {
            void var1_1;
            this.flowController().initialWindowSize(var1_1.intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
        void var3_4;
        void var1_1;
        Http2Stream stream;
        promise = promise.unvoid();
        try {
            void var2_3;
            stream = this.requireStream((int)var2_3);
            switch (stream.state()) {
                case OPEN: 
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Stream " + stream.id() + " in unexpected state " + (Object)((Object)stream.state()));
                }
            }
        }
        catch (Throwable e) {
            data.release();
            return promise.setFailure(e);
        }
        this.flowController().addFlowControlled(stream, new FlowControlledData((Http2Stream)var1_1, (ByteBuf)var3_4, padding, endOfStream, promise));
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeHeaders0((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, false, 0, (short)0, false, padding, endStream, promise);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateHeadersSentState(Http2Stream stream, Http2Headers headers, boolean isServer, boolean endOfStream) {
        void var1_2;
        boolean isInformational = isServer && HttpStatusClass.valueOf((CharSequence)headers.status()) == HttpStatusClass.INFORMATIONAL;
        if ((isInformational || !endOfStream) && stream.isHeadersSent() || stream.isTrailersSent()) {
            void var3_4;
            Http2Stream http2Stream;
            throw new IllegalStateException("Stream " + http2Stream.id() + " sent too many headers EOS: " + (boolean)var3_4);
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.writeHeaders0((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, true, streamDependency, weight, exclusive, padding, endOfStream, promise);
    }

    /*
     * WARNING - void declaration
     */
    private static ChannelFuture sendHeaders(Http2FrameWriter frameWriter, ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean hasPriority, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        Http2FrameWriter http2FrameWriter;
        if (hasPriority) {
            return frameWriter.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endOfStream, promise);
        }
        return http2FrameWriter.writeHeaders((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, padding, endOfStream, promise);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelFuture writeHeaders0(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean hasPriority, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        try {
            void var12_15;
            void var3_4;
            Http2Stream stream = this.connection.stream(streamId);
            if (stream == null) {
                try {
                    stream = this.connection.local().createStream(streamId, false);
                }
                catch (Http2Exception cause) {
                    if (this.connection.remote().mayHaveCreatedStream(streamId)) {
                        promise.tryFailure((Throwable)new IllegalStateException("Stream no longer exists: " + streamId, cause));
                        return promise;
                    }
                    throw cause;
                }
            } else {
                switch (stream.state()) {
                    case RESERVED_LOCAL: {
                        stream.open(endOfStream);
                        break;
                    }
                    case OPEN: 
                    case HALF_CLOSED_REMOTE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Stream " + stream.id() + " in unexpected state " + (Object)((Object)stream.state()));
                    }
                }
            }
            Http2RemoteFlowController flowController = this.flowController();
            if (!endOfStream || !flowController.hasFlowControlled(stream)) {
                void var2_3;
                promise = promise.unvoid();
                boolean isInformational = DefaultHttp2ConnectionEncoder.validateHeadersSentState(stream, headers, this.connection.isServer(), endOfStream);
                ChannelFuture future = DefaultHttp2ConnectionEncoder.sendHeaders(this.frameWriter, ctx, streamId, headers, hasPriority, streamDependency, weight, exclusive, padding, endOfStream, promise);
                Throwable failureCause = future.cause();
                if (failureCause == null) {
                    stream.headersSent(isInformational);
                    if (!future.isSuccess()) {
                        this.notifyLifecycleManagerOnError(future, ctx);
                    }
                } else {
                    this.lifecycleManager.onError(ctx, true, (Throwable)var3_4);
                }
                if (endOfStream) {
                    this.lifecycleManager.closeStreamLocal(stream, future);
                }
                return var2_3;
            }
            var12_15.addFlowControlled(stream, new FlowControlledHeaders(stream, (Http2Headers)var3_4, hasPriority, streamDependency, weight, exclusive, padding, true, promise));
            return promise;
        }
        catch (Throwable t) {
            void var1_1;
            this.lifecycleManager.onError((ChannelHandlerContext)var1_1, true, t);
            promise.tryFailure(t);
            return promise;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePriority(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.frameWriter.writePriority((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3, weight, exclusive, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.lifecycleManager.resetStream((ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext ctx, Http2Settings settings, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.outstandingLocalSettingsQueue.add(settings);
        try {
            Boolean bl = settings.pushEnabled();
            if (bl != null && this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
        }
        catch (Throwable e) {
            return promise.setFailure(e);
        }
        return this.frameWriter.writeSettings((ChannelHandlerContext)var1_1, (Http2Settings)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var2_2;
        if (this.outstandingRemoteSettingsQueue == null) {
            return this.frameWriter.writeSettingsAck(ctx, promise);
        }
        Http2Settings settings = this.outstandingRemoteSettingsQueue.poll();
        if (settings == null) {
            return promise.setFailure((Throwable)new Http2Exception(Http2Error.INTERNAL_ERROR, "attempted to write a SETTINGS ACK with no  pending SETTINGS"));
        }
        Http2CodecUtil.SimpleChannelPromiseAggregator aggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        this.frameWriter.writeSettingsAck(ctx, aggregator.newPromise());
        ChannelPromise applySettingsPromise = aggregator.newPromise();
        try {
            this.remoteSettings(settings);
            applySettingsPromise.setSuccess();
        }
        catch (Throwable e) {
            void var3_4;
            void var1_1;
            applySettingsPromise.setFailure(e);
            this.lifecycleManager.onError((ChannelHandlerContext)var1_1, true, (Throwable)var3_4);
        }
        return var2_2.doneAllocatingPromises();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePing(ChannelHandlerContext ctx, boolean ack, long data, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.frameWriter.writePing((ChannelHandlerContext)var1_1, (boolean)var2_2, (long)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding, ChannelPromise promise) {
        try {
            void var2_3;
            if (this.connection.goAwayReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Sending PUSH_PROMISE after GO_AWAY received.", new Object[0]);
            }
            Http2Stream stream = this.requireStream(streamId);
            this.connection.local().reservePushStream(promisedStreamId, stream);
            promise = promise.unvoid();
            ChannelFuture future = this.frameWriter.writePushPromise(ctx, streamId, promisedStreamId, headers, padding, promise);
            Throwable failureCause = future.cause();
            if (failureCause == null) {
                stream.pushPromiseSent();
                if (!future.isSuccess()) {
                    this.notifyLifecycleManagerOnError(future, ctx);
                }
            } else {
                void var3_5;
                this.lifecycleManager.onError(ctx, true, (Throwable)var3_5);
            }
            return var2_3;
        }
        catch (Throwable t) {
            void var1_1;
            this.lifecycleManager.onError((ChannelHandlerContext)var1_1, true, t);
            promise.tryFailure(t);
            return promise;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.lifecycleManager.goAway((ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3, debugData, promise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement, ChannelPromise promise) {
        return promise.setFailure((Throwable)new UnsupportedOperationException("Use the Http2[Inbound|Outbound]FlowController objects to control window sizes"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.frameWriter.writeFrame((ChannelHandlerContext)var1_1, (byte)var2_2, (int)var3_3, flags, payload, promise);
    }

    @Override
    public void close() {
        this.frameWriter.close();
    }

    @Override
    public Http2Settings pollSentSettings() {
        return this.outstandingLocalSettingsQueue.poll();
    }

    @Override
    public Http2FrameWriter.Configuration configuration() {
        return this.frameWriter.configuration();
    }

    /*
     * WARNING - void declaration
     */
    private Http2Stream requireStream(int streamId) {
        void var2_3;
        Http2Stream stream = this.connection.stream(streamId);
        if (stream == null) {
            void var1_2;
            void message22;
            String message22 = this.connection.streamMayHaveExisted(streamId) ? "Stream no longer exists: " + streamId : "Stream does not exist: " + (int)message22;
            throw new IllegalArgumentException((String)var1_2);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void consumeReceivedSettings(Http2Settings settings) {
        void var1_1;
        if (this.outstandingRemoteSettingsQueue == null) {
            this.outstandingRemoteSettingsQueue = new ArrayDeque<Http2Settings>(2);
        }
        this.outstandingRemoteSettingsQueue.add((Http2Settings)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void notifyLifecycleManagerOnError(ChannelFuture future, ChannelHandlerContext ctx) {
        void var2_2;
        future.addListener((GenericFutureListener)new ChannelFutureListener(this, (ChannelHandlerContext)var2_2){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ DefaultHttp2ConnectionEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                Throwable cause = future.cause();
                if (cause != null) {
                    void var1_1;
                    this.this$0.lifecycleManager.onError(this.val$ctx, true, (Throwable)var1_1);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$200(Http2Stream x0, Http2Headers x1, boolean x2, boolean x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return DefaultHttp2ConnectionEncoder.validateHeadersSentState(x0, (Http2Headers)var1_1, (boolean)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ChannelFuture access$400(Http2FrameWriter x0, ChannelHandlerContext x1, int x2, Http2Headers x3, boolean x4, int x5, short x6, boolean x7, int x8, boolean x9, ChannelPromise x10) {
        void var3_3;
        void var2_2;
        void var1_1;
        return DefaultHttp2ConnectionEncoder.sendHeaders(x0, (ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, x4, x5, x6, x7, x8, x9, x10);
    }

    public abstract class FlowControlledBase
    implements ChannelFutureListener,
    Http2RemoteFlowController.FlowControlled {
        protected final Http2Stream stream;
        protected ChannelPromise promise;
        protected boolean endOfStream;
        protected int padding;
        final /* synthetic */ DefaultHttp2ConnectionEncoder this$0;

        /*
         * WARNING - void declaration
         */
        FlowControlledBase(DefaultHttp2ConnectionEncoder this$0, Http2Stream stream, int padding, boolean endOfStream, ChannelPromise promise) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            ObjectUtil.checkPositiveOrZero((int)padding, (String)"padding");
            this.padding = var3_3;
            this.endOfStream = endOfStream;
            this.stream = var2_2;
            this.promise = promise;
        }

        @Override
        public void writeComplete() {
            if (this.endOfStream) {
                this.this$0.lifecycleManager.closeStreamLocal(this.stream, (ChannelFuture)this.promise);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                void var1_1;
                FlowControlledBase flowControlledBase = this;
                flowControlledBase.error(flowControlledBase.this$0.flowController().channelHandlerContext(), var1_1.cause());
            }
        }
    }

    private final class FlowControlledHeaders
    extends FlowControlledBase {
        private final Http2Headers headers;
        private final boolean hasPriority;
        private final int streamDependency;
        private final short weight;
        private final boolean exclusive;

        /*
         * WARNING - void declaration
         */
        FlowControlledHeaders(Http2Stream stream, Http2Headers headers, boolean hasPriority, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            super(DefaultHttp2ConnectionEncoder.this, (Http2Stream)var2_2, padding, endOfStream, promise.unvoid());
            this.headers = var3_3;
            this.hasPriority = hasPriority;
            this.streamDependency = streamDependency;
            this.weight = weight;
            this.exclusive = exclusive;
        }

        @Override
        public final int size() {
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void error(ChannelHandlerContext ctx, Throwable cause) {
            void var2_2;
            if (ctx != null) {
                void var1_1;
                DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError((ChannelHandlerContext)var1_1, true, cause);
            }
            this.promise.tryFailure((Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ChannelHandlerContext ctx, int allowedBytes) {
            Object object;
            boolean isInformational = DefaultHttp2ConnectionEncoder.access$200(this.stream, this.headers, DefaultHttp2ConnectionEncoder.this.connection.isServer(), this.endOfStream);
            this.promise.addListener((GenericFutureListener)this);
            object = DefaultHttp2ConnectionEncoder.access$400(DefaultHttp2ConnectionEncoder.this.frameWriter, (ChannelHandlerContext)object, this.stream.id(), this.headers, this.hasPriority, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream, this.promise);
            object = object.cause();
            if (object == null) {
                void var2_2;
                this.stream.headersSent((boolean)var2_2);
            }
        }

        @Override
        public final boolean merge(ChannelHandlerContext ctx, Http2RemoteFlowController.FlowControlled next) {
            return false;
        }
    }

    private final class FlowControlledData
    extends FlowControlledBase {
        private final CoalescingBufferQueue queue;
        private int dataSize;

        /*
         * WARNING - void declaration
         */
        FlowControlledData(Http2Stream stream, ByteBuf buf, int padding, boolean endOfStream, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            super(DefaultHttp2ConnectionEncoder.this, (Http2Stream)var2_2, padding, endOfStream, promise);
            this.queue = new CoalescingBufferQueue(promise.channel());
            this.queue.add((ByteBuf)var3_3, promise);
            this.dataSize = this.queue.readableBytes();
        }

        @Override
        public final int size() {
            return this.dataSize + this.padding;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void error(ChannelHandlerContext ctx, Throwable cause) {
            void var2_2;
            void var1_1;
            this.queue.releaseAndFailAll(cause);
            DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError((ChannelHandlerContext)var1_1, true, (Throwable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(ChannelHandlerContext ctx, int allowedBytes) {
            void var2_2;
            void var1_1;
            void var3_3;
            void writePromise2;
            int queuedData = this.queue.readableBytes();
            if (!this.endOfStream) {
                if (queuedData == 0) {
                    if (this.queue.isEmpty()) {
                        FlowControlledData flowControlledData = this;
                        flowControlledData.dataSize = 0;
                        flowControlledData.padding = 0;
                        return;
                    }
                    ChannelPromise writePromise2 = ctx.newPromise().addListener((GenericFutureListener)this);
                    ctx.write((Object)this.queue.remove(0, writePromise2), writePromise2);
                    return;
                }
                if (allowedBytes == 0) {
                    return;
                }
            }
            int writableData = Math.min((int)writePromise2, allowedBytes);
            ChannelPromise writePromise3 = ctx.newPromise().addListener((GenericFutureListener)this);
            ByteBuf toWrite = this.queue.remove(writableData, writePromise3);
            this.dataSize = this.queue.readableBytes();
            int writablePadding = Math.min(allowedBytes - var3_3, this.padding);
            this.padding -= writablePadding;
            DefaultHttp2ConnectionEncoder.this.frameWriter().writeData((ChannelHandlerContext)var1_1, this.stream.id(), toWrite, (int)var2_2, this.endOfStream && this.size() == 0, writePromise3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean merge(ChannelHandlerContext ctx, Http2RemoteFlowController.FlowControlled next) {
            void var1_1;
            void var2_2;
            FlowControlledData nextData;
            if (FlowControlledData.class != next.getClass() || Integer.MAX_VALUE - (nextData = (FlowControlledData)var2_2).size() < this.size()) {
                return false;
            }
            nextData.queue.copyTo((AbstractCoalescingBufferQueue)this.queue);
            this.dataSize = this.queue.readableBytes();
            this.padding = Math.max(this.padding, nextData.padding);
            this.endOfStream = var1_1.endOfStream;
            return true;
        }
    }
}

