/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class DefaultHttp2ConnectionDecoder
implements Http2ConnectionDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2ConnectionDecoder.class);
    private Http2FrameListener internalFrameListener = new PrefaceFrameListener();
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Http2ConnectionEncoder encoder;
    private final Http2FrameReader frameReader;
    private Http2FrameListener listener;
    private final Http2PromisedRequestVerifier requestVerifier;
    private final Http2SettingsReceivedConsumer settingsReceivedConsumer;
    private final boolean autoAckPing;
    private final Http2Connection.PropertyKey contentLengthKey;
    private final boolean validateHeaders;

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2ConnectionDecoder(Http2Connection connection, Http2ConnectionEncoder encoder, Http2FrameReader frameReader) {
        this((Http2Connection)var1_1, (Http2ConnectionEncoder)var2_2, (Http2FrameReader)var3_3, Http2PromisedRequestVerifier.ALWAYS_VERIFY);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2ConnectionDecoder(Http2Connection connection, Http2ConnectionEncoder encoder, Http2FrameReader frameReader, Http2PromisedRequestVerifier requestVerifier) {
        this((Http2Connection)var1_1, (Http2ConnectionEncoder)var2_2, (Http2FrameReader)var3_3, requestVerifier, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2ConnectionDecoder(Http2Connection connection, Http2ConnectionEncoder encoder, Http2FrameReader frameReader, Http2PromisedRequestVerifier requestVerifier, boolean autoAckSettings) {
        this((Http2Connection)var1_1, (Http2ConnectionEncoder)var2_2, (Http2FrameReader)var3_3, requestVerifier, autoAckSettings, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultHttp2ConnectionDecoder(Http2Connection connection, Http2ConnectionEncoder encoder, Http2FrameReader frameReader, Http2PromisedRequestVerifier requestVerifier, boolean autoAckSettings, boolean autoAckPing) {
        this((Http2Connection)var1_1, (Http2ConnectionEncoder)var2_2, (Http2FrameReader)var3_3, requestVerifier, autoAckSettings, true, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2ConnectionDecoder(Http2Connection connection, Http2ConnectionEncoder encoder, Http2FrameReader frameReader, Http2PromisedRequestVerifier requestVerifier, boolean autoAckSettings, boolean autoAckPing, boolean validateHeaders) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.validateHeaders = validateHeaders;
        this.autoAckPing = autoAckPing;
        if (autoAckSettings) {
            this.settingsReceivedConsumer = null;
        } else {
            if (!(encoder instanceof Http2SettingsReceivedConsumer)) {
                throw new IllegalArgumentException("disabling autoAckSettings requires the encoder to be a " + Http2SettingsReceivedConsumer.class);
            }
            this.settingsReceivedConsumer = (Http2SettingsReceivedConsumer)((Object)encoder);
        }
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this.contentLengthKey = this.connection.newKey();
        this.frameReader = (Http2FrameReader)ObjectUtil.checkNotNull((Object)var3_3, (String)"frameReader");
        this.encoder = (Http2ConnectionEncoder)ObjectUtil.checkNotNull((Object)encoder, (String)"encoder");
        this.requestVerifier = (Http2PromisedRequestVerifier)ObjectUtil.checkNotNull((Object)requestVerifier, (String)"requestVerifier");
        if (connection.local().flowController() == null) {
            connection.local().flowController(new DefaultHttp2LocalFlowController(connection));
        }
        var1_1.local().flowController().frameWriter(var2_2.frameWriter());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        void var1_1;
        this.lifecycleManager = (Http2LifecycleManager)ObjectUtil.checkNotNull((Object)var1_1, (String)"lifecycleManager");
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2LocalFlowController flowController() {
        return this.connection.local().flowController();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void frameListener(Http2FrameListener listener) {
        void var1_1;
        this.listener = (Http2FrameListener)ObjectUtil.checkNotNull((Object)var1_1, (String)"listener");
    }

    @Override
    public Http2FrameListener frameListener() {
        return this.listener;
    }

    @Override
    public boolean prefaceReceived() {
        return FrameReadListener.class == this.internalFrameListener.getClass();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void decodeFrame(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Http2Exception {
        void var2_2;
        void var1_1;
        this.frameReader.readFrame((ChannelHandlerContext)var1_1, (ByteBuf)var2_2, this.internalFrameListener);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Settings localSettings() {
        void var1_1;
        void var3_3;
        void var2_2;
        Http2Settings settings = new Http2Settings();
        Http2FrameReader.Configuration config = this.frameReader.configuration();
        Http2HeadersDecoder.Configuration headersConfig = config.headersConfiguration();
        Http2FrameSizePolicy frameSizePolicy = config.frameSizePolicy();
        settings.initialWindowSize(this.flowController().initialWindowSize());
        settings.maxConcurrentStreams(this.connection.remote().maxActiveStreams());
        settings.headerTableSize(headersConfig.maxHeaderTableSize());
        settings.maxFrameSize(var2_2.maxFrameSize());
        settings.maxHeaderListSize(var3_3.maxHeaderListSize());
        if (!this.connection.isServer()) {
            settings.pushEnabled(this.connection.local().allowPushTo());
        }
        return var1_1;
    }

    @Override
    public void close() {
        this.frameReader.close();
    }

    protected long calculateMaxHeaderListSizeGoAway(long maxHeaderListSize) {
        return Http2CodecUtil.calculateMaxHeaderListSizeGoAway(maxHeaderListSize);
    }

    /*
     * WARNING - void declaration
     */
    private int unconsumedBytes(Http2Stream stream) {
        void var1_1;
        return this.flowController().unconsumedBytes((Http2Stream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void onGoAwayRead0(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        this.listener.onGoAwayRead((ChannelHandlerContext)var1_1, lastStreamId, errorCode, debugData);
        this.connection.goAwayReceived((int)var2_2, (long)var3_3, debugData);
    }

    /*
     * WARNING - void declaration
     */
    void onUnknownFrame0(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        this.listener.onUnknownFrame((ChannelHandlerContext)var1_1, (byte)var2_2, (int)var3_3, flags, payload);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyContentLength(Http2Stream stream, int data, boolean isEnd) throws Http2Exception {
        block4: {
            ContentLength contentLength = (ContentLength)stream.getProperty(this.contentLengthKey);
            if (contentLength != null) {
                try {
                    void var2_2;
                    contentLength.increaseReceivedBytes(this.connection.isServer(), stream.id(), (int)var2_2, isEnd);
                    if (!isEnd) break block4;
                    stream.removeProperty(this.contentLengthKey);
                }
                catch (Throwable throwable) {
                    void var3_4;
                    if (var3_4 != false) {
                        void var1_1;
                        var1_1.removeProperty(this.contentLengthKey);
                    }
                    throw throwable;
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$200(DefaultHttp2ConnectionDecoder x0, Http2Stream x1) {
        void var1_1;
        return x0.unconsumedBytes((Http2Stream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(DefaultHttp2ConnectionDecoder x0, Http2Stream x1, int x2, boolean x3) throws Http2Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.verifyContentLength((Http2Stream)var1_1, (int)var2_2, (boolean)var3_3);
    }

    static /* synthetic */ Http2Connection.PropertyKey access$600(DefaultHttp2ConnectionDecoder x0) {
        return x0.contentLengthKey;
    }

    static /* synthetic */ boolean access$700(DefaultHttp2ConnectionDecoder x0) {
        return x0.validateHeaders;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Http2FrameListener access$1402(DefaultHttp2ConnectionDecoder x0, Http2FrameListener x1) {
        void var1_1;
        x0.internalFrameListener = var1_1;
        return x0.internalFrameListener;
    }

    private static final class ContentLength {
        private final long expected;
        private long seen;

        /*
         * WARNING - void declaration
         */
        ContentLength(long expected) {
            void var1_1;
            this.expected = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final void increaseReceivedBytes(boolean server, int streamId, int bytes, boolean isEnd) throws Http2Exception {
            void var3_3;
            this.seen += (long)var3_3;
            if (this.seen < 0L) {
                throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, "Received amount of data did overflow and so not match content-length header %d", this.expected);
            }
            if (this.seen > this.expected) {
                throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, "Received amount of data %d does not match content-length header %d", this.seen, this.expected);
            }
            if (isEnd) {
                void var1_1;
                if (this.seen == 0L && var1_1 == false) {
                    return;
                }
                if (this.expected > this.seen) {
                    void var2_2;
                    throw Http2Exception.streamError((int)var2_2, Http2Error.PROTOCOL_ERROR, "Received amount of data %d does not match content-length header %d", this.seen, this.expected);
                }
            }
        }
    }

    private final class PrefaceFrameListener
    implements Http2FrameListener {
        private PrefaceFrameListener() {
        }

        private void verifyPrefaceReceived() throws Http2Exception {
            if (!DefaultHttp2ConnectionDecoder.this.prefaceReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received non-SETTINGS as first frame.", new Object[0]);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            return DefaultHttp2ConnectionDecoder.this.internalFrameListener.onDataRead((ChannelHandlerContext)var1_1, (int)var2_2, (ByteBuf)var3_3, padding, endOfStream);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, padding, endOfStream);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, streamDependency, weight, exclusive, padding, endOfStream);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPriorityRead((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3, weight, exclusive);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onRstStreamRead((ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onSettingsAckRead((ChannelHandlerContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
            void var2_2;
            void var1_1;
            if (!DefaultHttp2ConnectionDecoder.this.prefaceReceived()) {
                DefaultHttp2ConnectionDecoder.access$1402(DefaultHttp2ConnectionDecoder.this, new FrameReadListener());
            }
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onSettingsRead((ChannelHandlerContext)var1_1, (Http2Settings)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPingRead((ChannelHandlerContext)var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPingAckRead((ChannelHandlerContext)var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPushPromiseRead((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3, headers, padding);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultHttp2ConnectionDecoder.this.onGoAwayRead0((ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3, debugData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onWindowUpdateRead((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultHttp2ConnectionDecoder.this.onUnknownFrame0((ChannelHandlerContext)var1_1, (byte)var2_2, (int)var3_3, flags, payload);
        }
    }

    private final class FrameReadListener
    implements Http2FrameListener {
        private FrameReadListener() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int onDataRead(ChannelHandlerContext ctx2, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            int delta;
            boolean shouldIgnore;
            Http2Stream stream = DefaultHttp2ConnectionDecoder.this.connection.stream(streamId);
            Http2LocalFlowController flowController = DefaultHttp2ConnectionDecoder.this.flowController();
            int readable = data.readableBytes();
            int bytesToReturn = readable + padding;
            try {
                shouldIgnore = this.shouldIgnoreHeadersOrDataFrame(ctx2, streamId, stream, endOfStream, "DATA");
            }
            catch (Http2Exception e) {
                flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
                flowController.consumeBytes(stream, bytesToReturn);
                throw e;
            }
            catch (Throwable t) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, t, "Unhandled error on data stream id %d", streamId);
            }
            if (shouldIgnore) {
                flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
                flowController.consumeBytes(stream, bytesToReturn);
                this.verifyStreamMayHaveExisted(streamId, endOfStream, "DATA");
                return bytesToReturn;
            }
            Http2Exception error = null;
            switch (stream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                case HALF_CLOSED_REMOTE: 
                case CLOSED: {
                    error = Http2Exception.streamError(stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{stream.id(), stream.state()});
                    break;
                }
                default: {
                    error = Http2Exception.streamError(stream.id(), Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{stream.id(), stream.state()});
                }
            }
            int unconsumedBytes = DefaultHttp2ConnectionDecoder.access$200(DefaultHttp2ConnectionDecoder.this, stream);
            try {
                void var3_7;
                flowController.receiveFlowControlledFrame(stream, data, padding, endOfStream);
                unconsumedBytes = DefaultHttp2ConnectionDecoder.access$200(DefaultHttp2ConnectionDecoder.this, stream);
                if (error != null) {
                    throw error;
                }
                DefaultHttp2ConnectionDecoder.access$300(DefaultHttp2ConnectionDecoder.this, stream, readable, endOfStream);
                bytesToReturn = DefaultHttp2ConnectionDecoder.this.listener.onDataRead(ctx2, streamId, (ByteBuf)var3_7, padding, endOfStream);
                if (endOfStream) {
                    DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStreamRemote(stream, ctx2.newSucceededFuture());
                }
                int ctx2 = bytesToReturn;
                return ctx2;
            }
            catch (Http2Exception e) {
                delta = unconsumedBytes - DefaultHttp2ConnectionDecoder.access$200(DefaultHttp2ConnectionDecoder.this, stream);
                bytesToReturn -= delta;
                throw e;
            }
            catch (RuntimeException e) {
                void var1_4;
                void var2_6;
                delta = unconsumedBytes - DefaultHttp2ConnectionDecoder.access$200(DefaultHttp2ConnectionDecoder.this, stream);
                bytesToReturn -= var2_6;
                throw var1_4;
            }
            finally {
                flowController.consumeBytes(stream, bytesToReturn);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            this.onHeadersRead((ChannelHandlerContext)var1_1, (int)var2_2, (Http2Headers)var3_3, 0, (short)16, false, padding, endOfStream);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public final void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
            stream = DefaultHttp2ConnectionDecoder.access$100(DefaultHttp2ConnectionDecoder.this).stream(streamId);
            allowHalfClosedRemote = false;
            isTrailers = false;
            if (stream == null && !DefaultHttp2ConnectionDecoder.access$100(DefaultHttp2ConnectionDecoder.this).streamMayHaveExisted(streamId)) {
                stream = DefaultHttp2ConnectionDecoder.access$100(DefaultHttp2ConnectionDecoder.this).remote().createStream(streamId, endOfStream);
                allowHalfClosedRemote = stream.state() == Http2Stream.State.HALF_CLOSED_REMOTE;
            } else if (stream != null) {
                isTrailers = stream.isHeadersReceived();
            }
            if (this.shouldIgnoreHeadersOrDataFrame(ctx, streamId, stream, endOfStream, "HEADERS")) {
                return;
            }
            isInformational = DefaultHttp2ConnectionDecoder.access$100(DefaultHttp2ConnectionDecoder.this).isServer() == false && HttpStatusClass.valueOf((CharSequence)headers.status()) == HttpStatusClass.INFORMATIONAL;
            if ((isInformational || !endOfStream) && stream.isHeadersReceived() || stream.isTrailersReceived()) {
                throw Http2Exception.streamError(streamId, Http2Error.PROTOCOL_ERROR, "Stream %d received too many headers EOS: %s state: %s", new Object[]{streamId, endOfStream, stream.state()});
            }
            switch (1.$SwitchMap$io$netty$handler$codec$http2$Http2Stream$State[stream.state().ordinal()]) {
                case 5: {
                    stream.open(endOfStream);
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    if (allowHalfClosedRemote) break;
                    throw Http2Exception.streamError(stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{stream.id(), stream.state()});
                }
                case 4: {
                    throw Http2Exception.streamError(stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{stream.id(), stream.state()});
                }
                default: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{stream.id(), stream.state()});
                }
            }
            if (!isTrailers) {
                contentLength = headers.getAll(HttpHeaderNames.CONTENT_LENGTH);
                if (contentLength != null && !contentLength.isEmpty()) {
                    try {
                        cLength = HttpUtil.normalizeAndGetContentLength((List)contentLength, (boolean)false, (boolean)true);
                        if (cLength == -1L) ** GOTO lbl49
                        headers.setLong(HttpHeaderNames.CONTENT_LENGTH, cLength);
                        stream.setProperty(DefaultHttp2ConnectionDecoder.access$600(DefaultHttp2ConnectionDecoder.this), new ContentLength(cLength));
                    }
                    catch (IllegalArgumentException e) {
                        throw Http2Exception.streamError(stream.id(), Http2Error.PROTOCOL_ERROR, e, "Multiple content-length headers received", new Object[0]);
                    }
                }
            } else if (DefaultHttp2ConnectionDecoder.access$700(DefaultHttp2ConnectionDecoder.this) && headers.size() > 0) {
                iterator = headers.iterator();
                while (iterator.hasNext()) {
                    name = iterator.next().getKey();
                    if (!Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat(name)) continue;
                    throw Http2Exception.streamError(stream.id(), Http2Error.PROTOCOL_ERROR, "Found invalid Pseudo-Header in trailers: %s", new Object[]{name});
                }
            }
lbl49:
            // 6 sources

            stream.headersReceived(isInformational);
            DefaultHttp2ConnectionDecoder.access$300(DefaultHttp2ConnectionDecoder.this, stream, 0, endOfStream);
            DefaultHttp2ConnectionDecoder.access$800(DefaultHttp2ConnectionDecoder.this).flowController().updateDependencyTree(streamId, streamDependency, weight, exclusive);
            DefaultHttp2ConnectionDecoder.access$400(DefaultHttp2ConnectionDecoder.this).onHeadersRead(ctx, (int)var2_2, (Http2Headers)var3_3, streamDependency, weight, exclusive, padding, endOfStream);
            if (endOfStream) {
                DefaultHttp2ConnectionDecoder.access$500(DefaultHttp2ConnectionDecoder.this).closeStreamRemote(stream, var1_1.newSucceededFuture());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultHttp2ConnectionDecoder.this.encoder.flowController().updateDependencyTree(streamId, streamDependency, weight, exclusive);
            DefaultHttp2ConnectionDecoder.this.listener.onPriorityRead((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3, weight, exclusive);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            void var1_1;
            void var3_3;
            void var2_2;
            Http2Stream stream = DefaultHttp2ConnectionDecoder.this.connection.stream(streamId);
            if (stream == null) {
                this.verifyStreamMayHaveExisted(streamId, false, "RST_STREAM");
                return;
            }
            switch (stream.state()) {
                case IDLE: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "RST_STREAM received for IDLE stream %d", streamId);
                }
                case CLOSED: {
                    return;
                }
            }
            DefaultHttp2ConnectionDecoder.this.listener.onRstStreamRead(ctx, (int)var2_2, (long)var3_3);
            DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStream(stream, var1_1.newSucceededFuture());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
            void var1_1;
            Http2Settings settings = DefaultHttp2ConnectionDecoder.this.encoder.pollSentSettings();
            if (settings != null) {
                void var2_2;
                this.applyLocalSettings((Http2Settings)var2_2);
            }
            DefaultHttp2ConnectionDecoder.this.listener.onSettingsAckRead((ChannelHandlerContext)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void applyLocalSettings(Http2Settings settings) throws Http2Exception {
            Integer initialWindowSize;
            Integer maxFrameSize;
            Long maxHeaderListSize;
            Long headerTableSize;
            Long maxConcurrentStreams;
            Boolean pushEnabled = settings.pushEnabled();
            Http2FrameReader.Configuration config = DefaultHttp2ConnectionDecoder.this.frameReader.configuration();
            Http2HeadersDecoder.Configuration headerConfig = config.headersConfiguration();
            Http2FrameSizePolicy frameSizePolicy = config.frameSizePolicy();
            if (pushEnabled != null) {
                if (DefaultHttp2ConnectionDecoder.this.connection.isServer()) {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
                }
                DefaultHttp2ConnectionDecoder.this.connection.local().allowPushTo(pushEnabled);
            }
            if ((maxConcurrentStreams = settings.maxConcurrentStreams()) != null) {
                DefaultHttp2ConnectionDecoder.this.connection.remote().maxActiveStreams((int)Math.min(maxConcurrentStreams, Integer.MAX_VALUE));
            }
            if ((headerTableSize = settings.headerTableSize()) != null) {
                headerConfig.maxHeaderTableSize(headerTableSize);
            }
            if ((maxHeaderListSize = settings.maxHeaderListSize()) != null) {
                headerConfig.maxHeaderListSize(maxHeaderListSize, DefaultHttp2ConnectionDecoder.this.calculateMaxHeaderListSizeGoAway(maxHeaderListSize));
            }
            if ((maxFrameSize = settings.maxFrameSize()) != null) {
                void var2_2;
                void var3_3;
                var3_3.maxFrameSize(var2_2.intValue());
            }
            if ((initialWindowSize = settings.initialWindowSize()) != null) {
                void var1_1;
                DefaultHttp2ConnectionDecoder.this.flowController().initialWindowSize(var1_1.intValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
            void var2_2;
            void var1_1;
            if (DefaultHttp2ConnectionDecoder.this.settingsReceivedConsumer == null) {
                ChannelHandlerContext channelHandlerContext = ctx;
                DefaultHttp2ConnectionDecoder.this.encoder.writeSettingsAck(channelHandlerContext, channelHandlerContext.newPromise());
                DefaultHttp2ConnectionDecoder.this.encoder.remoteSettings(settings);
            } else {
                DefaultHttp2ConnectionDecoder.this.settingsReceivedConsumer.consumeReceivedSettings(settings);
            }
            DefaultHttp2ConnectionDecoder.this.listener.onSettingsRead((ChannelHandlerContext)var1_1, (Http2Settings)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
            void var2_2;
            void var1_1;
            if (DefaultHttp2ConnectionDecoder.this.autoAckPing) {
                DefaultHttp2ConnectionDecoder.this.encoder.writePing(ctx, true, data, ctx.newPromise());
            }
            DefaultHttp2ConnectionDecoder.this.listener.onPingRead((ChannelHandlerContext)var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
            void var2_2;
            void var1_1;
            DefaultHttp2ConnectionDecoder.this.listener.onPingAckRead((ChannelHandlerContext)var1_1, (long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            if (DefaultHttp2ConnectionDecoder.this.connection().isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A client cannot push.", new Object[0]);
            }
            Http2Stream parentStream = DefaultHttp2ConnectionDecoder.this.connection.stream(streamId);
            if (this.shouldIgnoreHeadersOrDataFrame(ctx, streamId, parentStream, false, "PUSH_PROMISE")) {
                return;
            }
            switch (parentStream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state for receiving push promise: %s", new Object[]{parentStream.id(), parentStream.state()});
                }
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isAuthoritative(ctx, headers)) {
                throw Http2Exception.streamError(promisedStreamId, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not authoritative", streamId, promisedStreamId);
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isCacheable(headers)) {
                throw Http2Exception.streamError(promisedStreamId, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be cacheable", streamId, promisedStreamId);
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isSafe(headers)) {
                throw Http2Exception.streamError(promisedStreamId, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be safe", streamId, promisedStreamId);
            }
            DefaultHttp2ConnectionDecoder.this.connection.remote().reservePushStream(promisedStreamId, parentStream);
            DefaultHttp2ConnectionDecoder.this.listener.onPushPromiseRead((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3, headers, padding);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultHttp2ConnectionDecoder.this.onGoAwayRead0((ChannelHandlerContext)var1_1, (int)var2_2, (long)var3_3, debugData);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            Http2Stream stream = DefaultHttp2ConnectionDecoder.this.connection.stream(streamId);
            if (stream == null || stream.state() == Http2Stream.State.CLOSED || this.streamCreatedAfterGoAwaySent(streamId)) {
                this.verifyStreamMayHaveExisted(streamId, false, "WINDOW_UPDATE");
                return;
            }
            DefaultHttp2ConnectionDecoder.this.encoder.flowController().incrementWindowSize(stream, windowSizeIncrement);
            DefaultHttp2ConnectionDecoder.this.listener.onWindowUpdateRead((ChannelHandlerContext)var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            DefaultHttp2ConnectionDecoder.this.onUnknownFrame0((ChannelHandlerContext)var1_1, (byte)var2_2, (int)var3_3, flags, payload);
        }

        /*
         * WARNING - void declaration
         */
        private boolean shouldIgnoreHeadersOrDataFrame(ChannelHandlerContext ctx, int streamId, Http2Stream stream, boolean endOfStream, String frameName) throws Http2Exception {
            void var2_2;
            if (stream == null) {
                if (this.streamCreatedAfterGoAwaySent(streamId)) {
                    logger.info("{} ignoring {} frame for stream {}. Stream sent after GOAWAY sent", new Object[]{ctx.channel(), frameName, streamId});
                    return true;
                }
                this.verifyStreamMayHaveExisted(streamId, endOfStream, frameName);
                throw Http2Exception.streamError(streamId, Http2Error.STREAM_CLOSED, "Received %s frame for an unknown stream %d", frameName, streamId);
            }
            if (stream.isResetSent() || this.streamCreatedAfterGoAwaySent((int)var2_2)) {
                if (logger.isInfoEnabled()) {
                    void var3_3;
                    void var1_1;
                    logger.info("{} ignoring {} frame for stream {}", new Object[]{var1_1.channel(), frameName, var3_3.isResetSent() ? "RST_STREAM sent." : "Stream created after GOAWAY sent. Last known stream by peer " + DefaultHttp2ConnectionDecoder.this.connection.remote().lastStreamKnownByPeer()});
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean streamCreatedAfterGoAwaySent(int streamId) {
            void var2_2;
            void var1_1;
            Http2Connection.Endpoint<Http2RemoteFlowController> remote = DefaultHttp2ConnectionDecoder.this.connection.remote();
            return DefaultHttp2ConnectionDecoder.this.connection.goAwaySent() && remote.isValidStreamId(streamId) && var1_1 > var2_2.lastStreamKnownByPeer();
        }

        /*
         * WARNING - void declaration
         */
        private void verifyStreamMayHaveExisted(int streamId, boolean endOfStream, String frameName) throws Http2Exception {
            if (!DefaultHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(streamId)) {
                void var2_2;
                void var3_3;
                void var1_1;
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d does not exist for inbound frame %s, endOfStream = %b", (int)var1_1, var3_3, (boolean)var2_2);
            }
        }
    }
}

