/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class DefaultHttp2Connection
implements Http2Connection {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2Connection.class);
    final IntObjectMap<Http2Stream> streamMap = new IntObjectHashMap();
    final PropertyKeyRegistry propertyKeyRegistry = new PropertyKeyRegistry();
    final ConnectionStream connectionStream = new ConnectionStream();
    final DefaultEndpoint<Http2LocalFlowController> localEndpoint;
    final DefaultEndpoint<Http2RemoteFlowController> remoteEndpoint;
    final List<Http2Connection.Listener> listeners = new ArrayList<Http2Connection.Listener>(4);
    final ActiveStreams activeStreams;
    Promise<Void> closePromise;

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2Connection(boolean server) {
        this((boolean)var1_1, 100);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttp2Connection(boolean server, int maxReservedStreams) {
        void var2_2;
        void var1_1;
        DefaultHttp2Connection defaultHttp2Connection = this;
        this.activeStreams = defaultHttp2Connection.new ActiveStreams(defaultHttp2Connection.listeners);
        boolean bl = server;
        this.localEndpoint = new DefaultEndpoint(bl, bl ? Integer.MAX_VALUE : maxReservedStreams);
        this.remoteEndpoint = new DefaultEndpoint(var1_1 == false, (int)var2_2);
        this.streamMap.put(this.connectionStream.id(), (Object)this.connectionStream);
    }

    final boolean isClosed() {
        return this.closePromise != null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Future<Void> close(Promise<Void> promise) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addListener(Http2Connection.Listener listener) {
        void var1_1;
        this.listeners.add((Http2Connection.Listener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeListener(Http2Connection.Listener listener) {
        void var1_1;
        this.listeners.remove(var1_1);
    }

    @Override
    public boolean isServer() {
        return this.localEndpoint.isServer();
    }

    @Override
    public Http2Stream connectionStream() {
        return this.connectionStream;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Stream stream(int streamId) {
        void var1_1;
        return (Http2Stream)this.streamMap.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean streamMayHaveExisted(int streamId) {
        void var1_1;
        return this.remoteEndpoint.mayHaveCreatedStream(streamId) || this.localEndpoint.mayHaveCreatedStream((int)var1_1);
    }

    @Override
    public int numActiveStreams() {
        return this.activeStreams.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Http2Stream forEachActiveStream(Http2StreamVisitor visitor) throws Http2Exception {
        void var1_1;
        return this.activeStreams.forEachActiveStream((Http2StreamVisitor)var1_1);
    }

    @Override
    public Http2Connection.Endpoint<Http2LocalFlowController> local() {
        return this.localEndpoint;
    }

    @Override
    public Http2Connection.Endpoint<Http2RemoteFlowController> remote() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean goAwayReceived() {
        return ((DefaultEndpoint)this.localEndpoint).lastStreamKnownByPeer >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void goAwayReceived(int lastKnownStream, long errorCode, ByteBuf debugData) throws Http2Exception {
        void var1_1;
        if (this.localEndpoint.lastStreamKnownByPeer() >= 0 && this.localEndpoint.lastStreamKnownByPeer() < lastKnownStream) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "lastStreamId MUST NOT increase. Current value: %d new value: %d", this.localEndpoint.lastStreamKnownByPeer(), lastKnownStream);
        }
        DefaultEndpoint.access$200(this.localEndpoint, lastKnownStream);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onGoAwayReceived(lastKnownStream, errorCode, debugData);
                continue;
            }
            catch (Throwable cause) {
                logger.error("Caught Throwable from listener onGoAwayReceived.", cause);
            }
        }
        this.closeStreamsGreaterThanLastKnownStreamId((int)var1_1, this.localEndpoint);
    }

    @Override
    public boolean goAwaySent() {
        return ((DefaultEndpoint)this.remoteEndpoint).lastStreamKnownByPeer >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean goAwaySent(int lastKnownStream, long errorCode, ByteBuf debugData) throws Http2Exception {
        void var1_1;
        if (this.remoteEndpoint.lastStreamKnownByPeer() >= 0) {
            if (lastKnownStream == this.remoteEndpoint.lastStreamKnownByPeer()) {
                return false;
            }
            if (lastKnownStream > this.remoteEndpoint.lastStreamKnownByPeer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Last stream identifier must not increase between sending multiple GOAWAY frames (was '%d', is '%d').", this.remoteEndpoint.lastStreamKnownByPeer(), lastKnownStream);
            }
        }
        DefaultEndpoint.access$200(this.remoteEndpoint, lastKnownStream);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onGoAwaySent(lastKnownStream, errorCode, debugData);
                continue;
            }
            catch (Throwable cause) {
                logger.error("Caught Throwable from listener onGoAwaySent.", cause);
            }
        }
        this.closeStreamsGreaterThanLastKnownStreamId((int)var1_1, this.remoteEndpoint);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void closeStreamsGreaterThanLastKnownStreamId(int lastKnownStream, DefaultEndpoint<?> endpoint) throws Http2Exception {
        void var2_2;
        void var1_1;
        this.forEachActiveStream(new Http2StreamVisitor(this, (int)var1_1, (DefaultEndpoint)var2_2){
            final /* synthetic */ int val$lastKnownStream;
            final /* synthetic */ DefaultEndpoint val$endpoint;
            final /* synthetic */ DefaultHttp2Connection this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$lastKnownStream = n;
                this.val$endpoint = defaultEndpoint;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean visit(Http2Stream stream) {
                if (stream.id() > this.val$lastKnownStream && this.val$endpoint.isValidStreamId(stream.id())) {
                    void var1_1;
                    var1_1.close();
                }
                return true;
            }
        });
    }

    private boolean isStreamMapEmpty() {
        return this.streamMap.size() == 1;
    }

    /*
     * WARNING - void declaration
     */
    void removeStream(DefaultStream stream, Iterator<?> itr) {
        boolean removed2;
        if (itr == null) {
            removed2 = this.streamMap.remove(stream.id()) != null;
        } else {
            void removed;
            removed.remove();
            removed2 = true;
        }
        if (removed2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    this.listeners.get(i).onStreamRemoved(stream);
                    continue;
                }
                catch (Throwable cause) {
                    void var3_4;
                    logger.error("Caught Throwable from listener onStreamRemoved.", (Throwable)var3_4);
                }
            }
            if (this.closePromise != null && this.isStreamMapEmpty()) {
                this.closePromise.trySuccess(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static Http2Stream.State activeState(int streamId, Http2Stream.State initialState, boolean isLocal, boolean halfClosed) throws Http2Exception {
        void var1_1;
        int n;
        switch (initialState) {
            case IDLE: {
                void var3_3;
                if (var3_3 != false) {
                    void var2_2;
                    if (var2_2 != false) {
                        return Http2Stream.State.HALF_CLOSED_LOCAL;
                    }
                    return Http2Stream.State.HALF_CLOSED_REMOTE;
                }
                return Http2Stream.State.OPEN;
            }
            case RESERVED_LOCAL: {
                return Http2Stream.State.HALF_CLOSED_REMOTE;
            }
            case RESERVED_REMOTE: {
                return Http2Stream.State.HALF_CLOSED_LOCAL;
            }
        }
        throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Attempting to open a stream in an invalid state: " + var1_1, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    void notifyHalfClosed(Http2Stream stream) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onStreamHalfClosed(stream);
                continue;
            }
            catch (Throwable cause) {
                void var3_3;
                logger.error("Caught Throwable from listener onStreamHalfClosed.", (Throwable)var3_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void notifyClosed(Http2Stream stream) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onStreamClosed(stream);
                continue;
            }
            catch (Throwable cause) {
                void var3_3;
                logger.error("Caught Throwable from listener onStreamClosed.", (Throwable)var3_3);
            }
        }
    }

    @Override
    public Http2Connection.PropertyKey newKey() {
        return this.propertyKeyRegistry.newKey();
    }

    final DefaultPropertyKey verifyKey(Http2Connection.PropertyKey key) {
        return ((DefaultPropertyKey)ObjectUtil.checkNotNull((Object)((DefaultPropertyKey)key), (String)"key")).verifyConnection(this);
    }

    private final class PropertyKeyRegistry {
        final List<DefaultPropertyKey> keys = new ArrayList<DefaultPropertyKey>(4);

        private PropertyKeyRegistry() {
        }

        /*
         * WARNING - void declaration
         */
        final DefaultPropertyKey newKey() {
            void var1_1;
            DefaultPropertyKey key = new DefaultPropertyKey(DefaultHttp2Connection.this, this.keys.size());
            this.keys.add(key);
            return var1_1;
        }

        final int size() {
            return this.keys.size();
        }
    }

    final class DefaultPropertyKey
    implements Http2Connection.PropertyKey {
        final int index;
        final /* synthetic */ DefaultHttp2Connection this$0;

        /*
         * WARNING - void declaration
         */
        DefaultPropertyKey(DefaultHttp2Connection this$0, int index) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.index = var2_2;
        }

        final DefaultPropertyKey verifyConnection(Http2Connection connection) {
            if (connection != this.this$0) {
                throw new IllegalArgumentException("Using a key that was not created by this connection");
            }
            return this;
        }
    }

    private final class ActiveStreams {
        private final List<Http2Connection.Listener> listeners;
        private final Queue<Event> pendingEvents = new ArrayDeque<Event>(4);
        private final Set<Http2Stream> streams = new LinkedHashSet<Http2Stream>();
        private int pendingIterations;

        /*
         * WARNING - void declaration
         */
        ActiveStreams(List<Http2Connection.Listener> listeners) {
            void var2_2;
            this.listeners = var2_2;
        }

        public final int size() {
            return this.streams.size();
        }

        /*
         * WARNING - void declaration
         */
        public final void activate(DefaultStream stream) {
            void var1_1;
            if (this.allowModifications()) {
                this.addToActiveStreams(stream);
                return;
            }
            this.pendingEvents.add(new Event(this, (DefaultStream)var1_1){
                final /* synthetic */ DefaultStream val$stream;
                final /* synthetic */ ActiveStreams this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$stream = defaultStream;
                }

                @Override
                public void process() {
                    this.this$1.addToActiveStreams(this.val$stream);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final void deactivate(DefaultStream stream, Iterator<?> itr) {
            void var2_2;
            void var1_1;
            if (this.allowModifications() || itr != null) {
                this.removeFromActiveStreams(stream, itr);
                return;
            }
            this.pendingEvents.add(new Event(this, (DefaultStream)var1_1, (Iterator)var2_2){
                final /* synthetic */ DefaultStream val$stream;
                final /* synthetic */ Iterator val$itr;
                final /* synthetic */ ActiveStreams this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$stream = defaultStream;
                    this.val$itr = iterator;
                }

                @Override
                public void process() {
                    this.this$1.removeFromActiveStreams(this.val$stream, this.val$itr);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final Http2Stream forEachActiveStream(Http2StreamVisitor visitor) throws Http2Exception {
            this.incrementPendingIterations();
            try {
                for (Http2Stream stream : this.streams) {
                    void var3_4;
                    if (visitor.visit(stream)) continue;
                    visitor = var3_4;
                    return visitor;
                }
                return null;
            }
            finally {
                this.decrementPendingIterations();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void addToActiveStreams(DefaultStream stream) {
            if (this.streams.add(stream)) {
                ++stream.createdBy().numActiveStreams;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        this.listeners.get(i).onStreamActive(stream);
                        continue;
                    }
                    catch (Throwable cause) {
                        void var3_3;
                        logger.error("Caught Throwable from listener onStreamActive.", (Throwable)var3_3);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        final void removeFromActiveStreams(DefaultStream stream, Iterator<?> itr) {
            void var2_2;
            void var1_1;
            if (this.streams.remove(stream)) {
                --stream.createdBy().numActiveStreams;
                DefaultHttp2Connection.this.notifyClosed(stream);
            }
            DefaultHttp2Connection.this.removeStream((DefaultStream)var1_1, (Iterator<?>)var2_2);
        }

        final boolean allowModifications() {
            return this.pendingIterations == 0;
        }

        final void incrementPendingIterations() {
            ++this.pendingIterations;
        }

        /*
         * WARNING - void declaration
         */
        final void decrementPendingIterations() {
            --this.pendingIterations;
            if (this.allowModifications()) {
                Event event;
                while ((event = this.pendingEvents.poll()) != null) {
                    try {
                        event.process();
                    }
                    catch (Throwable cause) {
                        void var1_2;
                        logger.error("Caught Throwable while processing pending ActiveStreams$Event.", (Throwable)var1_2);
                    }
                }
            }
        }
    }

    static interface Event {
        public void process();
    }

    private final class DefaultEndpoint<F extends Http2FlowController>
    implements Http2Connection.Endpoint<F> {
        private final boolean server;
        private long lastCreatedStreamIdentity = 0L;
        private int nextStreamIdToCreate;
        private int nextReservationStreamId;
        private int lastStreamKnownByPeer = -1;
        private boolean pushToAllowed;
        private F flowController;
        private int maxStreams;
        private int maxActiveStreams;
        private final int maxReservedStreams;
        int numActiveStreams;
        int numStreams;

        /*
         * WARNING - void declaration
         */
        DefaultEndpoint(boolean server, int maxReservedStreams) {
            void var3_3;
            void var2_2;
            this.server = server;
            if (server) {
                this.nextStreamIdToCreate = 2;
                this.nextReservationStreamId = 0;
            } else {
                this.nextStreamIdToCreate = 1;
                this.nextReservationStreamId = 1;
            }
            this.pushToAllowed = var2_2 == false;
            this.maxActiveStreams = Integer.MAX_VALUE;
            this.maxReservedStreams = ObjectUtil.checkPositiveOrZero((int)var3_3, (String)"maxReservedStreams");
            this.updateMaxStreams();
        }

        @Override
        public final int incrementAndGetNextStreamId() {
            if (this.nextReservationStreamId >= 0) {
                return this.nextReservationStreamId += 2;
            }
            return this.nextReservationStreamId;
        }

        /*
         * WARNING - void declaration
         */
        private void incrementExpectedStreamId(int streamId) {
            void var1_1;
            if (streamId > this.nextReservationStreamId && this.nextReservationStreamId >= 0) {
                this.nextReservationStreamId = streamId;
            }
            this.nextStreamIdToCreate = var1_1 + 2;
            ++this.numStreams;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean isValidStreamId(int streamId) {
            void var1_1;
            return streamId > 0 && this.server == ((var1_1 & 1) == 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean mayHaveCreatedStream(int streamId) {
            void var1_1;
            return this.isValidStreamId(streamId) && var1_1 <= this.lastStreamCreated();
        }

        @Override
        public final boolean canOpenStream() {
            return this.numActiveStreams < this.maxActiveStreams;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final DefaultStream createStream(int streamId, boolean halfClosed) throws Http2Exception {
            void var2_3;
            void var1_1;
            Http2Stream.State state = DefaultHttp2Connection.activeState(streamId, Http2Stream.State.IDLE, this.isLocal(), halfClosed);
            this.checkNewStreamAllowed(streamId, state);
            ++this.lastCreatedStreamIdentity;
            DefaultStream stream = new DefaultStream(this.lastCreatedStreamIdentity, streamId, state);
            this.incrementExpectedStreamId((int)var1_1);
            this.addStream(stream);
            stream.activate();
            return var2_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean created(Http2Stream stream) {
            void var1_1;
            return stream instanceof DefaultStream && ((DefaultStream)var1_1).createdBy() == this;
        }

        @Override
        public final boolean isServer() {
            return this.server;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final DefaultStream reservePushStream(int streamId, Http2Stream parent) throws Http2Exception {
            void var2_2;
            void var1_1;
            if (parent == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Parent stream missing", new Object[0]);
            }
            if (this.isLocal() ? !parent.state().localSideOpen() : !parent.state().remoteSideOpen()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d is not open for sending push promise", parent.id());
            }
            if (!this.opposite().allowPushTo()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server push not allowed to opposite endpoint", new Object[0]);
            }
            Http2Stream.State state = this.isLocal() ? Http2Stream.State.RESERVED_LOCAL : Http2Stream.State.RESERVED_REMOTE;
            this.checkNewStreamAllowed(streamId, state);
            ++this.lastCreatedStreamIdentity;
            DefaultStream stream = new DefaultStream(this.lastCreatedStreamIdentity, streamId, state);
            this.incrementExpectedStreamId((int)var1_1);
            this.addStream(stream);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void addStream(DefaultStream stream) {
            DefaultHttp2Connection.this.streamMap.put(stream.id(), (Object)stream);
            for (int i = 0; i < DefaultHttp2Connection.this.listeners.size(); ++i) {
                try {
                    DefaultHttp2Connection.this.listeners.get(i).onStreamAdded(stream);
                    continue;
                }
                catch (Throwable cause) {
                    void var3_3;
                    logger.error("Caught Throwable from listener onStreamAdded.", (Throwable)var3_3);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void allowPushTo(boolean allow) {
            void var1_1;
            if (allow && this.server) {
                throw new IllegalArgumentException("Servers do not allow push");
            }
            this.pushToAllowed = var1_1;
        }

        @Override
        public final boolean allowPushTo() {
            return this.pushToAllowed;
        }

        @Override
        public final int numActiveStreams() {
            return this.numActiveStreams;
        }

        @Override
        public final int maxActiveStreams() {
            return this.maxActiveStreams;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void maxActiveStreams(int maxActiveStreams) {
            void var1_1;
            this.maxActiveStreams = var1_1;
            this.updateMaxStreams();
        }

        @Override
        public final int lastStreamCreated() {
            return Math.max(0, this.nextStreamIdToCreate - 2);
        }

        @Override
        public final int lastStreamKnownByPeer() {
            return this.lastStreamKnownByPeer;
        }

        /*
         * WARNING - void declaration
         */
        private void lastStreamKnownByPeer(int lastKnownStream) {
            void var1_1;
            this.lastStreamKnownByPeer = var1_1;
        }

        @Override
        public final F flowController() {
            return this.flowController;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void flowController(F flowController) {
            void var1_1;
            this.flowController = (Http2FlowController)ObjectUtil.checkNotNull((Object)var1_1, (String)"flowController");
        }

        @Override
        public final Http2Connection.Endpoint<? extends Http2FlowController> opposite() {
            if (this.isLocal()) {
                return DefaultHttp2Connection.this.remoteEndpoint;
            }
            return DefaultHttp2Connection.this.localEndpoint;
        }

        private void updateMaxStreams() {
            this.maxStreams = (int)Math.min(Integer.MAX_VALUE, (long)this.maxActiveStreams + (long)this.maxReservedStreams);
        }

        /*
         * WARNING - void declaration
         */
        private void checkNewStreamAllowed(int streamId, Http2Stream.State state) throws Http2Exception {
            assert (state != Http2Stream.State.IDLE);
            if (this.lastStreamKnownByPeer >= 0 && streamId > this.lastStreamKnownByPeer) {
                throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Cannot create stream %d greater than Last-Stream-ID %d from GOAWAY.", streamId, this.lastStreamKnownByPeer);
            }
            if (!this.isValidStreamId(streamId)) {
                if (streamId < 0) {
                    throw new Http2NoMoreStreamIdsException();
                }
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Request stream %d is not correct for %s connection", streamId, this.server ? "server" : "client");
            }
            if (streamId < this.nextStreamIdToCreate) {
                throw Http2Exception.closedStreamError(Http2Error.PROTOCOL_ERROR, "Request stream %d is behind the next expected stream %d", streamId, this.nextStreamIdToCreate);
            }
            if (this.nextStreamIdToCreate <= 0) {
                throw new Http2Exception(Http2Error.REFUSED_STREAM, "Stream IDs are exhausted for this endpoint.", Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN);
            }
            boolean isReserved = state == Http2Stream.State.RESERVED_LOCAL || state == Http2Stream.State.RESERVED_REMOTE;
            if (!isReserved && !this.canOpenStream() || isReserved && this.numStreams >= this.maxStreams) {
                void var2_3;
                throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Maximum active streams violated for this endpoint: " + (var2_3 != false ? this.maxStreams : this.maxActiveStreams), new Object[0]);
            }
            if (DefaultHttp2Connection.this.isClosed()) {
                void var1_1;
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Attempted to create stream id %d after connection was closed", (int)var1_1);
            }
        }

        private boolean isLocal() {
            DefaultEndpoint defaultEndpoint = this;
            return defaultEndpoint == defaultEndpoint.DefaultHttp2Connection.this.localEndpoint;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$200(DefaultEndpoint x0, int x1) {
            void var1_1;
            x0.lastStreamKnownByPeer((int)var1_1);
        }
    }

    private final class ConnectionStream
    extends DefaultStream {
        ConnectionStream() {
            super(0L, 0, Http2Stream.State.IDLE);
        }

        @Override
        public final boolean isResetSent() {
            return false;
        }

        @Override
        final DefaultEndpoint<? extends Http2FlowController> createdBy() {
            return null;
        }

        @Override
        public final Http2Stream resetSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream open(boolean halfClosed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream closeLocalSide() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream closeRemoteSide() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream headersSent(boolean isInformational) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isHeadersSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Http2Stream pushPromiseSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isPushPromiseSent() {
            throw new UnsupportedOperationException();
        }
    }

    private class DefaultStream
    implements Http2Stream {
        private static final byte META_STATE_SENT_RST = 1;
        private static final byte META_STATE_SENT_HEADERS = 2;
        private static final byte META_STATE_SENT_TRAILERS = 4;
        private static final byte META_STATE_SENT_PUSHPROMISE = 8;
        private static final byte META_STATE_RECV_HEADERS = 16;
        private static final byte META_STATE_RECV_TRAILERS = 32;
        private final int id;
        private final long identity;
        private final PropertyMap properties = new PropertyMap();
        private Http2Stream.State state;
        private byte metaState;

        /*
         * WARNING - void declaration
         */
        DefaultStream(long identity, int id, Http2Stream.State state) {
            void var2_2;
            this.identity = var2_2;
            this.id = id;
            this.state = state;
        }

        @Override
        public final int id() {
            return this.id;
        }

        @Override
        public final Http2Stream.State state() {
            return this.state;
        }

        @Override
        public boolean isResetSent() {
            return (this.metaState & 1) != 0;
        }

        @Override
        public Http2Stream resetSent() {
            this.metaState = (byte)(this.metaState | 1);
            return this;
        }

        @Override
        public Http2Stream headersSent(boolean isInformational) {
            if (!isInformational) {
                this.metaState = (byte)(this.metaState | (this.isHeadersSent() ? 4 : 2));
            }
            return this;
        }

        @Override
        public boolean isHeadersSent() {
            return (this.metaState & 2) != 0;
        }

        @Override
        public boolean isTrailersSent() {
            return (this.metaState & 4) != 0;
        }

        @Override
        public Http2Stream headersReceived(boolean isInformational) {
            if (!isInformational) {
                this.metaState = (byte)(this.metaState | (this.isHeadersReceived() ? 32 : 16));
            }
            return this;
        }

        @Override
        public boolean isHeadersReceived() {
            return (this.metaState & 0x10) != 0;
        }

        @Override
        public boolean isTrailersReceived() {
            return (this.metaState & 0x20) != 0;
        }

        @Override
        public Http2Stream pushPromiseSent() {
            this.metaState = (byte)(this.metaState | 8);
            return this;
        }

        @Override
        public boolean isPushPromiseSent() {
            return (this.metaState & 8) != 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <V> V setProperty(Http2Connection.PropertyKey key, V value) {
            void var2_2;
            void var1_1;
            return this.properties.add(DefaultHttp2Connection.this.verifyKey((Http2Connection.PropertyKey)var1_1), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <V> V getProperty(Http2Connection.PropertyKey key) {
            void var1_1;
            return this.properties.get(DefaultHttp2Connection.this.verifyKey((Http2Connection.PropertyKey)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <V> V removeProperty(Http2Connection.PropertyKey key) {
            void var1_1;
            return this.properties.remove(DefaultHttp2Connection.this.verifyKey((Http2Connection.PropertyKey)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Http2Stream open(boolean halfClosed) throws Http2Exception {
            this.state = DefaultHttp2Connection.activeState(this.id, this.state, this.isLocal(), halfClosed);
            DefaultEndpoint<? extends Http2FlowController> endpoint = this.createdBy();
            if (!endpoint.canOpenStream()) {
                void var1_2;
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Maximum active streams violated for this endpoint: " + var1_2.maxActiveStreams(), new Object[0]);
            }
            this.activate();
            return this;
        }

        void activate() {
            if (this.state == Http2Stream.State.HALF_CLOSED_LOCAL) {
                this.headersSent(false);
            } else if (this.state == Http2Stream.State.HALF_CLOSED_REMOTE) {
                this.headersReceived(false);
            }
            DefaultHttp2Connection.this.activeStreams.activate(this);
        }

        /*
         * WARNING - void declaration
         */
        Http2Stream close(Iterator<?> itr) {
            void var1_1;
            if (this.state == Http2Stream.State.CLOSED) {
                return this;
            }
            this.state = Http2Stream.State.CLOSED;
            --this.createdBy().numStreams;
            DefaultHttp2Connection.this.activeStreams.deactivate(this, (Iterator<?>)var1_1);
            return this;
        }

        @Override
        public Http2Stream close() {
            return this.close(null);
        }

        @Override
        public Http2Stream closeLocalSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_LOCAL;
                    DefaultHttp2Connection.this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        @Override
        public Http2Stream closeRemoteSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_REMOTE;
                    DefaultHttp2Connection.this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        DefaultEndpoint<? extends Http2FlowController> createdBy() {
            if (DefaultHttp2Connection.this.localEndpoint.isValidStreamId(this.id)) {
                return DefaultHttp2Connection.this.localEndpoint;
            }
            return DefaultHttp2Connection.this.remoteEndpoint;
        }

        final boolean isLocal() {
            return DefaultHttp2Connection.this.localEndpoint.isValidStreamId(this.id);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            long value = this.identity;
            if (value == 0L) {
                return System.identityHashCode(this);
            }
            void v0 = var1_1;
            return (int)(v0 ^ v0 >>> 32);
        }

        private class PropertyMap {
            Object[] values = EmptyArrays.EMPTY_OBJECTS;

            private PropertyMap() {
            }

            /*
             * WARNING - void declaration
             */
            <V> V add(DefaultPropertyKey key, V value) {
                void var3_3;
                void var2_2;
                this.resizeIfNecessary(key.index);
                Object prevValue = this.values[key.index];
                this.values[var1_1.index] = var2_2;
                return var3_3;
            }

            /*
             * WARNING - void declaration
             */
            <V> V get(DefaultPropertyKey key) {
                void var1_1;
                if (key.index >= this.values.length) {
                    return null;
                }
                return (V)this.values[var1_1.index];
            }

            /*
             * WARNING - void declaration
             */
            <V> V remove(DefaultPropertyKey key) {
                void var2_2;
                Object prevValue = null;
                if (key.index < this.values.length) {
                    prevValue = this.values[key.index];
                    this.values[var1_1.index] = null;
                }
                return var2_2;
            }

            void resizeIfNecessary(int index) {
                if (index >= this.values.length) {
                    this.values = Arrays.copyOf(this.values, DefaultHttp2Connection.this.propertyKeyRegistry.size());
                }
            }
        }
    }
}

