/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliEncoder;
import io.netty.handler.codec.compression.BrotliOptions;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.DeflateOptions;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import io.netty.handler.codec.compression.SnappyOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdEncoder;
import io.netty.handler.codec.compression.ZstdOptions;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;

public class CompressorHttp2ConnectionEncoder
extends DecoratingHttp2ConnectionEncoder {
    public static final int DEFAULT_COMPRESSION_LEVEL = 6;
    public static final int DEFAULT_WINDOW_BITS = 15;
    public static final int DEFAULT_MEM_LEVEL = 8;
    private int compressionLevel;
    private int windowBits;
    private int memLevel;
    private final Http2Connection.PropertyKey propertyKey;
    private final boolean supportsCompressionOptions;
    private BrotliOptions brotliOptions;
    private GzipOptions gzipCompressionOptions;
    private DeflateOptions deflateOptions;
    private ZstdOptions zstdOptions;
    private SnappyOptions snappyOptions;

    /*
     * WARNING - void declaration
     */
    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder delegate) {
        this((Http2ConnectionEncoder)var1_1, CompressorHttp2ConnectionEncoder.defaultCompressionOptions());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static CompressionOptions[] defaultCompressionOptions() {
        void var0;
        ArrayList<Object> compressionOptions = new ArrayList<Object>();
        compressionOptions.add(StandardCompressionOptions.gzip());
        compressionOptions.add(StandardCompressionOptions.deflate());
        compressionOptions.add(StandardCompressionOptions.snappy());
        if (Brotli.isAvailable()) {
            compressionOptions.add(StandardCompressionOptions.brotli());
        }
        if (Zstd.isAvailable()) {
            compressionOptions.add(StandardCompressionOptions.zstd());
        }
        return var0.toArray(new CompressionOptions[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder delegate, int compressionLevel, int windowBits, int memLevel) {
        super((Http2ConnectionEncoder)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.compressionLevel = ObjectUtil.checkInRange((int)var2_2, (int)0, (int)9, (String)"compressionLevel");
        this.windowBits = ObjectUtil.checkInRange((int)var3_3, (int)9, (int)15, (String)"windowBits");
        this.memLevel = ObjectUtil.checkInRange((int)memLevel, (int)1, (int)9, (String)"memLevel");
        this.propertyKey = this.connection().newKey();
        this.connection().addListener(new Http2ConnectionAdapter(this){
            final /* synthetic */ CompressorHttp2ConnectionEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamRemoved(Http2Stream stream) {
                EmbeddedChannel compressor = (EmbeddedChannel)stream.getProperty(this.this$0.propertyKey);
                if (compressor != null) {
                    void var2_2;
                    void var1_1;
                    this.this$0.cleanup((Http2Stream)var1_1, (EmbeddedChannel)var2_2);
                }
            }
        });
        this.supportsCompressionOptions = false;
    }

    /*
     * WARNING - void declaration
     */
    public CompressorHttp2ConnectionEncoder(Http2ConnectionEncoder delegate, CompressionOptions ... compressionOptionsArgs) {
        super((Http2ConnectionEncoder)var1_1);
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)compressionOptionsArgs, (String)"CompressionOptions");
        ObjectUtil.deepCheckNotNull((String)"CompressionOptions", (Object[])compressionOptionsArgs);
        for (void compressionOptions : var2_2) {
            if (Brotli.isAvailable() && compressionOptions instanceof BrotliOptions) {
                this.brotliOptions = (BrotliOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof GzipOptions) {
                this.gzipCompressionOptions = (GzipOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof DeflateOptions) {
                this.deflateOptions = (DeflateOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof ZstdOptions) {
                this.zstdOptions = (ZstdOptions)compressionOptions;
                continue;
            }
            if (compressionOptions instanceof SnappyOptions) {
                this.snappyOptions = (SnappyOptions)compressionOptions;
                continue;
            }
            throw new IllegalArgumentException("Unsupported " + CompressionOptions.class.getSimpleName() + ": " + compressionOptions);
        }
        this.supportsCompressionOptions = true;
        this.propertyKey = this.connection().newKey();
        this.connection().addListener(new Http2ConnectionAdapter(this){
            final /* synthetic */ CompressorHttp2ConnectionEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onStreamRemoved(Http2Stream stream) {
                EmbeddedChannel compressor = (EmbeddedChannel)stream.getProperty(this.this$0.propertyKey);
                if (compressor != null) {
                    void var2_2;
                    void var1_1;
                    this.this$0.cleanup((Http2Stream)var1_1, (EmbeddedChannel)var2_2);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream, ChannelPromise promise) {
        Http2Stream stream = this.connection().stream(streamId);
        EmbeddedChannel channel = stream == null ? null : (EmbeddedChannel)stream.getProperty(this.propertyKey);
        if (channel == null) {
            return super.writeData(ctx, streamId, data, padding, endOfStream, promise);
        }
        try {
            channel.writeOutbound(new Object[]{data});
            ByteBuf buf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
            if (buf == null) {
                if (endOfStream) {
                    if (channel.finish()) {
                        buf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
                    }
                    ChannelFuture channelFuture = super.writeData(ctx, streamId, buf == null ? Unpooled.EMPTY_BUFFER : buf, padding, true, promise);
                    return channelFuture;
                }
                promise.setSuccess();
                ChannelPromise channelPromise = promise;
                return channelPromise;
            }
            PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
            while (true) {
                ByteBuf nextBuf;
                boolean compressedEndOfStream;
                if ((compressedEndOfStream = (nextBuf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel)) == null && endOfStream) && channel.finish()) {
                    nextBuf = CompressorHttp2ConnectionEncoder.nextReadableBuf(channel);
                    compressedEndOfStream = nextBuf == null;
                }
                ChannelPromise bufPromise = ctx.newPromise();
                combiner.add((Promise)bufPromise);
                super.writeData(ctx, streamId, buf, padding, compressedEndOfStream, bufPromise);
                if (nextBuf == null) break;
                padding = 0;
                buf = nextBuf;
            }
            combiner.finish((Promise)promise);
        }
        catch (Throwable cause) {
            void var3_5;
            promise.tryFailure((Throwable)var3_5);
        }
        finally {
            if (endOfStream) {
                this.cleanup(stream, channel);
            }
        }
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
        try {
            void var1_1;
            void var2_2;
            void var3_3;
            EmbeddedChannel compressor = this.newCompressor(ctx, headers, endStream);
            ChannelFuture future = super.writeHeaders(ctx, streamId, (Http2Headers)var3_3, padding, endStream, promise);
            this.bindCompressorToStream(compressor, (int)var2_2);
            return var1_1;
        }
        catch (Throwable e) {
            promise.tryFailure(e);
            return promise;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream, ChannelPromise promise) {
        try {
            void var1_1;
            void var2_2;
            void var3_3;
            EmbeddedChannel compressor = this.newCompressor(ctx, headers, endOfStream);
            ChannelFuture future = super.writeHeaders(ctx, streamId, (Http2Headers)var3_3, streamDependency, weight, exclusive, padding, endOfStream, promise);
            this.bindCompressorToStream(compressor, (int)var2_2);
            return var1_1;
        }
        catch (Throwable e) {
            promise.tryFailure(e);
            return promise;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected EmbeddedChannel newContentCompressor(ChannelHandlerContext ctx, CharSequence contentEncoding) throws Http2Exception {
        void var2_2;
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return this.newCompressionChannel(ctx, ZlibWrapper.GZIP);
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            return this.newCompressionChannel(ctx, ZlibWrapper.ZLIB);
        }
        if (Brotli.isAvailable() && this.brotliOptions != null && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{new BrotliEncoder(this.brotliOptions.parameters())});
        }
        if (this.zstdOptions != null && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{new ZstdEncoder(this.zstdOptions.compressionLevel(), this.zstdOptions.blockSize(), this.zstdOptions.maxEncodeSize())});
        }
        if (this.snappyOptions != null && HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase((CharSequence)var2_2)) {
            void var1_1;
            return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), var1_1.channel().config(), new ChannelHandler[]{new SnappyFrameEncoder()});
        }
        return null;
    }

    protected CharSequence getTargetContentEncoding(CharSequence contentEncoding) throws Http2Exception {
        return contentEncoding;
    }

    /*
     * WARNING - void declaration
     */
    private EmbeddedChannel newCompressionChannel(ChannelHandlerContext ctx, ZlibWrapper wrapper) {
        void var2_2;
        void var1_1;
        if (this.supportsCompressionOptions) {
            if (wrapper == ZlibWrapper.GZIP && this.gzipCompressionOptions != null) {
                return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)wrapper, (int)this.gzipCompressionOptions.compressionLevel(), (int)this.gzipCompressionOptions.windowBits(), (int)this.gzipCompressionOptions.memLevel())});
            }
            if (wrapper == ZlibWrapper.ZLIB && this.deflateOptions != null) {
                return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)wrapper, (int)this.deflateOptions.compressionLevel(), (int)this.deflateOptions.windowBits(), (int)this.deflateOptions.memLevel())});
            }
            throw new IllegalArgumentException("Unsupported ZlibWrapper: " + wrapper);
        }
        return new EmbeddedChannel(ctx.channel().id(), ctx.channel().metadata().hasDisconnect(), var1_1.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)var2_2, (int)this.compressionLevel, (int)this.windowBits, (int)this.memLevel)});
    }

    /*
     * WARNING - void declaration
     */
    private EmbeddedChannel newCompressor(ChannelHandlerContext ctx, Http2Headers headers, boolean endOfStream) throws Http2Exception {
        void var1_1;
        EmbeddedChannel compressor;
        if (endOfStream) {
            return null;
        }
        CharSequence encoding = (CharSequence)headers.get(HttpHeaderNames.CONTENT_ENCODING);
        if (encoding == null) {
            encoding = HttpHeaderValues.IDENTITY;
        }
        if ((compressor = this.newContentCompressor(ctx, encoding)) != null) {
            void var2_2;
            CharSequence targetContentEncoding = this.getTargetContentEncoding(encoding);
            if (HttpHeaderValues.IDENTITY.contentEqualsIgnoreCase(targetContentEncoding)) {
                headers.remove(HttpHeaderNames.CONTENT_ENCODING);
            } else {
                void var3_4;
                headers.set(HttpHeaderNames.CONTENT_ENCODING, var3_4);
            }
            var2_2.remove((Object)HttpHeaderNames.CONTENT_LENGTH);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void bindCompressorToStream(EmbeddedChannel compressor, int streamId) {
        Http2Stream stream;
        if (compressor != null && (stream = this.connection().stream(streamId)) != null) {
            void var1_1;
            void var2_3;
            var2_3.setProperty(this.propertyKey, var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void cleanup(Http2Stream stream, EmbeddedChannel compressor) {
        void var1_1;
        compressor.finishAndReleaseAll();
        var1_1.removeProperty(this.propertyKey);
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf nextReadableBuf(EmbeddedChannel compressor) {
        void var1_1;
        while (true) {
            ByteBuf buf;
            if ((buf = (ByteBuf)compressor.readOutbound()) == null) {
                return null;
            }
            if (buf.isReadable()) break;
            buf.release();
        }
        return var1_1;
    }
}

