/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public final class CleartextHttp2ServerUpgradeHandler
extends ByteToMessageDecoder {
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer((ByteBuf)Http2CodecUtil.connectionPrefaceBuf()).asReadOnly();
    private final HttpServerCodec httpServerCodec;
    private final HttpServerUpgradeHandler httpServerUpgradeHandler;
    private final ChannelHandler http2ServerHandler;

    /*
     * WARNING - void declaration
     */
    public CleartextHttp2ServerUpgradeHandler(HttpServerCodec httpServerCodec, HttpServerUpgradeHandler httpServerUpgradeHandler, ChannelHandler http2ServerHandler) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.httpServerCodec = (HttpServerCodec)ObjectUtil.checkNotNull((Object)var1_1, (String)"httpServerCodec");
        this.httpServerUpgradeHandler = (HttpServerUpgradeHandler)ObjectUtil.checkNotNull((Object)var2_2, (String)"httpServerUpgradeHandler");
        this.http2ServerHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)var3_3, (String)"http2ServerHandler");
    }

    /*
     * WARNING - void declaration
     */
    public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        ctx.pipeline().addAfter(ctx.name(), null, (ChannelHandler)this.httpServerUpgradeHandler).addAfter(var1_1.name(), null, (ChannelHandler)this.httpServerCodec);
    }

    /*
     * WARNING - void declaration
     */
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        void var3_4;
        void var2_2;
        int prefaceLength = CONNECTION_PREFACE.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLength);
        ByteBuf byteBuf = CONNECTION_PREFACE;
        void v1 = var2_2;
        if (!ByteBufUtil.equals((ByteBuf)byteBuf, (int)byteBuf.readerIndex(), (ByteBuf)v1, (int)v1.readerIndex(), (int)bytesRead)) {
            ctx.pipeline().remove((ChannelHandler)this);
            return;
        }
        if (bytesRead == var3_4) {
            void var1_1;
            ctx.pipeline().remove((ChannelHandler)this.httpServerCodec).remove((ChannelHandler)this.httpServerUpgradeHandler);
            ctx.pipeline().addAfter(ctx.name(), null, this.http2ServerHandler);
            ctx.pipeline().remove((ChannelHandler)this);
            var1_1.fireUserEventTriggered((Object)PriorKnowledgeUpgradeEvent.INSTANCE);
        }
    }

    public static final class PriorKnowledgeUpgradeEvent {
        private static final PriorKnowledgeUpgradeEvent INSTANCE = new PriorKnowledgeUpgradeEvent();

        private PriorKnowledgeUpgradeEvent() {
        }
    }
}

