/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelId;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

abstract class AbstractHttp2StreamChannel
extends DefaultAttributeMap
implements Http2StreamChannel {
    static final Http2FrameStreamVisitor WRITABLE_VISITOR = new Http2FrameStreamVisitor(){

        @Override
        public final boolean visit(Http2FrameStream stream) {
            AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)stream).attachment;
            abstractHttp2StreamChannel.trySetWritable();
            return true;
        }
    };
    static final Http2FrameStreamVisitor CHANNEL_INPUT_SHUTDOWN_READ_COMPLETE_VISITOR = new UserEventStreamVisitor(ChannelInputShutdownReadComplete.INSTANCE);
    static final Http2FrameStreamVisitor CHANNEL_OUTPUT_SHUTDOWN_EVENT_VISITOR = new UserEventStreamVisitor(ChannelOutputShutdownEvent.INSTANCE);
    static final Http2FrameStreamVisitor SSL_CLOSE_COMPLETION_EVENT_VISITOR = new UserEventStreamVisitor(SslCloseCompletionEvent.SUCCESS);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractHttp2StreamChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final int MIN_HTTP2_FRAME_SIZE = 9;
    private static final AtomicLongFieldUpdater<AbstractHttp2StreamChannel> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractHttp2StreamChannel.class, "totalPendingSize");
    private static final AtomicIntegerFieldUpdater<AbstractHttp2StreamChannel> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractHttp2StreamChannel.class, "unwritable");
    private final ChannelFutureListener windowUpdateFrameWriteListener = new ChannelFutureListener(this){
        final /* synthetic */ AbstractHttp2StreamChannel this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void operationComplete(ChannelFuture future) {
            AbstractHttp2StreamChannel.access$000(future, this.this$0);
        }
    };
    private final Http2StreamChannelConfig config = new Http2StreamChannelConfig(this);
    private final Http2ChannelUnsafe unsafe = new Http2ChannelUnsafe();
    private final ChannelId channelId;
    private final ChannelPipeline pipeline;
    private final Http2FrameCodec.DefaultHttp2FrameStream stream;
    private final ChannelPromise closePromise;
    private volatile boolean registered;
    private volatile long totalPendingSize;
    private volatile int unwritable;
    private Runnable fireChannelWritabilityChangedTask;
    private boolean outboundClosed;
    private int flowControlledBytes;
    private ReadStatus readStatus = ReadStatus.IDLE;
    private Queue<Object> inboundBuffer;
    private boolean firstFrameWritten;
    private boolean readCompletePending;

    /*
     * WARNING - void declaration
     */
    private static void windowUpdateFrameWriteComplete(ChannelFuture future, Channel streamChannel) {
        Object cause = future.cause();
        if (cause != null) {
            void var1_1;
            Object object;
            Throwable unwrappedCause;
            if (cause instanceof Http2FrameStreamException && (unwrappedCause = ((Throwable)cause).getCause()) != null) {
                void var2_2;
                cause = var2_2;
            }
            streamChannel.pipeline().fireExceptionCaught((Throwable)object);
            streamChannel.unsafe().close(var1_1.unsafe().voidPromise());
        }
    }

    /*
     * WARNING - void declaration
     */
    AbstractHttp2StreamChannel(Http2FrameCodec.DefaultHttp2FrameStream stream, int id, ChannelHandler inboundHandler) {
        void var2_2;
        this.stream = stream;
        var1_1.attachment = this;
        AbstractHttp2StreamChannel abstractHttp2StreamChannel = this;
        this.pipeline = new DefaultChannelPipeline(abstractHttp2StreamChannel, abstractHttp2StreamChannel){
            final /* synthetic */ AbstractHttp2StreamChannel this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Channel)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            protected void incrementPendingOutboundBytes(long size) {
                void var1_1;
                AbstractHttp2StreamChannel.access$200(this.this$0, (long)var1_1, true);
            }

            /*
             * WARNING - void declaration
             */
            protected void decrementPendingOutboundBytes(long size) {
                void var1_1;
                AbstractHttp2StreamChannel.access$300(this.this$0, (long)var1_1, true);
            }

            /*
             * WARNING - void declaration
             */
            protected void onUnhandledInboundException(Throwable cause) {
                void var1_1;
                if (cause instanceof Http2FrameStreamException) {
                    this.this$0.closeWithError(((Http2FrameStreamException)cause).error());
                    return;
                }
                Http2Exception exception = Http2CodecUtil.getEmbeddedHttp2Exception(cause);
                if (exception != null) {
                    void var2_2;
                    this.this$0.closeWithError(var2_2.error());
                    return;
                }
                super.onUnhandledInboundException((Throwable)var1_1);
            }
        };
        this.closePromise = this.pipeline.newPromise();
        this.channelId = new Http2StreamChannelId(this.parent().id(), (int)var2_2);
        if (inboundHandler != null) {
            void var3_3;
            this.pipeline.addLast(new ChannelHandler[]{var3_3});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void incrementPendingOutboundBytes(long size, boolean invokeLater) {
        void var1_1;
        if (size == 0L) {
            return;
        }
        long l = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, (long)var1_1);
        if (l > (long)this.config().getWriteBufferHighWaterMark()) {
            void var3_2;
            this.setUnwritable((boolean)var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void decrementPendingOutboundBytes(long size, boolean invokeLater) {
        void var1_1;
        if (size == 0L) {
            return;
        }
        long l = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, (long)(-var1_1));
        if (l < (long)this.config().getWriteBufferLowWaterMark() && this.parent().isWritable()) {
            void var3_2;
            this.setWritable((boolean)var3_2);
        }
    }

    final void trySetWritable() {
        if (this.totalPendingSize < (long)this.config().getWriteBufferLowWaterMark()) {
            this.setWritable(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setWritable(boolean invokeLater) {
        void var3_3;
        void var2_2;
        int newValue;
        int oldValue;
        while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue = this.unwritable, newValue = oldValue & 0xFFFFFFFE)) {
        }
        if (var2_2 != false && var3_3 == false) {
            this.fireChannelWritabilityChanged(invokeLater);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setUnwritable(boolean invokeLater) {
        void var2_2;
        void var3_3;
        int oldValue;
        do {
            oldValue = this.unwritable;
            int newValue = oldValue | 1;
        } while (!UNWRITABLE_UPDATER.compareAndSet(this, oldValue, (int)var3_3));
        if (var2_2 == false) {
            this.fireChannelWritabilityChanged(invokeLater);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fireChannelWritabilityChanged(boolean invokeLater) {
        void var2_3;
        ChannelPipeline pipeline = this.pipeline();
        if (invokeLater) {
            void var1_2;
            Runnable task = this.fireChannelWritabilityChangedTask;
            if (task == null) {
                this.fireChannelWritabilityChangedTask = task = new Runnable(this, pipeline){
                    final /* synthetic */ ChannelPipeline val$pipeline;
                    final /* synthetic */ AbstractHttp2StreamChannel this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$pipeline = channelPipeline;
                    }

                    @Override
                    public void run() {
                        this.val$pipeline.fireChannelWritabilityChanged();
                    }
                };
            }
            this.eventLoop().execute((Runnable)var1_2);
            return;
        }
        var2_3.fireChannelWritabilityChanged();
    }

    @Override
    public Http2FrameStream stream() {
        return this.stream;
    }

    void closeOutbound() {
        this.outboundClosed = true;
    }

    void streamClosed() {
        this.unsafe.readEOS();
        this.unsafe.doBeginRead();
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return !this.closePromise.isDone();
    }

    public boolean isActive() {
        return this.isOpen();
    }

    public boolean isWritable() {
        return this.unwritable == 0;
    }

    public ChannelId id() {
        return this.channelId;
    }

    public EventLoop eventLoop() {
        return this.parent().eventLoop();
    }

    public Channel parent() {
        return this.parentContext().channel();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public SocketAddress localAddress() {
        return this.parent().localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.parent().remoteAddress();
    }

    public ChannelFuture closeFuture() {
        return this.closePromise;
    }

    /*
     * WARNING - void declaration
     */
    public long bytesBeforeUnwritable() {
        long bytes = (long)this.config().getWriteBufferHighWaterMark() - this.totalPendingSize + 1L;
        if (bytes > 0L && this.isWritable()) {
            void var1_1;
            return (long)var1_1;
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public long bytesBeforeWritable() {
        void var1_1;
        long bytes = this.totalPendingSize - (long)this.config().getWriteBufferLowWaterMark() + 1L;
        if (bytes <= 0L || this.isWritable()) {
            return 0L;
        }
        return (long)var1_1;
    }

    public Channel.Unsafe unsafe() {
        return this.unsafe;
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    public Channel read() {
        this.pipeline().read();
        return this;
    }

    public Channel flush() {
        this.pipeline().flush();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture bind(SocketAddress localAddress) {
        void var1_1;
        return this.pipeline().bind((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect(SocketAddress remoteAddress) {
        void var1_1;
        return this.pipeline().connect((SocketAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        void var2_2;
        void var1_1;
        return this.pipeline().connect((SocketAddress)var1_1, (SocketAddress)var2_2);
    }

    public ChannelFuture disconnect() {
        return this.pipeline().disconnect();
    }

    public ChannelFuture close() {
        return this.pipeline().close();
    }

    public ChannelFuture deregister() {
        return this.pipeline().deregister();
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.pipeline().bind((SocketAddress)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.pipeline().connect((SocketAddress)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.pipeline().connect((SocketAddress)var1_1, (SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture disconnect(ChannelPromise promise) {
        void var1_1;
        return this.pipeline().disconnect((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture close(ChannelPromise promise) {
        void var1_1;
        return this.pipeline().close((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture deregister(ChannelPromise promise) {
        void var1_1;
        return this.pipeline().deregister((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture write(Object msg) {
        void var1_1;
        return this.pipeline().write((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.pipeline().write((Object)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        return this.pipeline().writeAndFlush((Object)var1_1, (ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture writeAndFlush(Object msg) {
        void var1_1;
        return this.pipeline().writeAndFlush((Object)var1_1);
    }

    public ChannelPromise newPromise() {
        return this.pipeline().newPromise();
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline().newProgressivePromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.pipeline().newSucceededFuture();
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture newFailedFuture(Throwable cause) {
        void var1_1;
        return this.pipeline().newFailedFuture((Throwable)var1_1);
    }

    public ChannelPromise voidPromise() {
        return this.pipeline().voidPromise();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return this == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int compareTo(Channel o) {
        void var1_1;
        if (this == o) {
            return 0;
        }
        return this.id().compareTo((Object)var1_1.id());
    }

    public String toString() {
        return this.parent().toString() + "(H2 - " + this.stream + ')';
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    void fireChildRead(Http2Frame frame) {
        void var1_1;
        assert (this.eventLoop().inEventLoop());
        if (!this.isActive()) {
            ReferenceCountUtil.release((Object)frame);
            return;
        }
        if (this.readStatus != ReadStatus.IDLE) {
            void var2_2;
            assert (this.inboundBuffer == null || this.inboundBuffer.isEmpty());
            RecvByteBufAllocator.Handle allocHandle = this.unsafe.recvBufAllocHandle();
            this.unsafe.doRead0(frame, allocHandle);
            if (allocHandle.continueReading()) {
                this.maybeAddChannelToReadCompletePendingQueue();
                return;
            }
            this.unsafe.notifyReadComplete((RecvByteBufAllocator.Handle)var2_2, true, false);
            return;
        }
        if (this.inboundBuffer == null) {
            this.inboundBuffer = new ArrayDeque<Object>(4);
        }
        this.inboundBuffer.add(var1_1);
    }

    void fireChildReadComplete() {
        assert (this.eventLoop().inEventLoop());
        assert (this.readStatus != ReadStatus.IDLE || !this.readCompletePending);
        this.unsafe.notifyReadComplete(this.unsafe.recvBufAllocHandle(), false, false);
    }

    /*
     * WARNING - void declaration
     */
    final void closeWithError(Http2Error error) {
        void var1_1;
        assert (this.eventLoop().inEventLoop());
        this.unsafe.close(this.unsafe.voidPromise(), (Http2Error)var1_1);
    }

    private void maybeAddChannelToReadCompletePendingQueue() {
        if (!this.readCompletePending) {
            this.readCompletePending = true;
            this.addChannelToReadCompletePendingQueue();
        }
    }

    protected void flush0(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    /*
     * WARNING - void declaration
     */
    protected ChannelFuture write0(ChannelHandlerContext ctx, Object msg) {
        void var3_3;
        void var2_2;
        void var1_1;
        ChannelPromise promise = ctx.newPromise();
        var1_1.write((Object)var2_2, promise);
        return var3_3;
    }

    protected abstract boolean isParentReadInProgress();

    protected abstract void addChannelToReadCompletePendingQueue();

    protected abstract ChannelHandlerContext parentContext();

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ChannelFuture x0, Channel x1) {
        void var1_1;
        AbstractHttp2StreamChannel.windowUpdateFrameWriteComplete(x0, (Channel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(AbstractHttp2StreamChannel x0, long x1, boolean x2) {
        void var3_2;
        void var1_1;
        x0.incrementPendingOutboundBytes((long)var1_1, (boolean)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(AbstractHttp2StreamChannel x0, long x1, boolean x2) {
        void var3_2;
        void var1_1;
        x0.decrementPendingOutboundBytes((long)var1_1, (boolean)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$402(AbstractHttp2StreamChannel x0, boolean x1) {
        void var1_1;
        x0.registered = var1_1;
        return x0.registered;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$602(AbstractHttp2StreamChannel x0, boolean x1) {
        void var1_1;
        x0.readCompletePending = var1_1;
        return x0.readCompletePending;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Queue access$802(AbstractHttp2StreamChannel x0, Queue x1) {
        void var1_1;
        x0.inboundBuffer = var1_1;
        return x0.inboundBuffer;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$902(AbstractHttp2StreamChannel x0, boolean x1) {
        void var1_1;
        x0.outboundClosed = var1_1;
        return x0.outboundClosed;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ReadStatus access$1302(AbstractHttp2StreamChannel x0, ReadStatus x1) {
        void var1_1;
        x0.readStatus = var1_1;
        return x0.readStatus;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1602(AbstractHttp2StreamChannel x0, int x1) {
        void var1_1;
        x0.flowControlledBytes = var1_1;
        return x0.flowControlledBytes;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1802(AbstractHttp2StreamChannel x0, boolean x1) {
        void var1_1;
        x0.firstFrameWritten = var1_1;
        return x0.firstFrameWritten;
    }

    private static final class Http2StreamChannelConfig
    extends DefaultChannelConfig {
        /*
         * WARNING - void declaration
         */
        Http2StreamChannelConfig(Channel channel) {
            super((Channel)var1_1);
            void var1_1;
        }

        public final MessageSizeEstimator getMessageSizeEstimator() {
            return FlowControlledFrameSizeEstimator.INSTANCE;
        }

        public final ChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        public final ChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
            void var1_1;
            if (!(allocator.newHandle() instanceof RecvByteBufAllocator.ExtendedHandle)) {
                throw new IllegalArgumentException("allocator.newHandle() must return an object of type: " + RecvByteBufAllocator.ExtendedHandle.class);
            }
            super.setRecvByteBufAllocator((RecvByteBufAllocator)var1_1);
            return this;
        }
    }

    private final class Http2ChannelUnsafe
    implements Channel.Unsafe {
        private final VoidChannelPromise unsafeVoidPromise;
        private RecvByteBufAllocator.Handle recvHandle;
        private boolean writeDoneAndNoFlush;
        private boolean closeInitiated;
        private boolean readEOS;
        private boolean receivedEndOfStream;
        private boolean sentEndOfStream;

        private Http2ChannelUnsafe() {
            this.unsafeVoidPromise = new VoidChannelPromise((Channel)AbstractHttp2StreamChannel.this, false);
        }

        /*
         * WARNING - void declaration
         */
        public final void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            void var3_3;
            if (!promise.setUncancellable()) {
                return;
            }
            var3_3.setFailure((Throwable)new UnsupportedOperationException());
        }

        public final RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = AbstractHttp2StreamChannel.this.config().getRecvByteBufAllocator().newHandle();
                this.recvHandle.reset(AbstractHttp2StreamChannel.this.config());
            }
            return this.recvHandle;
        }

        public final SocketAddress localAddress() {
            return AbstractHttp2StreamChannel.this.parent().unsafe().localAddress();
        }

        public final SocketAddress remoteAddress() {
            return AbstractHttp2StreamChannel.this.parent().unsafe().remoteAddress();
        }

        /*
         * WARNING - void declaration
         */
        public final void register(EventLoop eventLoop, ChannelPromise promise) {
            void var2_2;
            if (!promise.setUncancellable()) {
                return;
            }
            if (AbstractHttp2StreamChannel.this.registered) {
                promise.setFailure((Throwable)new UnsupportedOperationException("Re-register is not supported"));
                return;
            }
            AbstractHttp2StreamChannel.access$402(AbstractHttp2StreamChannel.this, true);
            var2_2.setSuccess();
            AbstractHttp2StreamChannel.this.pipeline().fireChannelRegistered();
            if (AbstractHttp2StreamChannel.this.isActive()) {
                AbstractHttp2StreamChannel.this.pipeline().fireChannelActive();
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void bind(SocketAddress localAddress, ChannelPromise promise) {
            void var2_2;
            if (!promise.setUncancellable()) {
                return;
            }
            var2_2.setFailure((Throwable)new UnsupportedOperationException());
        }

        /*
         * WARNING - void declaration
         */
        public final void disconnect(ChannelPromise promise) {
            void var1_1;
            this.close((ChannelPromise)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void close(ChannelPromise promise) {
            void var1_1;
            this.close((ChannelPromise)var1_1, Http2Error.CANCEL);
        }

        /*
         * WARNING - void declaration
         */
        final void close(ChannelPromise promise, Http2Error error) {
            void var3_3;
            void var1_1;
            if (!promise.setUncancellable()) {
                return;
            }
            if (this.closeInitiated) {
                if (AbstractHttp2StreamChannel.this.closePromise.isDone()) {
                    promise.setSuccess();
                    return;
                }
                if (!(promise instanceof VoidChannelPromise)) {
                    AbstractHttp2StreamChannel.this.closePromise.addListener((GenericFutureListener)new ChannelFutureListener(this, promise){
                        final /* synthetic */ ChannelPromise val$promise;
                        final /* synthetic */ Http2ChannelUnsafe this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                            this.val$promise = channelPromise;
                        }

                        public void operationComplete(ChannelFuture future) {
                            this.val$promise.setSuccess();
                        }
                    });
                }
                return;
            }
            this.closeInitiated = true;
            AbstractHttp2StreamChannel.access$602(AbstractHttp2StreamChannel.this, false);
            boolean wasActive = AbstractHttp2StreamChannel.this.isActive();
            if (!(!AbstractHttp2StreamChannel.this.parent().isActive() || !Http2CodecUtil.isStreamIdValid(AbstractHttp2StreamChannel.this.stream.id()) || this.readEOS || this.receivedEndOfStream && this.sentEndOfStream)) {
                DefaultHttp2ResetFrame resetFrame = new DefaultHttp2ResetFrame(error).stream(AbstractHttp2StreamChannel.this.stream());
                this.write(resetFrame, AbstractHttp2StreamChannel.this.unsafe().voidPromise());
                this.flush();
            }
            if (AbstractHttp2StreamChannel.this.inboundBuffer != null) {
                Object msg;
                while ((msg = AbstractHttp2StreamChannel.this.inboundBuffer.poll()) != null) {
                    void var2_2;
                    ReferenceCountUtil.release((Object)var2_2);
                }
                AbstractHttp2StreamChannel.access$802(AbstractHttp2StreamChannel.this, null);
            }
            AbstractHttp2StreamChannel.access$902(AbstractHttp2StreamChannel.this, true);
            AbstractHttp2StreamChannel.this.closePromise.setSuccess();
            var1_1.setSuccess();
            Http2ChannelUnsafe http2ChannelUnsafe = this;
            http2ChannelUnsafe.fireChannelInactiveAndDeregister(http2ChannelUnsafe.voidPromise(), (boolean)var3_3);
        }

        public final void closeForcibly() {
            Http2ChannelUnsafe http2ChannelUnsafe = this;
            http2ChannelUnsafe.close(http2ChannelUnsafe.AbstractHttp2StreamChannel.this.unsafe().voidPromise());
        }

        /*
         * WARNING - void declaration
         */
        public final void deregister(ChannelPromise promise) {
            void var1_1;
            this.fireChannelInactiveAndDeregister((ChannelPromise)var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        private void fireChannelInactiveAndDeregister(ChannelPromise promise, boolean fireChannelInactive) {
            void var1_1;
            void var2_2;
            if (!promise.setUncancellable()) {
                return;
            }
            if (!AbstractHttp2StreamChannel.this.registered) {
                promise.setSuccess();
                return;
            }
            this.invokeLater(new Runnable(this, (boolean)var2_2, (ChannelPromise)var1_1){
                final /* synthetic */ boolean val$fireChannelInactive;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ Http2ChannelUnsafe this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$fireChannelInactive = bl;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    if (this.val$fireChannelInactive) {
                        this.this$1.AbstractHttp2StreamChannel.this.pipeline.fireChannelInactive();
                    }
                    if (this.this$1.AbstractHttp2StreamChannel.this.registered) {
                        AbstractHttp2StreamChannel.access$402(this.this$1.AbstractHttp2StreamChannel.this, false);
                        this.this$1.AbstractHttp2StreamChannel.this.pipeline.fireChannelUnregistered();
                    }
                    Http2ChannelUnsafe.access$1100(this.this$1, this.val$promise);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private void safeSetSuccess(ChannelPromise promise) {
            if (!(promise instanceof VoidChannelPromise) && !promise.trySuccess()) {
                void var1_1;
                logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void invokeLater(Runnable task) {
            try {
                AbstractHttp2StreamChannel.this.eventLoop().execute(task);
                return;
            }
            catch (RejectedExecutionException e) {
                void var1_2;
                logger.warn("Can't invoke task later as EventLoop rejected it", (Throwable)var1_2);
                return;
            }
        }

        public final void beginRead() {
            if (!AbstractHttp2StreamChannel.this.isActive()) {
                return;
            }
            this.updateLocalWindowIfNeeded();
            switch (AbstractHttp2StreamChannel.this.readStatus) {
                case IDLE: {
                    AbstractHttp2StreamChannel.access$1302(AbstractHttp2StreamChannel.this, ReadStatus.IN_PROGRESS);
                    this.doBeginRead();
                    return;
                }
                case IN_PROGRESS: {
                    AbstractHttp2StreamChannel.access$1302(AbstractHttp2StreamChannel.this, ReadStatus.REQUESTED);
                }
            }
        }

        private Object pollQueuedMessage() {
            if (AbstractHttp2StreamChannel.this.inboundBuffer == null) {
                return null;
            }
            return AbstractHttp2StreamChannel.this.inboundBuffer.poll();
        }

        /*
         * WARNING - void declaration
         */
        final void doBeginRead() {
            if (AbstractHttp2StreamChannel.this.readStatus == ReadStatus.IDLE) {
                if (this.readEOS && (AbstractHttp2StreamChannel.this.inboundBuffer == null || AbstractHttp2StreamChannel.this.inboundBuffer.isEmpty())) {
                    this.flush();
                    AbstractHttp2StreamChannel.this.unsafe.closeForcibly();
                    return;
                }
            } else {
                do {
                    void var2_2;
                    void var3_3;
                    Object message;
                    if ((message = this.pollQueuedMessage()) == null) {
                        this.flush();
                        if (!this.readEOS) break;
                        AbstractHttp2StreamChannel.this.unsafe.closeForcibly();
                        return;
                    }
                    RecvByteBufAllocator.Handle allocHandle = this.recvBufAllocHandle();
                    allocHandle.reset(AbstractHttp2StreamChannel.this.config());
                    boolean continueReading = false;
                    do {
                        this.doRead0((Http2Frame)message, allocHandle);
                    } while ((this.readEOS || (continueReading = allocHandle.continueReading())) && (message = this.pollQueuedMessage()) != null);
                    if (var3_3 != false && AbstractHttp2StreamChannel.this.isParentReadInProgress() && !this.readEOS) {
                        AbstractHttp2StreamChannel.this.maybeAddChannelToReadCompletePendingQueue();
                        continue;
                    }
                    this.notifyReadComplete((RecvByteBufAllocator.Handle)var2_2, true, true);
                    this.resetReadStatus();
                } while (AbstractHttp2StreamChannel.this.readStatus != ReadStatus.IDLE);
            }
        }

        final void readEOS() {
            this.readEOS = true;
        }

        /*
         * WARNING - void declaration
         */
        private void updateLocalWindowIfNeeded() {
            if (AbstractHttp2StreamChannel.this.flowControlledBytes != 0 && !AbstractHttp2StreamChannel.this.parentContext().isRemoved()) {
                void var1_2;
                int bytes = AbstractHttp2StreamChannel.this.flowControlledBytes;
                AbstractHttp2StreamChannel.access$1602(AbstractHttp2StreamChannel.this, 0);
                ChannelFuture future = AbstractHttp2StreamChannel.this.write0(AbstractHttp2StreamChannel.this.parentContext(), new DefaultHttp2WindowUpdateFrame(bytes).stream(AbstractHttp2StreamChannel.this.stream));
                this.writeDoneAndNoFlush = true;
                if (future.isDone()) {
                    AbstractHttp2StreamChannel.access$000(future, AbstractHttp2StreamChannel.this);
                    return;
                }
                var1_2.addListener((GenericFutureListener)AbstractHttp2StreamChannel.this.windowUpdateFrameWriteListener);
            }
        }

        private void resetReadStatus() {
            AbstractHttp2StreamChannel.access$1302(AbstractHttp2StreamChannel.this, AbstractHttp2StreamChannel.this.readStatus == ReadStatus.REQUESTED ? ReadStatus.IN_PROGRESS : ReadStatus.IDLE);
        }

        /*
         * WARNING - void declaration
         */
        final void notifyReadComplete(RecvByteBufAllocator.Handle allocHandle, boolean forceReadComplete, boolean inReadLoop) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (!AbstractHttp2StreamChannel.this.readCompletePending && var2_2 == false) {
                return;
            }
            AbstractHttp2StreamChannel.access$602(AbstractHttp2StreamChannel.this, false);
            if (var3_3 == false) {
                this.resetReadStatus();
            }
            var1_1.readComplete();
            AbstractHttp2StreamChannel.this.pipeline().fireChannelReadComplete();
            this.flush();
            if (this.readEOS) {
                AbstractHttp2StreamChannel.this.unsafe.closeForcibly();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void doRead0(Http2Frame frame, RecvByteBufAllocator.Handle allocHandle) {
            void var1_1;
            void var2_2;
            void var3_3;
            int bytes;
            if (frame instanceof Http2DataFrame) {
                bytes = ((Http2DataFrame)frame).initialFlowControlledBytes();
                AbstractHttp2StreamChannel.access$1602(AbstractHttp2StreamChannel.this, AbstractHttp2StreamChannel.this.flowControlledBytes + bytes);
            } else {
                bytes = 9;
            }
            this.receivedEndOfStream |= this.isEndOfStream(frame);
            allocHandle.attemptedBytesRead(bytes);
            allocHandle.lastBytesRead((int)var3_3);
            var2_2.incMessagesRead(1);
            AbstractHttp2StreamChannel.this.pipeline().fireChannelRead((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Object msg, ChannelPromise promise) {
            if (!promise.setUncancellable()) {
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            if (!AbstractHttp2StreamChannel.this.isActive() || AbstractHttp2StreamChannel.this.outboundClosed && (msg instanceof Http2HeadersFrame || msg instanceof Http2DataFrame)) {
                ReferenceCountUtil.release((Object)msg);
                promise.setFailure((Throwable)new ClosedChannelException());
                return;
            }
            try {
                if (!(msg instanceof Http2StreamFrame)) {
                    void var1_1;
                    String msgStr = msg.toString();
                    ReferenceCountUtil.release((Object)var1_1);
                    promise.setFailure((Throwable)new IllegalArgumentException("Message must be an " + StringUtil.simpleClassName(Http2StreamFrame.class) + ": " + msgStr));
                    return;
                }
                Http2StreamFrame frame = this.validateStreamFrame((Http2StreamFrame)msg).stream(AbstractHttp2StreamChannel.this.stream());
                this.writeHttp2StreamFrame(frame, promise);
            }
            catch (Throwable t) {
                void var3_5;
                void var2_2;
                var2_2.tryFailure((Throwable)var3_5);
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean isEndOfStream(Http2Frame frame) {
            if (frame instanceof Http2HeadersFrame) {
                return ((Http2HeadersFrame)frame).isEndStream();
            }
            if (frame instanceof Http2DataFrame) {
                void var1_1;
                return ((Http2DataFrame)var1_1).isEndStream();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private void writeHttp2StreamFrame(Http2StreamFrame frame, ChannelPromise promise) {
            void var2_2;
            void var3_3;
            void var1_1;
            if (!(AbstractHttp2StreamChannel.this.firstFrameWritten || Http2CodecUtil.isStreamIdValid(AbstractHttp2StreamChannel.this.stream().id()) || frame instanceof Http2HeadersFrame)) {
                ReferenceCountUtil.release((Object)frame);
                promise.setFailure((Throwable)new IllegalArgumentException("The first frame must be a headers frame. Was: " + frame.name()));
                return;
            }
            boolean firstWrite = AbstractHttp2StreamChannel.this.firstFrameWritten ? false : AbstractHttp2StreamChannel.access$1802(AbstractHttp2StreamChannel.this, true);
            this.sentEndOfStream |= this.isEndOfStream(frame);
            ChannelFuture f = AbstractHttp2StreamChannel.this.write0(AbstractHttp2StreamChannel.this.parentContext(), frame);
            if (f.isDone()) {
                if (firstWrite) {
                    this.firstWriteComplete(f, promise);
                    return;
                }
                this.writeComplete(f, promise);
                return;
            }
            long bytes = FlowControlledFrameSizeEstimator.HANDLE_INSTANCE.size((Object)var1_1);
            AbstractHttp2StreamChannel.access$200(AbstractHttp2StreamChannel.this, bytes, false);
            f.addListener((GenericFutureListener)new ChannelFutureListener(this, (boolean)var3_3, (ChannelPromise)var2_2, bytes){
                final /* synthetic */ boolean val$firstWrite;
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ long val$bytes;
                final /* synthetic */ Http2ChannelUnsafe this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$firstWrite = bl;
                    this.val$promise = channelPromise;
                    this.val$bytes = l;
                }

                /*
                 * WARNING - void declaration
                 */
                public void operationComplete(ChannelFuture future) {
                    if (this.val$firstWrite) {
                        Http2ChannelUnsafe.access$2000(this.this$1, future, this.val$promise);
                    } else {
                        void var1_1;
                        Http2ChannelUnsafe.access$2100(this.this$1, (ChannelFuture)var1_1, this.val$promise);
                    }
                    AbstractHttp2StreamChannel.access$300(this.this$1.AbstractHttp2StreamChannel.this, this.val$bytes, false);
                }
            });
            this.writeDoneAndNoFlush = true;
        }

        /*
         * WARNING - void declaration
         */
        private void firstWriteComplete(ChannelFuture future, ChannelPromise promise) {
            void var1_1;
            void var2_2;
            Throwable cause = future.cause();
            if (cause == null) {
                promise.setSuccess();
                return;
            }
            this.closeForcibly();
            var2_2.setFailure(this.wrapStreamClosedError((Throwable)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private void writeComplete(ChannelFuture future, ChannelPromise promise) {
            void var1_1;
            void var2_2;
            Throwable cause = future.cause();
            if (cause == null) {
                promise.setSuccess();
                return;
            }
            Throwable error = this.wrapStreamClosedError(cause);
            if (error instanceof IOException) {
                if (AbstractHttp2StreamChannel.this.config.isAutoClose()) {
                    this.closeForcibly();
                } else {
                    AbstractHttp2StreamChannel.access$902(AbstractHttp2StreamChannel.this, true);
                }
            }
            var2_2.setFailure((Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private Throwable wrapStreamClosedError(Throwable cause) {
            void var1_1;
            if (cause instanceof Http2Exception && ((Http2Exception)cause).error() == Http2Error.STREAM_CLOSED) {
                return new ClosedChannelException().initCause(cause);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Http2StreamFrame validateStreamFrame(Http2StreamFrame frame) {
            void var1_1;
            if (frame.stream() != null && frame.stream() != AbstractHttp2StreamChannel.this.stream) {
                void var2_2;
                String msgString = frame.toString();
                ReferenceCountUtil.release((Object)frame);
                throw new IllegalArgumentException("Stream " + frame.stream() + " must not be set on the frame: " + (String)var2_2);
            }
            return var1_1;
        }

        public final void flush() {
            if (!this.writeDoneAndNoFlush || AbstractHttp2StreamChannel.this.isParentReadInProgress()) {
                return;
            }
            this.writeDoneAndNoFlush = false;
            AbstractHttp2StreamChannel.this.flush0(AbstractHttp2StreamChannel.this.parentContext());
        }

        public final ChannelPromise voidPromise() {
            return this.unsafeVoidPromise;
        }

        public final ChannelOutboundBuffer outboundBuffer() {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1100(Http2ChannelUnsafe x0, ChannelPromise x1) {
            void var1_1;
            x0.safeSetSuccess((ChannelPromise)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$2000(Http2ChannelUnsafe x0, ChannelFuture x1, ChannelPromise x2) {
            void var2_2;
            void var1_1;
            x0.firstWriteComplete((ChannelFuture)var1_1, (ChannelPromise)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$2100(Http2ChannelUnsafe x0, ChannelFuture x1, ChannelPromise x2) {
            void var2_2;
            void var1_1;
            x0.writeComplete((ChannelFuture)var1_1, (ChannelPromise)var2_2);
        }
    }

    private static enum ReadStatus {
        IDLE,
        IN_PROGRESS,
        REQUESTED;

    }

    private static final class FlowControlledFrameSizeEstimator
    implements MessageSizeEstimator {
        static final FlowControlledFrameSizeEstimator INSTANCE = new FlowControlledFrameSizeEstimator();
        private static final MessageSizeEstimator.Handle HANDLE_INSTANCE = new MessageSizeEstimator.Handle(){

            /*
             * WARNING - void declaration
             */
            public final int size(Object msg) {
                if (msg instanceof Http2DataFrame) {
                    void var1_1;
                    return (int)Math.min(Integer.MAX_VALUE, (long)((Http2DataFrame)var1_1).initialFlowControlledBytes() + 9L);
                }
                return 9;
            }
        };

        private FlowControlledFrameSizeEstimator() {
        }

        public final MessageSizeEstimator.Handle newHandle() {
            return HANDLE_INSTANCE;
        }
    }

    private static final class UserEventStreamVisitor
    implements Http2FrameStreamVisitor {
        private final Object event;

        /*
         * WARNING - void declaration
         */
        UserEventStreamVisitor(Object event) {
            void var1_1;
            this.event = ObjectUtil.checkNotNull((Object)var1_1, (String)"event");
        }

        @Override
        public final boolean visit(Http2FrameStream stream) {
            AbstractHttp2StreamChannel abstractHttp2StreamChannel = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)stream).attachment;
            abstractHttp2StreamChannel.pipeline().fireUserEventTriggered(this.event);
            return true;
        }
    }
}

