/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ControlFrameLimitEncoder;
import io.netty.handler.codec.http2.Http2EmptyDataFrameConnectionDecoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2MaxRstFrameDecoder;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.util.internal.ObjectUtil;

public abstract class AbstractHttp2ConnectionHandlerBuilder<T extends Http2ConnectionHandler, B extends AbstractHttp2ConnectionHandlerBuilder<T, B>> {
    private static final Http2HeadersEncoder.SensitivityDetector DEFAULT_HEADER_SENSITIVITY_DETECTOR = Http2HeadersEncoder.NEVER_SENSITIVE;
    private static final int DEFAULT_MAX_RST_FRAMES_PER_CONNECTION_FOR_SERVER = 200;
    private Http2Settings initialSettings = Http2Settings.defaultSettings();
    private Http2FrameListener frameListener;
    private long gracefulShutdownTimeoutMillis = Http2CodecUtil.DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS;
    private boolean decoupleCloseAndGoAway;
    private boolean flushPreface = true;
    private Boolean isServer;
    private Integer maxReservedStreams;
    private Http2Connection connection;
    private Http2ConnectionDecoder decoder;
    private Http2ConnectionEncoder encoder;
    private Boolean validateHeaders;
    private Http2FrameLogger frameLogger;
    private Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector;
    private Boolean encoderEnforceMaxConcurrentStreams;
    private Boolean encoderIgnoreMaxHeaderListSize;
    private Http2PromisedRequestVerifier promisedRequestVerifier = Http2PromisedRequestVerifier.ALWAYS_VERIFY;
    private boolean autoAckSettingsFrame = true;
    private boolean autoAckPingFrame = true;
    private int maxQueuedControlFrames = 10000;
    private int maxConsecutiveEmptyFrames = 2;
    private Integer maxRstFramesPerWindow;
    private int secondsPerWindow = 30;

    protected Http2Settings initialSettings() {
        return this.initialSettings;
    }

    /*
     * WARNING - void declaration
     */
    protected B initialSettings(Http2Settings settings) {
        void var1_1;
        this.initialSettings = (Http2Settings)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"settings"));
        return this.self();
    }

    protected Http2FrameListener frameListener() {
        return this.frameListener;
    }

    /*
     * WARNING - void declaration
     */
    protected B frameListener(Http2FrameListener frameListener) {
        void var1_1;
        this.frameListener = (Http2FrameListener)ObjectUtil.checkNotNull((Object)var1_1, (String)"frameListener");
        return this.self();
    }

    protected long gracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    /*
     * WARNING - void declaration
     */
    protected B gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        void var1_1;
        if (gracefulShutdownTimeoutMillis < -1L) {
            throw new IllegalArgumentException("gracefulShutdownTimeoutMillis: " + gracefulShutdownTimeoutMillis + " (expected: -1 for indefinite or >= 0)");
        }
        this.gracefulShutdownTimeoutMillis = var1_1;
        return this.self();
    }

    protected boolean isServer() {
        if (this.isServer != null) {
            return this.isServer;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected B server(boolean isServer) {
        void var1_1;
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "connection", this.connection);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "codec", this.decoder);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "codec", this.encoder);
        this.isServer = (boolean)var1_1;
        return this.self();
    }

    protected int maxReservedStreams() {
        if (this.maxReservedStreams != null) {
            return this.maxReservedStreams;
        }
        return 100;
    }

    /*
     * WARNING - void declaration
     */
    protected B maxReservedStreams(int maxReservedStreams) {
        void var1_1;
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "connection", this.connection);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "codec", this.decoder);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("server", "codec", this.encoder);
        this.maxReservedStreams = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"maxReservedStreams");
        return this.self();
    }

    protected Http2Connection connection() {
        return this.connection;
    }

    /*
     * WARNING - void declaration
     */
    protected B connection(Http2Connection connection) {
        void var1_1;
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("connection", "maxReservedStreams", this.maxReservedStreams);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("connection", "server", this.isServer);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("connection", "codec", this.decoder);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("connection", "codec", this.encoder);
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)var1_1, (String)"connection");
        return this.self();
    }

    protected Http2ConnectionDecoder decoder() {
        return this.decoder;
    }

    protected Http2ConnectionEncoder encoder() {
        return this.encoder;
    }

    /*
     * WARNING - void declaration
     */
    protected B codec(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder) {
        void var2_2;
        void var1_1;
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "server", this.isServer);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "maxReservedStreams", this.maxReservedStreams);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "connection", this.connection);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "frameLogger", (Object)this.frameLogger);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "validateHeaders", this.validateHeaders);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "headerSensitivityDetector", this.headerSensitivityDetector);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint("codec", "encoderEnforceMaxConcurrentStreams", this.encoderEnforceMaxConcurrentStreams);
        ObjectUtil.checkNotNull((Object)decoder, (String)"decoder");
        ObjectUtil.checkNotNull((Object)encoder, (String)"encoder");
        if (decoder.connection() != encoder.connection()) {
            throw new IllegalArgumentException("The specified encoder and decoder have different connections.");
        }
        this.decoder = var1_1;
        this.encoder = var2_2;
        return this.self();
    }

    protected boolean isValidateHeaders() {
        if (this.validateHeaders != null) {
            return this.validateHeaders;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected B validateHeaders(boolean validateHeaders) {
        void var1_1;
        this.enforceNonCodecConstraints("validateHeaders");
        this.validateHeaders = (boolean)var1_1;
        return this.self();
    }

    protected Http2FrameLogger frameLogger() {
        return this.frameLogger;
    }

    /*
     * WARNING - void declaration
     */
    protected B frameLogger(Http2FrameLogger frameLogger) {
        void var1_1;
        this.enforceNonCodecConstraints("frameLogger");
        this.frameLogger = (Http2FrameLogger)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"frameLogger"));
        return this.self();
    }

    protected boolean encoderEnforceMaxConcurrentStreams() {
        if (this.encoderEnforceMaxConcurrentStreams != null) {
            return this.encoderEnforceMaxConcurrentStreams;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected B encoderEnforceMaxConcurrentStreams(boolean encoderEnforceMaxConcurrentStreams) {
        void var1_1;
        this.enforceNonCodecConstraints("encoderEnforceMaxConcurrentStreams");
        this.encoderEnforceMaxConcurrentStreams = (boolean)var1_1;
        return this.self();
    }

    protected int encoderEnforceMaxQueuedControlFrames() {
        return this.maxQueuedControlFrames;
    }

    /*
     * WARNING - void declaration
     */
    protected B encoderEnforceMaxQueuedControlFrames(int maxQueuedControlFrames) {
        void var1_1;
        this.enforceNonCodecConstraints("encoderEnforceMaxQueuedControlFrames");
        this.maxQueuedControlFrames = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"maxQueuedControlFrames");
        return this.self();
    }

    protected Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector() {
        if (this.headerSensitivityDetector != null) {
            return this.headerSensitivityDetector;
        }
        return DEFAULT_HEADER_SENSITIVITY_DETECTOR;
    }

    /*
     * WARNING - void declaration
     */
    protected B headerSensitivityDetector(Http2HeadersEncoder.SensitivityDetector headerSensitivityDetector) {
        void var1_1;
        this.enforceNonCodecConstraints("headerSensitivityDetector");
        this.headerSensitivityDetector = (Http2HeadersEncoder.SensitivityDetector)ObjectUtil.checkNotNull((Object)var1_1, (String)"headerSensitivityDetector");
        return this.self();
    }

    /*
     * WARNING - void declaration
     */
    protected B encoderIgnoreMaxHeaderListSize(boolean ignoreMaxHeaderListSize) {
        void var1_1;
        this.enforceNonCodecConstraints("encoderIgnoreMaxHeaderListSize");
        this.encoderIgnoreMaxHeaderListSize = (boolean)var1_1;
        return this.self();
    }

    @Deprecated
    protected B initialHuffmanDecodeCapacity(int initialHuffmanDecodeCapacity) {
        return this.self();
    }

    /*
     * WARNING - void declaration
     */
    protected B promisedRequestVerifier(Http2PromisedRequestVerifier promisedRequestVerifier) {
        void var1_1;
        this.enforceNonCodecConstraints("promisedRequestVerifier");
        this.promisedRequestVerifier = (Http2PromisedRequestVerifier)ObjectUtil.checkNotNull((Object)var1_1, (String)"promisedRequestVerifier");
        return this.self();
    }

    protected Http2PromisedRequestVerifier promisedRequestVerifier() {
        return this.promisedRequestVerifier;
    }

    protected int decoderEnforceMaxConsecutiveEmptyDataFrames() {
        return this.maxConsecutiveEmptyFrames;
    }

    /*
     * WARNING - void declaration
     */
    protected B decoderEnforceMaxConsecutiveEmptyDataFrames(int maxConsecutiveEmptyFrames) {
        void var1_1;
        this.enforceNonCodecConstraints("maxConsecutiveEmptyFrames");
        this.maxConsecutiveEmptyFrames = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"maxConsecutiveEmptyFrames");
        return this.self();
    }

    /*
     * WARNING - void declaration
     */
    protected B decoderEnforceMaxRstFramesPerWindow(int maxRstFramesPerWindow, int secondsPerWindow) {
        void var2_2;
        void var1_1;
        this.enforceNonCodecConstraints("decoderEnforceMaxRstFramesPerWindow");
        this.maxRstFramesPerWindow = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"maxRstFramesPerWindow");
        this.secondsPerWindow = ObjectUtil.checkPositiveOrZero((int)var2_2, (String)"secondsPerWindow");
        return this.self();
    }

    /*
     * WARNING - void declaration
     */
    protected B autoAckSettingsFrame(boolean autoAckSettings) {
        void var1_1;
        this.enforceNonCodecConstraints("autoAckSettingsFrame");
        this.autoAckSettingsFrame = var1_1;
        return this.self();
    }

    protected boolean isAutoAckSettingsFrame() {
        return this.autoAckSettingsFrame;
    }

    /*
     * WARNING - void declaration
     */
    protected B autoAckPingFrame(boolean autoAckPingFrame) {
        void var1_1;
        this.enforceNonCodecConstraints("autoAckPingFrame");
        this.autoAckPingFrame = var1_1;
        return this.self();
    }

    protected boolean isAutoAckPingFrame() {
        return this.autoAckPingFrame;
    }

    /*
     * WARNING - void declaration
     */
    protected B decoupleCloseAndGoAway(boolean decoupleCloseAndGoAway) {
        void var1_1;
        this.decoupleCloseAndGoAway = var1_1;
        return this.self();
    }

    protected boolean decoupleCloseAndGoAway() {
        return this.decoupleCloseAndGoAway;
    }

    /*
     * WARNING - void declaration
     */
    protected B flushPreface(boolean flushPreface) {
        void var1_1;
        this.flushPreface = var1_1;
        return this.self();
    }

    protected boolean flushPreface() {
        return this.flushPreface;
    }

    /*
     * WARNING - void declaration
     */
    protected T build() {
        void var1_1;
        if (this.encoder != null) {
            assert (this.decoder != null);
            AbstractHttp2ConnectionHandlerBuilder abstractHttp2ConnectionHandlerBuilder = this;
            return abstractHttp2ConnectionHandlerBuilder.buildFromCodec(abstractHttp2ConnectionHandlerBuilder.decoder, this.encoder);
        }
        Http2Connection connection = this.connection;
        if (connection == null) {
            connection = new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams());
        }
        return this.buildFromConnection((Http2Connection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private T buildFromConnection(Http2Connection connection) {
        void var3_3;
        void var1_1;
        void var2_2;
        Http2FrameWriter writer;
        Long maxHeaderListSize = this.initialSettings.maxHeaderListSize();
        Http2FrameReader reader = new DefaultHttp2FrameReader(new DefaultHttp2HeadersDecoder(this.isValidateHeaders(), maxHeaderListSize == null ? 8192L : maxHeaderListSize, -1));
        DefaultHttp2FrameWriter defaultHttp2FrameWriter = writer = this.encoderIgnoreMaxHeaderListSize == null ? new DefaultHttp2FrameWriter(this.headerSensitivityDetector()) : new DefaultHttp2FrameWriter(this.headerSensitivityDetector(), this.encoderIgnoreMaxHeaderListSize);
        if (this.frameLogger != null) {
            reader = new Http2InboundFrameLogger(reader, this.frameLogger);
            writer = new Http2OutboundFrameLogger(writer, this.frameLogger);
        }
        Http2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder(connection, writer);
        boolean encoderEnforceMaxConcurrentStreams = this.encoderEnforceMaxConcurrentStreams();
        if (this.maxQueuedControlFrames != 0) {
            encoder = new Http2ControlFrameLimitEncoder(encoder, this.maxQueuedControlFrames);
        }
        if (encoderEnforceMaxConcurrentStreams) {
            if (connection.isServer()) {
                encoder.close();
                reader.close();
                throw new IllegalArgumentException("encoderEnforceMaxConcurrentStreams: " + encoderEnforceMaxConcurrentStreams + " not supported for server");
            }
            encoder = new StreamBufferingEncoder(encoder);
        }
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(connection, encoder, (Http2FrameReader)var2_2, this.promisedRequestVerifier(), this.isAutoAckSettingsFrame(), this.isAutoAckPingFrame(), this.isValidateHeaders());
        return this.buildFromCodec((Http2ConnectionDecoder)var1_1, (Http2ConnectionEncoder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private T buildFromCodec(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder) {
        void var3_4;
        T handler;
        int maxConsecutiveEmptyDataFrames = this.decoderEnforceMaxConsecutiveEmptyDataFrames();
        if (maxConsecutiveEmptyDataFrames > 0) {
            decoder = new Http2EmptyDataFrameConnectionDecoder(decoder, maxConsecutiveEmptyDataFrames);
        }
        int maxRstFrames = this.maxRstFramesPerWindow == null ? (this.isServer() ? 200 : 0) : this.maxRstFramesPerWindow;
        if (maxRstFrames > 0 && this.secondsPerWindow > 0) {
            decoder = new Http2MaxRstFrameDecoder(decoder, maxRstFrames, this.secondsPerWindow);
        }
        try {
            handler = this.build(decoder, encoder, this.initialSettings);
        }
        catch (Throwable t) {
            void var1_1;
            void var2_2;
            var2_2.close();
            var1_1.close();
            throw new IllegalStateException("failed to build an Http2ConnectionHandler", t);
        }
        ((Http2ConnectionHandler)handler).gracefulShutdownTimeoutMillis(this.gracefulShutdownTimeoutMillis);
        if (((Http2ConnectionHandler)handler).decoder().frameListener() == null) {
            ((Http2ConnectionHandler)handler).decoder().frameListener(this.frameListener);
        }
        return var3_4;
    }

    protected abstract T build(Http2ConnectionDecoder var1, Http2ConnectionEncoder var2, Http2Settings var3) throws Exception;

    protected final B self() {
        return (B)this;
    }

    /*
     * WARNING - void declaration
     */
    private void enforceNonCodecConstraints(String rejected) {
        void var1_1;
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint(rejected, "server/connection", this.decoder);
        AbstractHttp2ConnectionHandlerBuilder.enforceConstraint((String)var1_1, "server/connection", this.encoder);
    }

    /*
     * WARNING - void declaration
     */
    private static void enforceConstraint(String methodName, String rejectorName, Object value) {
        if (value != null) {
            void var1_1;
            String string;
            throw new IllegalStateException(string + "() cannot be called because " + (String)var1_1 + "() has been called already.");
        }
    }
}

