/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TrafficCounter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TrafficCounter.class);
    private final AtomicLong currentWrittenBytes = new AtomicLong();
    private final AtomicLong currentReadBytes = new AtomicLong();
    private long writingTime;
    private long readingTime;
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    private long lastCumulativeTime;
    private long lastWriteThroughput;
    private long lastReadThroughput;
    final AtomicLong lastTime = new AtomicLong();
    private volatile long lastWrittenBytes;
    private volatile long lastReadBytes;
    private volatile long lastWritingTime;
    private volatile long lastReadingTime;
    private final AtomicLong realWrittenBytes = new AtomicLong();
    private long realWriteThroughput;
    final AtomicLong checkInterval = new AtomicLong(1000L);
    final String name;
    final AbstractTrafficShapingHandler trafficShapingHandler;
    final ScheduledExecutorService executor;
    Runnable monitor;
    volatile ScheduledFuture<?> scheduledFuture;
    volatile boolean monitorActive;

    public static long milliSecondFromNano() {
        return System.nanoTime() / 1000000L;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void start() {
        if (this.monitorActive) {
            return;
        }
        this.lastTime.set(TrafficCounter.milliSecondFromNano());
        long localCheckInterval = this.checkInterval.get();
        if (localCheckInterval > 0L && this.executor != null) {
            void var1_1;
            this.monitorActive = true;
            this.monitor = new TrafficMonitoringTask();
            this.scheduledFuture = this.executor.scheduleAtFixedRate(this.monitor, 0L, (long)var1_1, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (!this.monitorActive) {
            return;
        }
        this.monitorActive = false;
        this.resetAccounting(TrafficCounter.milliSecondFromNano());
        if (this.trafficShapingHandler != null) {
            this.trafficShapingHandler.doAccounting(this);
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void resetAccounting(long newLastTime) {
        void var3_2;
        void var1_1;
        long interval = newLastTime - this.lastTime.getAndSet((long)var1_1);
        if (interval == 0L) {
            return;
        }
        if (logger.isDebugEnabled() && interval > this.checkInterval() << 1) {
            logger.debug("Acct schedule not ok: " + interval + " > 2*" + this.checkInterval() + " from " + this.name);
        }
        this.lastReadBytes = this.currentReadBytes.getAndSet(0L);
        this.lastWrittenBytes = this.currentWrittenBytes.getAndSet(0L);
        this.lastReadThroughput = this.lastReadBytes * 1000L / interval;
        this.lastWriteThroughput = this.lastWrittenBytes * 1000L / interval;
        this.realWriteThroughput = this.realWrittenBytes.getAndSet(0L) * 1000L / var3_2;
        this.lastWritingTime = Math.max(this.lastWritingTime, this.writingTime);
        this.lastReadingTime = Math.max(this.lastReadingTime, this.readingTime);
    }

    /*
     * WARNING - void declaration
     */
    public TrafficCounter(ScheduledExecutorService executor, String name, long checkInterval) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.name = (String)ObjectUtil.checkNotNull((Object)var2_2, (String)"name");
        this.trafficShapingHandler = null;
        this.executor = var1_1;
        this.init((long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public TrafficCounter(AbstractTrafficShapingHandler trafficShapingHandler, ScheduledExecutorService executor, String name, long checkInterval) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.name = (String)ObjectUtil.checkNotNull((Object)var3_3, (String)"name");
        this.trafficShapingHandler = (AbstractTrafficShapingHandler)((Object)ObjectUtil.checkNotNullWithIAE((Object)var1_1, (String)"trafficShapingHandler"));
        this.executor = var2_2;
        this.init(checkInterval);
    }

    /*
     * WARNING - void declaration
     */
    private void init(long checkInterval) {
        void var1_1;
        this.lastCumulativeTime = System.currentTimeMillis();
        this.readingTime = this.writingTime = TrafficCounter.milliSecondFromNano();
        this.lastWritingTime = this.writingTime;
        this.lastReadingTime = this.writingTime;
        this.configure((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void configure(long newCheckInterval) {
        long newInterval = newCheckInterval / 10L * 10L;
        if (this.checkInterval.getAndSet(newInterval) != newInterval) {
            void var3_2;
            if (var3_2 <= 0L) {
                this.stop();
                this.lastTime.set(TrafficCounter.milliSecondFromNano());
                return;
            }
            this.stop();
            this.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    void bytesRecvFlowControl(long recv) {
        void var1_1;
        this.currentReadBytes.addAndGet(recv);
        this.cumulativeReadBytes.addAndGet((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void bytesWriteFlowControl(long write) {
        void var1_1;
        this.currentWrittenBytes.addAndGet(write);
        this.cumulativeWrittenBytes.addAndGet((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void bytesRealWriteFlowControl(long write) {
        void var1_1;
        this.realWrittenBytes.addAndGet((long)var1_1);
    }

    public long checkInterval() {
        return this.checkInterval.get();
    }

    public long lastReadThroughput() {
        return this.lastReadThroughput;
    }

    public long lastWriteThroughput() {
        return this.lastWriteThroughput;
    }

    public long lastReadBytes() {
        return this.lastReadBytes;
    }

    public long lastWrittenBytes() {
        return this.lastWrittenBytes;
    }

    public long currentReadBytes() {
        return this.currentReadBytes.get();
    }

    public long currentWrittenBytes() {
        return this.currentWrittenBytes.get();
    }

    public long lastTime() {
        return this.lastTime.get();
    }

    public long cumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    public long cumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public long lastCumulativeTime() {
        return this.lastCumulativeTime;
    }

    public AtomicLong getRealWrittenBytes() {
        return this.realWrittenBytes;
    }

    public long getRealWriteThroughput() {
        return this.realWriteThroughput;
    }

    public void resetCumulativeTime() {
        this.lastCumulativeTime = System.currentTimeMillis();
        this.cumulativeReadBytes.set(0L);
        this.cumulativeWrittenBytes.set(0L);
    }

    public String name() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public long readTimeToWait(long size, long limitTraffic, long maxTime) {
        void var3_2;
        void var1_1;
        return this.readTimeToWait((long)var1_1, (long)var3_2, maxTime, TrafficCounter.milliSecondFromNano());
    }

    /*
     * WARNING - void declaration
     */
    public long readTimeToWait(long size, long limitTraffic, long maxTime, long now) {
        void var3_2;
        void var1_1;
        this.bytesRecvFlowControl(size);
        if (var1_1 == 0L || limitTraffic == 0L) {
            return 0L;
        }
        long lastTimeCheck = this.lastTime.get();
        long sum = this.currentReadBytes.get();
        long localReadingTime = this.readingTime;
        long lastRB = this.lastReadBytes;
        long interval = now - lastTimeCheck;
        long pastDelay = Math.max(this.lastReadingTime - lastTimeCheck, 0L);
        if (interval > 10L) {
            long time = sum * 1000L / limitTraffic - interval + pastDelay;
            if (time > 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Time: " + time + ':' + sum + ':' + interval + ':' + pastDelay);
                }
                if (time > maxTime && now + time - localReadingTime > maxTime) {
                    time = maxTime;
                }
                this.readingTime = Math.max(localReadingTime, now + time);
                return time;
            }
            this.readingTime = Math.max(localReadingTime, now);
            return 0L;
        }
        long lastsum = sum + lastRB;
        long lastinterval = interval + this.checkInterval.get();
        long time = lastsum * 1000L / var3_2 - lastinterval + pastDelay;
        if (time > 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Time: " + time + ':' + lastsum + ':' + lastinterval + ':' + pastDelay);
            }
            if (time > maxTime && now + time - localReadingTime > maxTime) {
                time = maxTime;
            }
            this.readingTime = Math.max(localReadingTime, now + time);
            return time;
        }
        this.readingTime = Math.max(localReadingTime, now);
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public long writeTimeToWait(long size, long limitTraffic, long maxTime) {
        void var3_2;
        void var1_1;
        return this.writeTimeToWait((long)var1_1, (long)var3_2, maxTime, TrafficCounter.milliSecondFromNano());
    }

    /*
     * WARNING - void declaration
     */
    public long writeTimeToWait(long size, long limitTraffic, long maxTime, long now) {
        void var3_2;
        void var1_1;
        this.bytesWriteFlowControl(size);
        if (var1_1 == 0L || limitTraffic == 0L) {
            return 0L;
        }
        long lastTimeCheck = this.lastTime.get();
        long sum = this.currentWrittenBytes.get();
        long lastWB = this.lastWrittenBytes;
        long localWritingTime = this.writingTime;
        long pastDelay = Math.max(this.lastWritingTime - lastTimeCheck, 0L);
        long interval = now - lastTimeCheck;
        if (interval > 10L) {
            long time = sum * 1000L / limitTraffic - interval + pastDelay;
            if (time > 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Time: " + time + ':' + sum + ':' + interval + ':' + pastDelay);
                }
                if (time > maxTime && now + time - localWritingTime > maxTime) {
                    time = maxTime;
                }
                this.writingTime = Math.max(localWritingTime, now + time);
                return time;
            }
            this.writingTime = Math.max(localWritingTime, now);
            return 0L;
        }
        long lastsum = sum + lastWB;
        long lastinterval = interval + this.checkInterval.get();
        long time = lastsum * 1000L / var3_2 - lastinterval + pastDelay;
        if (time > 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Time: " + time + ':' + lastsum + ':' + lastinterval + ':' + pastDelay);
            }
            if (time > maxTime && now + time - localWritingTime > maxTime) {
                time = maxTime;
            }
            this.writingTime = Math.max(localWritingTime, now + time);
            return time;
        }
        this.writingTime = Math.max(localWritingTime, now);
        return 0L;
    }

    public String toString() {
        return new StringBuilder(165).append("Monitor ").append(this.name).append(" Current Speed Read: ").append(this.lastReadThroughput >> 10).append(" KB/s, Asked Write: ").append(this.lastWriteThroughput >> 10).append(" KB/s, Real Write: ").append(this.realWriteThroughput >> 10).append(" KB/s, Current Read: ").append(this.currentReadBytes.get() >> 10).append(" KB, Current asked Write: ").append(this.currentWrittenBytes.get() >> 10).append(" KB, Current real Write: ").append(this.realWrittenBytes.get() >> 10).append(" KB").toString();
    }

    private final class TrafficMonitoringTask
    implements Runnable {
        private TrafficMonitoringTask() {
        }

        @Override
        public final void run() {
            if (!TrafficCounter.this.monitorActive) {
                return;
            }
            TrafficCounter.this.resetAccounting(TrafficCounter.milliSecondFromNano());
            if (TrafficCounter.this.trafficShapingHandler != null) {
                TrafficCounter.this.trafficShapingHandler.doAccounting(TrafficCounter.this);
            }
        }
    }
}

