/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class GlobalTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ConcurrentMap<Integer, PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    long maxGlobalWriteSize = 0x19000000L;

    /*
     * WARNING - void declaration
     */
    void createGlobalTrafficCounter(ScheduledExecutorService executor) {
        void var1_1;
        TrafficCounter tc = new TrafficCounter(this, (ScheduledExecutorService)ObjectUtil.checkNotNull((Object)executor, (String)"executor"), "GlobalTC", this.checkInterval);
        this.setTrafficCounter(tc);
        var1_1.start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public GlobalTrafficShapingHandler(ScheduledExecutorService executor, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super((long)var2_3, readLimit, checkInterval, maxTime);
        void var1_2;
        void var2_3;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public GlobalTrafficShapingHandler(ScheduledExecutorService executor, long writeLimit, long readLimit, long checkInterval) {
        super((long)var2_2, readLimit, checkInterval);
        void var1_1;
        void var2_2;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public GlobalTrafficShapingHandler(ScheduledExecutorService executor, long writeLimit, long readLimit) {
        super((long)var2_2, readLimit);
        void var1_1;
        void var2_2;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public GlobalTrafficShapingHandler(ScheduledExecutorService executor, long checkInterval) {
        super((long)var2_2);
        void var1_1;
        void var2_2;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public GlobalTrafficShapingHandler(EventExecutor executor) {
        void var1_1;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_1);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxGlobalWriteSize(long maxGlobalWriteSize) {
        void var1_1;
        this.maxGlobalWriteSize = var1_1;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    /*
     * WARNING - void declaration
     */
    private PerChannel getOrSetPerChannel(ChannelHandlerContext ctx) {
        void var2_2;
        Integer key = (ctx = ctx.channel()).hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel == null) {
            void var1_1;
            perChannel = new PerChannel();
            new PerChannel().messagesQueue = new ArrayDeque();
            perChannel.queueSize = 0L;
            perChannel.lastWriteTimestamp = perChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put((Integer)var1_1, perChannel);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.getOrSetPerChannel(ctx);
        super.handlerAdded((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        Channel channel = ctx.channel();
        Integer key = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.remove(key);
        if (perChannel != null) {
            PerChannel perChannel2 = perChannel;
            synchronized (perChannel2) {
                void var3_4;
                Iterator<ToSend> iterator;
                if (iterator.isActive()) {
                    for (ToSend toSend : perChannel.messagesQueue) {
                        long size = this.calculateSize(toSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(size);
                        perChannel.queueSize -= size;
                        this.queuesSize.addAndGet(-size);
                        ctx.write(toSend.toSend, toSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-perChannel.queueSize);
                    for (ToSend toSend : perChannel.messagesQueue) {
                        if (!(toSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)toSend.toSend).release();
                    }
                }
                var3_4.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(ctx);
        this.releaseReadSuspended(ctx);
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    long checkWaitReadTime(ChannelHandlerContext ctx, long wait, long now) {
        void var2_2;
        void var1_1;
        Integer key = ctx.channel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel != null && wait > this.maxTime && now + wait - var1_1.lastReadTimestamp > this.maxTime) {
            wait = this.maxTime;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void informReadOperation(ChannelHandlerContext ctx, long now) {
        Integer key = ctx.channel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel != null) {
            void var2_2;
            var1_1.lastReadTimestamp = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void submitWrite(ChannelHandlerContext ctx, Object msg, long size, long writedelay, long now, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        ToSend newToSend;
        Channel channel = ctx.channel();
        Integer key = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel == null) {
            perChannel = this.getOrSetPerChannel(ctx);
        }
        long delay = writedelay;
        boolean globalSizeExceeded = false;
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            void var3_3;
            if (writedelay == 0L && perChannel.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(size);
                ctx.write(msg, promise);
                perChannel.lastWriteTimestamp = now;
                return;
            }
            if (delay > this.maxTime && now + delay - perChannel.lastWriteTimestamp > this.maxTime) {
                delay = this.maxTime;
            }
            newToSend = new ToSend(delay + now, msg, size, promise);
            perChannel.messagesQueue.addLast(newToSend);
            perChannel.queueSize += size;
            this.queuesSize.addAndGet((long)var3_3);
            this.checkWriteSuspend(ctx, delay, perChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                globalSizeExceeded = true;
            }
        }
        if (globalSizeExceeded) {
            this.setUserDefinedWritability(ctx, false);
        }
        long futureNow = newToSend.relativeTimeAction;
        PerChannel forSchedule = perChannel;
        ctx.executor().schedule(new Runnable(this, (ChannelHandlerContext)var1_1, (PerChannel)var2_2, futureNow){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ PerChannel val$forSchedule;
            final /* synthetic */ long val$futureNow;
            final /* synthetic */ GlobalTrafficShapingHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
                this.val$forSchedule = perChannel;
                this.val$futureNow = l;
            }

            @Override
            public void run() {
                GlobalTrafficShapingHandler.access$200(this.this$0, this.val$ctx, this.val$forSchedule, this.val$futureNow);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private void sendAllValid(ChannelHandlerContext ctx, PerChannel perChannel, long now) {
        void var1_1;
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            void var2_3;
            ToSend newToSend = perChannel.messagesQueue.pollFirst();
            while (newToSend != null) {
                long size;
                if (newToSend.relativeTimeAction <= now) {
                    size = newToSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                    perChannel.queueSize -= size;
                } else {
                    perChannel.messagesQueue.addFirst(newToSend);
                    break;
                }
                this.queuesSize.addAndGet(-size);
                ctx.write(newToSend.toSend, newToSend.promise);
                perChannel.lastWriteTimestamp = now;
                newToSend = perChannel.messagesQueue.pollFirst();
            }
            if (var2_3.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(ctx);
            }
        }
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(GlobalTrafficShapingHandler x0, ChannelHandlerContext x1, PerChannel x2, long x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.sendAllValid((ChannelHandlerContext)var1_1, (PerChannel)var2_2, (long)var3_3);
    }

    private static final class ToSend {
        final long relativeTimeAction;
        final Object toSend;
        final long size;
        final ChannelPromise promise;

        /*
         * WARNING - void declaration
         */
        private ToSend(long delay, Object toSend, long size, ChannelPromise promise) {
            void var3_2;
            void var1_1;
            this.relativeTimeAction = var1_1;
            this.toSend = var3_2;
            this.size = size;
            this.promise = promise;
        }
    }

    private static final class PerChannel {
        ArrayDeque<ToSend> messagesQueue;
        long queueSize;
        long lastWriteTimestamp;
        long lastReadTimestamp;

        private PerChannel() {
        }
    }
}

