/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.GlobalChannelTrafficCounter;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.util.Attribute;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class GlobalChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(GlobalChannelTrafficShapingHandler.class);
    final ConcurrentMap<Integer, PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    volatile long maxGlobalWriteSize = 0x19000000L;
    private volatile long writeChannelLimit;
    private volatile long readChannelLimit;
    private static final float DEFAULT_DEVIATION = 0.1f;
    private static final float MAX_DEVIATION = 0.4f;
    private static final float DEFAULT_SLOWDOWN = 0.4f;
    private static final float DEFAULT_ACCELERATION = -0.1f;
    private volatile float maxDeviation;
    private volatile float accelerationFactor;
    private volatile float slowDownFactor;
    private volatile boolean readDeviationActive;
    private volatile boolean writeDeviationActive;

    /*
     * WARNING - void declaration
     */
    void createGlobalTrafficCounter(ScheduledExecutorService executor) {
        void var1_1;
        this.setMaxDeviation(0.1f, 0.4f, -0.1f);
        ObjectUtil.checkNotNullWithIAE((Object)executor, (String)"executor");
        GlobalChannelTrafficCounter tc = new GlobalChannelTrafficCounter(this, executor, "GlobalChannelTC", this.checkInterval);
        this.setTrafficCounter(tc);
        var1_1.start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService executor, long writeGlobalLimit, long readGlobalLimit, long writeChannelLimit, long readChannelLimit, long checkInterval, long maxTime) {
        super((long)var2_2, readGlobalLimit, checkInterval, maxTime);
        void var1_1;
        void var2_2;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_1);
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
    }

    /*
     * WARNING - void declaration
     */
    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService executor, long writeGlobalLimit, long readGlobalLimit, long writeChannelLimit, long readChannelLimit, long checkInterval) {
        super((long)var2_2, readGlobalLimit, checkInterval);
        void var1_1;
        void var2_2;
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService executor, long writeGlobalLimit, long readGlobalLimit, long writeChannelLimit, long readChannelLimit) {
        super((long)var2_3, readGlobalLimit);
        void var1_2;
        void var2_3;
        this.writeChannelLimit = writeChannelLimit;
        this.readChannelLimit = readChannelLimit;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService executor, long checkInterval) {
        super((long)var2_2);
        void var1_1;
        void var2_2;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService executor) {
        void var1_1;
        this.createGlobalTrafficCounter((ScheduledExecutorService)var1_1);
    }

    public float maxDeviation() {
        return this.maxDeviation;
    }

    public float accelerationFactor() {
        return this.accelerationFactor;
    }

    public float slowDownFactor() {
        return this.slowDownFactor;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxDeviation(float maxDeviation, float slowDownFactor, float accelerationFactor) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (maxDeviation > 0.4f) {
            throw new IllegalArgumentException("maxDeviation must be <= 0.4");
        }
        ObjectUtil.checkPositiveOrZero((float)slowDownFactor, (String)"slowDownFactor");
        if (accelerationFactor > 0.0f) {
            throw new IllegalArgumentException("accelerationFactor must be <= 0");
        }
        this.maxDeviation = var1_1;
        this.accelerationFactor = var3_3 + 1.0f;
        this.slowDownFactor = var2_2 + 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    private void computeDeviationCumulativeBytes() {
        void var3_2;
        void var1_1;
        long maxWrittenBytes = 0L;
        long maxReadBytes = 0L;
        long minWrittenBytes = Long.MAX_VALUE;
        long minReadBytes = Long.MAX_VALUE;
        for (PerChannel perChannel : this.channelQueues.values()) {
            long value = perChannel.channelTrafficCounter.cumulativeWrittenBytes();
            if (maxWrittenBytes < value) {
                maxWrittenBytes = value;
            }
            if (minWrittenBytes > value) {
                minWrittenBytes = value;
            }
            if (maxReadBytes < (value = perChannel.channelTrafficCounter.cumulativeReadBytes())) {
                maxReadBytes = value;
            }
            if (minReadBytes <= value) continue;
            minReadBytes = value;
        }
        boolean multiple = this.channelQueues.size() > 1;
        this.readDeviationActive = multiple && minReadBytes < maxReadBytes / 2L;
        this.writeDeviationActive = multiple && minWrittenBytes < maxWrittenBytes / 2L;
        this.cumulativeWrittenBytes.set((long)var1_1);
        this.cumulativeReadBytes.set((long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doAccounting(TrafficCounter counter) {
        void var1_1;
        this.computeDeviationCumulativeBytes();
        super.doAccounting((TrafficCounter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private long computeBalancedWait(float maxLocal, float maxGlobal, long wait) {
        void var1_1;
        void var3_3;
        float f;
        void var2_2;
        if (maxGlobal == 0.0f) {
            return wait;
        }
        float ratio = maxLocal / var2_2;
        if (f > this.maxDeviation) {
            if (ratio < 1.0f - this.maxDeviation) {
                return wait;
            }
            ratio = this.slowDownFactor;
            if (wait < 10L) {
                wait = 10L;
            }
        } else {
            ratio = this.accelerationFactor;
        }
        return (long)((float)var3_3 * var1_1);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxGlobalWriteSize(long maxGlobalWriteSize) {
        void var1_1;
        this.maxGlobalWriteSize = ObjectUtil.checkPositive((long)var1_1, (String)"maxGlobalWriteSize");
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    /*
     * WARNING - void declaration
     */
    public void configureChannel(long newWriteLimit, long newReadLimit) {
        void var3_3;
        void var1_1;
        this.writeChannelLimit = var1_1;
        this.readChannelLimit = var3_3;
        long now = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(now);
        }
    }

    public long getWriteChannelLimit() {
        return this.writeChannelLimit;
    }

    /*
     * WARNING - void declaration
     */
    public void setWriteChannelLimit(long writeLimit) {
        void var1_1;
        this.writeChannelLimit = var1_1;
        long now = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(now);
        }
    }

    public long getReadChannelLimit() {
        return this.readChannelLimit;
    }

    /*
     * WARNING - void declaration
     */
    public void setReadChannelLimit(long readLimit) {
        void var1_1;
        this.readChannelLimit = var1_1;
        long now = TrafficCounter.milliSecondFromNano();
        for (PerChannel perChannel : this.channelQueues.values()) {
            perChannel.channelTrafficCounter.resetAccounting(now);
        }
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    /*
     * WARNING - void declaration
     */
    private PerChannel getOrSetPerChannel(ChannelHandlerContext ctx) {
        void var3_3;
        Channel channel = ctx.channel();
        Integer key = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel == null) {
            void var1_1;
            perChannel = new PerChannel();
            new PerChannel().messagesQueue = new ArrayDeque();
            perChannel.channelTrafficCounter = new TrafficCounter(this, null, "ChannelTC" + var1_1.channel().hashCode(), this.checkInterval);
            perChannel.queueSize = 0L;
            perChannel.lastWriteTimestamp = perChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put((Integer)channel, perChannel);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.getOrSetPerChannel(ctx);
        this.trafficCounter.resetCumulativeTime();
        super.handlerAdded((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.trafficCounter.resetCumulativeTime();
        Channel channel = ctx.channel();
        Integer key = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.remove(key);
        if (perChannel != null) {
            PerChannel perChannel2 = perChannel;
            synchronized (perChannel2) {
                void var3_4;
                Iterator<ToSend> iterator;
                if (iterator.isActive()) {
                    for (ToSend toSend : perChannel.messagesQueue) {
                        long size = this.calculateSize(toSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(size);
                        perChannel.channelTrafficCounter.bytesRealWriteFlowControl(size);
                        perChannel.queueSize -= size;
                        this.queuesSize.addAndGet(-size);
                        ctx.write(toSend.toSend, toSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-perChannel.queueSize);
                    for (ToSend toSend : perChannel.messagesQueue) {
                        if (!(toSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)toSend.toSend).release();
                    }
                }
                var3_4.messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(ctx);
        this.releaseReadSuspended(ctx);
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        long size = this.calculateSize(msg);
        long now = TrafficCounter.milliSecondFromNano();
        if (size > 0L) {
            long waitGlobal = this.trafficCounter.readTimeToWait(size, this.getReadLimit(), this.maxTime, now);
            Integer key = ctx.channel().hashCode();
            PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
            long wait = 0L;
            if (perChannel != null) {
                void var3_3;
                wait = perChannel.channelTrafficCounter.readTimeToWait((long)var3_3, this.readChannelLimit, this.maxTime, now);
                if (this.readDeviationActive) {
                    long maxLocalRead = perChannel.channelTrafficCounter.cumulativeReadBytes();
                    long maxGlobalRead = this.cumulativeReadBytes.get();
                    if (maxLocalRead <= 0L) {
                        maxLocalRead = 0L;
                    }
                    if (maxGlobalRead < maxLocalRead) {
                        maxGlobalRead = maxLocalRead;
                    }
                    wait = this.computeBalancedWait(maxLocalRead, maxGlobalRead, wait);
                }
            }
            if (wait < waitGlobal) {
                wait = waitGlobal;
            }
            if ((wait = this.checkWaitReadTime(ctx, wait, now)) >= 10L) {
                Channel channel = ctx.channel();
                ChannelConfig config = channel.config();
                if (logger.isDebugEnabled()) {
                    logger.debug("Read Suspend: " + wait + ':' + config.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(ctx));
                }
                if (config.isAutoRead() && GlobalChannelTrafficShapingHandler.isHandlerActive(ctx)) {
                    config.setAutoRead(false);
                    channel.attr(READ_SUSPENDED).set((Object)Boolean.TRUE);
                    Attribute attr = channel.attr(REOPEN_TASK);
                    Runnable reopenTask = (Runnable)attr.get();
                    if (reopenTask == null) {
                        reopenTask = new AbstractTrafficShapingHandler.ReopenReadTimerTask(ctx);
                        attr.set((Object)reopenTask);
                    }
                    ctx.executor().schedule(reopenTask, wait, TimeUnit.MILLISECONDS);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Suspend final status => " + config.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(ctx) + " will reopened at: " + wait);
                    }
                }
            }
        }
        this.informReadOperation(ctx, now);
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected long checkWaitReadTime(ChannelHandlerContext ctx, long wait, long now) {
        void var2_2;
        void var1_1;
        Integer key = ctx.channel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel != null && wait > this.maxTime && now + wait - var1_1.lastReadTimestamp > this.maxTime) {
            wait = this.maxTime;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void informReadOperation(ChannelHandlerContext ctx, long now) {
        Integer key = ctx.channel().hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel != null) {
            void var2_2;
            var1_1.lastReadTimestamp = var2_2;
        }
    }

    protected long maximumCumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    protected long maximumCumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public Collection<TrafficCounter> channelTrafficCounters() {
        return new AbstractCollection<TrafficCounter>(this){
            final /* synthetic */ GlobalChannelTrafficShapingHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public Iterator<TrafficCounter> iterator() {
                return new Iterator<TrafficCounter>(this){
                    final Iterator<PerChannel> iter;
                    final /* synthetic */ 1 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.iter = this.this$1.this$0.channelQueues.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public TrafficCounter next() {
                        return this.iter.next().channelTrafficCounter;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return this.this$0.channelQueues.size();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        long size = this.calculateSize(msg);
        long now = TrafficCounter.milliSecondFromNano();
        if (size > 0L) {
            long waitGlobal = this.trafficCounter.writeTimeToWait(size, this.getWriteLimit(), this.maxTime, now);
            Integer key = ctx.channel().hashCode();
            PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
            long wait = 0L;
            if (perChannel != null) {
                wait = perChannel.channelTrafficCounter.writeTimeToWait(size, this.writeChannelLimit, this.maxTime, now);
                if (this.writeDeviationActive) {
                    long maxLocalWrite = perChannel.channelTrafficCounter.cumulativeWrittenBytes();
                    long maxGlobalWrite = this.cumulativeWrittenBytes.get();
                    if (maxLocalWrite <= 0L) {
                        maxLocalWrite = 0L;
                    }
                    if (maxGlobalWrite < maxLocalWrite) {
                        maxGlobalWrite = maxLocalWrite;
                    }
                    wait = this.computeBalancedWait(maxLocalWrite, maxGlobalWrite, wait);
                }
            }
            if (wait < waitGlobal) {
                wait = waitGlobal;
            }
            if (wait >= 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Write suspend: " + wait + ':' + ctx.channel().config().isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(ctx));
                }
                this.submitWrite(ctx, msg, size, wait, now, promise);
                return;
            }
        }
        this.submitWrite((ChannelHandlerContext)var1_1, var2_2, size, 0L, now, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void submitWrite(ChannelHandlerContext ctx, Object msg, long size, long writedelay, long now, ChannelPromise promise) {
        void var2_2;
        void var1_1;
        ToSend newToSend;
        Channel channel = ctx.channel();
        Integer key = channel.hashCode();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(key);
        if (perChannel == null) {
            perChannel = this.getOrSetPerChannel(ctx);
        }
        long delay = writedelay;
        boolean globalSizeExceeded = false;
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            void var3_3;
            if (writedelay == 0L && perChannel.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(size);
                perChannel.channelTrafficCounter.bytesRealWriteFlowControl(size);
                ctx.write(msg, promise);
                perChannel.lastWriteTimestamp = now;
                return;
            }
            if (delay > this.maxTime && now + delay - perChannel.lastWriteTimestamp > this.maxTime) {
                delay = this.maxTime;
            }
            newToSend = new ToSend(delay + now, msg, size, promise);
            perChannel.messagesQueue.addLast(newToSend);
            perChannel.queueSize += size;
            this.queuesSize.addAndGet((long)var3_3);
            this.checkWriteSuspend(ctx, delay, perChannel.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                globalSizeExceeded = true;
            }
        }
        if (globalSizeExceeded) {
            this.setUserDefinedWritability(ctx, false);
        }
        long futureNow = newToSend.relativeTimeAction;
        PerChannel forSchedule = perChannel;
        ctx.executor().schedule(new Runnable(this, (ChannelHandlerContext)var1_1, (PerChannel)var2_2, futureNow){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ PerChannel val$forSchedule;
            final /* synthetic */ long val$futureNow;
            final /* synthetic */ GlobalChannelTrafficShapingHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
                this.val$forSchedule = perChannel;
                this.val$futureNow = l;
            }

            @Override
            public void run() {
                GlobalChannelTrafficShapingHandler.access$100(this.this$0, this.val$ctx, this.val$forSchedule, this.val$futureNow);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private void sendAllValid(ChannelHandlerContext ctx, PerChannel perChannel, long now) {
        void var1_1;
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            void var2_3;
            ToSend newToSend = perChannel.messagesQueue.pollFirst();
            while (newToSend != null) {
                long size;
                if (newToSend.relativeTimeAction <= now) {
                    size = newToSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                    perChannel.channelTrafficCounter.bytesRealWriteFlowControl(size);
                    perChannel.queueSize -= size;
                } else {
                    perChannel.messagesQueue.addFirst(newToSend);
                    break;
                }
                this.queuesSize.addAndGet(-size);
                ctx.write(newToSend.toSend, newToSend.promise);
                perChannel.lastWriteTimestamp = now;
                newToSend = perChannel.messagesQueue.pollFirst();
            }
            if (var2_3.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(ctx);
            }
        }
        var1_1.flush();
    }

    @Override
    public String toString() {
        return new StringBuilder(340).append(super.toString()).append(" Write Channel Limit: ").append(this.writeChannelLimit).append(" Read Channel Limit: ").append(this.readChannelLimit).toString();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(GlobalChannelTrafficShapingHandler x0, ChannelHandlerContext x1, PerChannel x2, long x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.sendAllValid((ChannelHandlerContext)var1_1, (PerChannel)var2_2, (long)var3_3);
    }

    private static final class ToSend {
        final long relativeTimeAction;
        final Object toSend;
        final ChannelPromise promise;
        final long size;

        /*
         * WARNING - void declaration
         */
        private ToSend(long delay, Object toSend, long size, ChannelPromise promise) {
            void var3_2;
            void var1_1;
            this.relativeTimeAction = var1_1;
            this.toSend = var3_2;
            this.size = size;
            this.promise = promise;
        }
    }

    static final class PerChannel {
        ArrayDeque<ToSend> messagesQueue;
        TrafficCounter channelTrafficCounter;
        long queueSize;
        long lastWriteTimestamp;
        long lastReadTimestamp;

        PerChannel() {
        }
    }
}

