/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import java.util.ArrayDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ArrayDeque<ToSend> messagesQueue = new ArrayDeque();
    private long queueSize;

    /*
     * WARNING - void declaration
     */
    public ChannelTrafficShapingHandler(long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super((long)var1_1, (long)var3_2, checkInterval, maxTime);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelTrafficShapingHandler(long writeLimit, long readLimit, long checkInterval) {
        super((long)var1_1, (long)var3_2, checkInterval);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelTrafficShapingHandler(long writeLimit, long readLimit) {
        super((long)var1_1, (long)var3_2);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChannelTrafficShapingHandler(long checkInterval) {
        super((long)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        void var2_2;
        TrafficCounter trafficCounter = new TrafficCounter(this, (ScheduledExecutorService)ctx.executor(), "ChannelTC" + ctx.channel().hashCode(), this.checkInterval);
        this.setTrafficCounter(trafficCounter);
        var2_2.start();
        super.handlerAdded((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.trafficCounter.stop();
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (ctx.channel().isActive()) {
                for (ToSend toSend : this.messagesQueue) {
                    long size = this.calculateSize(toSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                    this.queueSize -= size;
                    ctx.write(toSend.toSend, toSend.promise);
                }
            } else {
                for (ToSend toSend : this.messagesQueue) {
                    if (!(toSend.toSend instanceof ByteBuf)) continue;
                    ((ByteBuf)toSend.toSend).release();
                }
            }
            this.messagesQueue.clear();
        }
        this.releaseWriteSuspended(ctx);
        this.releaseReadSuspended(ctx);
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void submitWrite(ChannelHandlerContext ctx, Object msg, long size, long delay, long now, ChannelPromise promise) {
        void var1_1;
        void var2_2;
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            void var3_3;
            if (delay == 0L && this.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(size);
                ctx.write(msg, promise);
                return;
            }
            ToSend newToSend = new ToSend(delay + now, msg, promise);
            this.messagesQueue.addLast(newToSend);
            this.queueSize += var3_3;
            this.checkWriteSuspend(ctx, delay, this.queueSize);
        }
        long futureNow = var2_2.relativeTimeAction;
        ctx.executor().schedule(new Runnable(this, (ChannelHandlerContext)var1_1, futureNow){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ long val$futureNow;
            final /* synthetic */ ChannelTrafficShapingHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
                this.val$futureNow = l;
            }

            @Override
            public void run() {
                ChannelTrafficShapingHandler.access$100(this.this$0, this.val$ctx, this.val$futureNow);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private void sendAllValid(ChannelHandlerContext ctx, long now) {
        void var1_1;
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            ToSend newToSend = this.messagesQueue.pollFirst();
            while (newToSend != null) {
                if (newToSend.relativeTimeAction <= now) {
                    long size = this.calculateSize(newToSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                    this.queueSize -= size;
                } else {
                    this.messagesQueue.addFirst(newToSend);
                    break;
                }
                ctx.write(newToSend.toSend, newToSend.promise);
                newToSend = this.messagesQueue.pollFirst();
            }
            if (this.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(ctx);
            }
        }
        var1_1.flush();
    }

    public long queueSize() {
        return this.queueSize;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(ChannelTrafficShapingHandler x0, ChannelHandlerContext x1, long x2) {
        void var2_2;
        void var1_1;
        x0.sendAllValid((ChannelHandlerContext)var1_1, (long)var2_2);
    }

    private static final class ToSend {
        final long relativeTimeAction;
        final Object toSend;
        final ChannelPromise promise;

        /*
         * WARNING - void declaration
         */
        private ToSend(long delay, Object toSend, ChannelPromise promise) {
            void var3_2;
            void var1_1;
            this.relativeTimeAction = var1_1;
            this.toSend = var3_2;
            this.promise = promise;
        }
    }
}

