/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTrafficShapingHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    public static final long DEFAULT_MAX_TIME = 15000L;
    static final long DEFAULT_MAX_SIZE = 0x400000L;
    static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter;
    private volatile long writeLimit;
    private volatile long readLimit;
    protected volatile long maxTime = 15000L;
    protected volatile long checkInterval = 1000L;
    static final AttributeKey<Boolean> READ_SUSPENDED = AttributeKey.valueOf((String)(AbstractTrafficShapingHandler.class.getName() + ".READ_SUSPENDED"));
    static final AttributeKey<Runnable> REOPEN_TASK = AttributeKey.valueOf((String)(AbstractTrafficShapingHandler.class.getName() + ".REOPEN_TASK"));
    volatile long maxWriteDelay = 4000L;
    volatile long maxWriteSize = 0x400000L;
    final int userDefinedWritabilityIndex;
    static final int CHANNEL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 1;
    static final int GLOBAL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 2;
    static final int GLOBALCHANNEL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 3;

    /*
     * WARNING - void declaration
     */
    void setTrafficCounter(TrafficCounter newTrafficCounter) {
        void var1_1;
        this.trafficCounter = var1_1;
    }

    protected int userDefinedWritabilityIndex() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractTrafficShapingHandler(long writeLimit, long readLimit, long checkInterval, long maxTime) {
        void var3_2;
        void var1_1;
        this.maxTime = ObjectUtil.checkPositive((long)maxTime, (String)"maxTime");
        this.userDefinedWritabilityIndex = this.userDefinedWritabilityIndex();
        this.writeLimit = var1_1;
        this.readLimit = var3_2;
        this.checkInterval = checkInterval;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractTrafficShapingHandler(long writeLimit, long readLimit, long checkInterval) {
        this((long)var1_1, (long)var3_2, checkInterval, 15000L);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractTrafficShapingHandler(long writeLimit, long readLimit) {
        this((long)var1_1, (long)var3_2, 1000L, 15000L);
        void var3_2;
        void var1_1;
    }

    protected AbstractTrafficShapingHandler() {
        this(0L, 0L, 1000L, 15000L);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractTrafficShapingHandler(long checkInterval) {
        this(0L, 0L, (long)var1_1, 15000L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void configure(long newWriteLimit, long newReadLimit, long newCheckInterval) {
        void var3_2;
        void var1_1;
        this.configure((long)var1_1, (long)var3_2);
        this.configure(newCheckInterval);
    }

    /*
     * WARNING - void declaration
     */
    public void configure(long newWriteLimit, long newReadLimit) {
        void var3_2;
        void var1_1;
        this.writeLimit = var1_1;
        this.readLimit = var3_2;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configure(long newCheckInterval) {
        void var1_1;
        this.checkInterval = var1_1;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    public long getWriteLimit() {
        return this.writeLimit;
    }

    /*
     * WARNING - void declaration
     */
    public void setWriteLimit(long writeLimit) {
        void var1_1;
        this.writeLimit = var1_1;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public long getReadLimit() {
        return this.readLimit;
    }

    /*
     * WARNING - void declaration
     */
    public void setReadLimit(long readLimit) {
        void var1_1;
        this.readLimit = var1_1;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    /*
     * WARNING - void declaration
     */
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
        if (this.trafficCounter != null) {
            void var1_1;
            this.trafficCounter.configure((long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxTimeWait(long maxTime) {
        void var1_1;
        this.maxTime = ObjectUtil.checkPositive((long)var1_1, (String)"maxTime");
    }

    public long getMaxTimeWait() {
        return this.maxTime;
    }

    public long getMaxWriteDelay() {
        return this.maxWriteDelay;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxWriteDelay(long maxWriteDelay) {
        void var1_1;
        this.maxWriteDelay = ObjectUtil.checkPositive((long)var1_1, (String)"maxWriteDelay");
    }

    public long getMaxWriteSize() {
        return this.maxWriteSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxWriteSize(long maxWriteSize) {
        void var1_1;
        this.maxWriteSize = var1_1;
    }

    protected void doAccounting(TrafficCounter counter) {
    }

    /*
     * WARNING - void declaration
     */
    void releaseReadSuspended(ChannelHandlerContext ctx) {
        void var1_1;
        Channel channel = ctx.channel();
        channel.attr(READ_SUSPENDED).set((Object)Boolean.FALSE);
        var1_1.config().setAutoRead(true);
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        long size = this.calculateSize(msg);
        long now = TrafficCounter.milliSecondFromNano();
        if (size > 0L) {
            long wait = this.trafficCounter.readTimeToWait(size, this.readLimit, this.maxTime, now);
            if ((wait = this.checkWaitReadTime(ctx, wait, now)) >= 10L) {
                Channel channel = ctx.channel();
                ChannelConfig config = channel.config();
                if (logger.isDebugEnabled()) {
                    logger.debug("Read suspend: " + wait + ':' + config.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(ctx));
                }
                if (config.isAutoRead() && AbstractTrafficShapingHandler.isHandlerActive(ctx)) {
                    config.setAutoRead(false);
                    channel.attr(READ_SUSPENDED).set((Object)Boolean.TRUE);
                    Attribute attr = channel.attr(REOPEN_TASK);
                    Runnable reopenTask = (Runnable)attr.get();
                    if (reopenTask == null) {
                        void var3_4;
                        reopenTask = new ReopenReadTimerTask(ctx);
                        var3_4.set((Object)reopenTask);
                    }
                    ctx.executor().schedule(reopenTask, wait, TimeUnit.MILLISECONDS);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Suspend final status => " + config.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(ctx) + " will reopened at: " + wait);
                    }
                }
            }
        }
        this.informReadOperation(ctx, now);
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        Channel channel = ctx.channel();
        if (channel.hasAttr(REOPEN_TASK)) {
            void var2_2;
            var2_2.attr(REOPEN_TASK).set(null);
        }
        super.handlerRemoved((ChannelHandlerContext)var1_1);
    }

    long checkWaitReadTime(ChannelHandlerContext ctx, long wait, long now) {
        return wait;
    }

    void informReadOperation(ChannelHandlerContext ctx, long now) {
    }

    protected static boolean isHandlerActive(ChannelHandlerContext ctx) {
        Object object;
        Object suspended = (Boolean)ctx.channel().attr(READ_SUSPENDED).get();
        return suspended == null || Boolean.FALSE.equals(object);
    }

    /*
     * WARNING - void declaration
     */
    public void read(ChannelHandlerContext ctx) {
        if (AbstractTrafficShapingHandler.isHandlerActive(ctx)) {
            void var1_1;
            var1_1.read();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        long wait;
        long size = this.calculateSize(msg);
        long now = TrafficCounter.milliSecondFromNano();
        if (size > 0L && (wait = this.trafficCounter.writeTimeToWait(size, this.writeLimit, this.maxTime, now)) >= 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Write suspend: " + wait + ':' + ctx.channel().config().isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(ctx));
            }
            this.submitWrite(ctx, msg, size, wait, now, promise);
            return;
        }
        this.submitWrite((ChannelHandlerContext)var1_1, var2_2, size, 0L, now, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected void submitWrite(ChannelHandlerContext ctx, Object msg, long delay, ChannelPromise promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.submitWrite((ChannelHandlerContext)var1_1, msg, this.calculateSize(var2_2), (long)var3_3, TrafficCounter.milliSecondFromNano(), promise);
    }

    abstract void submitWrite(ChannelHandlerContext var1, Object var2, long var3, long var5, long var7, ChannelPromise var9);

    /*
     * WARNING - void declaration
     */
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.setUserDefinedWritability(ctx, true);
        super.channelRegistered((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void setUserDefinedWritability(ChannelHandlerContext ctx, boolean writable) {
        ChannelOutboundBuffer cob = ctx.channel().unsafe().outboundBuffer();
        if (cob != null) {
            void var2_2;
            void var1_1;
            var1_1.setUserDefinedWritability(this.userDefinedWritabilityIndex, (boolean)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    void checkWriteSuspend(ChannelHandlerContext ctx, long delay, long queueSize) {
        void var2_2;
        if (queueSize > this.maxWriteSize || var2_2 > this.maxWriteDelay) {
            void var1_1;
            this.setUserDefinedWritability((ChannelHandlerContext)var1_1, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    void releaseWriteSuspended(ChannelHandlerContext ctx) {
        void var1_1;
        this.setUserDefinedWritability((ChannelHandlerContext)var1_1, true);
    }

    public TrafficCounter trafficCounter() {
        return this.trafficCounter;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder(290).append("TrafficShaping with Write Limit: ").append(this.writeLimit).append(" Read Limit: ").append(this.readLimit).append(" CheckInterval: ").append(this.checkInterval).append(" maxDelay: ").append(this.maxWriteDelay).append(" maxSize: ").append(this.maxWriteSize).append(" and Counter: ");
        if (this.trafficCounter != null) {
            builder.append(this.trafficCounter);
        } else {
            builder.append("none");
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected long calculateSize(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof FileRegion) {
            void var1_1;
            return ((FileRegion)var1_1).count();
        }
        return -1L;
    }

    static final class ReopenReadTimerTask
    implements Runnable {
        final ChannelHandlerContext ctx;

        /*
         * WARNING - void declaration
         */
        ReopenReadTimerTask(ChannelHandlerContext ctx) {
            void var1_1;
            this.ctx = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            Channel channel = this.ctx.channel();
            ChannelConfig config = channel.config();
            if (!config.isAutoRead() && AbstractTrafficShapingHandler.isHandlerActive(this.ctx)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not unsuspend: " + config.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(this.ctx));
                }
                channel.attr(READ_SUSPENDED).set((Object)Boolean.FALSE);
            } else {
                void var1_1;
                if (logger.isDebugEnabled()) {
                    if (config.isAutoRead() && !AbstractTrafficShapingHandler.isHandlerActive(this.ctx)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Unsuspend: " + config.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(this.ctx));
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Normal unsuspend: " + config.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(this.ctx));
                    }
                }
                channel.attr(READ_SUSPENDED).set((Object)Boolean.FALSE);
                config.setAutoRead(true);
                var1_1.read();
            }
            if (logger.isDebugEnabled()) {
                void var2_2;
                logger.debug("Unsuspend final status => " + var2_2.isAutoRead() + ':' + AbstractTrafficShapingHandler.isHandlerActive(this.ctx));
            }
        }
    }
}

