/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.WriteTimeoutException;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class WriteTimeoutHandler
extends ChannelOutboundHandlerAdapter {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long timeoutNanos;
    private WriteTimeoutTask lastTask;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    public WriteTimeoutHandler(int timeoutSeconds) {
        this((long)var1_1, TimeUnit.SECONDS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WriteTimeoutHandler(long timeout, TimeUnit unit) {
        void var1_1;
        void var3_2;
        ObjectUtil.checkNotNull((Object)((Object)unit), (String)"unit");
        if (timeout <= 0L) {
            this.timeoutNanos = 0L;
            return;
        }
        this.timeoutNanos = Math.max(var3_2.toNanos((long)var1_1), MIN_TIMEOUT_NANOS);
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.timeoutNanos > 0L) {
            promise = promise.unvoid();
            this.scheduleTimeout(ctx, promise);
        }
        var1_1.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        assert (ctx.executor().inEventLoop());
        WriteTimeoutTask task = this.lastTask;
        this.lastTask = null;
        while (task != null) {
            void var2_2;
            assert (task.ctx.executor().inEventLoop());
            task.scheduledFuture.cancel(false);
            WriteTimeoutTask prev = task.prev;
            task.prev = null;
            task.next = null;
            task = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleTimeout(ChannelHandlerContext ctx, ChannelPromise promise) {
        void var1_1;
        WriteTimeoutTask task = new WriteTimeoutTask(ctx, promise);
        new WriteTimeoutTask(ctx, promise).scheduledFuture = var1_1.executor().schedule((Runnable)task, this.timeoutNanos, TimeUnit.NANOSECONDS);
        if (!task.scheduledFuture.isDone()) {
            void var3_3;
            void var2_2;
            this.addWriteTimeoutTask(task);
            var2_2.addListener((GenericFutureListener)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addWriteTimeoutTask(WriteTimeoutTask task) {
        void var1_1;
        assert (task.ctx.executor().inEventLoop());
        if (this.lastTask != null) {
            this.lastTask.next = task;
            task.prev = this.lastTask;
        }
        this.lastTask = var1_1;
    }

    private void removeWriteTimeoutTask(WriteTimeoutTask task) {
        assert (task.ctx.executor().inEventLoop());
        if (task == this.lastTask) {
            assert (task.next == null);
            this.lastTask = this.lastTask.prev;
            if (this.lastTask != null) {
                this.lastTask.next = null;
            }
        } else {
            if (task.prev == null && task.next == null) {
                return;
            }
            if (task.prev == null) {
                task.next.prev = null;
            } else {
                task.prev.next = task.next;
                task.next.prev = task.prev;
            }
        }
        task.prev = null;
        var1_1.next = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void writeTimedOut(ChannelHandlerContext ctx) throws Exception {
        if (!this.closed) {
            void var1_1;
            ctx.fireExceptionCaught((Throwable)((Object)WriteTimeoutException.INSTANCE));
            var1_1.close();
            this.closed = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(WriteTimeoutHandler x0, WriteTimeoutTask x1) {
        void var1_1;
        x0.removeWriteTimeoutTask((WriteTimeoutTask)var1_1);
    }

    private final class WriteTimeoutTask
    implements ChannelFutureListener,
    Runnable {
        private final ChannelHandlerContext ctx;
        private final ChannelPromise promise;
        WriteTimeoutTask prev;
        WriteTimeoutTask next;
        Future<?> scheduledFuture;

        /*
         * WARNING - void declaration
         */
        WriteTimeoutTask(ChannelHandlerContext ctx, ChannelPromise promise) {
            void var3_3;
            void var2_2;
            this.ctx = var2_2;
            this.promise = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            if (!this.promise.isDone()) {
                try {
                    WriteTimeoutHandler.this.writeTimedOut(this.ctx);
                }
                catch (Throwable t) {
                    void var1_1;
                    this.ctx.fireExceptionCaught((Throwable)var1_1);
                }
            }
            WriteTimeoutHandler.access$100(WriteTimeoutHandler.this, this);
        }

        public final void operationComplete(ChannelFuture future) throws Exception {
            this.scheduledFuture.cancel(false);
            if (this.ctx.executor().inEventLoop()) {
                WriteTimeoutHandler.access$100(WriteTimeoutHandler.this, this);
                return;
            }
            assert (this.promise.isDone());
            this.ctx.executor().execute((Runnable)this);
        }
    }
}

