/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class IdleStateHandler
extends ChannelDuplexHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final ChannelFutureListener writeListener = new ChannelFutureListener(this){
        final /* synthetic */ IdleStateHandler this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            IdleStateHandler.access$002(this.this$0, this.this$0.ticksInNanos());
            IdleStateHandler.access$102(this.this$0, IdleStateHandler.access$202(this.this$0, true));
        }
    };
    private final boolean observeOutput;
    private final long readerIdleTimeNanos;
    private final long writerIdleTimeNanos;
    private final long allIdleTimeNanos;
    private Future<?> readerIdleTimeout;
    private long lastReadTime;
    private boolean firstReaderIdleEvent = true;
    private Future<?> writerIdleTimeout;
    private long lastWriteTime;
    private boolean firstWriterIdleEvent = true;
    private Future<?> allIdleTimeout;
    private boolean firstAllIdleEvent = true;
    private byte state;
    private static final byte ST_INITIALIZED = 1;
    private static final byte ST_DESTROYED = 2;
    private boolean reading;
    private long lastChangeCheckTimeStamp;
    private int lastMessageHashCode;
    private long lastPendingWriteBytes;
    private long lastFlushProgress;

    /*
     * WARNING - void declaration
     */
    public IdleStateHandler(int readerIdleTimeSeconds, int writerIdleTimeSeconds, int allIdleTimeSeconds) {
        this((long)var1_1, (long)var2_2, (long)var3_3, TimeUnit.SECONDS);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IdleStateHandler(long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        this(false, (long)var1_1, (long)var3_2, allIdleTime, unit);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IdleStateHandler(boolean observeOutput, long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        void var2_3;
        void var1_2;
        ObjectUtil.checkNotNull((Object)((Object)unit), (String)"unit");
        this.observeOutput = var1_2;
        this.readerIdleTimeNanos = readerIdleTime <= 0L ? 0L : Math.max(unit.toNanos((long)var2_3), MIN_TIMEOUT_NANOS);
        this.writerIdleTimeNanos = writerIdleTime <= 0L ? 0L : Math.max(unit.toNanos(writerIdleTime), MIN_TIMEOUT_NANOS);
        if (allIdleTime <= 0L) {
            this.allIdleTimeNanos = 0L;
            return;
        }
        this.allIdleTimeNanos = Math.max(unit.toNanos(allIdleTime), MIN_TIMEOUT_NANOS);
    }

    public long getReaderIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.readerIdleTimeNanos);
    }

    public long getWriterIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.writerIdleTimeNanos);
    }

    public long getAllIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.allIdleTimeNanos);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            void var1_1;
            this.initialize((ChannelHandlerContext)var1_1);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    /*
     * WARNING - void declaration
     */
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (ctx.channel().isActive()) {
            this.initialize(ctx);
        }
        super.channelRegistered((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.initialize(ctx);
        super.channelActive((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.destroy();
        super.channelInactive((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        void var2_2;
        void var1_1;
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.reading = true;
            IdleStateHandler idleStateHandler = this;
            idleStateHandler.firstAllIdleEvent = true;
            idleStateHandler.firstReaderIdleEvent = true;
        }
        var1_1.fireChannelRead((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if ((this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) && this.reading) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
        var1_1.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener)this.writeListener);
            return;
        }
        var1_1.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    public void resetReadTimeout() {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
    }

    public void resetWriteTimeout() {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastWriteTime = this.ticksInNanos();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(ChannelHandlerContext ctx) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        this.initOutputChanged(ctx);
        IdleStateHandler idleStateHandler = this;
        idleStateHandler.lastReadTime = idleStateHandler.lastWriteTime = this.ticksInNanos();
        if (this.readerIdleTimeNanos > 0L) {
            this.readerIdleTimeout = this.schedule(ctx, new ReaderIdleTimeoutTask(ctx), this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.writerIdleTimeNanos > 0L) {
            this.writerIdleTimeout = this.schedule(ctx, new WriterIdleTimeoutTask(ctx), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.allIdleTimeNanos > 0L) {
            void var1_1;
            this.allIdleTimeout = this.schedule(ctx, new AllIdleTimeoutTask((ChannelHandlerContext)var1_1), this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
    }

    long ticksInNanos() {
        return System.nanoTime();
    }

    /*
     * WARNING - void declaration
     */
    Future<?> schedule(ChannelHandlerContext ctx, Runnable task, long delay, TimeUnit unit) {
        void var3_3;
        void var2_2;
        return ctx.executor().schedule((Runnable)var2_2, (long)var3_3, unit);
    }

    private void destroy() {
        this.state = (byte)2;
        if (this.readerIdleTimeout != null) {
            this.readerIdleTimeout.cancel(false);
            this.readerIdleTimeout = null;
        }
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel(false);
            this.allIdleTimeout = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        void var2_2;
        ctx.fireUserEventTriggered((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected IdleStateEvent newIdleStateEvent(IdleState state, boolean first) {
        void var2_2;
        void var1_1;
        switch (state) {
            case ALL_IDLE: {
                if (first) {
                    return IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.ALL_IDLE_STATE_EVENT;
            }
            case READER_IDLE: {
                if (first) {
                    return IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.READER_IDLE_STATE_EVENT;
            }
            case WRITER_IDLE: {
                if (first) {
                    return IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.WRITER_IDLE_STATE_EVENT;
            }
        }
        throw new IllegalArgumentException("Unhandled: state=" + var1_1 + ", first=" + (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void initOutputChanged(ChannelHandlerContext ctx) {
        if (this.observeOutput) {
            ctx = ctx.channel();
            ChannelOutboundBuffer buf = (ctx = ctx.unsafe()).outboundBuffer();
            if (buf != null) {
                void var1_1;
                this.lastMessageHashCode = System.identityHashCode(buf.current());
                this.lastPendingWriteBytes = buf.totalPendingWriteBytes();
                this.lastFlushProgress = var1_1.currentProgress();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasOutputChanged(ChannelHandlerContext ctx, boolean first) {
        if (this.observeOutput) {
            if (this.lastChangeCheckTimeStamp != this.lastWriteTime) {
                this.lastChangeCheckTimeStamp = this.lastWriteTime;
                if (!first) {
                    return true;
                }
            }
            ctx = ctx.channel();
            ChannelOutboundBuffer buf = (ctx = ctx.unsafe()).outboundBuffer();
            if (buf != null) {
                void var1_1;
                long flushProgress;
                int messageHashCode = System.identityHashCode(buf.current());
                long pendingWriteBytes = buf.totalPendingWriteBytes();
                if (messageHashCode != this.lastMessageHashCode || pendingWriteBytes != this.lastPendingWriteBytes) {
                    void var3_3;
                    this.lastMessageHashCode = var3_3;
                    this.lastPendingWriteBytes = pendingWriteBytes;
                    if (!first) {
                        return true;
                    }
                }
                if ((flushProgress = var1_1.currentProgress()) != this.lastFlushProgress) {
                    void var2_2;
                    this.lastFlushProgress = flushProgress;
                    return var2_2 == false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$002(IdleStateHandler x0, long x1) {
        void var1_1;
        x0.lastWriteTime = var1_1;
        return x0.lastWriteTime;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(IdleStateHandler x0, boolean x1) {
        void var1_1;
        x0.firstWriterIdleEvent = var1_1;
        return x0.firstWriterIdleEvent;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$202(IdleStateHandler x0, boolean x1) {
        void var1_1;
        x0.firstAllIdleEvent = var1_1;
        return x0.firstAllIdleEvent;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Future access$602(IdleStateHandler x0, Future x1) {
        void var1_1;
        x0.readerIdleTimeout = var1_1;
        return x0.readerIdleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$702(IdleStateHandler x0, boolean x1) {
        void var1_1;
        x0.firstReaderIdleEvent = var1_1;
        return x0.firstReaderIdleEvent;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Future access$902(IdleStateHandler x0, Future x1) {
        void var1_1;
        x0.writerIdleTimeout = var1_1;
        return x0.writerIdleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1000(IdleStateHandler x0, ChannelHandlerContext x1, boolean x2) {
        void var2_2;
        void var1_1;
        return x0.hasOutputChanged((ChannelHandlerContext)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Future access$1202(IdleStateHandler x0, Future x1) {
        void var1_1;
        x0.allIdleTimeout = var1_1;
        return x0.allIdleTimeout;
    }

    private final class AllIdleTimeoutTask
    extends AbstractIdleTask {
        /*
         * WARNING - void declaration
         */
        AllIdleTimeoutTask(ChannelHandlerContext ctx) {
            void var2_2;
            super((ChannelHandlerContext)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void run(ChannelHandlerContext ctx) {
            long nextDelay = IdleStateHandler.this.allIdleTimeNanos;
            if (!IdleStateHandler.this.reading) {
                nextDelay -= IdleStateHandler.this.ticksInNanos() - Math.max(IdleStateHandler.this.lastReadTime, IdleStateHandler.this.lastWriteTime);
            }
            if (nextDelay <= 0L) {
                AllIdleTimeoutTask allIdleTimeoutTask = this;
                IdleStateHandler.access$1202(IdleStateHandler.this, IdleStateHandler.this.schedule(ctx, allIdleTimeoutTask, allIdleTimeoutTask.IdleStateHandler.this.allIdleTimeNanos, TimeUnit.NANOSECONDS));
                boolean first = IdleStateHandler.this.firstAllIdleEvent;
                IdleStateHandler.access$202(IdleStateHandler.this, false);
                try {
                    if (IdleStateHandler.access$1000(IdleStateHandler.this, ctx, first)) {
                        return;
                    }
                    IdleStateEvent event = IdleStateHandler.this.newIdleStateEvent(IdleState.ALL_IDLE, first);
                    IdleStateHandler.this.channelIdle(ctx, event);
                }
                catch (Throwable t) {
                    void var2_5;
                    ctx.fireExceptionCaught((Throwable)var2_5);
                    return;
                }
            } else {
                void var2_2;
                void var1_1;
                IdleStateHandler.access$1202(IdleStateHandler.this, IdleStateHandler.this.schedule((ChannelHandlerContext)var1_1, this, (long)var2_2, TimeUnit.NANOSECONDS));
            }
        }
    }

    private final class WriterIdleTimeoutTask
    extends AbstractIdleTask {
        /*
         * WARNING - void declaration
         */
        WriterIdleTimeoutTask(ChannelHandlerContext ctx) {
            void var2_2;
            super((ChannelHandlerContext)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void run(ChannelHandlerContext ctx) {
            long lastWriteTime = IdleStateHandler.this.lastWriteTime;
            long nextDelay = IdleStateHandler.this.writerIdleTimeNanos - (IdleStateHandler.this.ticksInNanos() - lastWriteTime);
            if (nextDelay <= 0L) {
                WriterIdleTimeoutTask writerIdleTimeoutTask = this;
                IdleStateHandler.access$902(IdleStateHandler.this, IdleStateHandler.this.schedule(ctx, writerIdleTimeoutTask, writerIdleTimeoutTask.IdleStateHandler.this.writerIdleTimeNanos, TimeUnit.NANOSECONDS));
                boolean first = IdleStateHandler.this.firstWriterIdleEvent;
                IdleStateHandler.access$102(IdleStateHandler.this, false);
                try {
                    if (IdleStateHandler.access$1000(IdleStateHandler.this, ctx, first)) {
                        return;
                    }
                    IdleStateEvent event = IdleStateHandler.this.newIdleStateEvent(IdleState.WRITER_IDLE, first);
                    IdleStateHandler.this.channelIdle(ctx, event);
                }
                catch (Throwable t) {
                    void var2_5;
                    ctx.fireExceptionCaught((Throwable)var2_5);
                    return;
                }
            } else {
                void var1_1;
                IdleStateHandler.access$902(IdleStateHandler.this, IdleStateHandler.this.schedule((ChannelHandlerContext)var1_1, this, nextDelay, TimeUnit.NANOSECONDS));
            }
        }
    }

    private final class ReaderIdleTimeoutTask
    extends AbstractIdleTask {
        /*
         * WARNING - void declaration
         */
        ReaderIdleTimeoutTask(ChannelHandlerContext ctx) {
            void var2_2;
            super((ChannelHandlerContext)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void run(ChannelHandlerContext ctx) {
            long nextDelay = IdleStateHandler.this.readerIdleTimeNanos;
            if (!IdleStateHandler.this.reading) {
                nextDelay -= IdleStateHandler.this.ticksInNanos() - IdleStateHandler.this.lastReadTime;
            }
            if (nextDelay <= 0L) {
                ReaderIdleTimeoutTask readerIdleTimeoutTask = this;
                IdleStateHandler.access$602(IdleStateHandler.this, IdleStateHandler.this.schedule(ctx, readerIdleTimeoutTask, readerIdleTimeoutTask.IdleStateHandler.this.readerIdleTimeNanos, TimeUnit.NANOSECONDS));
                boolean first = IdleStateHandler.this.firstReaderIdleEvent;
                IdleStateHandler.access$702(IdleStateHandler.this, false);
                try {
                    IdleStateEvent event = IdleStateHandler.this.newIdleStateEvent(IdleState.READER_IDLE, first);
                    IdleStateHandler.this.channelIdle(ctx, event);
                }
                catch (Throwable t) {
                    void var2_5;
                    ctx.fireExceptionCaught((Throwable)var2_5);
                    return;
                }
            } else {
                void var2_2;
                void var1_1;
                IdleStateHandler.access$602(IdleStateHandler.this, IdleStateHandler.this.schedule((ChannelHandlerContext)var1_1, this, (long)var2_2, TimeUnit.NANOSECONDS));
            }
        }
    }

    private static abstract class AbstractIdleTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        /*
         * WARNING - void declaration
         */
        AbstractIdleTask(ChannelHandlerContext ctx) {
            void var1_1;
            this.ctx = var1_1;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            AbstractIdleTask abstractIdleTask = this;
            abstractIdleTask.run(abstractIdleTask.ctx);
        }

        protected abstract void run(ChannelHandlerContext var1);
    }
}

