/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class ChunkedWriteHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private Queue<PendingWrite> queue;
    private volatile ChannelHandlerContext ctx;

    public ChunkedWriteHandler() {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ChunkedWriteHandler(int maxPendingWrites) {
        void var1_1;
        ObjectUtil.checkPositive((int)var1_1, (String)"maxPendingWrites");
    }

    private void allocateQueue() {
        if (this.queue == null) {
            this.queue = new ArrayDeque<PendingWrite>();
        }
    }

    private boolean queueIsEmpty() {
        return this.queue == null || this.queue.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.ctx = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void resumeTransfer() {
        void var1_1;
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        if (ctx.executor().inEventLoop()) {
            this.resumeTransfer0(ctx);
            return;
        }
        ctx.executor().execute(new Runnable(this, (ChannelHandlerContext)var1_1){
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ ChunkedWriteHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$ctx = channelHandlerContext;
            }

            @Override
            public void run() {
                ChunkedWriteHandler.access$000(this.this$0, this.val$ctx);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void resumeTransfer0(ChannelHandlerContext ctx) {
        try {
            this.doFlush(ctx);
            return;
        }
        catch (Exception e) {
            void var1_2;
            logger.warn("Unexpected exception while sending chunks.", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.queueIsEmpty() || msg instanceof ChunkedInput) {
            this.allocateQueue();
            this.queue.add(new PendingWrite(msg, promise));
            return;
        }
        var1_1.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.doFlush((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.doFlush(ctx);
        var1_1.fireChannelInactive();
    }

    /*
     * WARNING - void declaration
     */
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        var1_1.fireChannelWritabilityChanged();
    }

    /*
     * WARNING - void declaration
     */
    private void discard(Throwable cause) {
        PendingWrite currentWrite;
        if (this.queueIsEmpty()) {
            return;
        }
        while ((currentWrite = this.queue.poll()) != null) {
            void var2_2;
            Object message = currentWrite.msg;
            if (message instanceof ChunkedInput) {
                long inputLength;
                boolean endOfInput;
                ChunkedInput in = (ChunkedInput)message;
                try {
                    endOfInput = in.isEndOfInput();
                    inputLength = in.length();
                    ChunkedWriteHandler.closeInput(in);
                }
                catch (Exception e) {
                    void var3_3;
                    ChunkedWriteHandler.closeInput(var3_3);
                    currentWrite.fail(e);
                    logger.warn("ChunkedInput failed", (Throwable)e);
                    continue;
                }
                if (!endOfInput) {
                    if (cause == null) {
                        cause = new ClosedChannelException();
                    }
                    currentWrite.fail(cause);
                    continue;
                }
                currentWrite.success(inputLength);
                continue;
            }
            if (cause == null) {
                cause = new ClosedChannelException();
            }
            var2_2.fail(cause);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doFlush(ChannelHandlerContext ctx) {
        boolean bl;
        PendingWrite currentWrite;
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            this.discard(null);
            ctx.flush();
            return;
        }
        if (this.queueIsEmpty()) {
            ctx.flush();
            return;
        }
        boolean requiresFlush = true;
        ByteBufAllocator allocator = ctx.alloc();
        while (channel.isWritable() && (currentWrite = this.queue.peek()) != null) {
            if (currentWrite.promise.isDone()) {
                this.queue.remove();
                continue;
            }
            Object pendingMessage = currentWrite.msg;
            if (pendingMessage instanceof ChunkedInput) {
                boolean suspend;
                boolean endOfInput;
                ChunkedInput chunks = (ChunkedInput)pendingMessage;
                ByteBuf message = null;
                try {
                    message = (ByteBuf)chunks.readChunk(allocator);
                    endOfInput = chunks.isEndOfInput();
                    suspend = message == null && !endOfInput;
                }
                catch (Throwable t) {
                    this.queue.remove();
                    if (message != null) {
                        ReferenceCountUtil.release(message);
                    }
                    ChunkedWriteHandler.closeInput(chunks);
                    currentWrite.fail(t);
                    break;
                }
                if (suspend) break;
                if (message == null) {
                    message = Unpooled.EMPTY_BUFFER;
                }
                if (endOfInput) {
                    this.queue.remove();
                }
                ChannelFuture f = ctx.writeAndFlush((Object)message);
                if (endOfInput) {
                    if (f.isDone()) {
                        ChunkedWriteHandler.handleEndOfInputFuture(f, chunks, currentWrite);
                    } else {
                        f.addListener((GenericFutureListener)new ChannelFutureListener(this, chunks, currentWrite){
                            final /* synthetic */ ChunkedInput val$chunks;
                            final /* synthetic */ PendingWrite val$currentWrite;
                            final /* synthetic */ ChunkedWriteHandler this$0;
                            {
                                void var1_1;
                                this.this$0 = var1_1;
                                this.val$chunks = chunkedInput;
                                this.val$currentWrite = pendingWrite;
                            }

                            public void operationComplete(ChannelFuture future) {
                                ChunkedWriteHandler.access$100(future, this.val$chunks, this.val$currentWrite);
                            }
                        });
                    }
                } else {
                    boolean resume;
                    boolean bl2 = resume = !channel.isWritable();
                    if (f.isDone()) {
                        this.handleFuture(f, chunks, currentWrite, resume);
                    } else {
                        f.addListener((GenericFutureListener)new ChannelFutureListener(this, chunks, currentWrite, bl){
                            final /* synthetic */ ChunkedInput val$chunks;
                            final /* synthetic */ PendingWrite val$currentWrite;
                            final /* synthetic */ boolean val$resume;
                            final /* synthetic */ ChunkedWriteHandler this$0;
                            {
                                void var1_1;
                                this.this$0 = var1_1;
                                this.val$chunks = chunkedInput;
                                this.val$currentWrite = pendingWrite;
                                this.val$resume = bl;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void operationComplete(ChannelFuture future) {
                                void var1_1;
                                ChunkedWriteHandler.access$200(this.this$0, (ChannelFuture)var1_1, this.val$chunks, this.val$currentWrite, this.val$resume);
                            }
                        });
                    }
                }
                bl = false;
            } else {
                void var6_6;
                this.queue.remove();
                ctx.write((Object)var6_6, currentWrite.promise);
                bl = true;
            }
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        if (bl) {
            void var1_1;
            var1_1.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void handleEndOfInputFuture(ChannelFuture future, ChunkedInput<?> input, PendingWrite currentWrite) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (!future.isSuccess()) {
            ChannelFuture channelFuture;
            ChunkedWriteHandler.closeInput(input);
            currentWrite.fail(channelFuture.cause());
            return;
        }
        long inputProgress = input.progress();
        long inputLength = input.length();
        ChunkedWriteHandler.closeInput(var1_1);
        currentWrite.progress((long)var3_3, inputLength);
        var2_2.success(inputLength);
    }

    /*
     * WARNING - void declaration
     */
    private void handleFuture(ChannelFuture future, ChunkedInput<?> input, PendingWrite currentWrite, boolean resume) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (!future.isSuccess()) {
            ChunkedWriteHandler.closeInput(input);
            currentWrite.fail(future.cause());
            return;
        }
        var3_3.progress(input.progress(), var2_2.length());
        if (resume && var1_1.channel().isWritable()) {
            this.resumeTransfer();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void closeInput(ChunkedInput<?> chunks) {
        try {
            chunks.close();
            return;
        }
        catch (Throwable t) {
            void var0_1;
            logger.warn("Failed to close a ChunkedInput.", (Throwable)var0_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ChunkedWriteHandler x0, ChannelHandlerContext x1) {
        void var1_1;
        x0.resumeTransfer0((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(ChannelFuture x0, ChunkedInput x1, PendingWrite x2) {
        void var2_2;
        void var1_1;
        ChunkedWriteHandler.handleEndOfInputFuture(x0, var1_1, (PendingWrite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(ChunkedWriteHandler x0, ChannelFuture x1, ChunkedInput x2, PendingWrite x3, boolean x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.handleFuture((ChannelFuture)var1_1, (ChunkedInput<?>)var2_2, (PendingWrite)var3_3, x4);
    }

    private static final class PendingWrite {
        final Object msg;
        final ChannelPromise promise;

        /*
         * WARNING - void declaration
         */
        PendingWrite(Object msg, ChannelPromise promise) {
            void var2_2;
            void var1_1;
            this.msg = var1_1;
            this.promise = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        final void fail(Throwable cause) {
            void var1_1;
            ReferenceCountUtil.release((Object)this.msg);
            this.promise.tryFailure((Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void success(long total) {
            void var1_1;
            if (this.promise.isDone()) {
                return;
            }
            void v0 = var1_1;
            this.progress((long)v0, (long)v0);
            this.promise.trySuccess();
        }

        /*
         * WARNING - void declaration
         */
        final void progress(long progress, long total) {
            if (this.promise instanceof ChannelProgressivePromise) {
                void var3_2;
                void var1_1;
                ((ChannelProgressivePromise)this.promise).tryProgress((long)var1_1, (long)var3_2);
            }
        }
    }
}

