/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ChunkedStream
implements ChunkedInput<ByteBuf> {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private long offset;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    public ChunkedStream(InputStream in) {
        this((InputStream)var1_1, 8192);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedStream(InputStream in, int chunkSize) {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)in, (String)"in");
        ObjectUtil.checkPositive((int)chunkSize, (String)"chunkSize");
        this.in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream((InputStream)var1_1);
        this.chunkSize = var2_2;
    }

    public long transferredBytes() {
        return this.offset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEndOfInput() throws Exception {
        void var1_1;
        if (this.closed) {
            return true;
        }
        if (this.in.available() > 0) {
            return false;
        }
        int b = this.in.read();
        if (b < 0) {
            return true;
        }
        this.in.unread((int)var1_1);
        return false;
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        this.in.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        return this.readChunk(var1_1.alloc());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        ByteBuf buffer;
        boolean release;
        int n;
        block5: {
            if (this.isEndOfInput()) {
                return null;
            }
            n = this.in.available();
            int chunkSize = n <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
            release = true;
            buffer = allocator.buffer(chunkSize);
            try {
                int written = buffer.writeBytes((InputStream)this.in, chunkSize);
                if (written >= 0) break block5;
            }
            catch (Throwable throwable) {
                void var3_5;
                if (var3_5 != false) {
                    void var1_1;
                    var1_1.release();
                }
                throw throwable;
            }
            buffer.release();
            return null;
        }
        this.offset += (long)n;
        release = false;
        ByteBuf byteBuf = buffer;
        return byteBuf;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

