/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChunkedNioStream
implements ChunkedInput<ByteBuf> {
    private final ReadableByteChannel in;
    private final int chunkSize;
    private long offset;
    private final ByteBuffer byteBuffer;

    /*
     * WARNING - void declaration
     */
    public ChunkedNioStream(ReadableByteChannel in) {
        this((ReadableByteChannel)var1_1, 8192);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedNioStream(ReadableByteChannel in, int chunkSize) {
        void var2_2;
        void var1_1;
        this.in = (ReadableByteChannel)ObjectUtil.checkNotNull((Object)var1_1, (String)"in");
        this.chunkSize = ObjectUtil.checkPositive((int)chunkSize, (String)"chunkSize");
        this.byteBuffer = ByteBuffer.allocate((int)var2_2);
    }

    public long transferredBytes() {
        return this.offset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEndOfInput() throws Exception {
        if (this.byteBuffer.position() > 0) {
            return false;
        }
        if (this.in.isOpen()) {
            void var1_1;
            int b = this.in.read(this.byteBuffer);
            if (b < 0) {
                return true;
            }
            this.offset += (long)var1_1;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        this.in.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        return this.readChunk(var1_1.alloc());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        int localReadBytes;
        if (this.isEndOfInput()) {
            return null;
        }
        int readBytes = this.byteBuffer.position();
        while ((localReadBytes = this.in.read(this.byteBuffer)) >= 0) {
            this.offset += (long)localReadBytes;
            if ((readBytes += localReadBytes) != this.chunkSize) continue;
        }
        this.byteBuffer.flip();
        boolean release = true;
        ByteBuf buffer = allocator.buffer(this.byteBuffer.remaining());
        try {
            buffer.writeBytes(this.byteBuffer);
            this.byteBuffer.clear();
            release = false;
            ByteBuf byteBuf = buffer;
            return byteBuf;
        }
        catch (Throwable throwable) {
            void var3_5;
            if (var3_5 != false) {
                void var1_1;
                var1_1.release();
            }
            throw throwable;
        }
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long progress() {
        return this.offset;
    }
}

