/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;

public class ChunkedNioFile
implements ChunkedInput<ByteBuf> {
    private final FileChannel in;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    /*
     * WARNING - void declaration
     */
    public ChunkedNioFile(File in) throws IOException {
        this(new RandomAccessFile((File)var1_1, "r").getChannel());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedNioFile(File in, int chunkSize) throws IOException {
        this(new RandomAccessFile((File)var1_1, "r").getChannel(), (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedNioFile(FileChannel in) throws IOException {
        this((FileChannel)var1_1, 8192);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedNioFile(FileChannel in, int chunkSize) throws IOException {
        this(in, 0L, var1_1.size(), (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedNioFile(FileChannel in, long offset, long length, int chunkSize) throws IOException {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)in, (String)"in");
        ObjectUtil.checkPositiveOrZero((long)offset, (String)"offset");
        ObjectUtil.checkPositiveOrZero((long)length, (String)"length");
        ObjectUtil.checkPositive((int)chunkSize, (String)"chunkSize");
        if (!in.isOpen()) {
            throw new ClosedChannelException();
        }
        this.in = var1_1;
        this.chunkSize = chunkSize;
        ChunkedNioFile chunkedNioFile = this;
        chunkedNioFile.offset = chunkedNioFile.startOffset = offset;
        this.endOffset = var2_2 + length;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.offset >= this.endOffset || !this.in.isOpen();
    }

    @Override
    public void close() throws Exception {
        this.in.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        return this.readChunk(var1_1.alloc());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        long offset = this.offset;
        if (offset >= this.endOffset) {
            return null;
        }
        int chunkSize = (int)Math.min((long)this.chunkSize, this.endOffset - offset);
        ByteBuf buffer = allocator.buffer(chunkSize);
        boolean release = true;
        try {
            int localReadBytes;
            int readBytes = 0;
            while ((localReadBytes = buffer.writeBytes(this.in, offset + (long)readBytes, chunkSize - readBytes)) >= 0 && (readBytes += localReadBytes) != chunkSize) {
            }
            this.offset += (long)readBytes;
            release = false;
            ByteBuf byteBuf = buffer;
            return byteBuf;
        }
        catch (Throwable throwable) {
            if (release) {
                void var1_1;
                var1_1.release();
            }
            throw throwable;
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

