/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ChunkedFile
implements ChunkedInput<ByteBuf> {
    private final RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    /*
     * WARNING - void declaration
     */
    public ChunkedFile(File file) throws IOException {
        this((File)var1_1, 8192);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedFile(File file, int chunkSize) throws IOException {
        this(new RandomAccessFile((File)var1_1, "r"), (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedFile(RandomAccessFile file) throws IOException {
        this((RandomAccessFile)var1_1, 8192);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedFile(RandomAccessFile file, int chunkSize) throws IOException {
        this(file, 0L, var1_1.length(), (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkedFile(RandomAccessFile file, long offset, long length, int chunkSize) throws IOException {
        void var2_2;
        void var1_1;
        ObjectUtil.checkNotNull((Object)file, (String)"file");
        ObjectUtil.checkPositiveOrZero((long)offset, (String)"offset");
        ObjectUtil.checkPositiveOrZero((long)length, (String)"length");
        ObjectUtil.checkPositive((int)chunkSize, (String)"chunkSize");
        this.file = file;
        ChunkedFile chunkedFile = this;
        chunkedFile.offset = chunkedFile.startOffset = offset;
        this.endOffset = offset + length;
        this.chunkSize = chunkSize;
        var1_1.seek((long)var2_2);
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.offset >= this.endOffset || !this.file.getChannel().isOpen();
    }

    @Override
    public void close() throws Exception {
        this.file.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        return this.readChunk(var1_1.alloc());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        long offset = this.offset;
        if (offset >= this.endOffset) {
            return null;
        }
        int chunkSize = (int)Math.min((long)this.chunkSize, this.endOffset - offset);
        ByteBuf buf = allocator.heapBuffer(chunkSize);
        boolean release = true;
        try {
            void var2_2;
            this.file.readFully(buf.array(), buf.arrayOffset(), chunkSize);
            buf.writerIndex(chunkSize);
            this.offset = var2_2 + (long)chunkSize;
            release = false;
            ByteBuf byteBuf = buf;
            return byteBuf;
        }
        catch (Throwable throwable) {
            if (release) {
                void var1_1;
                var1_1.release();
            }
            throw throwable;
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

