/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.X509TrustManagerWrapper;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class SimpleTrustManagerFactory
extends TrustManagerFactory {
    private static final Provider PROVIDER = new Provider("", 0.0, ""){
        private static final long serialVersionUID = -2680540247105807895L;
        {
            void var2_2;
            void var1_1;
        }
    };
    private static final FastThreadLocal<SimpleTrustManagerFactorySpi> CURRENT_SPI = new FastThreadLocal<SimpleTrustManagerFactorySpi>(){

        protected final SimpleTrustManagerFactorySpi initialValue() {
            return new SimpleTrustManagerFactorySpi();
        }
    };

    protected SimpleTrustManagerFactory() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleTrustManagerFactory(String name) {
        super((TrustManagerFactorySpi)CURRENT_SPI.get(), PROVIDER, name);
        void var1_1;
        ((SimpleTrustManagerFactorySpi)CURRENT_SPI.get()).init(this);
        CURRENT_SPI.remove();
        ObjectUtil.checkNotNull((Object)var1_1, (String)"name");
    }

    protected abstract void engineInit(KeyStore var1) throws Exception;

    protected abstract void engineInit(ManagerFactoryParameters var1) throws Exception;

    protected abstract TrustManager[] engineGetTrustManagers();

    static final class SimpleTrustManagerFactorySpi
    extends TrustManagerFactorySpi {
        private SimpleTrustManagerFactory parent;
        private volatile TrustManager[] trustManagers;

        SimpleTrustManagerFactorySpi() {
        }

        /*
         * WARNING - void declaration
         */
        final void init(SimpleTrustManagerFactory parent) {
            void var1_1;
            this.parent = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void engineInit(KeyStore keyStore) throws KeyStoreException {
            try {
                this.parent.engineInit((KeyStore)keyStore);
                return;
            }
            catch (KeyStoreException keyStoreException) {
                keyStore = keyStoreException;
                throw keyStoreException;
            }
            catch (Exception e) {
                void var1_2;
                throw new KeyStoreException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            try {
                this.parent.engineInit((ManagerFactoryParameters)managerFactoryParameters);
                return;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                managerFactoryParameters = invalidAlgorithmParameterException;
                throw invalidAlgorithmParameterException;
            }
            catch (Exception e) {
                void var1_2;
                throw new InvalidAlgorithmParameterException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final TrustManager[] engineGetTrustManagers() {
            void var1_1;
            TrustManager[] trustManagers = this.trustManagers;
            if (this.trustManagers == null) {
                trustManagers = this.parent.engineGetTrustManagers();
                if (PlatformDependent.javaVersion() >= 7) {
                    SimpleTrustManagerFactorySpi.wrapIfNeeded(trustManagers);
                }
                this.trustManagers = trustManagers;
            }
            return (TrustManager[])var1_1.clone();
        }

        /*
         * WARNING - void declaration
         */
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private static void wrapIfNeeded(TrustManager[] trustManagers) {
            for (int i = 0; i < trustManagers.length; ++i) {
                void var2_2;
                TrustManager tm = trustManagers[i];
                if (!(tm instanceof X509TrustManager) || tm instanceof X509ExtendedTrustManager) continue;
                trustManagers[i] = new X509TrustManagerWrapper((X509TrustManager)var2_2);
            }
        }
    }
}

