/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.X509KeyManagerWrapper;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public abstract class SimpleKeyManagerFactory
extends KeyManagerFactory {
    private static final Provider PROVIDER = new Provider("", 0.0, ""){
        private static final long serialVersionUID = -2680540247105807895L;
        {
            void var2_2;
            void var1_1;
        }
    };
    private static final FastThreadLocal<SimpleKeyManagerFactorySpi> CURRENT_SPI = new FastThreadLocal<SimpleKeyManagerFactorySpi>(){

        protected final SimpleKeyManagerFactorySpi initialValue() {
            return new SimpleKeyManagerFactorySpi();
        }
    };

    protected SimpleKeyManagerFactory() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleKeyManagerFactory(String name) {
        super((KeyManagerFactorySpi)CURRENT_SPI.get(), PROVIDER, (String)ObjectUtil.checkNotNull((Object)var1_1, (String)"name"));
        void var1_1;
        ((SimpleKeyManagerFactorySpi)CURRENT_SPI.get()).init(this);
        CURRENT_SPI.remove();
    }

    protected abstract void engineInit(KeyStore var1, char[] var2) throws Exception;

    protected abstract void engineInit(ManagerFactoryParameters var1) throws Exception;

    protected abstract KeyManager[] engineGetKeyManagers();

    private static final class SimpleKeyManagerFactorySpi
    extends KeyManagerFactorySpi {
        private SimpleKeyManagerFactory parent;
        private volatile KeyManager[] keyManagers;

        private SimpleKeyManagerFactorySpi() {
        }

        /*
         * WARNING - void declaration
         */
        final void init(SimpleKeyManagerFactory parent) {
            void var1_1;
            this.parent = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void engineInit(KeyStore keyStore, char[] pwd) throws KeyStoreException {
            try {
                void var2_3;
                this.parent.engineInit((KeyStore)keyStore, (char[])var2_3);
                return;
            }
            catch (KeyStoreException keyStoreException) {
                keyStore = keyStoreException;
                throw keyStoreException;
            }
            catch (Exception e) {
                void var1_2;
                throw new KeyStoreException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            try {
                this.parent.engineInit((ManagerFactoryParameters)managerFactoryParameters);
                return;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                managerFactoryParameters = invalidAlgorithmParameterException;
                throw invalidAlgorithmParameterException;
            }
            catch (Exception e) {
                void var1_2;
                throw new InvalidAlgorithmParameterException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final KeyManager[] engineGetKeyManagers() {
            void var1_1;
            KeyManager[] keyManagers = this.keyManagers;
            if (this.keyManagers == null) {
                keyManagers = this.parent.engineGetKeyManagers();
                if (PlatformDependent.javaVersion() >= 7) {
                    SimpleKeyManagerFactorySpi.wrapIfNeeded(keyManagers);
                }
                this.keyManagers = keyManagers;
            }
            return (KeyManager[])var1_1.clone();
        }

        /*
         * WARNING - void declaration
         */
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private static void wrapIfNeeded(KeyManager[] keyManagers) {
            for (int i = 0; i < keyManagers.length; ++i) {
                void var2_2;
                KeyManager tm = keyManagers[i];
                if (!(tm instanceof X509KeyManager) || tm instanceof X509ExtendedKeyManager) continue;
                keyManagers[i] = new X509KeyManagerWrapper((X509KeyManager)var2_2);
            }
        }
    }
}

