/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.ssl.util.BouncyCastleSelfSignedCertGenerator;
import io.netty.handler.ssl.util.OpenJdkSelfSignedCertGenerator;
import io.netty.handler.ssl.util.ThreadLocalInsecureRandom;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;

public final class SelfSignedCertificate {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelfSignedCertificate.class);
    private static final Date DEFAULT_NOT_BEFORE = new Date(SystemPropertyUtil.getLong((String)"io.netty.selfSignedCertificate.defaultNotBefore", (long)(System.currentTimeMillis() - 31536000000L)));
    private static final Date DEFAULT_NOT_AFTER = new Date(SystemPropertyUtil.getLong((String)"io.netty.selfSignedCertificate.defaultNotAfter", (long)253402300799000L));
    private static final int DEFAULT_KEY_LENGTH_BITS = SystemPropertyUtil.getInt((String)"io.netty.handler.ssl.util.selfSignedKeyStrength", (int)2048);
    private final File certificate;
    private final File privateKey;
    private final X509Certificate cert;
    private final PrivateKey key;

    public SelfSignedCertificate() throws CertificateException {
        this(DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA", DEFAULT_KEY_LENGTH_BITS);
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(Date notBefore, Date notAfter) throws CertificateException {
        this("localhost", (Date)var1_1, (Date)var2_2, "RSA", DEFAULT_KEY_LENGTH_BITS);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(Date notBefore, Date notAfter, String algorithm, int bits) throws CertificateException {
        this("localhost", (Date)var1_1, (Date)var2_2, (String)var3_3, bits);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(String fqdn) throws CertificateException {
        this((String)var1_1, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA", DEFAULT_KEY_LENGTH_BITS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(String fqdn, String algorithm, int bits) throws CertificateException {
        this((String)var1_1, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, (String)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(String fqdn, Date notBefore, Date notAfter) throws CertificateException {
        this((String)var1_1, ThreadLocalInsecureRandom.current(), DEFAULT_KEY_LENGTH_BITS, (Date)var2_2, (Date)var3_3, "RSA");
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(String fqdn, Date notBefore, Date notAfter, String algorithm, int bits) throws CertificateException {
        this((String)var1_1, ThreadLocalInsecureRandom.current(), bits, (Date)var2_2, (Date)var3_3, algorithm);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(String fqdn, SecureRandom random, int bits) throws CertificateException {
        this((String)var1_1, (SecureRandom)var2_2, (int)var3_3, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, "RSA");
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(String fqdn, SecureRandom random, String algorithm, int bits) throws CertificateException {
        this((String)var1_1, (SecureRandom)var2_2, bits, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SelfSignedCertificate(String fqdn, SecureRandom random, int bits, Date notBefore, Date notAfter) throws CertificateException {
        this((String)var1_1, (SecureRandom)var2_2, (int)var3_3, notBefore, notAfter, "RSA");
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SelfSignedCertificate(String fqdn, SecureRandom random, int bits, Date notBefore, Date notAfter, String algorithm) throws CertificateException {
        void var3_10;
        String[] paths;
        KeyPair keypair;
        if (!"EC".equalsIgnoreCase(algorithm) && !"RSA".equalsIgnoreCase(algorithm)) {
            throw new IllegalArgumentException("Algorithm not valid: " + algorithm);
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
            keyGen.initialize(bits, random);
            keypair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        try {
            paths = BouncyCastleSelfSignedCertGenerator.generate(fqdn, keypair, random, notBefore, notAfter, algorithm);
        }
        catch (Throwable t) {
            if (!SelfSignedCertificate.isBouncyCastleAvailable()) {
                logger.debug("Failed to generate a self-signed X.509 certificate because BouncyCastle PKIX is not available in classpath");
            } else {
                logger.debug("Failed to generate a self-signed X.509 certificate using Bouncy Castle:", t);
            }
            try {
                paths = OpenJdkSelfSignedCertGenerator.generate(fqdn, keypair, random, notBefore, notAfter, algorithm);
            }
            catch (Throwable t2) {
                logger.debug("Failed to generate a self-signed X.509 certificate using sun.security.x509:", t2);
                CertificateException certificateException = new CertificateException("No provider succeeded to generate a self-signed certificate. See debug log for the root cause.", t2);
                ThrowableUtil.addSuppressed((Throwable)certificateException, (Throwable)t);
                throw certificateException;
            }
        }
        this.certificate = new File(paths[0]);
        this.privateKey = new File(paths[1]);
        this.key = var3_10.getPrivate();
        FileInputStream certificateInput = null;
        try {
            certificateInput = new FileInputStream(this.certificate);
            this.cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(certificateInput);
        }
        catch (Exception e) {
            try {
                void var1_5;
                throw new CertificateEncodingException((Throwable)var1_5);
            }
            catch (Throwable throwable) {
                if (certificateInput == null) throw throwable;
                try {
                    certificateInput.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    void var2_8;
                    if (!logger.isWarnEnabled()) throw throwable;
                    logger.warn("Failed to close a file: " + this.certificate, (Throwable)var2_8);
                }
                throw throwable;
            }
        }
        try {
            certificateInput.close();
            return;
        }
        catch (IOException e) {
            if (!logger.isWarnEnabled()) return;
            logger.warn("Failed to close a file: " + this.certificate, (Throwable)e);
            return;
        }
    }

    public final File certificate() {
        return this.certificate;
    }

    public final File privateKey() {
        return this.privateKey;
    }

    public final X509Certificate cert() {
        return this.cert;
    }

    public final PrivateKey key() {
        return this.key;
    }

    public final void delete() {
        SelfSignedCertificate.safeDelete(this.certificate);
        SelfSignedCertificate.safeDelete(this.privateKey);
    }

    /*
     * WARNING - void declaration
     */
    static String[] newSelfSignedCertificate(String fqdn, PrivateKey key, X509Certificate cert2) throws IOException, CertificateEncodingException {
        File file;
        String keyText;
        ByteBuf encodedBuf;
        ByteBuf wrappedBuf = Unpooled.wrappedBuffer((byte[])key.getEncoded());
        try {
            encodedBuf = Base64.encode((ByteBuf)wrappedBuf, (boolean)true);
            try {
                keyText = "-----BEGIN PRIVATE KEY-----\n" + encodedBuf.toString(CharsetUtil.US_ASCII) + "\n-----END PRIVATE KEY-----\n";
            }
            finally {
                encodedBuf.release();
            }
        }
        finally {
            wrappedBuf.release();
        }
        fqdn = fqdn.replaceAll("[^\\w.-]", "x");
        File keyFile = PlatformDependent.createTempFile((String)("keyutil_" + fqdn + '_'), (String)".key", null);
        keyFile.deleteOnExit();
        FileOutputStream keyOut = new FileOutputStream(keyFile);
        try {
            ((OutputStream)keyOut).write(keyText.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)keyOut).close();
            keyOut = null;
        }
        catch (Throwable cert2) {
            SelfSignedCertificate.safeClose(keyFile, keyOut);
            SelfSignedCertificate.safeDelete(keyFile);
            throw cert2;
        }
        wrappedBuf = Unpooled.wrappedBuffer((byte[])cert2.getEncoded());
        try {
            encodedBuf = Base64.encode((ByteBuf)wrappedBuf, (boolean)true);
            try {
                String certText = "-----BEGIN CERTIFICATE-----\n" + encodedBuf.toString(CharsetUtil.US_ASCII) + "\n-----END CERTIFICATE-----\n";
            }
            finally {
                encodedBuf.release();
            }
        }
        catch (Throwable encodedBuf2) {
            void var1_2;
            var1_2.release();
            throw encodedBuf2;
        }
        wrappedBuf.release();
        File certFile = PlatformDependent.createTempFile((String)("keyutil_" + fqdn + '_'), (String)".crt", null);
        certFile.deleteOnExit();
        FileOutputStream certOut = new FileOutputStream(certFile);
        try {
            void var2_4;
            ((OutputStream)certOut).write(var2_4.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)certOut).close();
            certOut = null;
        }
        catch (Throwable throwable) {
            void var3_6;
            SelfSignedCertificate.safeClose(certFile, (OutputStream)var3_6);
            SelfSignedCertificate.safeDelete(certFile);
            SelfSignedCertificate.safeDelete(keyFile);
            throw throwable;
        }
        return new String[]{file.getPath(), keyFile.getPath()};
    }

    private static void safeDelete(File certFile) {
        if (!certFile.delete() && logger.isWarnEnabled()) {
            File file;
            logger.warn("Failed to delete a file: " + file);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void safeClose(File keyFile, OutputStream keyOut) {
        try {
            keyOut.close();
            return;
        }
        catch (IOException e) {
            if (logger.isWarnEnabled()) {
                void var1_2;
                File file;
                logger.warn("Failed to close a file: " + file, (Throwable)var1_2);
            }
            return;
        }
    }

    private static boolean isBouncyCastleAvailable() {
        try {
            Class.forName("org.bouncycastle.cert.X509v3CertificateBuilder");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

