/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SuppressJava6Requirement;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class LazyX509Certificate
extends X509Certificate {
    static final CertificateFactory X509_CERT_FACTORY;
    private final byte[] bytes;
    private X509Certificate wrapped;

    /*
     * WARNING - void declaration
     */
    public LazyX509Certificate(byte[] bytes) {
        void var1_1;
        this.bytes = (byte[])ObjectUtil.checkNotNull((Object)var1_1, (String)"bytes");
    }

    @Override
    public final void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.unwrap().checkValidity();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        void var1_1;
        this.unwrap().checkValidity((Date)var1_1);
    }

    @Override
    public final X500Principal getIssuerX500Principal() {
        return this.unwrap().getIssuerX500Principal();
    }

    @Override
    public final X500Principal getSubjectX500Principal() {
        return this.unwrap().getSubjectX500Principal();
    }

    @Override
    public final List<String> getExtendedKeyUsage() throws CertificateParsingException {
        return this.unwrap().getExtendedKeyUsage();
    }

    @Override
    public final Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        return this.unwrap().getSubjectAlternativeNames();
    }

    @Override
    public final Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return this.unwrap().getIssuerAlternativeNames();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressJava6Requirement(reason="Can only be called from Java8 as class is package-private")
    public final void verify(PublicKey key, Provider sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        void var2_2;
        void var1_1;
        this.unwrap().verify((PublicKey)var1_1, (Provider)var2_2);
    }

    @Override
    public final int getVersion() {
        return this.unwrap().getVersion();
    }

    @Override
    public final BigInteger getSerialNumber() {
        return this.unwrap().getSerialNumber();
    }

    @Override
    public final Principal getIssuerDN() {
        return this.unwrap().getIssuerDN();
    }

    @Override
    public final Principal getSubjectDN() {
        return this.unwrap().getSubjectDN();
    }

    @Override
    public final Date getNotBefore() {
        return this.unwrap().getNotBefore();
    }

    @Override
    public final Date getNotAfter() {
        return this.unwrap().getNotAfter();
    }

    @Override
    public final byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.unwrap().getTBSCertificate();
    }

    @Override
    public final byte[] getSignature() {
        return this.unwrap().getSignature();
    }

    @Override
    public final String getSigAlgName() {
        return this.unwrap().getSigAlgName();
    }

    @Override
    public final String getSigAlgOID() {
        return this.unwrap().getSigAlgOID();
    }

    @Override
    public final byte[] getSigAlgParams() {
        return this.unwrap().getSigAlgParams();
    }

    @Override
    public final boolean[] getIssuerUniqueID() {
        return this.unwrap().getIssuerUniqueID();
    }

    @Override
    public final boolean[] getSubjectUniqueID() {
        return this.unwrap().getSubjectUniqueID();
    }

    @Override
    public final boolean[] getKeyUsage() {
        return this.unwrap().getKeyUsage();
    }

    @Override
    public final int getBasicConstraints() {
        return this.unwrap().getBasicConstraints();
    }

    @Override
    public final byte[] getEncoded() {
        return (byte[])this.bytes.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        void var1_1;
        this.unwrap().verify((PublicKey)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        void var2_2;
        void var1_1;
        this.unwrap().verify((PublicKey)var1_1, (String)var2_2);
    }

    @Override
    public final String toString() {
        return this.unwrap().toString();
    }

    @Override
    public final PublicKey getPublicKey() {
        return this.unwrap().getPublicKey();
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        return this.unwrap().hasUnsupportedCriticalExtension();
    }

    @Override
    public final Set<String> getCriticalExtensionOIDs() {
        return this.unwrap().getCriticalExtensionOIDs();
    }

    @Override
    public final Set<String> getNonCriticalExtensionOIDs() {
        return this.unwrap().getNonCriticalExtensionOIDs();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] getExtensionValue(String oid) {
        void var1_1;
        return this.unwrap().getExtensionValue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private X509Certificate unwrap() {
        void var1_1;
        X509Certificate wrapped = this.wrapped;
        if (wrapped == null) {
            try {
                wrapped = this.wrapped = (X509Certificate)X509_CERT_FACTORY.generateCertificate(new ByteArrayInputStream(this.bytes));
            }
            catch (CertificateException e) {
                void var1_2;
                throw new IllegalStateException((Throwable)var1_2);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
            return;
        }
        catch (CertificateException e) {
            void var0;
            throw new ExceptionInInitializerError((Throwable)var0);
        }
    }
}

