/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class FingerprintTrustManagerFactoryBuilder {
    private final String algorithm;
    private final List<String> fingerprints = new ArrayList<String>();

    /*
     * WARNING - void declaration
     */
    FingerprintTrustManagerFactoryBuilder(String algorithm) {
        void var1_1;
        this.algorithm = (String)ObjectUtil.checkNotNull((Object)var1_1, (String)"algorithm");
    }

    /*
     * WARNING - void declaration
     */
    public final FingerprintTrustManagerFactoryBuilder fingerprints(CharSequence ... fingerprints) {
        void var1_1;
        return this.fingerprints(Arrays.asList((Object[])ObjectUtil.checkNotNull((Object)var1_1, (String)"fingerprints")));
    }

    /*
     * WARNING - void declaration
     */
    public final FingerprintTrustManagerFactoryBuilder fingerprints(Iterable<? extends CharSequence> fingerprints) {
        Iterator iterator;
        ObjectUtil.checkNotNull(fingerprints, (String)"fingerprints");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            CharSequence fingerprint = (CharSequence)iterator.next();
            ObjectUtil.checkNotNullWithIAE((Object)fingerprint, (String)"fingerprint");
            this.fingerprints.add(var2_2.toString());
        }
        return this;
    }

    public final FingerprintTrustManagerFactory build() {
        if (this.fingerprints.isEmpty()) {
            throw new IllegalStateException("No fingerprints provided");
        }
        return new FingerprintTrustManagerFactory(this.algorithm, FingerprintTrustManagerFactory.toFingerprintArray(this.fingerprints));
    }
}

