/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.util.FingerprintTrustManagerFactoryBuilder;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class FingerprintTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("^[0-9a-fA-F:]+$");
    private static final Pattern FINGERPRINT_STRIP_PATTERN = Pattern.compile(":");
    private final FastThreadLocal<MessageDigest> tlmd;
    private final TrustManager tm = new X509TrustManager(this){
        final /* synthetic */ FingerprintTrustManagerFactory this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String s) throws CertificateException {
            void var1_1;
            this.checkTrusted("client", (X509Certificate[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkServerTrusted(X509Certificate[] chain, String s) throws CertificateException {
            void var1_1;
            this.checkTrusted("server", (X509Certificate[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void checkTrusted(String type, X509Certificate[] chain) throws CertificateException {
            X509Certificate cert = chain[0];
            byte[] fingerprint = this.fingerprint(cert);
            boolean found = false;
            for (byte[] allowedFingerprint : this.this$0.fingerprints) {
                if (!Arrays.equals(fingerprint, allowedFingerprint)) continue;
                found = true;
                break;
            }
            if (!found) {
                void var2_2;
                void var1_1;
                throw new CertificateException((String)var1_1 + " certificate with unknown fingerprint: " + var2_2.getSubjectDN());
            }
        }

        /*
         * WARNING - void declaration
         */
        private byte[] fingerprint(X509Certificate cert) throws CertificateEncodingException {
            void var1_1;
            void var2_2;
            MessageDigest md = (MessageDigest)this.this$0.tlmd.get();
            md.reset();
            return var2_2.digest(var1_1.getEncoded());
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    };
    private final byte[][] fingerprints;

    public static FingerprintTrustManagerFactoryBuilder builder(String algorithm) {
        String string;
        return new FingerprintTrustManagerFactoryBuilder(string);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public FingerprintTrustManagerFactory(Iterable<String> fingerprints) {
        this("SHA1", FingerprintTrustManagerFactory.toFingerprintArray((Iterable<String>)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public FingerprintTrustManagerFactory(String ... fingerprints) {
        this("SHA1", FingerprintTrustManagerFactory.toFingerprintArray(Arrays.asList(var1_1)));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public FingerprintTrustManagerFactory(byte[] ... fingerprints) {
        this("SHA1", (byte[][])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    FingerprintTrustManagerFactory(String algorithm, byte[][] fingerprints) {
        void var1_1;
        void var2_2;
        MessageDigest md;
        ObjectUtil.checkNotNull((Object)algorithm, (String)"algorithm");
        ObjectUtil.checkNotNull((Object)fingerprints, (String)"fingerprints");
        if (fingerprints.length == 0) {
            throw new IllegalArgumentException("No fingerprints provided");
        }
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("Unsupported hash algorithm: %s", algorithm), e);
        }
        int hashLength = md.getDigestLength();
        ArrayList<Object> list = new ArrayList<Object>(fingerprints.length);
        for (void f : var2_2) {
            if (f == null) break;
            if (((void)f).length != hashLength) {
                throw new IllegalArgumentException(String.format("malformed fingerprint (length is %d but expected %d): %s", ((void)f).length, hashLength, ByteBufUtil.hexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])f))));
            }
            list.add(f.clone());
        }
        this.tlmd = new FastThreadLocal<MessageDigest>(this, (String)var1_1){
            final /* synthetic */ String val$algorithm;
            final /* synthetic */ FingerprintTrustManagerFactory this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$algorithm = string;
            }

            /*
             * WARNING - void declaration
             */
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance(this.val$algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    void var1_1;
                    throw new IllegalArgumentException(String.format("Unsupported hash algorithm: %s", this.val$algorithm), (Throwable)var1_1);
                }
            }
        };
        this.fingerprints = (byte[][])list.toArray((T[])new byte[0][]);
    }

    /*
     * WARNING - void declaration
     */
    static byte[][] toFingerprintArray(Iterable<String> fingerprints) {
        void var1_1;
        String f;
        Iterator<String> iterator;
        ObjectUtil.checkNotNull(fingerprints, (String)"fingerprints");
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        iterator = iterator.iterator();
        while (iterator.hasNext() && (f = (String)iterator.next()) != null) {
            void var2_2;
            if (!FINGERPRINT_PATTERN.matcher(f).matches()) {
                throw new IllegalArgumentException("malformed fingerprint: " + f);
            }
            f = FINGERPRINT_STRIP_PATTERN.matcher(f).replaceAll("");
            list.add(StringUtil.decodeHexDump((CharSequence)var2_2));
        }
        return (byte[][])var1_1.toArray((T[])new byte[0][]);
    }

    @Override
    protected final void engineInit(KeyStore keyStore) throws Exception {
    }

    @Override
    protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    @Override
    protected final TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }
}

