/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

final class BouncyCastleSelfSignedCertGenerator {
    private static final Provider PROVIDER;

    /*
     * WARNING - void declaration
     */
    static String[] generate(String fqdn, KeyPair keypair, SecureRandom random, Date notBefore, Date notAfter, String algorithm) throws Exception {
        void var2_2;
        String string;
        void var1_1;
        void var3_3;
        PrivateKey key = keypair.getPrivate();
        X500Name owner = new X500Name("CN=" + fqdn);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, random), notBefore, notAfter, owner, keypair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder(algorithm.equalsIgnoreCase("EC") ? "SHA256withECDSA" : "SHA256WithRSAEncryption").build(key);
        X509CertificateHolder certHolder = builder.build((ContentSigner)var3_3);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certHolder);
        cert.verify(var1_1.getPublic());
        return SelfSignedCertificate.newSelfSignedCertificate(string, key, (X509Certificate)var2_2);
    }

    private BouncyCastleSelfSignedCertGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        Class<?> providerClass;
        try {
            providerClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                providerClass = Class.forName("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new RuntimeException("Neither BouncyCastleProvider nor BouncyCastleFipsProvider found");
            }
        }
        try {
            PROVIDER = (Provider)providerClass.newInstance();
            return;
        }
        catch (Exception e) {
            void var0_1;
            throw new RuntimeException("Failed to instantiate BouncyCastle provider", (Throwable)var0_1);
        }
    }
}

