/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslUtils;
import java.security.Provider;

public enum SslProvider {
    JDK,
    OPENSSL,
    OPENSSL_REFCNT;


    public static boolean isAlpnSupported(SslProvider provider) {
        SslProvider sslProvider;
        switch (provider) {
            case JDK: {
                return JdkAlpnApplicationProtocolNegotiator.isAlpnSupported();
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isAlpnSupported();
            }
        }
        throw new Error("Unknown SslProvider: " + (Object)((Object)sslProvider));
    }

    public static boolean isTlsv13Supported(SslProvider sslProvider) {
        return SslProvider.isTlsv13Supported(sslProvider, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isTlsv13Supported(SslProvider sslProvider, Provider provider) {
        SslProvider sslProvider2;
        switch (sslProvider) {
            case JDK: {
                void var1_1;
                return SslUtils.isTLSv13SupportedByJDK((Provider)var1_1);
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isTlsv13Supported();
            }
        }
        throw new Error("Unknown SslProvider: " + (Object)((Object)sslProvider2));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isOptionSupported(SslProvider sslProvider, SslContextOption<?> option) {
        SslProvider sslProvider2;
        switch (sslProvider) {
            case JDK: {
                return false;
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                void var1_1;
                return OpenSsl.isOptionSupported(var1_1);
            }
        }
        throw new Error("Unknown SslProvider: " + (Object)((Object)sslProvider2));
    }

    /*
     * WARNING - void declaration
     */
    static boolean isTlsv13EnabledByDefault(SslProvider sslProvider, Provider provider) {
        SslProvider sslProvider2;
        switch (sslProvider) {
            case JDK: {
                void var1_1;
                return SslUtils.isTLSv13EnabledByJDK((Provider)var1_1);
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isTlsv13Supported();
            }
        }
        throw new Error("Unknown SslProvider: " + (Object)((Object)sslProvider2));
    }
}

