/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.internal.ReflectionUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public abstract class SslMasterKeyHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger;
    private static final Class<?> SSL_SESSIONIMPL_CLASS;
    private static final Field SSL_SESSIONIMPL_MASTER_SECRET_FIELD;
    public static final String SYSTEM_PROP_KEY = "io.netty.ssl.masterKeyHandler";
    private static final Throwable UNAVAILABILITY_CAUSE;

    protected SslMasterKeyHandler() {
    }

    public static void ensureSunSslEngineAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw new IllegalStateException("Failed to find SSLSessionImpl on classpath", UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable sunSslEngineUnavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static boolean isSunSslEngineAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    protected abstract void accept(SecretKey var1, SSLSession var2);

    /*
     * WARNING - void declaration
     */
    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        void var2_3;
        void var1_1;
        if (evt == SslHandshakeCompletionEvent.SUCCESS && this.masterKeyHandlerEnabled()) {
            SecretKey secretKey;
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            SSLEngine engine = sslHandler.engine();
            SSLSession sslSession = engine.getSession();
            if (SslMasterKeyHandler.isSunSslEngineAvailable() && sslSession.getClass().equals(SSL_SESSIONIMPL_CLASS)) {
                try {
                    secretKey = (SecretKey)SSL_SESSIONIMPL_MASTER_SECRET_FIELD.get(sslSession);
                }
                catch (IllegalAccessException e) {
                    void var1_2;
                    throw new IllegalArgumentException("Failed to access the field 'masterSecret' via reflection.", (Throwable)var1_2);
                }
                this.accept(secretKey, sslSession);
            } else if (OpenSsl.isAvailable() && secretKey instanceof ReferenceCountedOpenSslEngine) {
                secretKey = ((ReferenceCountedOpenSslEngine)((Object)secretKey)).masterKey();
                this.accept((SecretKey)((Object)sslHandler), sslSession);
            }
        }
        var1_1.fireUserEventTriggered((Object)var2_3);
    }

    protected boolean masterKeyHandlerEnabled() {
        return SystemPropertyUtil.getBoolean((String)SYSTEM_PROP_KEY, (boolean)false);
    }

    public static SslMasterKeyHandler newWireSharkSslMasterKeyHandler() {
        return new WiresharkSslMasterKeyHandler();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_1;
        void var1;
        void var0_2;
        Throwable cause;
        logger = InternalLoggerFactory.getInstance(SslMasterKeyHandler.class);
        Class<?> clazz = null;
        Field field = null;
        try {
            clazz = Class.forName("sun.security.ssl.SSLSessionImpl");
            field = clazz.getDeclaredField("masterSecret");
            cause = ReflectionUtil.trySetAccessible((AccessibleObject)field, (boolean)true);
        }
        catch (Throwable throwable) {
            void var3_3;
            Throwable e = throwable;
            cause = throwable;
            if (logger.isTraceEnabled()) {
                logger.debug("sun.security.ssl.SSLSessionImpl is unavailable.", e);
            }
            logger.debug("sun.security.ssl.SSLSessionImpl is unavailable: {}", (Object)var3_3.getMessage());
        }
        UNAVAILABILITY_CAUSE = var0_2;
        SSL_SESSIONIMPL_CLASS = var1;
        SSL_SESSIONIMPL_MASTER_SECRET_FIELD = var2_1;
    }

    private static final class WiresharkSslMasterKeyHandler
    extends SslMasterKeyHandler {
        private static final InternalLogger wireshark_logger = InternalLoggerFactory.getInstance((String)"io.netty.wireshark");

        private WiresharkSslMasterKeyHandler() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void accept(SecretKey masterKey, SSLSession session) {
            void var1_1;
            void var2_2;
            if (masterKey.getEncoded().length != 48) {
                throw new IllegalArgumentException("An invalid length master key was provided.");
            }
            byte[] sessionId = session.getId();
            wireshark_logger.warn("RSA Session-ID:{} Master-Key:{}", (Object)ByteBufUtil.hexDump((byte[])var2_2).toLowerCase(), (Object)ByteBufUtil.hexDump((byte[])var1_1.getEncoded()).toLowerCase());
        }
    }
}

