/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.AbstractCoalescingBufferQueue;
import io.netty.channel.Channel;
import io.netty.util.internal.PlatformDependent;

abstract class SslHandlerCoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final boolean wantsDirectBuffer;

    /*
     * WARNING - void declaration
     */
    SslHandlerCoalescingBufferQueue(Channel channel, int initSize, boolean wantsDirectBuffer) {
        super((Channel)var1_1, (int)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.wantsDirectBuffer = var3_3;
    }

    protected abstract int wrapDataSize();

    /*
     * WARNING - void declaration
     */
    protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (SslHandlerCoalescingBufferQueue.attemptCopyToCumulation(cumulation, next, this.wrapDataSize())) {
            return cumulation;
        }
        return this.copyAndCompose((ByteBufAllocator)var1_1, (ByteBuf)var2_2, (ByteBuf)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first, int bufferSize) {
        void var1_1;
        void var2_2;
        ByteBuf newFirst;
        newFirst = this.wantsDirectBuffer ? allocator.directBuffer(bufferSize) : newFirst.heapBuffer(bufferSize);
        try {
            newFirst.writeBytes(first);
        }
        catch (Throwable cause) {
            void var3_4;
            newFirst.release();
            PlatformDependent.throwException((Throwable)var3_4);
        }
        assert (!first.isReadable());
        var2_2.release();
        return var1_1;
    }

    protected ByteBuf removeEmptyValue() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean attemptCopyToCumulation(ByteBuf cumulation, ByteBuf next, int wrapDataSize) {
        void var3_3;
        void var2_2;
        int inReadableBytes = next.readableBytes();
        if (inReadableBytes == 0) {
            next.release();
            return true;
        }
        int cumulationCapacity = cumulation.capacity();
        if (wrapDataSize - cumulation.readableBytes() >= inReadableBytes && (cumulation.isWritable(inReadableBytes) && cumulationCapacity >= wrapDataSize || cumulationCapacity < var2_2 && ByteBufUtil.ensureWritableSuccess((int)cumulation.ensureWritable((int)var3_3, false)))) {
            void var1_1;
            ByteBuf byteBuf;
            byteBuf.writeBytes(next);
            var1_1.release();
            return true;
        }
        return false;
    }
}

