/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPromise;
import io.netty.channel.unix.UnixChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.netty.handler.ssl.AsyncRunnable;
import io.netty.handler.ssl.ConscryptAlpnSslEngine;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandlerCoalescingBufferQueue;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslHandshakeTimeoutException;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.StacklessSSLHandshakeException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;

public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final int STATE_SENT_FIRST_MESSAGE = 1;
    private static final int STATE_FLUSHED_BEFORE_HANDSHAKE = 2;
    private static final int STATE_READ_DURING_HANDSHAKE = 4;
    private static final int STATE_HANDSHAKE_STARTED = 8;
    private static final int STATE_NEEDS_FLUSH = 16;
    private static final int STATE_OUTBOUND_CLOSED = 32;
    private static final int STATE_CLOSE_NOTIFY = 64;
    private static final int STATE_PROCESS_TASK = 128;
    private static final int STATE_FIRE_CHANNEL_READ = 256;
    private static final int STATE_UNWRAP_REENTRY = 512;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslEngineType engineType;
    private final Executor delegatedTaskExecutor;
    private final boolean jdkCompatibilityMode;
    private final ByteBuffer[] singleBuffer = new ByteBuffer[1];
    private final boolean startTls;
    private final ResumptionController resumptionController;
    private final SslTasksRunner sslTaskRunnerForUnwrap = new SslTasksRunner(true);
    private final SslTasksRunner sslTaskRunner = new SslTasksRunner(false);
    private SslHandlerCoalescingBufferQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new LazyChannelPromise();
    private final LazyChannelPromise sslClosePromise = new LazyChannelPromise();
    private int packetLength;
    private short state;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyFlushTimeoutMillis = 3000L;
    private volatile long closeNotifyReadTimeoutMillis;
    volatile int wrapDataSize = 16384;

    /*
     * WARNING - void declaration
     */
    public SslHandler(SSLEngine engine) {
        this((SSLEngine)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler(SSLEngine engine, boolean startTls) {
        this((SSLEngine)var1_1, (boolean)var2_2, (Executor)ImmediateExecutor.INSTANCE);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler(SSLEngine engine, Executor delegatedTaskExecutor) {
        this((SSLEngine)var1_1, false, (Executor)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor) {
        this((SSLEngine)var1_1, (boolean)var2_2, (Executor)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor, ResumptionController resumptionController) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.engine = (SSLEngine)ObjectUtil.checkNotNull((Object)engine, (String)"engine");
        this.delegatedTaskExecutor = (Executor)ObjectUtil.checkNotNull((Object)var3_3, (String)"delegatedTaskExecutor");
        this.engineType = SslEngineType.forEngine(engine);
        this.startTls = var2_2;
        this.jdkCompatibilityMode = this.engineType.jdkCompatibilityMode((SSLEngine)var1_1);
        SslHandler sslHandler = this;
        sslHandler.setCumulator(sslHandler.engineType.cumulator);
        this.resumptionController = resumptionController;
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    /*
     * WARNING - void declaration
     */
    public void setHandshakeTimeout(long handshakeTimeout, TimeUnit unit) {
        void var1_1;
        void var3_2;
        ObjectUtil.checkNotNull((Object)((Object)unit), (String)"unit");
        this.setHandshakeTimeoutMillis(var3_2.toMillis((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setHandshakeTimeoutMillis(long handshakeTimeoutMillis) {
        void var1_1;
        this.handshakeTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)var1_1, (String)"handshakeTimeoutMillis");
    }

    /*
     * WARNING - void declaration
     */
    public final void setWrapDataSize(int wrapDataSize) {
        void var1_1;
        this.wrapDataSize = var1_1;
    }

    @Deprecated
    public long getCloseNotifyTimeoutMillis() {
        return this.getCloseNotifyFlushTimeoutMillis();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setCloseNotifyTimeout(long closeNotifyTimeout, TimeUnit unit) {
        void var3_2;
        void var1_1;
        this.setCloseNotifyFlushTimeout((long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setCloseNotifyTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
        void var1_1;
        this.setCloseNotifyFlushTimeoutMillis((long)var1_1);
    }

    public final long getCloseNotifyFlushTimeoutMillis() {
        return this.closeNotifyFlushTimeoutMillis;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCloseNotifyFlushTimeout(long closeNotifyFlushTimeout, TimeUnit unit) {
        void var1_1;
        void var3_2;
        this.setCloseNotifyFlushTimeoutMillis(var3_2.toMillis((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void setCloseNotifyFlushTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
        void var1_1;
        this.closeNotifyFlushTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)var1_1, (String)"closeNotifyFlushTimeoutMillis");
    }

    public final long getCloseNotifyReadTimeoutMillis() {
        return this.closeNotifyReadTimeoutMillis;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCloseNotifyReadTimeout(long closeNotifyReadTimeout, TimeUnit unit) {
        void var1_1;
        void var3_2;
        this.setCloseNotifyReadTimeoutMillis(var3_2.toMillis((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void setCloseNotifyReadTimeoutMillis(long closeNotifyReadTimeoutMillis) {
        void var1_1;
        this.closeNotifyReadTimeoutMillis = ObjectUtil.checkPositiveOrZero((long)var1_1, (String)"closeNotifyReadTimeoutMillis");
    }

    public SSLEngine engine() {
        return this.engine;
    }

    /*
     * WARNING - void declaration
     */
    public String applicationProtocol() {
        void var1_1;
        SSLEngine engine = this.engine();
        if (!(engine instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)var1_1).getNegotiatedApplicationProtocol();
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise;
    }

    @Deprecated
    public ChannelFuture close() {
        return this.closeOutbound();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ChannelFuture close(ChannelPromise promise) {
        void var1_1;
        return this.closeOutbound((ChannelPromise)var1_1);
    }

    public ChannelFuture closeOutbound() {
        SslHandler sslHandler = this;
        return sslHandler.closeOutbound(sslHandler.ctx.newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public ChannelFuture closeOutbound(ChannelPromise promise) {
        void var1_1;
        ChannelHandlerContext ctx = this.ctx;
        if (ctx.executor().inEventLoop()) {
            this.closeOutbound0(promise);
        } else {
            void var2_2;
            var2_2.executor().execute(new Runnable(this, promise){
                final /* synthetic */ ChannelPromise val$promise;
                final /* synthetic */ SslHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = channelPromise;
                }

                @Override
                public void run() {
                    SslHandler.access$500(this.this$0, this.val$promise);
                }
            });
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void closeOutbound0(ChannelPromise promise) {
        this.setState(32);
        this.engine.closeOutbound();
        try {
            SslHandler sslHandler = this;
            sslHandler.flush(sslHandler.ctx, promise);
            return;
        }
        catch (Exception e) {
            void var1_1;
            if (!var1_1.tryFailure((Throwable)e)) {
                void var2_2;
                logger.warn("{} flush() raised a masked exception.", (Object)this.ctx.channel(), (Object)var2_2);
            }
            return;
        }
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslClosePromise;
    }

    /*
     * WARNING - void declaration
     */
    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        try {
            if (this.pendingUnencryptedWrites != null && !this.pendingUnencryptedWrites.isEmpty()) {
                this.pendingUnencryptedWrites.releaseAndFailAll((ChannelOutboundInvoker)ctx, (Throwable)new ChannelException("Pending write on removal of SslHandler"));
            }
            this.pendingUnencryptedWrites = null;
            SSLException cause = null;
            if (!this.handshakePromise.isDone() && this.handshakePromise.tryFailure((Throwable)(cause = new SSLHandshakeException("SslHandler removed before handshake completed")))) {
                void var1_1;
                var1_1.fireUserEventTriggered((Object)new SslHandshakeCompletionEvent(cause));
            }
            if (!this.sslClosePromise.isDone()) {
                void var2_3;
                if (cause == null) {
                    cause = new SSLException("SslHandler removed before SSLEngine was closed");
                }
                this.notifyClosePromise((Throwable)var2_3);
            }
            return;
        }
        finally {
            ReferenceCountUtil.release((Object)this.engine);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.deregister((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        this.closeOutboundAndChannel((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        void var1_1;
        this.closeOutboundAndChannel((ChannelHandlerContext)var1_1, (ChannelPromise)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public void read(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (!this.handshakePromise.isDone()) {
            this.setState(4);
        }
        var1_1.read();
    }

    private static IllegalStateException newPendingWritesNullException() {
        return new IllegalStateException("pendingUnencryptedWrites is null, handlerRemoved0 called?");
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        if (!(msg instanceof ByteBuf)) {
            void var1_1;
            UnsupportedMessageTypeException exception = new UnsupportedMessageTypeException(msg, new Class[]{ByteBuf.class});
            ReferenceCountUtil.safeRelease((Object)msg);
            promise.setFailure((Throwable)var1_1);
            return;
        }
        if (this.pendingUnencryptedWrites == null) {
            ReferenceCountUtil.safeRelease((Object)msg);
            promise.setFailure((Throwable)SslHandler.newPendingWritesNullException());
            return;
        }
        this.pendingUnencryptedWrites.add((ByteBuf)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.startTls && !this.isStateSet(1)) {
            this.setState(1);
            this.pendingUnencryptedWrites.writeAndRemoveAll(ctx);
            this.forceFlush(ctx);
            this.startHandshakeProcessing(true);
            return;
        }
        if (this.isStateSet(128)) {
            return;
        }
        try {
            this.wrapAndFlush(ctx);
            return;
        }
        catch (Throwable cause) {
            void var2_2;
            void var1_1;
            this.setHandshakeFailure((ChannelHandlerContext)var1_1, cause);
            PlatformDependent.throwException((Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void wrapAndFlush(ChannelHandlerContext ctx) throws SSLException {
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, ctx.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.setState(2);
        }
        try {
            this.wrap(ctx, false);
            this.forceFlush(ctx);
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.forceFlush((ChannelHandlerContext)var1_1);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private void wrap(ChannelHandlerContext ctx, boolean inUnwrap) throws SSLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean wrapNonAppData(ChannelHandlerContext ctx, boolean inUnwrap) throws SSLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SSLEngineResult wrapMultiple(ByteBufAllocator alloc, SSLEngine engine, ByteBuf in, ByteBuf out) throws SSLException {
        SSLEngineResult result = null;
        do {
            ByteBuf wrapBuf;
            int nextSliceSize;
            int nextOutSize;
            if (!out.isWritable(nextOutSize = this.engineType.calculateRequiredOutBufSpace(this, nextSliceSize = Math.min(16384, in.readableBytes()), in.nioBufferCount()))) {
                if (result != null) break;
                out.ensureWritable(nextOutSize);
            }
            if ((result = this.wrap(alloc, engine, wrapBuf = in.readSlice(nextSliceSize), out)).getStatus() == SSLEngineResult.Status.CLOSED) break;
            if (!wrapBuf.isReadable()) continue;
            ByteBuf byteBuf = in;
            byteBuf.readerIndex(byteBuf.readerIndex() - wrapBuf.readableBytes());
        } while (in.readableBytes() > 0);
        return result;
    }

    private SSLEngineResult wrap(ByteBufAllocator alloc, SSLEngine engine, ByteBuf in, ByteBuf out) throws SSLException {
        ByteBuf newDirectIn = null;
        try {
            SSLEngineResult result;
            ByteBuffer[] in0;
            int readerIndex = in.readerIndex();
            int readableBytes = in.readableBytes();
            if (in.isDirect() || !this.engineType.wantsDirectBuffer) {
                if (!(in instanceof CompositeByteBuf) && in.nioBufferCount() == 1) {
                    in0 = this.singleBuffer;
                    this.singleBuffer[0] = in.internalNioBuffer(readerIndex, readableBytes);
                } else {
                    in0 = in.nioBuffers();
                }
            } else {
                newDirectIn = in0.directBuffer(readableBytes);
                newDirectIn.writeBytes(in, readerIndex, readableBytes);
                in0 = this.singleBuffer;
                ByteBuf byteBuf = newDirectIn;
                this.singleBuffer[0] = byteBuf.internalNioBuffer(byteBuf.readerIndex(), readableBytes);
            }
            while (true) {
                ByteBuf byteBuf = out;
                ByteBuffer out0 = SslHandler.toByteBuffer(byteBuf, byteBuf.writerIndex(), out.writableBytes());
                result = engine.wrap(in0, out0);
                in.skipBytes(result.bytesConsumed());
                ByteBuf byteBuf2 = out;
                byteBuf2.writerIndex(byteBuf2.writerIndex() + result.bytesProduced());
                if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                out.ensureWritable(engine.getSession().getPacketBufferSize());
            }
            SSLEngineResult sSLEngineResult = result;
            return sSLEngineResult;
        }
        finally {
            this.singleBuffer[0] = null;
            if (newDirectIn != null) {
                newDirectIn.release();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        void var3_4;
        boolean handshakeFailed = this.handshakePromise.cause() != null;
        ClosedChannelException exception = new ClosedChannelException();
        if (this.isStateSet(8) && !this.handshakePromise.isDone()) {
            ThrowableUtil.addSuppressed((Throwable)exception, (Throwable)StacklessSSLHandshakeException.newInstance("Connection closed while SSL/TLS handshake was in progress", SslHandler.class, "channelInactive"));
        }
        this.setHandshakeFailure(ctx, exception, !this.isStateSet(32), this.isStateSet(8), false);
        this.notifyClosePromise((Throwable)var3_4);
        try {
            super.channelInactive(ctx);
            return;
        }
        catch (DecoderException e) {
            void var2_3;
            if (var2_3 == false || !(e.getCause() instanceof SSLException)) {
                void var1_2;
                throw var1_2;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.ignoreException(cause)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)ctx.channel(), (Object)cause);
            }
            if (ctx.channel().isActive()) {
                ctx.close();
                return;
            }
        } else {
            void var2_2;
            void var1_1;
            var1_1.fireExceptionCaught((Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean ignoreException(Throwable t) {
        if (!(t instanceof SSLException) && t instanceof IOException && this.sslClosePromise.isDone()) {
            StackTraceElement[] stackTraceElementArray;
            void var2_2;
            String message = t.getMessage();
            if (message != null && IGNORABLE_ERROR_MESSAGE.matcher((CharSequence)var2_2).matches()) {
                return true;
            }
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray.getStackTrace();
            stackTraceElementArray = stackTraceElementArray2;
            stackTraceElementArray = stackTraceElementArray2;
            int n = stackTraceElementArray2.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element = stackTraceElementArray[i];
                String classname = element.getClassName();
                String methodname = element.getMethodName();
                if (classname.startsWith("io.netty.") || !"read".equals(methodname)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = PlatformDependent.getClassLoader(((Object)((Object)this)).getClass()).loadClass(classname);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                    continue;
                }
                catch (Throwable cause) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Unexpected exception while loading class {} classname {}", new Object[]{((Object)((Object)this)).getClass(), classname, cause});
                }
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isEncrypted(ByteBuf buffer) {
        return SslHandler.isEncrypted(buffer, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEncrypted(ByteBuf buffer, boolean probeSSLv2) {
        void var1_1;
        ByteBuf byteBuf;
        if (buffer.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        ByteBuf byteBuf2 = byteBuf;
        return SslUtils.getEncryptedPacketLength(byteBuf2, byteBuf2.readerIndex(), (boolean)var1_1) != -2;
    }

    /*
     * WARNING - void declaration
     */
    private void decodeJdkCompatible(ChannelHandlerContext ctx, ByteBuf in) throws NotSslRecordException {
        void var3_3;
        int packetLength = this.packetLength;
        if (packetLength > 0) {
            if (in.readableBytes() < packetLength) {
                return;
            }
        } else {
            int readableBytes = in.readableBytes();
            if (readableBytes < 5) {
                return;
            }
            ByteBuf byteBuf = in;
            packetLength = SslUtils.getEncryptedPacketLength(byteBuf, byteBuf.readerIndex(), true);
            if (packetLength == -2) {
                void var3_4;
                NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump((ByteBuf)in));
                ByteBuf byteBuf2 = in;
                byteBuf2.skipBytes(byteBuf2.readableBytes());
                this.setHandshakeFailure(ctx, e);
                throw var3_4;
            }
            if (var3_3 == -1) {
                return;
            }
            assert (var3_3 > 0);
            if (var3_3 > readableBytes) {
                this.packetLength = var3_3;
                return;
            }
        }
        this.packetLength = 0;
        try {
            void var2_2;
            int bytesConsumed = this.unwrap(ctx, (ByteBuf)var2_2, (int)var3_3);
            assert (bytesConsumed == var3_3 || this.engine.isInboundDone()) : "we feed the SSLEngine a packets worth of data: " + (int)var3_3 + " but it only consumed: " + bytesConsumed;
            return;
        }
        catch (Throwable cause) {
            void var1_1;
            this.handleUnwrapThrowable((ChannelHandlerContext)var1_1, cause);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void decodeNonJdkCompatible(ChannelHandlerContext ctx, ByteBuf in) {
        try {
            ByteBuf byteBuf = in;
            this.unwrap(ctx, byteBuf, byteBuf.readableBytes());
            return;
        }
        catch (Throwable cause) {
            void var2_3;
            void var1_1;
            this.handleUnwrapThrowable((ChannelHandlerContext)var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleUnwrapThrowable(ChannelHandlerContext ctx, Throwable cause) {
        void var2_2;
        try {
            if (this.handshakePromise.tryFailure(cause)) {
                ctx.fireUserEventTriggered((Object)new SslHandshakeCompletionEvent(cause));
            }
            if (this.pendingUnencryptedWrites != null) {
                this.wrapAndFlush(ctx);
            }
            this.setHandshakeFailure(ctx, cause, true, false, true);
        }
        catch (SSLException ex) {
            try {
                void var3_3;
                logger.debug("SSLException during trying to call SSLEngine.wrap(...) because of an previous SSLException, ignoring...", (Throwable)var3_3);
                this.setHandshakeFailure(ctx, cause, true, false, true);
            }
            catch (Throwable throwable) {
                void var1_1;
                this.setHandshakeFailure((ChannelHandlerContext)var1_1, cause, true, false, true);
                throw throwable;
            }
        }
        PlatformDependent.throwException((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws SSLException {
        void var2_2;
        void var1_1;
        if (this.isStateSet(128)) {
            return;
        }
        if (this.jdkCompatibilityMode) {
            this.decodeJdkCompatible(ctx, in);
            return;
        }
        this.decodeNonJdkCompatible((ChannelHandlerContext)var1_1, (ByteBuf)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.channelReadComplete0((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void channelReadComplete0(ChannelHandlerContext ctx) {
        void var1_1;
        this.discardSomeReadBytes();
        this.flushIfNeeded(ctx);
        this.readIfNeeded(ctx);
        this.clearState(256);
        var1_1.fireChannelReadComplete();
    }

    /*
     * WARNING - void declaration
     */
    private void readIfNeeded(ChannelHandlerContext ctx) {
        if (!(ctx.channel().config().isAutoRead() || this.isStateSet(256) && this.handshakePromise.isDone())) {
            void var1_1;
            var1_1.read();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void flushIfNeeded(ChannelHandlerContext ctx) {
        if (this.isStateSet(16)) {
            void var1_1;
            this.forceFlush((ChannelHandlerContext)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int unwrapNonAppData(ChannelHandlerContext ctx) throws SSLException {
        void var1_1;
        return this.unwrap((ChannelHandlerContext)var1_1, Unpooled.EMPTY_BUFFER, 0);
    }

    /*
     * WARNING - void declaration
     */
    private int unwrap(ChannelHandlerContext ctx, ByteBuf packet, int length) throws SSLException {
        void var3_4;
        boolean executedRead;
        boolean notifyClosure;
        int originalLength;
        block24: {
            originalLength = length;
            boolean wrapLater = false;
            notifyClosure = false;
            executedRead = false;
            ByteBuf decodeOut = this.allocate(ctx, length);
            try {
                do {
                    SSLEngineResult result = this.engineType.unwrap(this, packet, length, decodeOut);
                    SSLEngineResult.Status status = result.getStatus();
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    int produced = result.bytesProduced();
                    int consumed = result.bytesConsumed();
                    packet.skipBytes(consumed);
                    length -= consumed;
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        wrapLater |= (!decodeOut.isReadable() ? this.setHandshakeSuccess() : this.setHandshakeSuccessUnwrapMarkReentry()) || handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED;
                    }
                    if (decodeOut.isReadable()) {
                        this.setState(256);
                        if (this.isStateSet(512)) {
                            executedRead = true;
                            this.executeChannelRead(ctx, decodeOut);
                        } else {
                            ctx.fireChannelRead((Object)decodeOut);
                        }
                        decodeOut = null;
                    }
                    if (status == SSLEngineResult.Status.CLOSED) {
                        notifyClosure = true;
                    } else if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        int applicationBufferSize;
                        if (decodeOut != null) {
                            decodeOut.release();
                        }
                        decodeOut = this.allocate(ctx, this.engineType.calculatePendingData(this, (applicationBufferSize = this.engine.getSession().getApplicationBufferSize()) < produced ? applicationBufferSize : applicationBufferSize - produced));
                        continue;
                    }
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        boolean bl = this.runDelegatedTasks(true);
                        if (!bl) {
                            wrapLater = false;
                            break;
                        }
                    } else if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && this.wrapNonAppData(ctx, true) && length == 0) break;
                    if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW || handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && (consumed == 0 && produced == 0 || length == 0 && handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
                        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                        this.readIfNeeded(ctx);
                        break;
                    }
                    if (decodeOut != null) continue;
                    decodeOut = this.allocate(ctx, length);
                } while (!ctx.isRemoved());
                if (this.isStateSet(2) && this.handshakePromise.isDone()) {
                    this.clearState(2);
                    wrapLater = true;
                }
                if (wrapLater) {
                    this.wrap(ctx, true);
                }
                if (decodeOut == null) break block24;
            }
            catch (Throwable throwable) {
                if (decodeOut != null) {
                    decodeOut.release();
                }
                if (notifyClosure) {
                    if (executedRead) {
                        void var1_1;
                        this.executeNotifyClosePromise((ChannelHandlerContext)var1_1);
                    } else {
                        this.notifyClosePromise(null);
                    }
                }
                throw throwable;
            }
            decodeOut.release();
        }
        if (notifyClosure) {
            if (executedRead) {
                this.executeNotifyClosePromise(ctx);
            } else {
                this.notifyClosePromise(null);
            }
        }
        return originalLength - var3_4;
    }

    private boolean setHandshakeSuccessUnwrapMarkReentry() throws SSLException {
        boolean setReentryState = !this.isStateSet(512);
        if (setReentryState) {
            this.setState(512);
        }
        try {
            boolean bl = this.setHandshakeSuccess();
            return bl;
        }
        finally {
            if (setReentryState) {
                this.clearState(512);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeNotifyClosePromise(ChannelHandlerContext ctx) {
        try {
            ctx.executor().execute(new Runnable(this){
                final /* synthetic */ SslHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void run() {
                    SslHandler.access$700(this.this$0, null);
                }
            });
            return;
        }
        catch (RejectedExecutionException e) {
            void var1_2;
            this.notifyClosePromise((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeChannelRead(ChannelHandlerContext ctx, ByteBuf decodedOut) {
        try {
            ctx.executor().execute(new Runnable(this, ctx, decodedOut){
                final /* synthetic */ ChannelHandlerContext val$ctx;
                final /* synthetic */ ByteBuf val$decodedOut;
                final /* synthetic */ SslHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$ctx = channelHandlerContext;
                    this.val$decodedOut = byteBuf;
                }

                @Override
                public void run() {
                    this.val$ctx.fireChannelRead((Object)this.val$decodedOut);
                }
            });
            return;
        }
        catch (RejectedExecutionException e) {
            void var1_2;
            void var2_3;
            var2_3.release();
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuffer toByteBuffer(ByteBuf out, int index, int len) {
        void var2_2;
        void var1_1;
        ByteBuf byteBuf;
        if (out.nioBufferCount() == 1) {
            return out.internalNioBuffer(index, len);
        }
        return byteBuf.nioBuffer((int)var1_1, (int)var2_2);
    }

    private static boolean inEventLoop(Executor executor) {
        Executor executor2;
        return executor instanceof EventExecutor && ((EventExecutor)executor2).inEventLoop();
    }

    /*
     * Unable to fully structure code
     */
    private boolean runDelegatedTasks(boolean inUnwrap) {
        block9: {
            if (this.delegatedTaskExecutor != ImmediateExecutor.INSTANCE && !SslHandler.inEventLoop(this.delegatedTaskExecutor)) break block9;
            while (true) lbl-1000:
            // 6 sources

            {
                if ((task = this.engine.getDelegatedTask()) == null) {
                    return true;
                }
                this.setState(128);
                if (task instanceof AsyncRunnable) {
                    pending = false;
                    try {
                        asyncTask = (AsyncRunnable)task;
                        completionHandler = new AsyncTaskCompletionHandler(inUnwrap);
                        var2_4.run(completionHandler);
                        pending = completionHandler.resumeLater();
                        if (!pending) ** GOTO lbl-1000
                        return false;
                    }
                    finally {
                        if (pending) ** GOTO lbl-1000
                        this.clearState(128);
                    }
                    continue;
                }
                try {
                    var2_4.run();
                }
                finally {
                    this.clearState(128);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
        }
        this.executeDelegatedTask((boolean)var1_1);
        return false;
    }

    private SslTasksRunner getTaskRunner(boolean inUnwrap) {
        if (inUnwrap) {
            return this.sslTaskRunnerForUnwrap;
        }
        return this.sslTaskRunner;
    }

    /*
     * WARNING - void declaration
     */
    private void executeDelegatedTask(boolean inUnwrap) {
        void var1_1;
        SslHandler sslHandler = this;
        sslHandler.executeDelegatedTask(sslHandler.getTaskRunner((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void executeDelegatedTask(SslTasksRunner task) {
        this.setState(128);
        try {
            this.delegatedTaskExecutor.execute(task);
            return;
        }
        catch (RejectedExecutionException e) {
            void var1_2;
            this.clearState(128);
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean setHandshakeSuccess() throws SSLException {
        void var2_3;
        boolean notified;
        void var1_1;
        SSLSession session = this.engine.getSession();
        if (this.resumptionController != null && !this.handshakePromise.isDone()) {
            try {
                if (this.resumptionController.validateResumeIfNeeded(this.engine) && logger.isDebugEnabled()) {
                    logger.debug("{} Resumed and reauthenticated session", (Object)this.ctx.channel());
                }
            }
            catch (CertificateException e) {
                SSLHandshakeException exception = new SSLHandshakeException(e.getMessage());
                exception.initCause(e);
                throw var1_1;
            }
        }
        if (notified = !this.handshakePromise.isDone() && this.handshakePromise.trySuccess((Object)this.ctx.channel())) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} HANDSHAKEN: protocol:{} cipher suite:{}", new Object[]{this.ctx.channel(), var1_1.getProtocol(), var1_1.getCipherSuite()});
            }
            this.ctx.fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
        }
        if (this.isStateSet(4)) {
            this.clearState(4);
            if (!this.ctx.channel().config().isAutoRead()) {
                this.ctx.read();
            }
        }
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private void setHandshakeFailure(ChannelHandlerContext ctx, Throwable cause) {
        void var2_2;
        void var1_1;
        this.setHandshakeFailure((ChannelHandlerContext)var1_1, (Throwable)var2_2, true, true, false);
    }

    /*
     * WARNING - void declaration
     */
    private void setHandshakeFailure(ChannelHandlerContext ctx, Throwable cause, boolean closeInbound, boolean notify, boolean alwaysFlushAndClose) {
        try {
            block6: {
                this.setState(32);
                this.engine.closeOutbound();
                if (closeInbound) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException e) {
                        void var3_4;
                        String msg;
                        if (!logger.isDebugEnabled() || (msg = e.getMessage()) != null && (msg.contains("possible truncation attack") || msg.contains("closing inbound before receiving peer's close_notify"))) break block6;
                        logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)ctx.channel(), (Object)var3_4);
                    }
                }
            }
            if (this.handshakePromise.tryFailure(cause) || alwaysFlushAndClose) {
                SslUtils.handleHandshakeFailure(ctx, cause, notify);
            }
            this.releaseAndFailAll(ctx, cause);
            return;
        }
        catch (Throwable throwable) {
            void var2_2;
            void var1_1;
            this.releaseAndFailAll((ChannelHandlerContext)var1_1, (Throwable)var2_2);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setHandshakeFailureTransportFailure(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                void var2_2;
                SSLException transportFailure = new SSLException("failure when writing TLS control frames", cause);
                this.releaseAndFailAll(ctx, transportFailure);
                if (!this.handshakePromise.tryFailure((Throwable)transportFailure)) break block2;
                ctx.fireUserEventTriggered((Object)new SslHandshakeCompletionEvent((Throwable)var2_2));
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        ctx.close();
    }

    /*
     * WARNING - void declaration
     */
    private void releaseAndFailAll(ChannelHandlerContext ctx, Throwable cause) {
        if (this.resumptionController != null && (!this.engine.getSession().isValid() || cause instanceof SSLHandshakeException)) {
            this.resumptionController.remove(this.engine());
        }
        if (this.pendingUnencryptedWrites != null) {
            void var2_2;
            void var1_1;
            this.pendingUnencryptedWrites.releaseAndFailAll((ChannelOutboundInvoker)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyClosePromise(Throwable cause) {
        if (cause == null) {
            if (this.sslClosePromise.trySuccess(this.ctx.channel())) {
                this.ctx.fireUserEventTriggered((Object)SslCloseCompletionEvent.SUCCESS);
                return;
            }
        } else if (this.sslClosePromise.tryFailure(cause)) {
            void var1_1;
            this.ctx.fireUserEventTriggered((Object)new SslCloseCompletionEvent((Throwable)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closeOutboundAndChannel(ChannelHandlerContext ctx, ChannelPromise promise, boolean disconnect) throws Exception {
        block6: {
            this.setState(32);
            this.engine.closeOutbound();
            if (!ctx.channel().isActive()) {
                if (disconnect) {
                    ctx.disconnect(promise);
                    return;
                }
                ctx.close(promise);
                return;
            }
            ChannelPromise closeNotifyPromise = ctx.newPromise();
            try {
                this.flush(ctx, closeNotifyPromise);
                if (this.isStateSet(64)) break block6;
                this.setState(64);
                this.safeClose(ctx, (ChannelFuture)closeNotifyPromise, (ChannelPromise)PromiseNotifier.cascade((boolean)false, (Future)ctx.newPromise(), (Promise)promise));
                return;
            }
            catch (Throwable throwable) {
                if (!this.isStateSet(64)) {
                    void var1_1;
                    void var3_4;
                    this.setState(64);
                    this.safeClose(ctx, (ChannelFuture)var3_4, (ChannelPromise)PromiseNotifier.cascade((boolean)false, (Future)var1_1.newPromise(), (Promise)promise));
                } else {
                    void var2_2;
                    this.sslClosePromise.addListener((GenericFutureListener)new FutureListener<Channel>(this, (ChannelPromise)var2_2){
                        final /* synthetic */ ChannelPromise val$promise;
                        final /* synthetic */ SslHandler this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$promise = channelPromise;
                        }

                        public void operationComplete(Future<Channel> future) {
                            this.val$promise.setSuccess();
                        }
                    });
                }
                throw throwable;
            }
        }
        this.sslClosePromise.addListener((GenericFutureListener)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    private void flush(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var1_1;
        if (this.pendingUnencryptedWrites != null) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, promise);
        } else {
            void var2_2;
            var2_2.setFailure((Throwable)SslHandler.newPendingWritesNullException());
        }
        this.flush((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        Channel channel = ctx.channel();
        this.pendingUnencryptedWrites = new SslHandlerCoalescingBufferQueue(this, channel, 16, this.engineType.wantsDirectBuffer){
            final /* synthetic */ SslHandler this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Channel)var2_2, (int)var3_3, wantsDirectBuffer);
            }

            @Override
            protected int wrapDataSize() {
                return this.this$0.wrapDataSize;
            }
        };
        this.setOpensslEngineSocketFd(channel);
        boolean fastOpen = Boolean.TRUE.equals(channel.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT));
        boolean active = channel.isActive();
        if (active || fastOpen) {
            void var1_1;
            ChannelOutboundBuffer outboundBuffer;
            void var2_2;
            void var3_3;
            this.startHandshakeProcessing((boolean)var3_3);
            if (var2_2 != false && ((outboundBuffer = channel.unsafe().outboundBuffer()) == null || var1_1.totalPendingWriteBytes() > 0L)) {
                this.setState(16);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startHandshakeProcessing(boolean flushAtEnd) {
        if (!this.isStateSet(8)) {
            this.setState(8);
            if (this.engine.getUseClientMode()) {
                void var1_1;
                this.handshake((boolean)var1_1);
            }
            this.applyHandshakeTimeout();
            return;
        }
        if (this.isStateSet(16)) {
            SslHandler sslHandler = this;
            sslHandler.forceFlush(sslHandler.ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Future<Channel> renegotiate() {
        void var1_1;
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException();
        }
        return this.renegotiate((Promise<Channel>)var1_1.executor().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    public Future<Channel> renegotiate(Promise<Channel> promise) {
        void var1_1;
        ObjectUtil.checkNotNull(promise, (String)"promise");
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException();
        }
        EventExecutor executor = ctx.executor();
        if (!executor.inEventLoop()) {
            void var2_2;
            var2_2.execute(new Runnable(this, promise){
                final /* synthetic */ Promise val$promise;
                final /* synthetic */ SslHandler this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$promise = promise;
                }

                @Override
                public void run() {
                    SslHandler.access$2200(this.this$0, this.val$promise);
                }
            });
            return promise;
        }
        this.renegotiateOnEventLoop(promise);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void renegotiateOnEventLoop(Promise<Channel> newHandshakePromise) {
        void var1_1;
        Promise<Channel> oldHandshakePromise = this.handshakePromise;
        if (!oldHandshakePromise.isDone()) {
            void var2_2;
            PromiseNotifier.cascade((Future)var2_2, newHandshakePromise);
            return;
        }
        this.handshakePromise = var1_1;
        this.handshake(true);
        this.applyHandshakeTimeout();
    }

    /*
     * WARNING - void declaration
     */
    private void handshake(boolean flushAtEnd) {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return;
        }
        if (this.handshakePromise.isDone()) {
            return;
        }
        ChannelHandlerContext ctx = this.ctx;
        try {
            this.engine.beginHandshake();
            this.wrapNonAppData(ctx, false);
            if (flushAtEnd) {
                this.forceFlush(ctx);
                return;
            }
        }
        catch (Throwable e) {
            try {
                void var3_3;
                this.setHandshakeFailure(ctx, (Throwable)var3_3);
                if (flushAtEnd) {
                    this.forceFlush(ctx);
                    return;
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                if (var1_1 != false) {
                    void var2_2;
                    this.forceFlush((ChannelHandlerContext)var2_2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyHandshakeTimeout() {
        void var2_3;
        void var1_1;
        Promise<Channel> localHandshakePromise = this.handshakePromise;
        long handshakeTimeoutMillis = this.handshakeTimeoutMillis;
        if (handshakeTimeoutMillis <= 0L || localHandshakePromise.isDone()) {
            return;
        }
        ScheduledFuture timeoutFuture = this.ctx.executor().schedule(new Runnable(this, localHandshakePromise, handshakeTimeoutMillis){
            final /* synthetic */ Promise val$localHandshakePromise;
            final /* synthetic */ long val$handshakeTimeoutMillis;
            final /* synthetic */ SslHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$localHandshakePromise = promise;
                this.val$handshakeTimeoutMillis = l;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                SslHandshakeTimeoutException exception;
                block3: {
                    if (this.val$localHandshakePromise.isDone()) {
                        return;
                    }
                    exception = new SslHandshakeTimeoutException("handshake timed out after " + this.val$handshakeTimeoutMillis + "ms");
                    try {
                        if (!this.val$localHandshakePromise.tryFailure((Throwable)exception)) break block3;
                        SslUtils.handleHandshakeFailure(this.this$0.ctx, exception, true);
                    }
                    catch (Throwable throwable) {
                        void var1_1;
                        SslHandler.access$2300(this.this$0, this.this$0.ctx, (Throwable)var1_1);
                        throw throwable;
                    }
                }
                SslHandler.access$2300(this.this$0, this.this$0.ctx, exception);
            }
        }, handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        var1_1.addListener((GenericFutureListener)new FutureListener<Channel>(this, (Future)var2_3){
            final /* synthetic */ Future val$timeoutFuture;
            final /* synthetic */ SslHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$timeoutFuture = future;
            }

            public void operationComplete(Future<Channel> f) throws Exception {
                this.val$timeoutFuture.cancel(false);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void forceFlush(ChannelHandlerContext ctx) {
        void var1_1;
        this.clearState(16);
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void setOpensslEngineSocketFd(Channel c) {
        if (c instanceof UnixChannel && this.engine instanceof ReferenceCountedOpenSslEngine) {
            void var1_1;
            ((ReferenceCountedOpenSslEngine)this.engine).bioSetFd(((UnixChannel)var1_1).fd().intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.setOpensslEngineSocketFd(ctx.channel());
        if (!this.startTls) {
            this.startHandshakeProcessing(true);
        }
        var1_1.fireChannelActive();
    }

    /*
     * WARNING - void declaration
     */
    private void safeClose(ChannelHandlerContext ctx, ChannelFuture flushFuture, ChannelPromise promise) {
        void var3_3;
        void var1_1;
        void var2_2;
        long closeNotifyTimeout;
        if (!ctx.channel().isActive()) {
            ctx.close(promise);
            return;
        }
        ScheduledFuture timeoutFuture = !flushFuture.isDone() ? ((closeNotifyTimeout = this.closeNotifyFlushTimeoutMillis) > 0L ? ctx.executor().schedule(new Runnable(this, flushFuture, ctx, promise){
            final /* synthetic */ ChannelFuture val$flushFuture;
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ SslHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$flushFuture = channelFuture;
                this.val$ctx = channelHandlerContext;
                this.val$promise = channelPromise;
            }

            @Override
            public void run() {
                if (!this.val$flushFuture.isDone()) {
                    logger.warn("{} Last write attempt timed out; force-closing the connection.", (Object)this.val$ctx.channel());
                    SslHandler.access$2500(this.val$ctx.close(this.val$ctx.newPromise()), this.val$promise);
                }
            }
        }, closeNotifyTimeout, TimeUnit.MILLISECONDS) : null) : null;
        var2_2.addListener((GenericFutureListener)new ChannelFutureListener(this, (Future)timeoutFuture, (ChannelHandlerContext)var1_1, (ChannelPromise)var3_3){
            final /* synthetic */ Future val$timeoutFuture;
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ ChannelPromise val$promise;
            final /* synthetic */ SslHandler this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$timeoutFuture = future;
                this.val$ctx = channelHandlerContext;
                this.val$promise = channelPromise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(ChannelFuture f) {
                void var1_1;
                void var2_2;
                long closeNotifyReadTimeout;
                if (this.val$timeoutFuture != null) {
                    this.val$timeoutFuture.cancel(false);
                }
                if ((closeNotifyReadTimeout = this.this$0.closeNotifyReadTimeoutMillis) <= 0L) {
                    SslHandler.access$2500(this.val$ctx.close(this.val$ctx.newPromise()), this.val$promise);
                    return;
                }
                ScheduledFuture closeNotifyReadTimeoutFuture = !this.this$0.sslClosePromise.isDone() ? this.val$ctx.executor().schedule(new Runnable(this, closeNotifyReadTimeout){
                    final /* synthetic */ long val$closeNotifyReadTimeout;
                    final /* synthetic */ 11 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$closeNotifyReadTimeout = l;
                    }

                    @Override
                    public void run() {
                        if (!this.this$1.this$0.sslClosePromise.isDone()) {
                            logger.debug("{} did not receive close_notify in {}ms; force-closing the connection.", (Object)this.this$1.val$ctx.channel(), (Object)this.val$closeNotifyReadTimeout);
                            SslHandler.access$2500(this.this$1.val$ctx.close(this.this$1.val$ctx.newPromise()), this.this$1.val$promise);
                        }
                    }
                }, (long)var2_2, TimeUnit.MILLISECONDS) : null;
                this.this$0.sslClosePromise.addListener((GenericFutureListener)new FutureListener<Channel>(this, (Future)var1_1){
                    final /* synthetic */ Future val$closeNotifyReadTimeoutFuture;
                    final /* synthetic */ 11 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$closeNotifyReadTimeoutFuture = future;
                    }

                    public void operationComplete(Future<Channel> future) throws Exception {
                        if (this.val$closeNotifyReadTimeoutFuture != null) {
                            this.val$closeNotifyReadTimeoutFuture.cancel(false);
                        }
                        SslHandler.access$2500(this.this$1.val$ctx.close(this.this$1.val$ctx.newPromise()), this.this$1.val$promise);
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void addCloseListener(ChannelFuture future, ChannelPromise promise) {
        void var1_1;
        ChannelFuture channelFuture;
        PromiseNotifier.cascade((boolean)false, (Future)channelFuture, (Promise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf allocate(ChannelHandlerContext ctx, int capacity) {
        void var2_2;
        void var1_1;
        ByteBufAllocator alloc = ctx.alloc();
        if (this.engineType.wantsDirectBuffer) {
            return alloc.directBuffer(capacity);
        }
        return var1_1.buffer((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf allocateOutNetBuf(ChannelHandlerContext ctx, int pendingBytes, int numComponents) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.engineType.allocateWrapBuffer(this, var1_1.alloc(), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isStateSet(int bit) {
        void var1_1;
        return (this.state & bit) == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setState(int bit) {
        void var1_1;
        this.state = (short)(this.state | var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void clearState(int bit) {
        void var1_1;
        this.state = (short)(this.state & ~var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ByteBuffer access$300(ByteBuf x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return SslHandler.toByteBuffer(x0, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(SslHandler x0, ChannelPromise x1) {
        void var1_1;
        x0.closeOutbound0((ChannelPromise)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(SslHandler x0, ChannelHandlerContext x1, Throwable x2) {
        void var2_2;
        void var1_1;
        x0.setHandshakeFailureTransportFailure((ChannelHandlerContext)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(SslHandler x0, Throwable x1) {
        void var1_1;
        x0.notifyClosePromise((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SslTasksRunner access$800(SslHandler x0, boolean x1) {
        void var1_1;
        return x0.getTaskRunner((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(SslHandler x0, ChannelHandlerContext x1, Throwable x2) {
        void var2_2;
        void var1_1;
        x0.handleUnwrapThrowable((ChannelHandlerContext)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1100(SslHandler x0, ChannelHandlerContext x1, Throwable x2) {
        void var2_2;
        void var1_1;
        x0.setHandshakeFailure((ChannelHandlerContext)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1200(SslHandler x0, ChannelHandlerContext x1) {
        void var1_1;
        x0.forceFlush((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1300(SslHandler x0, ChannelHandlerContext x1) {
        void var1_1;
        x0.channelReadComplete0((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1400(SslHandler x0, int x1) {
        void var1_1;
        x0.clearState((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1500(SslHandler x0, SslTasksRunner x1) {
        void var1_1;
        x0.executeDelegatedTask((SslTasksRunner)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1700(SslHandler x0, ChannelHandlerContext x1, boolean x2) throws SSLException {
        void var2_2;
        void var1_1;
        x0.wrap((ChannelHandlerContext)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1800(SslHandler x0, ChannelHandlerContext x1) throws SSLException {
        void var1_1;
        return x0.unwrapNonAppData((ChannelHandlerContext)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1900(SslHandler x0, ChannelHandlerContext x1, boolean x2) throws SSLException {
        void var2_2;
        void var1_1;
        return x0.wrapNonAppData((ChannelHandlerContext)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$2200(SslHandler x0, Promise x1) {
        void var1_1;
        x0.renegotiateOnEventLoop((Promise<Channel>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$2300(SslHandler x0, ChannelHandlerContext x1, Throwable x2) {
        void var2_2;
        void var1_1;
        x0.releaseAndFailAll((ChannelHandlerContext)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$2500(ChannelFuture x0, ChannelPromise x1) {
        void var1_1;
        SslHandler.addCloseListener(x0, (ChannelPromise)var1_1);
    }

    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        protected final EventExecutor executor() {
            if (SslHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return SslHandler.this.ctx.executor();
        }

        protected final void checkDeadLock() {
            if (SslHandler.this.ctx == null) {
                return;
            }
            super.checkDeadLock();
        }
    }

    private final class SslTasksRunner
    implements Runnable {
        private final boolean inUnwrap;
        private final Runnable runCompleteTask = new Runnable(this){
            final /* synthetic */ SslTasksRunner this$1;
            {
                void var1_1;
                this.this$1 = var1_1;
            }

            @Override
            public void run() {
                this.this$1.runComplete();
            }
        };

        /*
         * WARNING - void declaration
         */
        SslTasksRunner(boolean inUnwrap) {
            void var2_2;
            this.inUnwrap = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private void taskError(Throwable e) {
            void var1_1;
            if (this.inUnwrap) {
                try {
                    SslHandler.access$1000(SslHandler.this, SslHandler.this.ctx, e);
                    return;
                }
                catch (Throwable cause) {
                    void var1_2;
                    this.safeExceptionCaught((Throwable)var1_2);
                    return;
                }
            }
            SslHandler.access$1100(SslHandler.this, SslHandler.this.ctx, (Throwable)var1_1);
            SslHandler.access$1200(SslHandler.this, SslHandler.this.ctx);
        }

        /*
         * WARNING - void declaration
         */
        private void safeExceptionCaught(Throwable cause) {
            try {
                SslHandler.this.exceptionCaught(SslHandler.this.ctx, this.wrapIfNeeded(cause));
                return;
            }
            catch (Throwable error) {
                void var1_2;
                SslHandler.this.ctx.fireExceptionCaught((Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private Throwable wrapIfNeeded(Throwable cause) {
            void var1_1;
            if (!this.inUnwrap) {
                return cause;
            }
            if (cause instanceof DecoderException) {
                return cause;
            }
            return new DecoderException((Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void tryDecodeAgain() {
            try {
                SslHandler.this.channelRead(SslHandler.this.ctx, Unpooled.EMPTY_BUFFER);
                return;
            }
            catch (Throwable cause) {
                void var1_1;
                this.safeExceptionCaught((Throwable)var1_1);
                return;
            }
            finally {
                SslHandler.access$1300(SslHandler.this, SslHandler.this.ctx);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void resumeOnEventExecutor() {
            assert (SslHandler.this.ctx.executor().inEventLoop());
            SslHandler.access$1400(SslHandler.this, 128);
            try {
                SSLEngineResult.HandshakeStatus status = SslHandler.this.engine.getHandshakeStatus();
                switch (status) {
                    case NEED_TASK: {
                        SslHandler.access$1500(SslHandler.this, this);
                        break;
                    }
                    case FINISHED: 
                    case NOT_HANDSHAKING: {
                        SslHandler.this.setHandshakeSuccess();
                        try {
                            SslHandler.access$1700(SslHandler.this, SslHandler.this.ctx, this.inUnwrap);
                        }
                        catch (Throwable e) {
                            this.taskError(e);
                            return;
                        }
                        if (this.inUnwrap) {
                            SslHandler.access$1800(SslHandler.this, SslHandler.this.ctx);
                        }
                        SslHandler.access$1200(SslHandler.this, SslHandler.this.ctx);
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_UNWRAP: {
                        try {
                            SslHandler.access$1800(SslHandler.this, SslHandler.this.ctx);
                        }
                        catch (SSLException e) {
                            SslHandler.access$1000(SslHandler.this, SslHandler.this.ctx, e);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    case NEED_WRAP: {
                        try {
                            if (!SslHandler.access$1900(SslHandler.this, SslHandler.this.ctx, false) && this.inUnwrap) {
                                SslHandler.access$1800(SslHandler.this, SslHandler.this.ctx);
                            }
                            SslHandler.access$1200(SslHandler.this, SslHandler.this.ctx);
                        }
                        catch (Throwable e) {
                            this.taskError(e);
                            return;
                        }
                        this.tryDecodeAgain();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (Throwable cause) {
                void var1_5;
                this.safeExceptionCaught((Throwable)var1_5);
            }
        }

        final void runComplete() {
            EventExecutor eventExecutor = SslHandler.this.ctx.executor();
            eventExecutor.execute(new Runnable(this){
                final /* synthetic */ SslTasksRunner this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                public void run() {
                    this.this$1.resumeOnEventExecutor();
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            try {
                Runnable task = SslHandler.this.engine.getDelegatedTask();
                if (task == null) {
                    return;
                }
                if (!(task instanceof AsyncRunnable)) {
                    task.run();
                    this.runComplete();
                    return;
                }
                task = (AsyncRunnable)task;
                task.run(this.runCompleteTask);
            }
            catch (Throwable cause) {
                void var1_2;
                this.handleException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void handleException(Throwable cause) {
            EventExecutor executor = SslHandler.this.ctx.executor();
            if (executor.inEventLoop()) {
                SslHandler.access$1400(SslHandler.this, 128);
                this.safeExceptionCaught(cause);
                return;
            }
            try {
                void var2_2;
                var2_2.execute(new Runnable(this, cause){
                    final /* synthetic */ Throwable val$cause;
                    final /* synthetic */ SslTasksRunner this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$cause = throwable;
                    }

                    @Override
                    public void run() {
                        SslHandler.access$1400(this.this$1.SslHandler.this, 128);
                        SslTasksRunner.access$2100(this.this$1, this.val$cause);
                    }
                });
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                void var1_1;
                SslHandler.access$1400(SslHandler.this, 128);
                SslHandler.this.ctx.fireExceptionCaught((Throwable)var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$2100(SslTasksRunner x0, Throwable x1) {
            void var1_1;
            x0.safeExceptionCaught((Throwable)var1_1);
        }
    }

    private final class AsyncTaskCompletionHandler
    implements Runnable {
        private final boolean inUnwrap;
        boolean didRun;
        boolean resumeLater;

        /*
         * WARNING - void declaration
         */
        AsyncTaskCompletionHandler(boolean inUnwrap) {
            void var2_2;
            this.inUnwrap = var2_2;
        }

        @Override
        public final void run() {
            this.didRun = true;
            if (this.resumeLater) {
                SslHandler.access$800(SslHandler.this, this.inUnwrap).runComplete();
            }
        }

        final boolean resumeLater() {
            if (!this.didRun) {
                this.resumeLater = true;
                return true;
            }
            return false;
        }
    }

    private static enum SslEngineType {
        TCNATIVE(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final SSLEngineResult unwrap(SslHandler handler, ByteBuf in, int len, ByteBuf out) throws SSLException {
                void var2_2;
                SSLEngineResult result;
                int nioBufferCount = in.nioBufferCount();
                int writerIndex = out.writerIndex();
                if (nioBufferCount > 1) {
                    ReferenceCountedOpenSslEngine opensslEngine = (ReferenceCountedOpenSslEngine)handler.engine;
                    try {
                        ((SslHandler)handler).singleBuffer[0] = SslHandler.access$300(out, writerIndex, out.writableBytes());
                        ByteBuf byteBuf = in;
                        result = opensslEngine.unwrap(byteBuf.nioBuffers(byteBuf.readerIndex(), len), handler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)handler).singleBuffer[0] = null;
                    }
                } else {
                    void var3_4;
                    void var1_1;
                    void v1 = result;
                    result = ((SslHandler)var1_1).engine.unwrap(SslHandler.access$300((ByteBuf)v1, v1.readerIndex(), (int)var3_4), SslHandler.access$300(out, writerIndex, out.writableBytes()));
                }
                out.writerIndex(writerIndex + result.bytesProduced());
                return var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final ByteBuf allocateWrapBuffer(SslHandler handler, ByteBufAllocator allocator, int pendingBytes, int numComponents) {
                void var3_3;
                void var1_1;
                return allocator.directBuffer(((ReferenceCountedOpenSslEngine)((SslHandler)var1_1).engine).calculateOutNetBufSize((int)var3_3, numComponents));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final int calculateRequiredOutBufSpace(SslHandler handler, int pendingBytes, int numComponents) {
                void var3_3;
                void var2_2;
                return ((ReferenceCountedOpenSslEngine)handler.engine).calculateMaxLengthForWrap((int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final int calculatePendingData(SslHandler handler, int guess) {
                void var2_3;
                int sslPending = ((ReferenceCountedOpenSslEngine)handler.engine).sslPending();
                if (sslPending > 0) {
                    void var1_2;
                    return (int)var1_2;
                }
                return (int)var2_3;
            }

            @Override
            final boolean jdkCompatibilityMode(SSLEngine engine) {
                return ((ReferenceCountedOpenSslEngine)engine).jdkCompatibilityMode;
            }
        }
        ,
        CONSCRYPT(true, ByteToMessageDecoder.COMPOSITE_CUMULATOR){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final SSLEngineResult unwrap(SslHandler handler, ByteBuf in, int len, ByteBuf out) throws SSLException {
                void var2_2;
                SSLEngineResult result;
                int nioBufferCount = in.nioBufferCount();
                int writerIndex = out.writerIndex();
                if (nioBufferCount > 1) {
                    try {
                        ((SslHandler)handler).singleBuffer[0] = SslHandler.access$300(out, writerIndex, out.writableBytes());
                        ByteBuf byteBuf = in;
                        result = ((ConscryptAlpnSslEngine)handler.engine).unwrap(byteBuf.nioBuffers(byteBuf.readerIndex(), len), handler.singleBuffer);
                    }
                    finally {
                        ((SslHandler)handler).singleBuffer[0] = null;
                    }
                } else {
                    void var3_4;
                    void var1_1;
                    void v1 = result;
                    result = ((SslHandler)var1_1).engine.unwrap(SslHandler.access$300((ByteBuf)v1, v1.readerIndex(), (int)var3_4), SslHandler.access$300(out, writerIndex, out.writableBytes()));
                }
                out.writerIndex(writerIndex + result.bytesProduced());
                return var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final ByteBuf allocateWrapBuffer(SslHandler handler, ByteBufAllocator allocator, int pendingBytes, int numComponents) {
                void var3_3;
                void var1_1;
                return allocator.directBuffer(((ConscryptAlpnSslEngine)((SslHandler)var1_1).engine).calculateOutNetBufSize((int)var3_3, numComponents));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final int calculateRequiredOutBufSpace(SslHandler handler, int pendingBytes, int numComponents) {
                void var3_3;
                void var2_2;
                return ((ConscryptAlpnSslEngine)handler.engine).calculateRequiredOutBufSpace((int)var2_2, (int)var3_3);
            }

            @Override
            final int calculatePendingData(SslHandler handler, int guess) {
                return guess;
            }

            @Override
            final boolean jdkCompatibilityMode(SSLEngine engine) {
                return true;
            }
        }
        ,
        JDK(false, ByteToMessageDecoder.MERGE_CUMULATOR){
            {
                void var3_3;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final SSLEngineResult unwrap(SslHandler handler, ByteBuf in, int len, ByteBuf out) throws SSLException {
                void var1_1;
                void var3_4;
                int consumed;
                int writerIndex = out.writerIndex();
                ByteBuf byteBuf = in;
                ByteBuffer inNioBuffer = SslHandler.access$300(byteBuf, byteBuf.readerIndex(), len);
                int position = inNioBuffer.position();
                SSLEngineResult result = handler.engine.unwrap(inNioBuffer, SslHandler.access$300(out, writerIndex, out.writableBytes()));
                out.writerIndex(writerIndex + result.bytesProduced());
                if (result.bytesConsumed() == 0 && (consumed = inNioBuffer.position() - var3_4) != result.bytesConsumed()) {
                    void var2_3;
                    return new SSLEngineResult(result.getStatus(), result.getHandshakeStatus(), (int)var2_3, result.bytesProduced());
                }
                return var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final ByteBuf allocateWrapBuffer(SslHandler handler, ByteBufAllocator allocator, int pendingBytes, int numComponents) {
                void var1_1;
                void var3_3;
                return allocator.heapBuffer(Math.max((int)var3_3, ((SslHandler)var1_1).engine.getSession().getPacketBufferSize()));
            }

            @Override
            final int calculateRequiredOutBufSpace(SslHandler handler, int pendingBytes, int numComponents) {
                return handler.engine.getSession().getPacketBufferSize();
            }

            @Override
            final int calculatePendingData(SslHandler handler, int guess) {
                return guess;
            }

            @Override
            final boolean jdkCompatibilityMode(SSLEngine engine) {
                return true;
            }
        };

        final boolean wantsDirectBuffer;
        final ByteToMessageDecoder.Cumulator cumulator;

        static SslEngineType forEngine(SSLEngine engine) {
            SSLEngine sSLEngine;
            if (engine instanceof ReferenceCountedOpenSslEngine) {
                return TCNATIVE;
            }
            if (sSLEngine instanceof ConscryptAlpnSslEngine) {
                return CONSCRYPT;
            }
            return JDK;
        }

        /*
         * WARNING - void declaration
         */
        private SslEngineType(boolean wantsDirectBuffer, ByteToMessageDecoder.Cumulator cumulator) {
            void var3_3;
            this.wantsDirectBuffer = var3_3;
            this.cumulator = cumulator;
        }

        abstract SSLEngineResult unwrap(SslHandler var1, ByteBuf var2, int var3, ByteBuf var4) throws SSLException;

        abstract int calculatePendingData(SslHandler var1, int var2);

        abstract boolean jdkCompatibilityMode(SSLEngine var1);

        abstract ByteBuf allocateWrapBuffer(SslHandler var1, ByteBufAllocator var2, int var3, int var4);

        abstract int calculateRequiredOutBufSpace(SslHandler var1, int var2, int var3);
    }
}

