/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.KeyManagerFactoryWrapper;
import io.netty.handler.ssl.util.TrustManagerFactoryWrapper;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class SslContextBuilder {
    private static final Map.Entry[] EMPTY_ENTRIES = new Map.Entry[0];
    private final boolean forServer;
    private SslProvider provider;
    private Provider sslContextProvider;
    private X509Certificate[] trustCertCollection;
    private TrustManagerFactory trustManagerFactory;
    private X509Certificate[] keyCertChain;
    private PrivateKey key;
    private String keyPassword;
    private KeyManagerFactory keyManagerFactory;
    private Iterable<String> ciphers;
    private CipherSuiteFilter cipherFilter = IdentityCipherSuiteFilter.INSTANCE;
    private ApplicationProtocolConfig apn;
    private long sessionCacheSize;
    private long sessionTimeout;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private String[] protocols;
    private boolean startTls;
    private boolean enableOcsp;
    private SecureRandom secureRandom;
    private String keyStoreType = KeyStore.getDefaultType();
    private String endpointIdentificationAlgorithm;
    private final Map<SslContextOption<?>, Object> options = new HashMap();

    public static SslContextBuilder forClient() {
        return new SslContextBuilder(false);
    }

    /*
     * WARNING - void declaration
     */
    public static SslContextBuilder forServer(File keyCertChainFile, File keyFile) {
        void var1_1;
        File file;
        return new SslContextBuilder(true).keyManager(file, (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SslContextBuilder forServer(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        void var1_1;
        InputStream inputStream;
        return new SslContextBuilder(true).keyManager(inputStream, (InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SslContextBuilder forServer(PrivateKey key, X509Certificate ... keyCertChain) {
        void var1_1;
        PrivateKey privateKey;
        return new SslContextBuilder(true).keyManager(privateKey, (X509Certificate[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SslContextBuilder forServer(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        void var1_1;
        return SslContextBuilder.forServer(key, SslContextBuilder.toArray(var1_1, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    /*
     * WARNING - void declaration
     */
    public static SslContextBuilder forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        void var2_2;
        void var1_1;
        File file;
        return new SslContextBuilder(true).keyManager(file, (File)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static SslContextBuilder forServer(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        void var2_2;
        void var1_1;
        InputStream inputStream;
        return new SslContextBuilder(true).keyManager(inputStream, (InputStream)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static SslContextBuilder forServer(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        void var2_2;
        void var1_1;
        PrivateKey privateKey;
        return new SslContextBuilder(true).keyManager(privateKey, (String)var1_1, (X509Certificate[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static SslContextBuilder forServer(PrivateKey key, String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        void var2_2;
        void var1_1;
        return SslContextBuilder.forServer(key, (String)var1_1, SslContextBuilder.toArray(var2_2, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    public static SslContextBuilder forServer(KeyManagerFactory keyManagerFactory) {
        KeyManagerFactory keyManagerFactory2;
        return new SslContextBuilder(true).keyManager(keyManagerFactory2);
    }

    public static SslContextBuilder forServer(KeyManager keyManager) {
        KeyManager keyManager2;
        return new SslContextBuilder(true).keyManager(keyManager2);
    }

    /*
     * WARNING - void declaration
     */
    private SslContextBuilder(boolean forServer) {
        void var1_1;
        this.forServer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> SslContextBuilder option(SslContextOption<T> option, T value) {
        if (value == null) {
            this.options.remove(option);
        } else {
            void var2_2;
            void var1_1;
            this.options.put((SslContextOption<?>)var1_1, var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder sslProvider(SslProvider provider) {
        void var1_1;
        this.provider = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyStoreType(String keyStoreType) {
        void var1_1;
        this.keyStoreType = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder sslContextProvider(Provider sslContextProvider) {
        void var1_1;
        this.sslContextProvider = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder trustManager(File trustCertCollectionFile) {
        try {
            return this.trustManager(SslContext.toX509Certificates(trustCertCollectionFile));
        }
        catch (Exception e) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException("File does not contain valid certificates: " + var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder trustManager(InputStream trustCertCollectionInputStream) {
        try {
            return this.trustManager(SslContext.toX509Certificates(trustCertCollectionInputStream));
        }
        catch (Exception e) {
            void var1_2;
            throw new IllegalArgumentException("Input stream does not contain valid certificates.", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder trustManager(X509Certificate ... trustCertCollection) {
        void var1_1;
        this.trustCertCollection = trustCertCollection != null ? (X509Certificate[])var1_1.clone() : null;
        this.trustManagerFactory = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder trustManager(Iterable<? extends X509Certificate> trustCertCollection) {
        void var1_1;
        return this.trustManager(SslContextBuilder.toArray(var1_1, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder trustManager(TrustManagerFactory trustManagerFactory) {
        void var1_1;
        this.trustCertCollection = null;
        this.trustManagerFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder trustManager(TrustManager trustManager) {
        void var1_1;
        this.trustManagerFactory = trustManager != null ? new TrustManagerFactoryWrapper((TrustManager)var1_1) : null;
        this.trustCertCollection = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(File keyCertChainFile, File keyFile) {
        void var2_2;
        void var1_1;
        return this.keyManager((File)var1_1, (File)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        void var2_2;
        void var1_1;
        return this.keyManager((InputStream)var1_1, (InputStream)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(PrivateKey key, X509Certificate ... keyCertChain) {
        void var2_2;
        void var1_1;
        return this.keyManager((PrivateKey)var1_1, (String)null, (X509Certificate[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        void var2_2;
        void var1_1;
        return this.keyManager((PrivateKey)var1_1, SslContextBuilder.toArray(var2_2, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(File keyCertChainFile, File keyFile, String keyPassword) {
        void var3_3;
        void var1_1;
        X509Certificate[] keyCertChain;
        try {
            keyCertChain = SslContext.toX509Certificates(keyCertChainFile);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("File does not contain valid certificates: " + keyCertChainFile, e);
        }
        try {
            PrivateKey key = SslContext.toPrivateKey(keyFile, (String)e);
        }
        catch (Exception e) {
            void var3_5;
            void var2_2;
            throw new IllegalArgumentException("File does not contain valid private key: " + var2_2, (Throwable)var3_5);
        }
        return this.keyManager((PrivateKey)var1_1, (String)var3_3, keyCertChain);
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        void var1_1;
        void var3_5;
        void var2_4;
        try {
            X509Certificate[] keyCertChain = SslContext.toX509Certificates(keyCertChainInputStream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input stream not contain valid certificates.", e);
        }
        try {
            PrivateKey key = SslContext.toPrivateKey(keyInputStream, keyPassword);
        }
        catch (Exception e) {
            void var1_3;
            throw new IllegalArgumentException("Input stream does not contain valid private key.", (Throwable)var1_3);
        }
        return this.keyManager((PrivateKey)var2_4, (String)var3_5, (X509Certificate[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        void var2_2;
        void var1_1;
        if (this.forServer) {
            ObjectUtil.checkNonEmpty((Object[])keyCertChain, (String)"keyCertChain");
            ObjectUtil.checkNotNull((Object)key, (String)"key required for servers");
        }
        if (keyCertChain == null || keyCertChain.length == 0) {
            this.keyCertChain = null;
        } else {
            void var3_3;
            X509Certificate[] x509CertificateArray = keyCertChain;
            int n = keyCertChain.length;
            for (int i = 0; i < n; ++i) {
                X509Certificate x509Certificate = x509CertificateArray[i];
                ObjectUtil.checkNotNullWithIAE((Object)x509Certificate, (String)"cert");
            }
            this.keyCertChain = (X509Certificate[])var3_3.clone();
        }
        this.key = var1_1;
        this.keyPassword = var2_2;
        this.keyManagerFactory = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(PrivateKey key, String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.keyManager((PrivateKey)var1_1, (String)var2_2, SslContextBuilder.toArray(var3_3, EmptyArrays.EMPTY_X509_CERTIFICATES));
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(KeyManagerFactory keyManagerFactory) {
        void var1_1;
        if (this.forServer) {
            ObjectUtil.checkNotNull((Object)keyManagerFactory, (String)"keyManagerFactory required for servers");
        }
        this.keyCertChain = null;
        this.key = null;
        this.keyPassword = null;
        this.keyManagerFactory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder keyManager(KeyManager keyManager) {
        void var1_1;
        if (this.forServer) {
            ObjectUtil.checkNotNull((Object)keyManager, (String)"keyManager required for servers");
        }
        this.keyManagerFactory = keyManager != null ? new KeyManagerFactoryWrapper((KeyManager)var1_1) : null;
        this.keyCertChain = null;
        this.key = null;
        this.keyPassword = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder ciphers(Iterable<String> ciphers) {
        void var1_1;
        return this.ciphers((Iterable<String>)var1_1, IdentityCipherSuiteFilter.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder ciphers(Iterable<String> ciphers, CipherSuiteFilter cipherFilter) {
        void var1_1;
        void var2_2;
        this.cipherFilter = (CipherSuiteFilter)ObjectUtil.checkNotNull((Object)var2_2, (String)"cipherFilter");
        this.ciphers = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder applicationProtocolConfig(ApplicationProtocolConfig apn) {
        void var1_1;
        this.apn = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder sessionCacheSize(long sessionCacheSize) {
        void var1_1;
        this.sessionCacheSize = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder sessionTimeout(long sessionTimeout) {
        void var1_1;
        this.sessionTimeout = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder clientAuth(ClientAuth clientAuth) {
        void var1_1;
        this.clientAuth = (ClientAuth)((Object)ObjectUtil.checkNotNull((Object)var1_1, (String)"clientAuth"));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder protocols(String ... protocols) {
        void var1_1;
        this.protocols = protocols == null ? null : (String[])var1_1.clone();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder protocols(Iterable<String> protocols) {
        void var1_1;
        return this.protocols(SslContextBuilder.toArray(var1_1, EmptyArrays.EMPTY_STRINGS));
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder startTls(boolean startTls) {
        void var1_1;
        this.startTls = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder enableOcsp(boolean enableOcsp) {
        void var1_1;
        this.enableOcsp = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder secureRandom(SecureRandom secureRandom) {
        void var1_1;
        this.secureRandom = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SslContextBuilder endpointIdentificationAlgorithm(String algorithm) {
        void var1_1;
        this.endpointIdentificationAlgorithm = var1_1;
        return this;
    }

    public final SslContext build() throws SSLException {
        if (this.forServer) {
            return SslContext.newServerContextInternal(this.provider, this.sslContextProvider, this.trustCertCollection, this.trustManagerFactory, this.keyCertChain, this.key, this.keyPassword, this.keyManagerFactory, this.ciphers, this.cipherFilter, this.apn, this.sessionCacheSize, this.sessionTimeout, this.clientAuth, this.protocols, this.startTls, this.enableOcsp, this.secureRandom, this.keyStoreType, SslContextBuilder.toArray(this.options.entrySet(), EMPTY_ENTRIES));
        }
        return SslContext.newClientContextInternal(this.provider, this.sslContextProvider, this.trustCertCollection, this.trustManagerFactory, this.keyCertChain, this.key, this.keyPassword, this.keyManagerFactory, this.ciphers, this.cipherFilter, this.apn, this.protocols, this.sessionCacheSize, this.sessionTimeout, this.enableOcsp, this.secureRandom, this.keyStoreType, this.endpointIdentificationAlgorithm, SslContextBuilder.toArray(this.options.entrySet(), EMPTY_ENTRIES));
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T[] toArray(Iterable<? extends T> iterable, T[] prototype) {
        void var1_1;
        void var2_2;
        Iterator<? extends T> iterator;
        if (iterable == null) {
            return null;
        }
        ArrayList<void> list = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object element = iterator.next();
            list.add(var3_3);
        }
        return var2_2.toArray((T[])var1_1);
    }
}

