/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.BouncyCastlePemReader;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslClientContext;
import io.netty.handler.ssl.JdkSslServerContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslClientContext;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.PemReader;
import io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslServerContext;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.AttributeMap;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;

public abstract class SslContext {
    static final String ALIAS = "key";
    static final CertificateFactory X509_CERT_FACTORY;
    private final boolean startTls;
    private final AttributeMap attributes = new DefaultAttributeMap();
    final ResumptionController resumptionController;
    private static final String OID_PKCS5_PBES2 = "1.2.840.113549.1.5.13";
    private static final String PBES2 = "PBES2";

    public static SslProvider defaultServerProvider() {
        return SslContext.defaultProvider();
    }

    public static SslProvider defaultClientProvider() {
        return SslContext.defaultProvider();
    }

    private static SslProvider defaultProvider() {
        if (OpenSsl.isAvailable()) {
            return SslProvider.OPENSSL;
        }
        return SslProvider.JDK;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(File certChainFile, File keyFile) throws SSLException {
        void var1_1;
        return SslContext.newServerContext(certChainFile, (File)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(File certChainFile, File keyFile, String keyPassword) throws SSLException {
        void var2_2;
        void var1_1;
        File file;
        return SslContext.newServerContext(null, file, (File)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        File file;
        return SslContext.newServerContext(null, file, (File)var1_1, (String)var2_2, (Iterable<String>)var3_3, nextProtocols, sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        File file;
        return SslContext.newServerContext(null, file, (File)var1_1, (String)var2_2, (Iterable<String>)var3_3, cipherFilter, apn, sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(SslProvider provider, File certChainFile, File keyFile) throws SSLException {
        void var2_2;
        void var1_1;
        return SslContext.newServerContext(provider, (File)var1_1, (File)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(SslProvider provider, File certChainFile, File keyFile, String keyPassword) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return SslContext.newServerContext(provider, (File)var1_1, (File)var2_2, (String)var3_3, null, IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(SslProvider provider, File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return SslContext.newServerContext(provider, (File)var1_1, (File)var2_2, (String)var3_3, ciphers, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(nextProtocols), sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(SslProvider provider, File certChainFile, File keyFile, String keyPassword, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return SslContext.newServerContext(provider, null, trustManagerFactory, (File)var1_1, (File)var2_2, (String)var3_3, null, ciphers, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(nextProtocols), sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(SslProvider provider, File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return SslContext.newServerContext(provider, null, null, (File)var1_1, (File)var2_2, (String)var3_3, null, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, KeyStore.getDefaultType());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newServerContext(SslProvider provider, File trustCertCollectionFile, TrustManagerFactory trustManagerFactory, File keyCertChainFile, File keyFile, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return SslContext.newServerContext(provider, (File)var1_1, (TrustManagerFactory)var2_2, (File)var3_3, keyFile, keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, KeyStore.getDefaultType());
    }

    /*
     * WARNING - void declaration
     */
    static SslContext newServerContext(SslProvider provider, File trustCertCollectionFile, TrustManagerFactory trustManagerFactory, File keyCertChainFile, File keyFile, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout, String keyStore) throws SSLException {
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            return SslContext.newServerContextInternal(provider, null, SslContext.toX509Certificates((File)var1_1), (TrustManagerFactory)var2_2, SslContext.toX509Certificates((File)var3_3), SslContext.toPrivateKey(keyFile, keyPassword), keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, ClientAuth.NONE, null, false, false, null, keyStore, new Map.Entry[0]);
        }
        catch (Exception exception) {
            Object object;
            Object e = exception;
            if (exception instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException("failed to initialize the server-side SSL context", (Throwable)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    static SslContext newServerContextInternal(SslProvider provider, Provider sslContextProvider, X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, SecureRandom secureRandom, String keyStoreType, Map.Entry<SslContextOption<?>, Object> ... ctxOptions) throws SSLException {
        SslProvider sslProvider;
        if (provider == null) {
            provider = SslContext.defaultServerProvider();
        }
        ResumptionController resumptionController = new ResumptionController();
        switch (provider) {
            case JDK: {
                if (enableOcsp) {
                    throw new IllegalArgumentException("OCSP is not supported with this SslProvider: " + (Object)((Object)provider));
                }
                return new JdkSslServerContext(sslContextProvider, trustCertCollection, trustManagerFactory, keyCertChain, key, keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, clientAuth, protocols, startTls, secureRandom, keyStoreType, resumptionController);
            }
            case OPENSSL: {
                SslContext.verifyNullSslContextProvider(provider, sslContextProvider);
                return new OpenSslServerContext(trustCertCollection, trustManagerFactory, keyCertChain, key, keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, clientAuth, protocols, startTls, enableOcsp, keyStoreType, resumptionController, ctxOptions);
            }
            case OPENSSL_REFCNT: {
                void var3_3;
                void var2_2;
                void var1_1;
                SslContext.verifyNullSslContextProvider(provider, (Provider)var1_1);
                return new ReferenceCountedOpenSslServerContext((X509Certificate[])var2_2, (TrustManagerFactory)var3_3, keyCertChain, key, keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, clientAuth, protocols, startTls, enableOcsp, keyStoreType, resumptionController, ctxOptions);
            }
        }
        throw new Error(sslProvider.toString());
    }

    private static void verifyNullSslContextProvider(SslProvider provider, Provider sslContextProvider) {
        if (sslContextProvider != null) {
            SslProvider sslProvider;
            throw new IllegalArgumentException("Java Security Provider unsupported for SslProvider: " + (Object)((Object)sslProvider));
        }
    }

    @Deprecated
    public static SslContext newClientContext() throws SSLException {
        return SslContext.newClientContext(null, null, null);
    }

    @Deprecated
    public static SslContext newClientContext(File certChainFile) throws SSLException {
        File file;
        return SslContext.newClientContext(null, file);
    }

    @Deprecated
    public static SslContext newClientContext(TrustManagerFactory trustManagerFactory) throws SSLException {
        TrustManagerFactory trustManagerFactory2;
        return SslContext.newClientContext(null, null, trustManagerFactory2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(File certChainFile, TrustManagerFactory trustManagerFactory) throws SSLException {
        void var1_1;
        File file;
        return SslContext.newClientContext(null, file, (TrustManagerFactory)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        File file;
        return SslContext.newClientContext(null, file, (TrustManagerFactory)var1_1, (Iterable<String>)var2_2, (Iterable<String>)var3_3, sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        File file;
        return SslContext.newClientContext(null, file, (TrustManagerFactory)var1_1, (Iterable<String>)var2_2, (CipherSuiteFilter)var3_3, apn, sessionCacheSize, sessionTimeout);
    }

    @Deprecated
    public static SslContext newClientContext(SslProvider provider) throws SSLException {
        return SslContext.newClientContext(provider, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(SslProvider provider, File certChainFile) throws SSLException {
        void var1_1;
        return SslContext.newClientContext(provider, (File)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(SslProvider provider, TrustManagerFactory trustManagerFactory) throws SSLException {
        void var1_1;
        return SslContext.newClientContext(provider, null, (TrustManagerFactory)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(SslProvider provider, File certChainFile, TrustManagerFactory trustManagerFactory) throws SSLException {
        void var2_2;
        void var1_1;
        return SslContext.newClientContext(provider, (File)var1_1, (TrustManagerFactory)var2_2, null, IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(SslProvider provider, File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return SslContext.newClientContext(provider, (File)var1_1, (TrustManagerFactory)var2_2, null, null, null, null, (Iterable<String>)var3_3, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(nextProtocols), sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(SslProvider provider, File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return SslContext.newClientContext(provider, (File)var1_1, (TrustManagerFactory)var2_2, null, null, null, null, (Iterable<String>)var3_3, cipherFilter, apn, sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SslContext newClientContext(SslProvider provider, File trustCertCollectionFile, TrustManagerFactory trustManagerFactory, File keyCertChainFile, File keyFile, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            return SslContext.newClientContextInternal(provider, null, SslContext.toX509Certificates((File)var1_1), (TrustManagerFactory)var2_2, SslContext.toX509Certificates((File)var3_3), SslContext.toPrivateKey(keyFile, keyPassword), keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, null, sessionCacheSize, sessionTimeout, false, null, KeyStore.getDefaultType(), null, new Map.Entry[0]);
        }
        catch (Exception exception) {
            Object object;
            Object e = exception;
            if (exception instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException("failed to initialize the client-side SSL context", (Throwable)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    static SslContext newClientContextInternal(SslProvider provider, Provider sslContextProvider, X509Certificate[] trustCert, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, String[] protocols, long sessionCacheSize, long sessionTimeout, boolean enableOcsp, SecureRandom secureRandom, String keyStoreType, String endpointIdentificationAlgorithm, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        SslProvider sslProvider;
        if (provider == null) {
            provider = SslContext.defaultClientProvider();
        }
        ResumptionController resumptionController = new ResumptionController();
        switch (provider) {
            case JDK: {
                if (enableOcsp) {
                    throw new IllegalArgumentException("OCSP is not supported with this SslProvider: " + (Object)((Object)provider));
                }
                return new JdkSslClientContext(sslContextProvider, trustCert, trustManagerFactory, keyCertChain, key, keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, protocols, sessionCacheSize, sessionTimeout, secureRandom, keyStoreType, endpointIdentificationAlgorithm, resumptionController);
            }
            case OPENSSL: {
                SslContext.verifyNullSslContextProvider(provider, sslContextProvider);
                OpenSsl.ensureAvailability();
                return new OpenSslClientContext(trustCert, trustManagerFactory, keyCertChain, key, keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, protocols, sessionCacheSize, sessionTimeout, enableOcsp, keyStoreType, endpointIdentificationAlgorithm, resumptionController, options);
            }
            case OPENSSL_REFCNT: {
                void var3_3;
                void var2_2;
                void var1_1;
                SslContext.verifyNullSslContextProvider(provider, (Provider)var1_1);
                OpenSsl.ensureAvailability();
                return new ReferenceCountedOpenSslClientContext((X509Certificate[])var2_2, (TrustManagerFactory)var3_3, keyCertChain, key, keyPassword, keyManagerFactory, ciphers, cipherFilter, apn, protocols, sessionCacheSize, sessionTimeout, enableOcsp, keyStoreType, endpointIdentificationAlgorithm, resumptionController, options);
            }
        }
        throw new Error(sslProvider.toString());
    }

    static ApplicationProtocolConfig toApplicationProtocolConfig(Iterable<String> nextProtocols) {
        ApplicationProtocolConfig applicationProtocolConfig;
        ApplicationProtocolConfig apn;
        apn = nextProtocols == null ? ApplicationProtocolConfig.DISABLED : new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN_AND_ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)((Object)apn));
        return applicationProtocolConfig;
    }

    protected SslContext() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    protected SslContext(boolean startTls) {
        this((boolean)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    SslContext(boolean startTls, ResumptionController resumptionController) {
        void var2_2;
        void var1_1;
        this.startTls = var1_1;
        this.resumptionController = var2_2;
    }

    public final AttributeMap attributes() {
        return this.attributes;
    }

    public final boolean isServer() {
        return !this.isClient();
    }

    public abstract boolean isClient();

    public abstract List<String> cipherSuites();

    public long sessionCacheSize() {
        return this.sessionContext().getSessionCacheSize();
    }

    public long sessionTimeout() {
        return this.sessionContext().getSessionTimeout();
    }

    @Deprecated
    public final List<String> nextProtocols() {
        return this.applicationProtocolNegotiator().protocols();
    }

    public abstract ApplicationProtocolNegotiator applicationProtocolNegotiator();

    public abstract SSLEngine newEngine(ByteBufAllocator var1);

    public abstract SSLEngine newEngine(ByteBufAllocator var1, String var2, int var3);

    public abstract SSLSessionContext sessionContext();

    /*
     * WARNING - void declaration
     */
    public final SslHandler newHandler(ByteBufAllocator alloc) {
        void var1_1;
        return this.newHandler((ByteBufAllocator)var1_1, this.startTls);
    }

    /*
     * WARNING - void declaration
     */
    protected SslHandler newHandler(ByteBufAllocator alloc, boolean startTls) {
        void var2_2;
        void var1_1;
        return new SslHandler(this.newEngine((ByteBufAllocator)var1_1), (boolean)var2_2, (Executor)ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler newHandler(ByteBufAllocator alloc, Executor delegatedTaskExecutor) {
        void var2_2;
        void var1_1;
        return this.newHandler((ByteBufAllocator)var1_1, this.startTls, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SslHandler newHandler(ByteBufAllocator alloc, boolean startTls, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SslHandler(this.newEngine((ByteBufAllocator)var1_1), (boolean)var2_2, (Executor)var3_3, this.resumptionController);
    }

    /*
     * WARNING - void declaration
     */
    public final SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.newHandler((ByteBufAllocator)var1_1, (String)var2_2, (int)var3_3, this.startTls);
    }

    /*
     * WARNING - void declaration
     */
    protected SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort, boolean startTls) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SslHandler(this.newEngine((ByteBufAllocator)var1_1, (String)var2_2, (int)var3_3), startTls, (Executor)ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    /*
     * WARNING - void declaration
     */
    public SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort, Executor delegatedTaskExecutor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.newHandler((ByteBufAllocator)var1_1, (String)var2_2, (int)var3_3, this.startTls, delegatedTaskExecutor);
    }

    /*
     * WARNING - void declaration
     */
    protected SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort, boolean startTls, Executor delegatedTaskExecutor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SslHandler(this.newEngine((ByteBufAllocator)var1_1, (String)var2_2, (int)var3_3), startTls, delegatedTaskExecutor, this.resumptionController);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected static PKCS8EncodedKeySpec generateKeySpec(char[] password, byte[] key) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        void var2_2;
        void var1_1;
        Object object;
        void var3_3;
        if (password == null) {
            return new PKCS8EncodedKeySpec(key);
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(key);
        String pbeAlgorithm = SslContext.getPBEAlgorithm(encryptedPrivateKeyInfo);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(pbeAlgorithm);
        Object pbeKeySpec = new PBEKeySpec(password);
        Object pbeKey = var3_3.generateSecret((KeySpec)pbeKeySpec);
        Cipher cipher = Cipher.getInstance(pbeAlgorithm);
        cipher.init(2, (Key)object, encryptedPrivateKeyInfo.getAlgParameters());
        return var1_1.getKeySpec((Cipher)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static String getPBEAlgorithm(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo2;
        void var2_2;
        AlgorithmParameters parameters = encryptedPrivateKeyInfo.getAlgParameters();
        String algName = encryptedPrivateKeyInfo.getAlgName();
        if (PlatformDependent.javaVersion() >= 8 && parameters != null && (OID_PKCS5_PBES2.equals(algName) || PBES2.equals(var2_2))) {
            void var1_1;
            return var1_1.toString();
        }
        return encryptedPrivateKeyInfo2.getAlgName();
    }

    /*
     * WARNING - void declaration
     */
    protected static KeyStore buildKeyStore(X509Certificate[] certChain, PrivateKey key, char[] keyPasswordChars, String keyStoreType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        void var3_3;
        X509Certificate[] x509CertificateArray;
        void var2_2;
        void var1_1;
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        ks.load(null, null);
        ks.setKeyEntry(ALIAS, (Key)var1_1, (char[])var2_2, x509CertificateArray);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected static PrivateKey toPrivateKey(File keyFile, String keyPassword) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        void var1_1;
        return SslContext.toPrivateKey(keyFile, (String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    static PrivateKey toPrivateKey(File keyFile, String keyPassword, boolean tryBouncyCastle) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        void var1_1;
        File file;
        PrivateKey pk;
        if (keyFile == null) {
            return null;
        }
        if (tryBouncyCastle && BouncyCastlePemReader.isAvailable() && (pk = BouncyCastlePemReader.getPrivateKey(keyFile, keyPassword)) != null) {
            void var2_3;
            return var2_3;
        }
        return SslContext.getPrivateKeyFromByteBuffer(PemReader.readPrivateKey(file), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static PrivateKey toPrivateKey(InputStream keyInputStream, String keyPassword) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        void var1_1;
        InputStream inputStream;
        if (keyInputStream == null) {
            return null;
        }
        if (BouncyCastlePemReader.isAvailable()) {
            if (!keyInputStream.markSupported()) {
                keyInputStream = new BufferedInputStream(keyInputStream);
            }
            keyInputStream.mark(0x100000);
            PrivateKey pk = BouncyCastlePemReader.getPrivateKey(keyInputStream, keyPassword);
            if (pk != null) {
                void var2_2;
                return var2_2;
            }
            keyInputStream.reset();
        }
        return SslContext.getPrivateKeyFromByteBuffer(PemReader.readPrivateKey(inputStream), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static PrivateKey getPrivateKeyFromByteBuffer(ByteBuf encodedKeyBuf, String keyPassword) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, KeyException, IOException {
        void var2_3;
        void var1_2;
        byte[] encodedKey = new byte[encodedKeyBuf.readableBytes()];
        encodedKeyBuf.readBytes(encodedKey).release();
        Object encodedKeySpec = SslContext.generateKeySpec(keyPassword == null ? null : var1_2.toCharArray(), (byte[])var2_3);
        try {
            return KeyFactory.getInstance("RSA").generatePrivate((KeySpec)encodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                return KeyFactory.getInstance("DSA").generatePrivate((KeySpec)encodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                try {
                    return KeyFactory.getInstance("EC").generatePrivate((KeySpec)encodedKeySpec);
                }
                catch (InvalidKeySpecException e) {
                    void var0_1;
                    throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", (Throwable)var0_1);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected static TrustManagerFactory buildTrustManagerFactory(File certChainFile, TrustManagerFactory trustManagerFactory) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        void var1_1;
        return SslContext.buildTrustManagerFactory(certChainFile, (TrustManagerFactory)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    protected static TrustManagerFactory buildTrustManagerFactory(File certChainFile, TrustManagerFactory trustManagerFactory, String keyType) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        void var2_2;
        void var1_1;
        X509Certificate[] x509CertificateArray = SslContext.toX509Certificates(certChainFile);
        return SslContext.buildTrustManagerFactory(x509CertificateArray, (TrustManagerFactory)var1_1, (String)var2_2);
    }

    protected static X509Certificate[] toX509Certificates(File file) throws CertificateException {
        File file2;
        if (file == null) {
            return null;
        }
        return SslContext.getCertificatesFromBuffers(PemReader.readCertificates(file2));
    }

    protected static X509Certificate[] toX509Certificates(InputStream in) throws CertificateException {
        InputStream inputStream;
        if (in == null) {
            return null;
        }
        return SslContext.getCertificatesFromBuffers(PemReader.readCertificates(inputStream));
    }

    /*
     * WARNING - void declaration
     */
    private static X509Certificate[] getCertificatesFromBuffers(ByteBuf[] certs) throws CertificateException {
        void var2_6;
        ByteBuf[] byteBufArray;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate[] x509Certs = new X509Certificate[certs.length];
        try {
            for (int i = 0; i < certs.length; ++i) {
                ByteBufInputStream is = new ByteBufInputStream(certs[i], false);
                try {
                    x509Certs[i] = (X509Certificate)cf.generateCertificate((InputStream)is);
                    continue;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            byteBufArray = certs;
        }
        catch (Throwable throwable) {
            ByteBuf[] byteBufArray2;
            for (ByteBuf byteBuf : byteBufArray2) {
                byteBuf.release();
            }
            throw throwable;
        }
        int n = certs.length;
        for (int i = 0; i < n; ++i) {
            ByteBuf byteBuf = byteBufArray[i];
            byteBuf.release();
        }
        return var2_6;
    }

    /*
     * WARNING - void declaration
     */
    protected static TrustManagerFactory buildTrustManagerFactory(X509Certificate[] certCollection, TrustManagerFactory trustManagerFactory, String keyStoreType) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        void var1_1;
        void var2_2;
        X509Certificate[] x509CertificateArray;
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        ks.load(null, null);
        int i = 1;
        for (X509Certificate cert : x509CertificateArray) {
            String alias = Integer.toString(i);
            ks.setCertificateEntry(alias, cert);
            ++i;
        }
        if (trustManagerFactory == null) {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        trustManagerFactory.init((KeyStore)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static PrivateKey toPrivateKeyInternal(File keyFile, String keyPassword) throws SSLException {
        try {
            void var1_2;
            return SslContext.toPrivateKey(keyFile, (String)var1_2);
        }
        catch (Exception e) {
            void var0_1;
            throw new SSLException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static X509Certificate[] toX509CertificatesInternal(File file) throws SSLException {
        try {
            return SslContext.toX509Certificates(file);
        }
        catch (CertificateException e) {
            void var0_1;
            throw new SSLException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static KeyManagerFactory buildKeyManagerFactory(X509Certificate[] certChainFile, String keyAlgorithm, PrivateKey key, String keyPassword, KeyManagerFactory kmf, String keyStore) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException, UnrecoverableKeyException {
        void var3_3;
        void var1_1;
        void var2_2;
        Object object;
        if (keyAlgorithm == null) {
            keyAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        char[] keyPasswordChars = SslContext.keyStorePassword(keyPassword);
        object = SslContext.buildKeyStore(object, (PrivateKey)var2_2, keyPasswordChars, keyStore);
        return SslContext.buildKeyManagerFactory((KeyStore)object, (String)var1_1, (char[])var3_3, kmf);
    }

    /*
     * WARNING - void declaration
     */
    static KeyManagerFactory buildKeyManagerFactory(KeyStore ks, String keyAlgorithm, char[] keyPasswordChars, KeyManagerFactory kmf) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        void var3_3;
        void var2_2;
        KeyStore keyStore;
        if (kmf == null) {
            void var1_1;
            if (keyAlgorithm == null) {
                keyAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            kmf = KeyManagerFactory.getInstance((String)var1_1);
        }
        kmf.init(keyStore, (char[])var2_2);
        return var3_3;
    }

    static char[] keyStorePassword(String keyPassword) {
        String string;
        if (keyPassword == null) {
            return EmptyArrays.EMPTY_CHARS;
        }
        return string.toCharArray();
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
            return;
        }
        catch (CertificateException e) {
            void var0;
            throw new IllegalStateException("unable to instance X.509 CertificateFactory", (Throwable)var0);
        }
    }
}

