/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;

public abstract class SslClientHelloHandler<T>
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    public static final int MAX_CLIENT_HELLO_LENGTH = 0xFFFFFF;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslClientHelloHandler.class);
    private final int maxClientHelloLength;
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;
    private ByteBuf handshakeBuffer;

    public SslClientHelloHandler() {
        this(0xFFFFFF);
    }

    /*
     * WARNING - void declaration
     */
    protected SslClientHelloHandler(int maxClientHelloLength) {
        void var1_1;
        this.maxClientHelloLength = ObjectUtil.checkInRange((int)var1_1, (int)0, (int)0xFFFFFF, (String)"maxClientHelloLength");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!this.suppressRead && !this.handshakeFailed) {
            Throwable e32;
            try {
                int readerIndex = in.readerIndex();
                int readableBytes = in.readableBytes();
                int handshakeLength = -1;
                block8: while (true) {
                    if (readableBytes < 5) {
                        return;
                    }
                    short s = in.getUnsignedByte(readerIndex);
                    switch (s) {
                        case 20: 
                        case 21: {
                            int len = SslUtils.getEncryptedPacketLength(in, readerIndex, true);
                            if (len == -2) {
                                this.handshakeFailed = true;
                                NotSslRecordException e2 = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump((ByteBuf)in));
                                ByteBuf byteBuf = in;
                                byteBuf.skipBytes(byteBuf.readableBytes());
                                ctx.fireUserEventTriggered((Object)new SniCompletionEvent(e2));
                                SslUtils.handleHandshakeFailure(ctx, e2, true);
                                throw e2;
                            }
                            if (len == -1) {
                                return;
                            }
                            this.select(ctx, null);
                            return;
                        }
                        case 22: {
                            void e32;
                            int len;
                            short e2 = in.getUnsignedByte((int)(len + true));
                            if (e2 != 3) break block8;
                            int packetLength = in.getUnsignedShort(len + 3) + 5;
                            if (readableBytes < packetLength) {
                                return;
                            }
                            if (packetLength == 5) {
                                this.select(ctx, null);
                                return;
                            }
                            int endOffset = len + packetLength;
                            if (handshakeLength == -1) {
                                if (len + 4 > endOffset) {
                                    return;
                                }
                                short s2 = in.getUnsignedByte(len + 5);
                                handshakeLength = s2;
                                if (s2 != 1) {
                                    this.select(ctx, null);
                                    return;
                                }
                                handshakeLength = in.getUnsignedMedium(len + 5 + 1);
                                if (handshakeLength > this.maxClientHelloLength && this.maxClientHelloLength != 0) {
                                    TooLongFrameException e32 = new TooLongFrameException("ClientHello length exceeds " + this.maxClientHelloLength + ": " + handshakeLength);
                                    ByteBuf byteBuf = in;
                                    byteBuf.skipBytes(byteBuf.readableBytes());
                                    ctx.fireUserEventTriggered((Object)new SniCompletionEvent(e32));
                                    SslUtils.handleHandshakeFailure(ctx, e32, true);
                                    throw e32;
                                }
                                e32 += 4;
                                if (handshakeLength + 4 + 5 <= (packetLength -= 4)) {
                                    this.select(ctx, in.retainedSlice((int)(e32 += 5), handshakeLength));
                                    return;
                                }
                                if (this.handshakeBuffer == null) {
                                    this.handshakeBuffer = ctx.alloc().buffer(handshakeLength);
                                } else {
                                    this.handshakeBuffer.clear();
                                }
                            }
                            this.handshakeBuffer.writeBytes(in, (int)(e32 + 5), packetLength - 5);
                            e32 += packetLength;
                            readableBytes -= packetLength;
                            if (handshakeLength > this.handshakeBuffer.readableBytes()) continue block8;
                            ByteBuf clientHello = this.handshakeBuffer.setIndex(0, handshakeLength);
                            this.handshakeBuffer = null;
                            this.select(ctx, clientHello);
                            return;
                        }
                    }
                    break;
                }
                this.select(ctx, null);
                return;
            }
            catch (NotSslRecordException notSslRecordException) {
                e32 = notSslRecordException;
                throw notSslRecordException;
            }
            catch (TooLongFrameException tooLongFrameException) {
                e32 = tooLongFrameException;
                throw tooLongFrameException;
            }
            catch (Exception e4) {
                void var1_1;
                if (logger.isDebugEnabled()) {
                    void var3_6;
                    void var2_2;
                    logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump((ByteBuf)var2_2), (Throwable)var3_6);
                }
                this.select((ChannelHandlerContext)var1_1, null);
            }
        }
    }

    private void releaseHandshakeBuffer() {
        SslClientHelloHandler.releaseIfNotNull(this.handshakeBuffer);
        this.handshakeBuffer = null;
    }

    private static void releaseIfNotNull(ByteBuf buffer) {
        if (buffer != null) {
            ByteBuf byteBuf;
            byteBuf.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void select(ChannelHandlerContext ctx, ByteBuf clientHello) throws Exception {
        block5: {
            try {
                void var1_1;
                void var3_4;
                Future<T> future = this.lookup(ctx, clientHello);
                if (future.isDone()) {
                    this.onLookupComplete(ctx, future);
                    break block5;
                }
                this.suppressRead = true;
                ByteBuf finalClientHello = clientHello;
                var3_4.addListener((GenericFutureListener)new FutureListener<T>(this, finalClientHello, (ChannelHandlerContext)var1_1){
                    final /* synthetic */ ByteBuf val$finalClientHello;
                    final /* synthetic */ ChannelHandlerContext val$ctx;
                    final /* synthetic */ SslClientHelloHandler this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$finalClientHello = byteBuf;
                        this.val$ctx = channelHandlerContext;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void operationComplete(Future<T> future) {
                        SslClientHelloHandler.releaseIfNotNull(this.val$finalClientHello);
                        try {
                            SslClientHelloHandler.access$102(this.this$0, false);
                            try {
                                this.this$0.onLookupComplete(this.val$ctx, future);
                            }
                            catch (DecoderException err) {
                                this.val$ctx.fireExceptionCaught((Throwable)err);
                            }
                            catch (Exception cause) {
                                this.val$ctx.fireExceptionCaught((Throwable)new DecoderException((Throwable)cause));
                            }
                            catch (Throwable cause) {
                                void var1_4;
                                this.val$ctx.fireExceptionCaught((Throwable)var1_4);
                            }
                        }
                        catch (Throwable throwable) {
                            if (this.this$0.readPending) {
                                SslClientHelloHandler.access$202(this.this$0, false);
                                this.val$ctx.read();
                            }
                            throw throwable;
                        }
                        if (this.this$0.readPending) {
                            SslClientHelloHandler.access$202(this.this$0, false);
                            this.val$ctx.read();
                            return;
                        }
                    }
                });
                clientHello = null;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    PlatformDependent.throwException((Throwable)throwable);
                }
                catch (Throwable throwable3) {
                    void var2_3;
                    SslClientHelloHandler.releaseIfNotNull((ByteBuf)var2_3);
                    throw throwable3;
                }
                SslClientHelloHandler.releaseIfNotNull(clientHello);
                return;
            }
        }
        SslClientHelloHandler.releaseIfNotNull(clientHello);
        return;
    }

    /*
     * WARNING - void declaration
     */
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        this.releaseHandshakeBuffer();
        super.handlerRemoved0((ChannelHandlerContext)var1_1);
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, ByteBuf var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, Future<T> var2) throws Exception;

    /*
     * WARNING - void declaration
     */
    public void read(ChannelHandlerContext ctx) throws Exception {
        void var1_1;
        if (this.suppressRead) {
            this.readPending = true;
            return;
        }
        var1_1.read();
    }

    /*
     * WARNING - void declaration
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.bind((SocketAddress)var2_2, (ChannelPromise)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.connect((SocketAddress)var2_2, (SocketAddress)var3_3, promise);
    }

    /*
     * WARNING - void declaration
     */
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.disconnect((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.close((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        void var2_2;
        ctx.deregister((ChannelPromise)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        void var3_3;
        void var2_2;
        ctx.write((Object)var2_2, (ChannelPromise)var3_3);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(SslClientHelloHandler x0, boolean x1) {
        void var1_1;
        x0.suppressRead = var1_1;
        return x0.suppressRead;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$202(SslClientHelloHandler x0, boolean x1) {
        void var1_1;
        x0.readPending = var1_1;
        return x0.readPending;
    }
}

