/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsyncMapping;
import io.netty.util.DomainNameMapping;
import io.netty.util.Mapping;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    private static final Selection EMPTY_SELECTION = new Selection(null, null);
    protected final AsyncMapping<String, SslContext> mapping;
    private volatile Selection selection = EMPTY_SELECTION;

    /*
     * WARNING - void declaration
     */
    public SniHandler(Mapping<? super String, ? extends SslContext> mapping) {
        this(new AsyncMappingAdapter((Mapping)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SniHandler(Mapping<? super String, ? extends SslContext> mapping, int maxClientHelloLength, long handshakeTimeoutMillis) {
        this(new AsyncMappingAdapter((Mapping)var1_1), (int)var2_2, (long)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SniHandler(DomainNameMapping<? extends SslContext> mapping) {
        this((Mapping<? super String, ? extends SslContext>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SniHandler(AsyncMapping<? super String, ? extends SslContext> mapping) {
        this((AsyncMapping<? super String, ? extends SslContext>)var1_1, 0, 0L);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SniHandler(AsyncMapping<? super String, ? extends SslContext> mapping, int maxClientHelloLength, long handshakeTimeoutMillis) {
        super((int)var2_2, (long)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.mapping = (AsyncMapping)ObjectUtil.checkNotNull((Object)var1_1, (String)"mapping");
    }

    /*
     * WARNING - void declaration
     */
    public SniHandler(Mapping<? super String, ? extends SslContext> mapping, long handshakeTimeoutMillis) {
        this(new AsyncMappingAdapter((Mapping)var1_1), (long)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SniHandler(AsyncMapping<? super String, ? extends SslContext> mapping, long handshakeTimeoutMillis) {
        this((AsyncMapping<? super String, ? extends SslContext>)var1_1, 0, (long)var2_2);
        void var2_2;
        void var1_1;
    }

    public String hostname() {
        return this.selection.hostname;
    }

    public SslContext sslContext() {
        return this.selection.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) throws Exception {
        void var1_1;
        void var2_2;
        return this.mapping.map((Object)var2_2, var1_1.executor().newPromise());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslContext> future) throws Exception {
        Throwable cause;
        if (!future.isSuccess()) {
            cause = future.cause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new DecoderException("failed to get the SslContext for " + hostname, cause);
        }
        SslContext sslContext = (SslContext)cause.getNow();
        this.selection = new Selection(sslContext, hostname);
        try {
            void var3_4;
            void var2_3;
            this.replaceHandler(ctx, (String)var2_3, (SslContext)var3_4);
            return;
        }
        catch (Throwable cause2) {
            void var1_2;
            this.selection = EMPTY_SELECTION;
            PlatformDependent.throwException((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void replaceHandler(ChannelHandlerContext ctx, String hostname, SslContext sslContext) throws Exception {
        SslHandler sslHandler = null;
        try {
            void var1_1;
            void var3_4;
            sslHandler = this.newSslHandler((SslContext)var3_4, ctx.alloc());
            var1_1.pipeline().replace((ChannelHandler)this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
            sslHandler = null;
            return;
        }
        catch (Throwable throwable) {
            if (sslHandler != null) {
                void var2_3;
                ReferenceCountUtil.safeRelease((Object)var2_3.engine());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected SslHandler newSslHandler(SslContext context, ByteBufAllocator allocator) {
        void var1_1;
        void var2_2;
        SslHandler sslHandler = context.newHandler((ByteBufAllocator)var2_2);
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        return var1_1;
    }

    private static final class Selection {
        final SslContext context;
        final String hostname;

        /*
         * WARNING - void declaration
         */
        Selection(SslContext context, String hostname) {
            void var2_2;
            void var1_1;
            this.context = var1_1;
            this.hostname = var2_2;
        }
    }

    private static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslContext> {
        private final Mapping<? super String, ? extends SslContext> mapping;

        /*
         * WARNING - void declaration
         */
        private AsyncMappingAdapter(Mapping<? super String, ? extends SslContext> mapping) {
            void var1_1;
            this.mapping = (Mapping)ObjectUtil.checkNotNull((Object)var1_1, (String)"mapping");
        }

        /*
         * WARNING - void declaration
         */
        public final Future<SslContext> map(String input, Promise<SslContext> promise) {
            void var1_1;
            void var2_3;
            try {
                SslContext context = (SslContext)this.mapping.map((Object)input);
            }
            catch (Throwable cause) {
                return promise.setFailure(cause);
            }
            return var2_3.setSuccess((Object)var1_1);
        }
    }
}

