/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.ResumableX509ExtendedTrustManager;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

final class ResumptionController {
    private final Set<SSLEngine> confirmedValidations = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final AtomicReference<ResumableX509ExtendedTrustManager> resumableTm = new AtomicReference();

    ResumptionController() {
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Guarded by version check")
    public final TrustManager wrapIfNeeded(TrustManager tm) {
        void var1_1;
        if (tm instanceof ResumableX509ExtendedTrustManager) {
            if (PlatformDependent.javaVersion() < 7 || !(tm instanceof X509ExtendedTrustManager)) {
                throw new IllegalStateException("ResumableX509ExtendedTrustManager implementation must be a subclass of X509ExtendedTrustManager, found: " + (tm == null ? null : tm.getClass()));
            }
            if (!this.resumableTm.compareAndSet(null, (ResumableX509ExtendedTrustManager)tm)) {
                throw new IllegalStateException("Only one ResumableX509ExtendedTrustManager can be configured for resumed sessions");
            }
            return new X509ExtendedWrapTrustManager((X509ExtendedTrustManager)tm, this.confirmedValidations);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(SSLEngine engine) {
        if (this.resumableTm.get() != null) {
            void var1_1;
            this.confirmedValidations.remove(ResumptionController.unwrapEngine((SSLEngine)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean validateResumeIfNeeded(SSLEngine engine) throws CertificateException, SSLPeerUnverifiedException {
        ResumableX509ExtendedTrustManager tm;
        boolean bl = engine.getSession().isValid();
        if (bl && (tm = this.resumableTm.get()) != null) {
            Certificate[] peerCertificates = engine.getSession().getPeerCertificates();
            if (!this.confirmedValidations.remove(engine = ResumptionController.unwrapEngine(engine))) {
                if (engine.getUseClientMode()) {
                    tm.resumeServerTrusted(ResumptionController.chainOf(peerCertificates), engine);
                } else {
                    void var1_1;
                    void var3_4;
                    void var2_3;
                    var2_3.resumeClientTrusted(ResumptionController.chainOf((Certificate[])var3_4), (SSLEngine)var1_1);
                }
                return true;
            }
        }
        return false;
    }

    private static SSLEngine unwrapEngine(SSLEngine engine) {
        SSLEngine sSLEngine;
        if (engine instanceof JdkSslEngine) {
            return ((JdkSslEngine)engine).getWrappedEngine();
        }
        return sSLEngine;
    }

    /*
     * WARNING - void declaration
     */
    private static X509Certificate[] chainOf(Certificate[] peerCertificates) {
        void var1_1;
        if (peerCertificates instanceof X509Certificate[]) {
            return (X509Certificate[])peerCertificates;
        }
        X509Certificate[] chain = new X509Certificate[peerCertificates.length];
        for (int i = 0; i < peerCertificates.length; ++i) {
            Certificate cert = peerCertificates[i];
            if (!(cert instanceof X509Certificate) && cert != null) {
                void var3_3;
                throw new IllegalArgumentException("Only X509Certificates are supported, found: " + var3_3.getClass());
            }
            chain[i] = (X509Certificate)cert;
        }
        return var1_1;
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    private static final class X509ExtendedWrapTrustManager
    extends X509ExtendedTrustManager {
        private final X509ExtendedTrustManager trustManager;
        private final Set<SSLEngine> confirmedValidations;

        /*
         * WARNING - void declaration
         */
        X509ExtendedWrapTrustManager(X509ExtendedTrustManager trustManager, Set<SSLEngine> confirmedValidations) {
            void var2_2;
            void var1_1;
            this.trustManager = var1_1;
            this.confirmedValidations = var2_2;
        }

        private static void unsupported() throws CertificateException {
            throw new CertificateException(new UnsupportedOperationException("Resumable trust managers require the SSLEngine parameter"));
        }

        @Override
        public final void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            X509ExtendedWrapTrustManager.unsupported();
        }

        @Override
        public final void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            X509ExtendedWrapTrustManager.unsupported();
        }

        @Override
        public final void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            X509ExtendedWrapTrustManager.unsupported();
        }

        @Override
        public final void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            X509ExtendedWrapTrustManager.unsupported();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.trustManager.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2, engine);
            this.confirmedValidations.add((SSLEngine)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.trustManager.checkServerTrusted((X509Certificate[])var1_1, (String)var2_2, engine);
            this.confirmedValidations.add((SSLEngine)var3_3);
        }

        @Override
        public final X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }
    }
}

