/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContextOption;
import io.netty.internal.tcnative.CertificateCallback;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SniHostNameMatcher;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class ReferenceCountedOpenSslServerContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslServerContext.class);
    private static final byte[] ID = new byte[]{110, 101, 116, 116, 121};
    private final OpenSslServerSessionContext sessionContext;

    /*
     * WARNING - void declaration
     */
    ReferenceCountedOpenSslServerContext(X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, String keyStore, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        this((X509Certificate[])var1_1, (TrustManagerFactory)var2_2, (X509Certificate[])var3_3, key, keyPassword, keyManagerFactory, ciphers, cipherFilter, ReferenceCountedOpenSslServerContext.toNegotiator(apn), sessionCacheSize, sessionTimeout, clientAuth, protocols, startTls, enableOcsp, keyStore, resumptionController, options);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ReferenceCountedOpenSslServerContext(X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, Iterable<String> ciphers, CipherSuiteFilter cipherFilter, OpenSslApplicationProtocolNegotiator apn, long sessionCacheSize, long sessionTimeout, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, String keyStore, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, apn, 1, keyCertChain, clientAuth, protocols, startTls, null, enableOcsp, true, resumptionController, options);
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, (X509Certificate[])var1_1, (TrustManagerFactory)var2_3, (X509Certificate[])var3_4, key, keyPassword, keyManagerFactory, keyStore, sessionCacheSize, sessionTimeout, resumptionController);
            if (SERVER_ENABLE_SESSION_TICKET) {
                this.sessionContext.setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    public final OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - void declaration
     */
    static OpenSslServerSessionContext newSessionContext(ReferenceCountedOpenSslContext thiz, long ctx, OpenSslEngineMap engineMap, X509Certificate[] trustCertCollection, TrustManagerFactory trustManagerFactory, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword, KeyManagerFactory keyManagerFactory, String keyStore, long sessionCacheSize, long sessionTimeout, ResumptionController resumptionController) throws SSLException {
        OpenSslKeyMaterialProvider keyMaterialProvider = null;
        try {
            ReferenceCountedOpenSslContext referenceCountedOpenSslContext;
            Object manager;
            try {
                SSLContext.setVerify((long)ctx, (int)0, (int)10);
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    ObjectUtil.checkNotNull((Object)keyCertChain, (String)"keyCertChain");
                    ReferenceCountedOpenSslServerContext.setKeyMaterial(ctx, keyCertChain, key, keyPassword);
                } else {
                    if (keyManagerFactory == null) {
                        char[] keyPasswordChars = ReferenceCountedOpenSslServerContext.keyStorePassword(keyPassword);
                        KeyStore ks = ReferenceCountedOpenSslServerContext.buildKeyStore(keyCertChain, key, keyPasswordChars, keyStore);
                        keyManagerFactory = ks.aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init(ks, keyPasswordChars);
                    }
                    keyMaterialProvider = ReferenceCountedOpenSslServerContext.providerFor(keyManagerFactory, keyPassword);
                    SSLContext.setCertificateCallback((long)ctx, (CertificateCallback)new OpenSslServerCertificateCallback(engineMap, new OpenSslKeyMaterialManager(keyMaterialProvider)));
                }
            }
            catch (Exception e) {
                throw new SSLException("failed to set certificate and key", e);
            }
            try {
                if (trustCertCollection != null) {
                    trustManagerFactory = ReferenceCountedOpenSslServerContext.buildTrustManagerFactory(trustCertCollection, trustManagerFactory, keyStore);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                manager = ReferenceCountedOpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers(), resumptionController);
                ReferenceCountedOpenSslServerContext.setVerifyCallback(ctx, engineMap, (X509TrustManager)manager);
                X509Certificate[] issuers = manager.getAcceptedIssuers();
                if (issuers != null && issuers.length > 0) {
                    long bio = 0L;
                    try {
                        bio = ReferenceCountedOpenSslServerContext.toBIO(ByteBufAllocator.DEFAULT, issuers);
                        if (!SSLContext.setCACertificateBio((long)ctx, (long)bio)) {
                            throw new SSLException("unable to setup accepted issuers for trustmanager " + manager);
                        }
                    }
                    finally {
                        ReferenceCountedOpenSslServerContext.freeBio(bio);
                    }
                }
                if (PlatformDependent.javaVersion() >= 8) {
                    void var3_4;
                    void var1_3;
                    SSLContext.setSniHostnameMatcher((long)var1_3, (SniHostNameMatcher)new OpenSslSniHostnameMatcher((OpenSslEngineMap)var3_4));
                }
            }
            catch (SSLException sSLException) {
                manager = sSLException;
                throw sSLException;
            }
            catch (Exception e) {
                throw new SSLException("unable to setup trustmanager", e);
            }
            OpenSslServerSessionContext sessionContext = new OpenSslServerSessionContext(referenceCountedOpenSslContext, keyMaterialProvider);
            sessionContext.setSessionIdContext(ID);
            sessionContext.setSessionCacheEnabled(SERVER_ENABLE_SESSION_CACHE);
            if (sessionCacheSize > 0L) {
                sessionContext.setSessionCacheSize((int)Math.min(sessionCacheSize, Integer.MAX_VALUE));
            }
            if (sessionTimeout > 0L) {
                sessionContext.setSessionTimeout((int)Math.min(sessionTimeout, Integer.MAX_VALUE));
            }
            keyMaterialProvider = null;
            OpenSslServerSessionContext openSslServerSessionContext = sessionContext;
            return openSslServerSessionContext;
        }
        catch (Throwable throwable) {
            if (keyMaterialProvider != null) {
                keyMaterialProvider.destroy();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressJava6Requirement(reason="Guarded by java version check")
    private static void setVerifyCallback(long ctx, OpenSslEngineMap engineMap, X509TrustManager manager) {
        void var3_2;
        void var2_1;
        long l;
        if (ReferenceCountedOpenSslServerContext.useExtendedTrustManager(manager)) {
            SSLContext.setCertVerifyCallback((long)ctx, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(engineMap, (X509ExtendedTrustManager)manager));
            return;
        }
        SSLContext.setCertVerifyCallback((long)l, (CertificateVerifier)new TrustManagerVerifyCallback((OpenSslEngineMap)var2_1, (X509TrustManager)var3_2));
    }

    private static final class OpenSslSniHostnameMatcher
    implements SniHostNameMatcher {
        private final OpenSslEngineMap engineMap;

        /*
         * WARNING - void declaration
         */
        OpenSslSniHostnameMatcher(OpenSslEngineMap engineMap) {
            void var1_1;
            this.engineMap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean match(long ssl, String hostname) {
            void var1_1;
            ReferenceCountedOpenSslEngine engine = this.engineMap.get(ssl);
            if (engine != null) {
                void var3_2;
                return engine.checkSniHostnameMatch(var3_2.getBytes(CharsetUtil.UTF_8));
            }
            logger.warn("No ReferenceCountedOpenSslEngine found for SSL pointer: {}", (Object)((long)var1_1));
            return false;
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        /*
         * WARNING - void declaration
         */
        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap engineMap, X509ExtendedTrustManager manager) {
            super((OpenSslEngineMap)var1_1);
            void var2_2;
            void var1_1;
            this.manager = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void verify(ReferenceCountedOpenSslEngine engine, X509Certificate[] peerCerts, String auth) throws Exception {
            void var1_1;
            void var3_3;
            void var2_2;
            this.manager.checkClientTrusted((X509Certificate[])var2_2, (String)var3_3, (SSLEngine)var1_1);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        /*
         * WARNING - void declaration
         */
        TrustManagerVerifyCallback(OpenSslEngineMap engineMap, X509TrustManager manager) {
            super((OpenSslEngineMap)var1_1);
            void var2_2;
            void var1_1;
            this.manager = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void verify(ReferenceCountedOpenSslEngine engine, X509Certificate[] peerCerts, String auth) throws Exception {
            void var3_3;
            void var2_2;
            this.manager.checkClientTrusted((X509Certificate[])var2_2, (String)var3_3);
        }
    }

    private static final class OpenSslServerCertificateCallback
    implements CertificateCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        /*
         * WARNING - void declaration
         */
        OpenSslServerCertificateCallback(OpenSslEngineMap engineMap, OpenSslKeyMaterialManager keyManagerHolder) {
            void var2_2;
            void var1_1;
            this.engineMap = var1_1;
            this.keyManagerHolder = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void handle(long ssl, byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws Exception {
            ReferenceCountedOpenSslEngine engine = this.engineMap.get(ssl);
            if (engine == null) {
                return;
            }
            try {
                this.keyManagerHolder.setKeyMaterialServerSide(engine);
                return;
            }
            catch (Throwable cause) {
                void var2_5;
                void var1_2;
                var1_2.initHandshakeException(cause);
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new SSLException((Throwable)var2_5);
            }
        }
    }
}

