/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.AsyncRunnable;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.ExtendedOpenSslSession;
import io.netty.handler.ssl.Java7SslParametersUtils;
import io.netty.handler.ssl.Java8SslUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslSession;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionId;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SignatureAlgorithmConverter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.util.LazyJavaxX509Certificate;
import io.netty.handler.ssl.util.LazyX509Certificate;
import io.netty.internal.tcnative.AsyncTask;
import io.netty.internal.tcnative.Buffer;
import io.netty.internal.tcnative.SSL;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.security.cert.X509Certificate;

public class ReferenceCountedOpenSslEngine
extends SSLEngine
implements ApplicationProtocolAccessor,
ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslEngine.class);
    private static final ResourceLeakDetector<ReferenceCountedOpenSslEngine> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslEngine.class);
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV2 = 0;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV3 = 1;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1 = 2;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_1 = 3;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_2 = 4;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_3 = 5;
    private static final int[] OPENSSL_OP_NO_PROTOCOLS = new int[]{SSL.SSL_OP_NO_SSLv2, SSL.SSL_OP_NO_SSLv3, SSL.SSL_OP_NO_TLSv1, SSL.SSL_OP_NO_TLSv1_1, SSL.SSL_OP_NO_TLSv1_2, SSL.SSL_OP_NO_TLSv1_3};
    static final int MAX_PLAINTEXT_LENGTH = SSL.SSL_MAX_PLAINTEXT_LENGTH;
    static final int MAX_RECORD_SIZE = SSL.SSL_MAX_RECORD_LENGTH;
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private long ssl;
    private long networkBIO;
    private HandshakeState handshakeState = HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile boolean destroyed;
    private volatile String applicationProtocol;
    private volatile boolean needTask;
    private boolean hasTLSv13Cipher;
    private boolean sessionSet;
    private final ResourceLeakTracker<ReferenceCountedOpenSslEngine> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(this){
        final /* synthetic */ ReferenceCountedOpenSslEngine this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ReferenceCounted touch(Object hint) {
            if (this.this$0.leak != null) {
                void var1_1;
                this.this$0.leak.record((Object)var1_1);
            }
            return this.this$0;
        }

        /*
         * WARNING - void declaration
         */
        protected void deallocate() {
            this.this$0.shutdown();
            if (this.this$0.leak != null) {
                void var1_1;
                boolean closed = this.this$0.leak.close((Object)this.this$0);
                assert (var1_1 != false);
            }
            this.this$0.parentContext.release();
        }
    };
    private final Set<String> enabledProtocols = new LinkedHashSet<String>();
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private String endpointIdentificationAlgorithm;
    private Object algorithmConstraints;
    private List<String> sniHostNames;
    private volatile Collection<?> matchers;
    private boolean isInboundDone;
    private boolean outboundClosed;
    final boolean jdkCompatibilityMode;
    private final boolean clientMode;
    final ByteBufAllocator alloc;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final ReferenceCountedOpenSslContext parentContext;
    private final OpenSslSession session;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final boolean enableOcsp;
    private int maxWrapOverhead;
    private int maxWrapBufferSize;
    private Throwable pendingException;
    private static final X509Certificate[] JAVAX_CERTS_NOT_SUPPORTED = new X509Certificate[0];

    /*
     * WARNING - void declaration
     */
    ReferenceCountedOpenSslEngine(ReferenceCountedOpenSslContext context, ByteBufAllocator alloc, String peerHost, int peerPort, boolean jdkCompatibilityMode, boolean leakDetection, String endpointIdentificationAlgorithm) {
        super(peerHost, peerPort);
        void var1_1;
        long finalSsl;
        OpenSsl.ensureAvailability();
        this.engineMap = context.engineMap;
        this.enableOcsp = context.enableOcsp;
        this.jdkCompatibilityMode = jdkCompatibilityMode;
        this.alloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)alloc, (String)"alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)((SslContext)context).applicationProtocolNegotiator();
        this.clientMode = ((SslContext)context).isClient();
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
        this.session = PlatformDependent.javaVersion() >= 7 ? new ExtendedOpenSslSession(this, new DefaultOpenSslSession(context.sessionContext())){
            private String[] peerSupportedSignatureAlgorithms;
            private List requestedServerNames;
            final /* synthetic */ ReferenceCountedOpenSslEngine this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((OpenSslSession)var2_2);
            }

            @Override
            public List getRequestedServerNames() {
                if (this.this$0.clientMode) {
                    return Java8SslUtils.getSniHostNames(this.this$0.sniHostNames);
                }
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
                synchronized (referenceCountedOpenSslEngine) {
                    if (this.requestedServerNames == null) {
                        String string;
                        this.requestedServerNames = this.this$0.isDestroyed() ? Collections.emptyList() : ((string = SSL.getSniHostname((long)this.this$0.ssl)) == null ? Collections.emptyList() : Java8SslUtils.getSniHostName(SSL.getSniHostname((long)this.this$0.ssl).getBytes(CharsetUtil.UTF_8)));
                    }
                    return this.requestedServerNames;
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String[] getPeerSupportedSignatureAlgorithms() {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
                synchronized (referenceCountedOpenSslEngine) {
                    if (this.peerSupportedSignatureAlgorithms == null) {
                        if (this.this$0.isDestroyed()) {
                            this.peerSupportedSignatureAlgorithms = EmptyArrays.EMPTY_STRINGS;
                        } else {
                            String[] algs = SSL.getSigAlgs((long)this.this$0.ssl);
                            if (algs == null) {
                                this.peerSupportedSignatureAlgorithms = EmptyArrays.EMPTY_STRINGS;
                            } else {
                                void var3_4;
                                void var2_2;
                                LinkedHashSet<String> algorithmList = new LinkedHashSet<String>(algs.length);
                                for (void var6_7 : var2_2) {
                                    String converted = SignatureAlgorithmConverter.toJavaName((String)var6_7);
                                    if (converted == null) continue;
                                    algorithmList.add(converted);
                                }
                                this.peerSupportedSignatureAlgorithms = var3_4.toArray(EmptyArrays.EMPTY_STRINGS);
                            }
                        }
                    }
                    return (String[])this.peerSupportedSignatureAlgorithms.clone();
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public List<byte[]> getStatusResponses() {
                void var1_1;
                byte[] ocspResponse = null;
                if (this.this$0.enableOcsp && this.this$0.clientMode) {
                    ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
                    synchronized (referenceCountedOpenSslEngine) {
                        if (!this.this$0.isDestroyed()) {
                            ocspResponse = SSL.getOcspResponse((long)this.this$0.ssl);
                        }
                    }
                }
                if (ocspResponse == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(var1_1);
            }
        } : new DefaultOpenSslSession(context.sessionContext());
        if (!context.sessionContext().useKeyManager()) {
            this.session.setLocalCertificate(context.keyCertChain);
        }
        Lock readerLock = context.ctxLock.readLock();
        readerLock.lock();
        try {
            finalSsl = SSL.newSSL((long)context.ctx, (!((SslContext)context).isClient() ? 1 : 0) != 0);
        }
        finally {
            readerLock.unlock();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            this.ssl = finalSsl;
            try {
                this.networkBIO = SSL.bioNewByteBuffer((long)this.ssl, (int)context.getBioNonApplicationBufferSize());
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine2 = this;
                referenceCountedOpenSslEngine2.setClientAuth(referenceCountedOpenSslEngine2.clientMode ? ClientAuth.NONE : context.clientAuth);
                assert (context.protocols != null);
                this.hasTLSv13Cipher = context.hasTLSv13Cipher;
                this.setEnabledProtocols(context.protocols);
                if (this.clientMode && SslUtils.isValidHostNameForSNI(peerHost) && (PlatformDependent.javaVersion() < 8 || Java8SslUtils.isValidHostNameForSNI(peerHost))) {
                    void var3_6;
                    SSL.setTlsExtHostName((long)this.ssl, (String)peerHost);
                    this.sniHostNames = Collections.singletonList(var3_6);
                }
                if (this.enableOcsp) {
                    SSL.enableOcsp((long)this.ssl);
                }
                if (!jdkCompatibilityMode) {
                    SSL.setMode((long)this.ssl, (int)(SSL.getMode((long)this.ssl) | SSL.SSL_MODE_ENABLE_PARTIAL_WRITE));
                }
                if (ReferenceCountedOpenSslEngine.isProtocolEnabled(SSL.getOptions((long)this.ssl), SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3") && (readerLock = this.clientMode ? ReferenceCountedOpenSslContext.CLIENT_ENABLE_SESSION_TICKET_TLSV13 : ReferenceCountedOpenSslContext.SERVER_ENABLE_SESSION_TICKET_TLSV13)) {
                    SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_NO_TICKET);
                }
                if (OpenSsl.isBoringSSL() && this.clientMode) {
                    SSL.setRenegotiateMode((long)this.ssl, (int)SSL.SSL_RENEGOTIATE_ONCE);
                }
                this.calculateMaxWrapOverhead();
                this.configureEndpointVerification(endpointIdentificationAlgorithm);
            }
            catch (Throwable cause) {
                void var2_5;
                this.shutdown();
                PlatformDependent.throwException((Throwable)var2_5);
            }
        }
        this.parentContext = var1_1;
        this.parentContext.retain();
        this.leak = leakDetection ? leakDetector.track((Object)this) : null;
    }

    final synchronized String[] authMethods() {
        if (this.isDestroyed()) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        return SSL.authenticationMethods((long)this.ssl);
    }

    /*
     * WARNING - void declaration
     */
    final boolean setKeyMaterial(OpenSslKeyMaterial keyMaterial) throws Exception {
        void var1_1;
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return false;
            }
            SSL.setKeyMaterial((long)this.ssl, (long)keyMaterial.certificateChainAddress(), (long)keyMaterial.privateKeyAddress());
        }
        this.session.setLocalCertificate(var1_1.certificateChain());
        return true;
    }

    final synchronized SecretKeySpec masterKey() {
        if (this.isDestroyed()) {
            return null;
        }
        return new SecretKeySpec(SSL.getMasterKey((long)this.ssl), "AES");
    }

    synchronized boolean isSessionReused() {
        if (this.isDestroyed()) {
            return false;
        }
        return SSL.isSessionReused((long)this.ssl);
    }

    /*
     * WARNING - void declaration
     */
    public void setOcspResponse(byte[] response) {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (this.clientMode) {
            throw new IllegalStateException("Not a server SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (!this.isDestroyed()) {
                void var1_1;
                SSL.setOcspResponse((long)this.ssl, (byte[])var1_1);
            }
            return;
        }
    }

    public byte[] getOcspResponse() {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (!this.clientMode) {
            throw new IllegalStateException("Not a client SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return EmptyArrays.EMPTY_BYTES;
            }
            return SSL.getOcspResponse((long)this.ssl);
        }
    }

    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ReferenceCounted retain(int increment) {
        void var1_1;
        this.refCnt.retain((int)var1_1);
        return this;
    }

    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ReferenceCounted touch(Object hint) {
        void var1_1;
        this.refCnt.touch((Object)var1_1);
        return this;
    }

    public final boolean release() {
        return this.refCnt.release();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean release(int decrement) {
        void var1_1;
        return this.refCnt.release((int)var1_1);
    }

    @Override
    public String getApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public final synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public final synchronized long sslPointer() {
        return this.ssl;
    }

    public final synchronized void shutdown() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.engineMap != null) {
                this.engineMap.remove(this.ssl);
            }
            SSL.freeSSL((long)this.ssl);
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            referenceCountedOpenSslEngine.networkBIO = 0L;
            referenceCountedOpenSslEngine.ssl = 0L;
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine2 = this;
            referenceCountedOpenSslEngine2.outboundClosed = true;
            referenceCountedOpenSslEngine2.isInboundDone = true;
        }
        SSL.clearError();
    }

    /*
     * WARNING - void declaration
     */
    private int writePlaintextData(ByteBuffer src, int len) {
        void var2_3;
        int sslWrote;
        int pos = src.position();
        int limit = src.limit();
        if (src.isDirect()) {
            sslWrote = SSL.writeToSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(src) + (long)pos), (int)len);
            if (sslWrote > 0) {
                src.position(pos + sslWrote);
            }
        } else {
            ByteBuf buf = this.alloc.directBuffer(sslWrote);
            try {
                src.limit(pos + sslWrote);
                buf.setBytes(0, src);
                src.limit(limit);
                sslWrote = SSL.writeToSSL((long)this.ssl, (long)OpenSsl.memoryAddress(buf), (int)sslWrote);
                if (sslWrote > 0) {
                    src.position(pos + sslWrote);
                } else {
                    void var3_4;
                    void var1_1;
                    var1_1.position((int)var3_4);
                }
            }
            finally {
                buf.release();
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void bioSetFd(int fd) {
        if (!this.isDestroyed()) {
            void var1_1;
            SSL.bioSetFd((long)this.ssl, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuf writeEncryptedData(ByteBuffer src, int len) throws SSLException {
        int pos = src.position();
        if (src.isDirect()) {
            SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(src) + (long)pos), (int)len, (boolean)false);
        } else {
            ByteBuf buf = this.alloc.directBuffer(len);
            try {
                void var2_2;
                void var1_1;
                void var3_3;
                int limit = src.limit();
                src.limit(pos + len);
                buf.writeBytes(src);
                src.position((int)var3_3);
                var1_1.limit(limit);
                SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(buf), (int)var2_2, (boolean)false);
                return buf;
            }
            catch (Throwable cause) {
                buf.release();
                PlatformDependent.throwException((Throwable)cause);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int readPlaintextData(ByteBuffer dst) throws SSLException {
        void var2_4;
        int sslRead;
        int pos = dst.position();
        if (dst.isDirect()) {
            sslRead = SSL.readFromSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(dst) + (long)pos), (int)(dst.limit() - pos));
            if (sslRead > 0) {
                dst.position(pos + sslRead);
            }
        } else {
            int limit = dst.limit();
            int len = Math.min(this.maxEncryptedPacketLength0(), limit - pos);
            ByteBuf buf = this.alloc.directBuffer(len);
            try {
                sslRead = SSL.readFromSSL((long)this.ssl, (long)OpenSsl.memoryAddress(buf), (int)len);
                if (sslRead > 0) {
                    void var1_1;
                    void var3_3;
                    dst.limit((int)(var3_3 + sslRead));
                    ByteBuf byteBuf = buf;
                    byteBuf.getBytes(byteBuf.readerIndex(), dst);
                    var1_1.limit(limit);
                }
            }
            finally {
                buf.release();
            }
        }
        return (int)var2_4;
    }

    final synchronized int maxWrapOverhead() {
        return this.maxWrapOverhead;
    }

    final synchronized int maxEncryptedPacketLength() {
        return this.maxEncryptedPacketLength0();
    }

    final int maxEncryptedPacketLength0() {
        return this.maxWrapOverhead + MAX_PLAINTEXT_LENGTH;
    }

    /*
     * WARNING - void declaration
     */
    final int calculateMaxLengthForWrap(int plaintextLength, int numComponents) {
        void var2_2;
        void var1_1;
        return (int)Math.min((long)this.maxWrapBufferSize, (long)var1_1 + (long)this.maxWrapOverhead * (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final int calculateOutNetBufSize(int plaintextLength, int numComponents) {
        void var2_2;
        void var1_1;
        return (int)Math.min(Integer.MAX_VALUE, (long)var1_1 + (long)this.maxWrapOverhead * (long)var2_2);
    }

    final synchronized int sslPending() {
        return this.sslPending0();
    }

    private void calculateMaxWrapOverhead() {
        this.maxWrapOverhead = SSL.getMaxWrapOverhead((long)this.ssl);
        this.maxWrapBufferSize = this.jdkCompatibilityMode ? this.maxEncryptedPacketLength0() : this.maxEncryptedPacketLength0() << 4;
    }

    private int sslPending0() {
        if (this.handshakeState != HandshakeState.FINISHED) {
            return 0;
        }
        return SSL.sslPending((long)this.ssl);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBytesAvailableEnoughForWrap(int bytesAvailable, int plaintextLength, int numComponents) {
        void var2_2;
        void var3_3;
        return (long)bytesAvailable - (long)this.maxWrapOverhead * (long)var3_3 >= (long)var2_2;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[TRYBLOCK]], but top level block is 47[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult newResult(SSLEngineResult.HandshakeStatus hs, int bytesConsumed, int bytesProduced) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.newResult(SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult newResult(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus hs, int bytesConsumed, int bytesProduced) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.isOutboundDone()) {
            if (this.isInboundDone()) {
                hs = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                this.shutdown();
            }
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, hs, bytesConsumed, bytesProduced);
        }
        if (hs == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.needTask = true;
        }
        return new SSLEngineResult((SSLEngineResult.Status)var1_1, (SSLEngineResult.HandshakeStatus)var2_2, (int)var3_3, bytesProduced);
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus hs, int bytesConsumed, int bytesProduced) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        return referenceCountedOpenSslEngine.newResult(referenceCountedOpenSslEngine.mayFinishHandshake((SSLEngineResult.HandshakeStatus)var1_1, bytesConsumed, bytesProduced), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus hs, int bytesConsumed, int bytesProduced) throws SSLException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.newResult((SSLEngineResult.Status)var1_1, this.mayFinishHandshake((SSLEngineResult.HandshakeStatus)var2_2, bytesConsumed, bytesProduced), (int)var3_3, bytesProduced);
    }

    /*
     * WARNING - void declaration
     */
    private SSLException shutdownWithError(String operations, int sslError) {
        void var2_2;
        void var1_1;
        return this.shutdownWithError((String)var1_1, (int)var2_2, SSL.getLastErrorNumber());
    }

    /*
     * WARNING - void declaration
     */
    private SSLException shutdownWithError(String operation, int sslError, int error) {
        void var3_3;
        if (logger.isDebugEnabled()) {
            void var2_2;
            void var1_1;
            String errorString = SSL.getErrorString((long)error);
            logger.debug("{} failed with {}: OpenSSL error: {} {}", new Object[]{var1_1, (int)var2_2, error, errorString});
        }
        this.shutdown();
        SSLException exception = this.newSSLExceptionForError((int)var3_3);
        if (this.pendingException != null) {
            exception.initCause(this.pendingException);
            this.pendingException = null;
        }
        return exception;
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult handleUnwrapException(int bytesConsumed, int bytesProduced, SSLException e) throws SSLException {
        void var3_3;
        int lastError = SSL.getLastErrorNumber();
        if (lastError != 0) {
            void var2_2;
            void var1_1;
            return this.sslReadErrorResult(SSL.SSL_ERROR_SSL, lastError, (int)var1_1, (int)var2_2);
        }
        throw var3_3;
    }

    /*
     * Exception decompiling
     */
    public final SSLEngineResult unwrap(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 33[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private boolean needWrapAgain(int stackError) {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            if (this.pendingException == null) {
                this.pendingException = this.newSSLExceptionForError(stackError);
            } else if (ReferenceCountedOpenSslEngine.shouldAddSuppressed(this.pendingException, stackError)) {
                void var1_1;
                ThrowableUtil.addSuppressed((Throwable)this.pendingException, (Throwable)this.newSSLExceptionForError((int)var1_1));
            }
            SSL.clearError();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private SSLException newSSLExceptionForError(int stackError) {
        void var1_1;
        void var2_2;
        String message = SSL.getErrorString((long)stackError);
        if (this.handshakeState == HandshakeState.FINISHED) {
            return new OpenSslException(message, stackError);
        }
        return new OpenSslHandshakeException((String)var2_2, (int)var1_1);
    }

    private static boolean shouldAddSuppressed(Throwable target, int errorCode) {
        for (Throwable suppressed : ThrowableUtil.getSuppressed((Throwable)target)) {
            if (!(suppressed instanceof NativeSslException) || ((NativeSslException)((Object)suppressed)).errorCode() != errorCode) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult sslReadErrorResult(int error, int stackError, int bytesConsumed, int bytesProduced) throws SSLException {
        void var2_2;
        void var1_1;
        if (this.needWrapAgain(stackError)) {
            void var3_3;
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, (int)var3_3, bytesProduced);
        }
        throw this.shutdownWithError("SSL_read", (int)var1_1, (int)var2_2);
    }

    private void closeAll() throws SSLException {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegotiation() throws SSLHandshakeException {
        if (!this.isDestroyed() && (!this.clientMode && SSL.getHandshakeCount((long)this.ssl) > 1 || this.clientMode && SSL.getHandshakeCount((long)this.ssl) > 2) && !"TLSv1.3".equals(this.session.getProtocol()) && this.handshakeState == HandshakeState.FINISHED) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotiation not allowed");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final SSLEngineResult unwrap(ByteBuffer[] srcs, ByteBuffer[] dsts) throws SSLException {
        void var2_2;
        void var1_1;
        return this.unwrap(srcs, 0, ((void)var1_1).length, dsts, 0, ((void)var2_2).length);
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer[] singleSrcBuffer(ByteBuffer src) {
        void var1_1;
        this.singleSrcBuffer[0] = var1_1;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer[] singleDstBuffer(ByteBuffer src) {
        void var1_1;
        this.singleDstBuffer[0] = var1_1;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        try {
            void var3_4;
            void var2_3;
            SSLEngineResult sSLEngineResult;
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            sSLEngineResult = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)((Object)sSLEngineResult)), 0, 1, (ByteBuffer[])var2_3, (int)var3_4, length);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        try {
            void var2_3;
            SSLEngineResult sSLEngineResult;
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            sSLEngineResult = referenceCountedOpenSslEngine.wrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)((Object)sSLEngineResult)), (ByteBuffer)var2_3);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        try {
            void var2_3;
            SSLEngineResult sSLEngineResult;
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            sSLEngineResult = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)((Object)sSLEngineResult)), this.singleDstBuffer((ByteBuffer)var2_3));
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        try {
            void var2_3;
            SSLEngineResult sSLEngineResult;
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            sSLEngineResult = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)((Object)sSLEngineResult)), (ByteBuffer[])var2_3);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void runAndResetNeedTask(Runnable task) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            try {
                void var1_1;
                if (this.isDestroyed()) {
                    return;
                }
                var1_1.run();
                if (this.handshakeState != HandshakeState.FINISHED && !this.isDestroyed() && SSL.doHandshake((long)this.ssl) <= 0) {
                    SSL.clearError();
                }
            }
            finally {
                this.needTask = false;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized Runnable getDelegatedTask() {
        void var1_1;
        if (this.isDestroyed()) {
            return null;
        }
        Runnable task = SSL.getTask((long)this.ssl);
        if (task == null) {
            return null;
        }
        if (task instanceof AsyncTask) {
            return new AsyncTaskDecorator((AsyncTask)task);
        }
        return new TaskDecorator(this, (Runnable)var1_1);
    }

    @Override
    public final synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        if (this.isOutboundDone()) {
            this.shutdown();
        }
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public final synchronized boolean isInboundDone() {
        return this.isInboundDone;
    }

    @Override
    public final synchronized void closeOutbound() {
        if (this.outboundClosed) {
            return;
        }
        this.outboundClosed = true;
        if (this.handshakeState != HandshakeState.NOT_STARTED && !this.isDestroyed()) {
            int n = SSL.getShutdown((long)this.ssl);
            if ((n & SSL.SSL_SENT_SHUTDOWN) != SSL.SSL_SENT_SHUTDOWN) {
                this.doSSLShutdown();
            }
            return;
        }
        this.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private boolean doSSLShutdown() {
        if (SSL.isInInit((long)this.ssl) != 0) {
            return false;
        }
        int err = SSL.shutdownSSL((long)this.ssl);
        if (err < 0) {
            int sslErr = SSL.getError((long)this.ssl, (int)err);
            if (sslErr == SSL.SSL_ERROR_SYSCALL || sslErr == SSL.SSL_ERROR_SSL) {
                if (logger.isDebugEnabled()) {
                    void var1_1;
                    int error = SSL.getLastErrorNumber();
                    logger.debug("SSL_shutdown failed: OpenSSL error: {} {}", (Object)error, (Object)SSL.getErrorString((long)((long)var1_1)));
                }
                this.shutdown();
                return false;
            }
            SSL.clearError();
        }
        return true;
    }

    @Override
    public final synchronized boolean isOutboundDone() {
        return this.outboundClosed && (this.networkBIO == 0L || SSL.bioLengthNonApplication((long)this.networkBIO) == 0);
    }

    @Override
    public final String[] getSupportedCipherSuites() {
        return OpenSsl.AVAILABLE_CIPHER_SUITES.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getEnabledCipherSuites() {
        boolean tls13Enabled;
        String[] extraCiphers;
        String[] enabled;
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (!this.isDestroyed()) {
                enabled = SSL.getCiphers((long)this.ssl);
                int n = SSL.getOptions((long)this.ssl);
                if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
                    extraCiphers = OpenSsl.EXTRA_SUPPORTED_TLS_1_3_CIPHERS;
                    tls13Enabled = true;
                } else {
                    extraCiphers = EmptyArrays.EMPTY_STRINGS;
                    tls13Enabled = false;
                }
            } else {
                return EmptyArrays.EMPTY_STRINGS;
            }
        }
        if (enabled == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        LinkedHashSet<String> enabledSet = new LinkedHashSet<String>(enabled.length + extraCiphers.length);
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine2 = this;
        synchronized (referenceCountedOpenSslEngine2) {
            void var1_5;
            for (int i = 0; i < enabled.length; ++i) {
                String cipher;
                String mapped = this.toJavaCipherSuite(enabled[i]);
                String string = cipher = mapped == null ? enabled[i] : mapped;
                if ((!tls13Enabled || !OpenSsl.isTlsv13Supported()) && SslUtils.isTLSv13Cipher(cipher)) continue;
                enabledSet.add(cipher);
            }
            Collections.addAll(enabledSet, var1_5);
        }
        return enabledSet.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setEnabledCipherSuites(String[] cipherSuites) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine;
        ObjectUtil.checkNotNull((Object)cipherSuites, (String)"cipherSuites");
        StringBuilder buf = new StringBuilder();
        StringBuilder bufTLSv13 = new StringBuilder();
        CipherSuiteConverter.convertToCipherStrings(Arrays.asList(cipherSuites), buf, bufTLSv13, OpenSsl.isBoringSSL());
        String cipherSuiteSpec = buf.toString();
        String cipherSuiteSpecTLSv13 = ((StringBuilder)((Object)referenceCountedOpenSslEngine)).toString();
        if (!OpenSsl.isTlsv13Supported() && !cipherSuiteSpecTLSv13.isEmpty()) {
            throw new IllegalArgumentException("TLSv1.3 is not supported by this java version.");
        }
        referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            boolean bl = this.hasTLSv13Cipher = !cipherSuiteSpecTLSv13.isEmpty();
            if (!this.isDestroyed()) {
                try {
                    void var2_3;
                    SSL.setCipherSuites((long)this.ssl, (String)cipherSuiteSpec, (boolean)false);
                    if (OpenSsl.isTlsv13Supported()) {
                        SSL.setCipherSuites((long)this.ssl, (String)OpenSsl.checkTls13Ciphers(logger, cipherSuiteSpecTLSv13), (boolean)true);
                    }
                    HashSet<String> protocols = new HashSet<String>(this.enabledProtocols);
                    if (cipherSuiteSpec.isEmpty()) {
                        protocols.remove("TLSv1");
                        protocols.remove("TLSv1.1");
                        protocols.remove("TLSv1.2");
                        protocols.remove("SSLv3");
                        protocols.remove("SSLv2");
                        protocols.remove("SSLv2Hello");
                    }
                    if (var2_3.isEmpty()) {
                        protocols.remove("TLSv1.3");
                    }
                    this.setEnabledProtocols0(protocols.toArray(EmptyArrays.EMPTY_STRINGS), !this.hasTLSv13Cipher);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to enable cipher suites: " + cipherSuiteSpec, e);
                }
            } else {
                void var1_1;
                throw new IllegalStateException("failed to enable cipher suites: " + (String)var1_1);
            }
            return;
        }
    }

    @Override
    public final String[] getSupportedProtocols() {
        return OpenSsl.SUPPORTED_PROTOCOLS_SET.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    @Override
    public final String[] getEnabledProtocols() {
        return this.enabledProtocols.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isProtocolEnabled(int opts, int disableMask, String protocolString) {
        void var2_2;
        void var1_1;
        return (opts & var1_1) == 0 && OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setEnabledProtocols(String[] protocols) {
        ObjectUtil.checkNotNullWithIAE((Object)protocols, (String)"protocols");
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            void var1_1;
            this.enabledProtocols.clear();
            this.enabledProtocols.add("SSLv2Hello");
            Collections.addAll(this.enabledProtocols, protocols);
            this.setEnabledProtocols0((String[])var1_1, !this.hasTLSv13Cipher);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setEnabledProtocols0(String[] protocols, boolean explicitDisableTLSv13) {
        void var1_1;
        assert (Thread.holdsLock(this));
        int minProtocolIndex = OPENSSL_OP_NO_PROTOCOLS.length;
        int maxProtocolIndex = 0;
        String[] stringArray = protocols;
        int n = protocols.length;
        for (int i = 0; i < n; ++i) {
            String p = stringArray[i];
            if (!OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(p)) {
                throw new IllegalArgumentException("Protocol " + p + " is not supported.");
            }
            if (p.equals("SSLv2")) {
                if (minProtocolIndex > 0) {
                    minProtocolIndex = 0;
                }
                if (maxProtocolIndex >= 0) continue;
                maxProtocolIndex = 0;
                continue;
            }
            if (p.equals("SSLv3")) {
                if (minProtocolIndex > 1) {
                    minProtocolIndex = 1;
                }
                if (maxProtocolIndex > 0) continue;
                maxProtocolIndex = 1;
                continue;
            }
            if (p.equals("TLSv1")) {
                if (minProtocolIndex > 2) {
                    minProtocolIndex = 2;
                }
                if (maxProtocolIndex >= 2) continue;
                maxProtocolIndex = 2;
                continue;
            }
            if (p.equals("TLSv1.1")) {
                if (minProtocolIndex > 3) {
                    minProtocolIndex = 3;
                }
                if (maxProtocolIndex >= 3) continue;
                maxProtocolIndex = 3;
                continue;
            }
            if (p.equals("TLSv1.2")) {
                if (minProtocolIndex > 4) {
                    minProtocolIndex = 4;
                }
                if (maxProtocolIndex >= 4) continue;
                maxProtocolIndex = 4;
                continue;
            }
            if (explicitDisableTLSv13 || !p.equals("TLSv1.3")) continue;
            if (minProtocolIndex > 5) {
                minProtocolIndex = 5;
            }
            if (maxProtocolIndex >= 5) continue;
            maxProtocolIndex = 5;
        }
        if (!this.isDestroyed()) {
            int i;
            SSL.clearOptions((long)this.ssl, (int)(SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2 | SSL.SSL_OP_NO_TLSv1_3));
            int opts = 0;
            for (i = 0; i < minProtocolIndex; ++i) {
                opts |= OPENSSL_OP_NO_PROTOCOLS[i];
            }
            assert (maxProtocolIndex != Integer.MAX_VALUE);
            for (i = maxProtocolIndex + 1; i < OPENSSL_OP_NO_PROTOCOLS.length; ++i) {
                opts |= OPENSSL_OP_NO_PROTOCOLS[i];
            }
            SSL.setOptions((long)this.ssl, (int)opts);
            return;
        }
        throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(var1_1));
    }

    @Override
    public final SSLSession getSession() {
        return this.session;
    }

    @Override
    public final synchronized void beginHandshake() throws SSLException {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed();
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                this.calculateMaxWrapOverhead();
                return;
            }
            case STARTED_EXPLICITLY: {
                return;
            }
            case FINISHED: {
                throw new SSLException("renegotiation unsupported");
            }
            case NOT_STARTED: {
                this.handshakeState = HandshakeState.STARTED_EXPLICITLY;
                if (this.handshake() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.needTask = true;
                }
                this.calculateMaxWrapOverhead();
                return;
            }
        }
        throw new Error();
    }

    private void checkEngineClosed() throws SSLException {
        if (this.isDestroyed()) {
            throw new SSLException("engine closed");
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int pendingStatus) {
        if (pendingStatus > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private static boolean isEmpty(Object[] arr) {
        Object[] objectArray;
        return arr == null || objectArray.length == 0;
    }

    private static boolean isEmpty(byte[] cert) {
        byte[] byArray;
        return cert == null || byArray.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult.HandshakeStatus handshakeException() throws SSLException {
        void var2_2;
        void var1_1;
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        Throwable exception = this.pendingException;
        assert (exception != null);
        this.pendingException = null;
        this.shutdown();
        if (exception instanceof SSLHandshakeException) {
            throw (SSLHandshakeException)exception;
        }
        SSLHandshakeException e = new SSLHandshakeException("General OpenSslEngine problem");
        e.initCause((Throwable)var1_1);
        throw var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final void initHandshakeException(Throwable cause) {
        void var1_1;
        if (this.pendingException == null) {
            this.pendingException = cause;
            return;
        }
        ThrowableUtil.addSuppressed((Throwable)this.pendingException, (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult.HandshakeStatus handshake() throws SSLException {
        int code;
        if (this.needTask) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.handshakeState == HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed();
        if (this.pendingException != null) {
            if (SSL.doHandshake((long)this.ssl) <= 0) {
                SSL.clearError();
            }
            return this.handshakeException();
        }
        this.engineMap.add(this);
        if (!this.sessionSet) {
            if (!this.parentContext.sessionContext().setSessionFromCache(this.ssl, this.session, this.getPeerHost(), this.getPeerPort())) {
                this.session.prepareHandshake();
            }
            this.sessionSet = true;
        }
        if ((code = SSL.doHandshake((long)this.ssl)) <= 0) {
            void var1_1;
            int sslError = SSL.getError((long)this.ssl, (int)code);
            if (sslError == SSL.SSL_ERROR_WANT_READ || sslError == SSL.SSL_ERROR_WANT_WRITE) {
                return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
            }
            if (sslError == SSL.SSL_ERROR_WANT_X509_LOOKUP || sslError == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || sslError == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            if (this.needWrapAgain(SSL.getLastErrorNumber())) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.pendingException != null) {
                return this.handshakeException();
            }
            throw this.shutdownWithError("SSL_do_handshake", (int)var1_1);
        }
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        this.session.handshakeFinished(SSL.getSessionId((long)this.ssl), SSL.getCipherForSSL((long)this.ssl), SSL.getVersion((long)this.ssl), SSL.getPeerCertificate((long)this.ssl), SSL.getPeerCertChain((long)this.ssl), SSL.getTime((long)this.ssl) * 1000L, this.parentContext.sessionTimeout() * 1000L);
        this.selectApplicationProtocol();
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus hs, int bytesConsumed, int bytesProduced) throws SSLException {
        void var1_1;
        void var2_2;
        void var3_3;
        if (hs == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && var3_3 > 0 || hs == SSLEngineResult.HandshakeStatus.NEED_WRAP && var2_2 > 0) {
            return this.handshake();
        }
        return this.mayFinishHandshake(var1_1 != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED);
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus status) throws SSLException {
        void var1_1;
        if (status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.handshakeState != HandshakeState.FINISHED) {
                return this.handshake();
            }
            if (!this.isDestroyed() && SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
        }
        return var1_1;
    }

    @Override
    public final synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    /*
     * WARNING - void declaration
     */
    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int pending) {
        if (this.needPendingStatus()) {
            void var1_1;
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus((int)var1_1);
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != HandshakeState.NOT_STARTED && !this.isDestroyed() && (this.handshakeState != HandshakeState.FINISHED || this.isInboundDone() || this.isOutboundDone());
    }

    /*
     * WARNING - void declaration
     */
    private String toJavaCipherSuite(String openSslCipherSuite) {
        void var1_1;
        if (openSslCipherSuite == null) {
            return null;
        }
        String string = SSL.getVersion((long)this.ssl);
        String prefix = ReferenceCountedOpenSslEngine.toJavaCipherSuitePrefix(string);
        return CipherSuiteConverter.toJava((String)var1_1, string);
    }

    /*
     * WARNING - void declaration
     */
    private static String toJavaCipherSuitePrefix(String protocolVersion) {
        void var0_1;
        String c22;
        char c22 = protocolVersion == null || protocolVersion.isEmpty() ? (char)'\u0000' : c22.charAt(0);
        switch (var0_1) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public final void setUseClientMode(boolean clientMode) {
        if (clientMode != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setNeedClientAuth(boolean b) {
        void var1_1;
        this.setClientAuth(var1_1 != false ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    @Override
    public final boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setWantClientAuth(boolean b) {
        void var1_1;
        this.setClientAuth(var1_1 != false ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    @Override
    public final boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void setVerify(int verifyMode, int depth) {
        if (!this.isDestroyed()) {
            void var2_2;
            void var1_1;
            SSL.setVerify((long)this.ssl, (int)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setClientAuth(ClientAuth mode) {
        if (this.clientMode) {
            return;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            void var1_1;
            if (this.clientAuth == mode) {
                return;
            }
            if (!this.isDestroyed()) {
                switch (mode) {
                    case NONE: {
                        SSL.setVerify((long)this.ssl, (int)0, (int)10);
                        break;
                    }
                    case REQUIRE: {
                        SSL.setVerify((long)this.ssl, (int)2, (int)10);
                        break;
                    }
                    case OPTIONAL: {
                        SSL.setVerify((long)this.ssl, (int)1, (int)10);
                        break;
                    }
                    default: {
                        throw new Error(mode.toString());
                    }
                }
            }
            this.clientAuth = var1_1;
            return;
        }
    }

    @Override
    public final void setEnableSessionCreation(boolean b) {
        if (b) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getEnableSessionCreation() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public final synchronized SSLParameters getSSLParameters() {
        void var1_1;
        SSLParameters sslParameters = super.getSSLParameters();
        int version = PlatformDependent.javaVersion();
        if (version >= 7) {
            void var2_2;
            Java7SslParametersUtils.setEndpointIdentificationAlgorithm(sslParameters, this.endpointIdentificationAlgorithm);
            Java7SslParametersUtils.setAlgorithmConstraints(sslParameters, this.algorithmConstraints);
            if (var2_2 >= 8) {
                if (this.sniHostNames != null) {
                    Java8SslUtils.setSniHostNames(sslParameters, this.sniHostNames);
                }
                if (!this.isDestroyed()) {
                    Java8SslUtils.setUseCipherSuitesOrder(sslParameters, (SSL.getOptions((long)this.ssl) & SSL.SSL_OP_CIPHER_SERVER_PREFERENCE) != 0);
                }
                Java8SslUtils.setSNIMatchers(sslParameters, this.matchers);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public final synchronized void setSSLParameters(SSLParameters sslParameters) {
        void var1_1;
        int version = PlatformDependent.javaVersion();
        if (version >= 7) {
            void var2_4;
            void var3_5;
            if (sslParameters.getAlgorithmConstraints() != null) {
                throw new IllegalArgumentException("AlgorithmConstraints are not supported.");
            }
            boolean isDestroyed = this.isDestroyed();
            if (version >= 8) {
                if (!isDestroyed) {
                    if (this.clientMode) {
                        List<String> sniHostNames = Java8SslUtils.getSniHostNames(sslParameters);
                        for (String name : sniHostNames) {
                            SSL.setTlsExtHostName((long)this.ssl, (String)name);
                        }
                        this.sniHostNames = sniHostNames;
                    }
                    if (Java8SslUtils.getUseCipherSuitesOrder(sslParameters)) {
                        SSL.setOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    } else {
                        SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    }
                }
                this.matchers = sslParameters.getSNIMatchers();
            }
            String endpointIdentificationAlgorithm = sslParameters.getEndpointIdentificationAlgorithm();
            if (var3_5 == false) {
                this.configureEndpointVerification(endpointIdentificationAlgorithm);
            }
            this.endpointIdentificationAlgorithm = var2_4;
            this.algorithmConstraints = sslParameters.getAlgorithmConstraints();
        }
        super.setSSLParameters((SSLParameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void configureEndpointVerification(String endpointIdentificationAlgorithm) {
        void var1_1;
        if (this.clientMode && ReferenceCountedOpenSslEngine.isEndPointVerificationEnabled((String)var1_1)) {
            SSL.setVerify((long)this.ssl, (int)2, (int)-1);
        }
    }

    private static boolean isEndPointVerificationEnabled(String endPointIdentificationAlgorithm) {
        String string;
        return endPointIdentificationAlgorithm != null && !string.isEmpty();
    }

    private boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - void declaration
     */
    final boolean checkSniHostnameMatch(byte[] hostname) {
        void var1_1;
        return Java8SslUtils.checkSniHostnameMatch(this.matchers, (byte[])var1_1);
    }

    @Override
    public String getNegotiatedApplicationProtocol() {
        return this.applicationProtocol;
    }

    private static long bufferAddress(ByteBuffer b) {
        ByteBuffer byteBuffer;
        assert (b.isDirect());
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.directBufferAddress((ByteBuffer)b);
        }
        return Buffer.address((ByteBuffer)byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    private void selectApplicationProtocol() throws SSLException {
        ApplicationProtocolConfig.SelectedListenerFailureBehavior behavior = this.apn.selectedListenerFailureBehavior();
        List<String> protocols = this.apn.protocols();
        switch (this.apn.protocol()) {
            case NONE: {
                return;
            }
            case ALPN: {
                String applicationProtocol = SSL.getAlpnSelected((long)this.ssl);
                if (applicationProtocol == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(protocols, behavior, applicationProtocol);
                return;
            }
            case NPN: {
                String applicationProtocol = SSL.getNextProtoNegotiated((long)this.ssl);
                if (applicationProtocol == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(protocols, behavior, applicationProtocol);
                return;
            }
            case NPN_AND_ALPN: {
                void var3_5;
                void var1_1;
                void var2_2;
                String applicationProtocol = SSL.getAlpnSelected((long)this.ssl);
                if (applicationProtocol == null) {
                    applicationProtocol = SSL.getNextProtoNegotiated((long)this.ssl);
                }
                if (applicationProtocol == null) break;
                this.applicationProtocol = this.selectApplicationProtocol((List<String>)var2_2, (ApplicationProtocolConfig.SelectedListenerFailureBehavior)var1_1, (String)var3_5);
                return;
            }
            default: {
                throw new Error();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String selectApplicationProtocol(List<String> protocols, ApplicationProtocolConfig.SelectedListenerFailureBehavior behavior, String applicationProtocol) throws SSLException {
        void var3_3;
        void var2_2;
        if (behavior == ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT) {
            return applicationProtocol;
        }
        int size = protocols.size();
        assert (size > 0);
        if (protocols.contains(applicationProtocol)) {
            return applicationProtocol;
        }
        if (var2_2 == ApplicationProtocolConfig.SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
            void var1_1;
            return (String)var1_1.get(size - 1);
        }
        throw new SSLException("unknown protocol " + (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(ReferenceCountedOpenSslEngine x0, Runnable x1) {
        void var1_1;
        x0.runAndResetNeedTask((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$900(ReferenceCountedOpenSslEngine x0, String x1) {
        void var1_1;
        return x0.toJavaCipherSuite((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HandshakeState access$1402(ReferenceCountedOpenSslEngine x0, HandshakeState x1) {
        void var1_1;
        x0.handshakeState = var1_1;
        return x0.handshakeState;
    }

    private static final class OpenSslHandshakeException
    extends SSLHandshakeException
    implements NativeSslException {
        private final int errorCode;

        /*
         * WARNING - void declaration
         */
        OpenSslHandshakeException(String reason, int errorCode) {
            super((String)var1_1);
            void var2_2;
            void var1_1;
            this.errorCode = var2_2;
        }

        @Override
        public final int errorCode() {
            return this.errorCode;
        }
    }

    private static final class OpenSslException
    extends SSLException
    implements NativeSslException {
        private final int errorCode;

        /*
         * WARNING - void declaration
         */
        OpenSslException(String reason, int errorCode) {
            super((String)var1_1);
            void var2_2;
            void var1_1;
            this.errorCode = var2_2;
        }

        @Override
        public final int errorCode() {
            return this.errorCode;
        }
    }

    private static interface NativeSslException {
        public int errorCode();
    }

    private final class DefaultOpenSslSession
    implements OpenSslSession {
        private final OpenSslSessionContext sessionContext;
        private X509Certificate[] x509PeerCerts;
        private Certificate[] peerCerts;
        private boolean valid = true;
        private String protocol;
        private String cipher;
        private OpenSslSessionId id = OpenSslSessionId.NULL_ID;
        private long creationTime;
        private long lastAccessed = -1L;
        private volatile int applicationBufferSize = MAX_PLAINTEXT_LENGTH;
        private volatile Certificate[] localCertificateChain;
        private volatile Map<String, Object> keyValueStorage = new ConcurrentHashMap<String, Object>();

        /*
         * WARNING - void declaration
         */
        DefaultOpenSslSession(OpenSslSessionContext sessionContext) {
            void var2_2;
            this.sessionContext = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private SSLSessionBindingEvent newSSLSessionBindingEvent(String name) {
            void var1_1;
            return new SSLSessionBindingEvent(ReferenceCountedOpenSslEngine.this.session, (String)var1_1);
        }

        @Override
        public final void prepareHandshake() {
            this.keyValueStorage.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setSessionDetails(long creationTime, long lastAccessedTime, OpenSslSessionId sessionId, Map<String, Object> keyValueStorage) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.id == OpenSslSessionId.NULL_ID) {
                    void var3_3;
                    void var1_1;
                    this.id = sessionId;
                    this.creationTime = var1_1;
                    this.lastAccessed = var3_3;
                    this.keyValueStorage = keyValueStorage;
                }
                return;
            }
        }

        @Override
        public final Map<String, Object> keyValueStorage() {
            return this.keyValueStorage;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final OpenSslSessionId sessionId() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                byte[] sessionId;
                if (this.id == OpenSslSessionId.NULL_ID && !ReferenceCountedOpenSslEngine.this.isDestroyed() && (sessionId = SSL.getSessionId((long)ReferenceCountedOpenSslEngine.this.ssl)) != null) {
                    void var2_2;
                    this.id = new OpenSslSessionId((byte[])var2_2);
                }
                return this.id;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setLocalCertificate(Certificate[] localCertificate) {
            void var1_1;
            this.localCertificateChain = var1_1;
        }

        @Override
        public final byte[] getId() {
            return this.sessionId().cloneBytes();
        }

        @Override
        public final OpenSslSessionContext getSessionContext() {
            return this.sessionContext;
        }

        @Override
        public final long getCreationTime() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.creationTime;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setLastAccessedTime(long time) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                void var1_1;
                this.lastAccessed = var1_1;
                return;
            }
        }

        @Override
        public final long getLastAccessedTime() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.lastAccessed == -1L ? this.creationTime : this.lastAccessed;
            }
        }

        @Override
        public final void invalidate() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                this.valid = false;
                this.sessionContext.removeFromCache(this.id);
                return;
            }
        }

        @Override
        public final boolean isValid() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                return this.valid || this.sessionContext.isInCache(this.id);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void putValue(String name, Object value) {
            void var1_1;
            void var3_3;
            ObjectUtil.checkNotNull((Object)name, (String)"name");
            ObjectUtil.checkNotNull((Object)value, (String)"value");
            Object old = this.keyValueStorage.put(name, value);
            if (value instanceof SSLSessionBindingListener) {
                void var2_2;
                ((SSLSessionBindingListener)var2_2).valueBound(this.newSSLSessionBindingEvent(name));
            }
            this.notifyUnbound(var3_3, (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object getValue(String name) {
            void var1_1;
            ObjectUtil.checkNotNull((Object)name, (String)"name");
            return this.keyValueStorage.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void removeValue(String name) {
            void var1_1;
            void var2_2;
            ObjectUtil.checkNotNull((Object)name, (String)"name");
            Object old = this.keyValueStorage.remove(name);
            this.notifyUnbound(var2_2, (String)var1_1);
        }

        @Override
        public final String[] getValueNames() {
            return this.keyValueStorage.keySet().toArray(EmptyArrays.EMPTY_STRINGS);
        }

        /*
         * WARNING - void declaration
         */
        private void notifyUnbound(Object value, String name) {
            if (value instanceof SSLSessionBindingListener) {
                void var2_2;
                void var1_1;
                ((SSLSessionBindingListener)var1_1).valueUnbound(this.newSSLSessionBindingEvent((String)var2_2));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void handshakeFinished(byte[] id, String cipher, String protocol, byte[] peerCertificate, byte[][] peerCertificateChain, long creationTime, long timeout) throws SSLException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (!ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                    void var3_4;
                    void var2_3;
                    if (this.id == OpenSslSessionId.NULL_ID) {
                        void var1_1;
                        this.id = id == null ? OpenSslSessionId.NULL_ID : new OpenSslSessionId((byte[])var1_1);
                        DefaultOpenSslSession defaultOpenSslSession = this;
                        defaultOpenSslSession.creationTime = defaultOpenSslSession.lastAccessed = creationTime;
                    }
                    this.cipher = ReferenceCountedOpenSslEngine.access$900(ReferenceCountedOpenSslEngine.this, (String)var2_3);
                    this.protocol = var3_4;
                    if (ReferenceCountedOpenSslEngine.this.clientMode) {
                        if (ReferenceCountedOpenSslEngine.isEmpty((Object[])peerCertificateChain)) {
                            this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                            this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES : JAVAX_CERTS_NOT_SUPPORTED;
                        } else {
                            this.peerCerts = new Certificate[peerCertificateChain.length];
                            this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? new X509Certificate[peerCertificateChain.length] : JAVAX_CERTS_NOT_SUPPORTED;
                            this.initCerts(peerCertificateChain, 0);
                        }
                    } else if (ReferenceCountedOpenSslEngine.isEmpty(peerCertificate)) {
                        this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                        this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
                    } else if (ReferenceCountedOpenSslEngine.isEmpty((Object[])peerCertificateChain)) {
                        this.peerCerts = new Certificate[]{new LazyX509Certificate(peerCertificate)};
                        this.x509PeerCerts = OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED ? new X509Certificate[]{new LazyJavaxX509Certificate(peerCertificate)} : JAVAX_CERTS_NOT_SUPPORTED;
                    } else {
                        this.peerCerts = new Certificate[peerCertificateChain.length + 1];
                        this.peerCerts[0] = new LazyX509Certificate(peerCertificate);
                        if (OpenSsl.JAVAX_CERTIFICATE_CREATION_SUPPORTED) {
                            this.x509PeerCerts = new X509Certificate[peerCertificateChain.length + 1];
                            this.x509PeerCerts[0] = new LazyJavaxX509Certificate(peerCertificate);
                        } else {
                            this.x509PeerCerts = JAVAX_CERTS_NOT_SUPPORTED;
                        }
                        this.initCerts(peerCertificateChain, 1);
                    }
                } else {
                    throw new SSLException("Already closed");
                }
                ReferenceCountedOpenSslEngine.this.calculateMaxWrapOverhead();
                ReferenceCountedOpenSslEngine.access$1402(ReferenceCountedOpenSslEngine.this, HandshakeState.FINISHED);
                return;
            }
        }

        private void initCerts(byte[][] chain, int startPos) {
            for (int i = 0; i < chain.length; ++i) {
                int certPos = startPos + i;
                this.peerCerts[certPos] = new LazyX509Certificate(chain[i]);
                if (this.x509PeerCerts == JAVAX_CERTS_NOT_SUPPORTED) continue;
                this.x509PeerCerts[certPos] = new LazyJavaxX509Certificate(chain[i]);
            }
        }

        @Override
        public final Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (ReferenceCountedOpenSslEngine.isEmpty(this.peerCerts)) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return (Certificate[])this.peerCerts.clone();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Certificate[] getLocalCertificates() {
            void var1_1;
            Certificate[] localCerts = this.localCertificateChain;
            if (this.localCertificateChain == null) {
                return null;
            }
            return (Certificate[])var1_1.clone();
        }

        @Override
        public final X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.x509PeerCerts == JAVAX_CERTS_NOT_SUPPORTED) {
                    throw new UnsupportedOperationException();
                }
                if (ReferenceCountedOpenSslEngine.isEmpty(this.x509PeerCerts)) {
                    throw new SSLPeerUnverifiedException("peer not verified");
                }
                return (X509Certificate[])this.x509PeerCerts.clone();
            }
        }

        @Override
        public final Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] certificateArray = this.getPeerCertificates();
            return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Principal getLocalPrincipal() {
            void var1_1;
            Certificate[] local = this.localCertificateChain;
            if (this.localCertificateChain == null || local.length == 0) {
                return null;
            }
            return ((java.security.cert.X509Certificate)var1_1[0]).getSubjectX500Principal();
        }

        @Override
        public final String getCipherSuite() {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
            synchronized (referenceCountedOpenSslEngine) {
                if (this.cipher == null) {
                    return "SSL_NULL_WITH_NULL_NULL";
                }
                return this.cipher;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String getProtocol() {
            void var1_1;
            String protocol = this.protocol;
            if (protocol == null) {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslEngine.this;
                synchronized (referenceCountedOpenSslEngine) {
                    protocol = !ReferenceCountedOpenSslEngine.this.isDestroyed() ? SSL.getVersion((long)ReferenceCountedOpenSslEngine.this.ssl) : "";
                }
            }
            return var1_1;
        }

        @Override
        public final String getPeerHost() {
            return ReferenceCountedOpenSslEngine.this.getPeerHost();
        }

        @Override
        public final int getPeerPort() {
            return ReferenceCountedOpenSslEngine.this.getPeerPort();
        }

        @Override
        public final int getPacketBufferSize() {
            return SSL.SSL_MAX_ENCRYPTED_LENGTH;
        }

        @Override
        public final int getApplicationBufferSize() {
            return this.applicationBufferSize;
        }

        @Override
        public final void tryExpandApplicationBufferSize(int packetLengthDataOnly) {
            if (packetLengthDataOnly > MAX_PLAINTEXT_LENGTH && this.applicationBufferSize != MAX_RECORD_SIZE) {
                this.applicationBufferSize = MAX_RECORD_SIZE;
            }
        }

        public final String toString() {
            return "DefaultOpenSslSession{sessionContext=" + this.sessionContext + ", id=" + this.id + '}';
        }

        public final int hashCode() {
            return this.sessionId().hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var1_1;
            if (o == this) {
                return true;
            }
            if (!(o instanceof OpenSslSession)) {
                return false;
            }
            return this.sessionId().equals(((OpenSslSession)var1_1).sessionId());
        }
    }

    private final class AsyncTaskDecorator
    extends TaskDecorator<AsyncTask>
    implements AsyncRunnable {
        /*
         * WARNING - void declaration
         */
        AsyncTaskDecorator(AsyncTask task) {
            void var2_2;
            super(ReferenceCountedOpenSslEngine.this, (Runnable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run(Runnable runnable) {
            void var1_1;
            if (ReferenceCountedOpenSslEngine.this.isDestroyed()) {
                return;
            }
            ((AsyncTask)this.task).runAsync((Runnable)new TaskDecorator(ReferenceCountedOpenSslEngine.this, (Runnable)var1_1));
        }
    }

    private static class TaskDecorator<R extends Runnable>
    implements Runnable {
        protected final R task;
        final /* synthetic */ ReferenceCountedOpenSslEngine this$0;

        /*
         * WARNING - void declaration
         */
        TaskDecorator(R task) {
            void var2_2;
            this.this$0 = var1_1;
            this.task = var2_2;
        }

        @Override
        public void run() {
            ReferenceCountedOpenSslEngine.access$700(this.this$0, this.task);
        }
    }

    private static enum HandshakeState {
        NOT_STARTED,
        STARTED_IMPLICITLY,
        STARTED_EXPLICITLY,
        FINISHED;

    }
}

