/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.EnhancingX509ExtendedTrustManager;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslAsyncPrivateKeyMethod;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslCertificateCompressionAlgorithm;
import io.netty.handler.ssl.OpenSslCertificateCompressionConfig;
import io.netty.handler.ssl.OpenSslCertificateException;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslPrivateKeyMethod;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslX509TrustManagerWrapper;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.util.LazyX509Certificate;
import io.netty.internal.tcnative.AsyncSSLPrivateKeyMethod;
import io.netty.internal.tcnative.CertificateCompressionAlgo;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.ResultCallback;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SSLPrivateKeyMethod;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger;
    private static final int DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final boolean USE_TASKS;
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    protected static final int VERIFY_DEPTH = 10;
    static final boolean CLIENT_ENABLE_SESSION_TICKET;
    static final boolean CLIENT_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_TICKET;
    static final boolean SERVER_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_CACHE;
    static final boolean CLIENT_ENABLE_SESSION_CACHE;
    protected long ctx;
    private final List<String> unmodifiableCiphers;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeakTracker<ReferenceCountedOpenSslContext> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(this){
        final /* synthetic */ ReferenceCountedOpenSslContext this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ReferenceCounted touch(Object hint) {
            if (this.this$0.leak != null) {
                void var1_1;
                this.this$0.leak.record((Object)var1_1);
            }
            return this.this$0;
        }

        /*
         * WARNING - void declaration
         */
        protected void deallocate() {
            this.this$0.destroy();
            if (this.this$0.leak != null) {
                void var1_1;
                boolean closed = this.this$0.leak.close((Object)this.this$0);
                assert (var1_1 != false);
            }
        }
    };
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final String[] protocols;
    final String endpointIdentificationAlgorithm;
    final boolean hasTLSv13Cipher;
    final boolean enableOcsp;
    final OpenSslEngineMap engineMap = new DefaultOpenSslEngineMap();
    final ReadWriteLock ctxLock = new ReentrantReadWriteLock();
    private volatile int bioNonApplicationBufferSize = DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;
    final boolean tlsFalseStart;

    /*
     * WARNING - void declaration
     */
    ReferenceCountedOpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, OpenSslApplicationProtocolNegotiator apn, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, String endpointIdentificationAlgorithm, boolean enableOcsp, boolean leakDetection, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... ctxOptions) throws SSLException {
        super(startTls, resumptionController);
        OpenSsl.ensureAvailability();
        if (enableOcsp && !OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported.");
        }
        if (mode != 1 && mode != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        boolean tlsFalseStart = false;
        boolean useTasks = USE_TASKS;
        OpenSslPrivateKeyMethod privateKeyMethod = null;
        OpenSslAsyncPrivateKeyMethod asyncPrivateKeyMethod = null;
        OpenSslCertificateCompressionConfig certCompressionConfig = null;
        Integer maxCertificateList = null;
        if (ctxOptions != null) {
            for (Map.Entry<SslContextOption<?>, Object> ctxOpt : ctxOptions) {
                SslContextOption<?> option = ctxOpt.getKey();
                if (option == OpenSslContextOption.TLS_FALSE_START) {
                    tlsFalseStart = (Boolean)ctxOpt.getValue();
                    continue;
                }
                if (option == OpenSslContextOption.USE_TASKS) {
                    useTasks = (Boolean)ctxOpt.getValue();
                    continue;
                }
                if (option == OpenSslContextOption.PRIVATE_KEY_METHOD) {
                    privateKeyMethod = (OpenSslPrivateKeyMethod)ctxOpt.getValue();
                    continue;
                }
                if (option == OpenSslContextOption.ASYNC_PRIVATE_KEY_METHOD) {
                    asyncPrivateKeyMethod = (OpenSslAsyncPrivateKeyMethod)ctxOpt.getValue();
                    continue;
                }
                if (option == OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS) {
                    certCompressionConfig = (OpenSslCertificateCompressionConfig)ctxOpt.getValue();
                    continue;
                }
                if (option == OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES) {
                    maxCertificateList = (Integer)ctxOpt.getValue();
                    continue;
                }
                logger.debug("Skipping unsupported " + SslContextOption.class.getSimpleName() + ": " + ctxOpt.getKey());
            }
        }
        if (privateKeyMethod != null && asyncPrivateKeyMethod != null) {
            throw new IllegalArgumentException("You can either only use " + OpenSslAsyncPrivateKeyMethod.class.getSimpleName() + " or " + OpenSslPrivateKeyMethod.class.getSimpleName());
        }
        this.tlsFalseStart = tlsFalseStart;
        this.leak = leakDetection ? leakDetector.track((Object)this) : null;
        this.mode = mode;
        ClientAuth clientAuth2 = this.clientAuth = this.isServer() ? (ClientAuth)((Object)ObjectUtil.checkNotNull((Object)((Object)clientAuth), (String)"clientAuth")) : ClientAuth.NONE;
        this.protocols = protocols == null ? OpenSsl.defaultProtocols(mode == 0) : protocols;
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
        this.enableOcsp = enableOcsp;
        this.keyCertChain = keyCertChain == null ? null : (Certificate[])keyCertChain.clone();
        String[] suites = ((CipherSuiteFilter)ObjectUtil.checkNotNull((Object)cipherFilter, (String)"cipherFilter")).filterCipherSuites(ciphers, OpenSsl.DEFAULT_CIPHERS, OpenSsl.availableJavaCipherSuites());
        LinkedHashSet suitesSet = new LinkedHashSet(suites.length);
        Collections.addAll(suitesSet, suites);
        this.unmodifiableCiphers = new ArrayList<String>(suitesSet);
        this.apn = (OpenSslApplicationProtocolNegotiator)ObjectUtil.checkNotNull((Object)apn, (String)"apn");
        try {
            List<String> nextProtoList;
            Object tlsv13Ciphers;
            boolean tlsv13Supported = OpenSsl.isTlsv13Supported();
            boolean anyTlsv13Ciphers = false;
            try {
                int protocolOpts = 30;
                if (tlsv13Supported) {
                    protocolOpts = 62;
                }
                this.ctx = SSLContext.make((int)protocolOpts, (int)mode);
            }
            catch (Exception e) {
                throw new SSLException("failed to create an SSL_CTX", e);
            }
            StringBuilder cipherBuilder = new StringBuilder();
            StringBuilder cipherTLSv13Builder = new StringBuilder();
            try {
                if (this.unmodifiableCiphers.isEmpty()) {
                    SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)false);
                    if (tlsv13Supported) {
                        SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)true);
                    }
                } else {
                    CipherSuiteConverter.convertToCipherStrings(this.unmodifiableCiphers, cipherBuilder, cipherTLSv13Builder, OpenSsl.isBoringSSL());
                    SSLContext.setCipherSuite((long)this.ctx, (String)cipherBuilder.toString(), (boolean)false);
                    if (tlsv13Supported) {
                        tlsv13Ciphers = OpenSsl.checkTls13Ciphers(logger, cipherTLSv13Builder.toString());
                        SSLContext.setCipherSuite((long)this.ctx, (String)tlsv13Ciphers, (boolean)true);
                        if (!((String)tlsv13Ciphers).isEmpty()) {
                            anyTlsv13Ciphers = true;
                        }
                    }
                }
            }
            catch (SSLException sSLException) {
                tlsv13Ciphers = sSLException;
                throw sSLException;
            }
            catch (Exception e) {
                throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, e);
            }
            int options = SSLContext.getOptions((long)this.ctx) | SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_CIPHER_SERVER_PREFERENCE | SSL.SSL_OP_NO_COMPRESSION | SSL.SSL_OP_NO_TICKET;
            if (cipherBuilder.length() == 0) {
                options |= SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2;
            }
            if (!tlsv13Supported) {
                options |= SSL.SSL_OP_NO_TLSv1_3;
            }
            this.hasTLSv13Cipher = anyTlsv13Ciphers;
            SSLContext.setOptions((long)this.ctx, (int)options);
            SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | SSL.SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER));
            if (DH_KEY_LENGTH != null) {
                SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
            }
            if (!(nextProtoList = apn.protocols()).isEmpty()) {
                String[] appProtocols = nextProtoList.toArray(EmptyArrays.EMPTY_STRINGS);
                int selectorBehavior = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(apn.selectorFailureBehavior());
                switch (apn.protocol()) {
                    case NPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])appProtocols, (int)selectorBehavior);
                        break;
                    }
                    case ALPN: {
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])appProtocols, (int)selectorBehavior);
                        break;
                    }
                    case NPN_AND_ALPN: {
                        Iterator<OpenSslCertificateCompressionConfig.AlgorithmConfig> iterator;
                        SSLContext.setNpnProtos((long)this.ctx, (String[])appProtocols, (int)selectorBehavior);
                        SSLContext.setAlpnProtos((long)this.ctx, iterator, (int)selectorBehavior);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (enableOcsp) {
                SSLContext.enableOcsp((long)this.ctx, (boolean)((SslContext)this).isClient());
            }
            SSLContext.setUseTasks((long)this.ctx, (boolean)useTasks);
            if (privateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new PrivateKeyMethod(this.engineMap, privateKeyMethod));
            }
            if (asyncPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (AsyncSSLPrivateKeyMethod)new AsyncPrivateKeyMethod(this.engineMap, asyncPrivateKeyMethod));
            }
            if (certCompressionConfig != null) {
                block18: for (OpenSslCertificateCompressionConfig.AlgorithmConfig configPair : certCompressionConfig) {
                    void var2_9;
                    CompressionAlgorithm algo = new CompressionAlgorithm(this.engineMap, configPair.algorithm());
                    switch (var2_9.mode()) {
                        case Decompress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_DECOMPRESS, (CertificateCompressionAlgo)algo);
                            continue block18;
                        }
                        case Compress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_COMPRESS, (CertificateCompressionAlgo)algo);
                            continue block18;
                        }
                        case Both: {
                            void var3_10;
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_BOTH, (CertificateCompressionAlgo)var3_10);
                            continue block18;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if (maxCertificateList != null) {
                SSLContext.setMaxCertList((long)this.ctx, (int)maxCertificateList);
            }
            SSLContext.setCurvesList((long)this.ctx, (String[])OpenSsl.NAMED_GROUPS);
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig.SelectorFailureBehavior behavior) {
        ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior;
        switch (selectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.newEngine0((ByteBufAllocator)var1_1, (String)var2_2, (int)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final SslHandler newHandler(ByteBufAllocator alloc, boolean startTls) {
        void var2_2;
        void var1_1;
        return new SslHandler(this.newEngine0((ByteBufAllocator)var1_1, null, -1, false), (boolean)var2_2, (Executor)ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort, boolean startTls) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SslHandler(this.newEngine0((ByteBufAllocator)var1_1, (String)var2_2, (int)var3_3, false), startTls, (Executor)ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected SslHandler newHandler(ByteBufAllocator alloc, boolean startTls, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SslHandler(this.newEngine0((ByteBufAllocator)var1_1, null, -1, false), (boolean)var2_2, (Executor)var3_3, this.resumptionController);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected SslHandler newHandler(ByteBufAllocator alloc, String peerHost, int peerPort, boolean startTls, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SslHandler(this.newEngine0((ByteBufAllocator)var1_1, (String)var2_2, (int)var3_3, false), false, executor, this.resumptionController);
    }

    /*
     * WARNING - void declaration
     */
    SSLEngine newEngine0(ByteBufAllocator alloc, String peerHost, int peerPort, boolean jdkCompatibilityMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new ReferenceCountedOpenSslEngine(this, (ByteBufAllocator)var1_1, (String)var2_2, (int)var3_3, jdkCompatibilityMode, true, this.endpointIdentificationAlgorithm);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SSLEngine newEngine(ByteBufAllocator alloc) {
        void var1_1;
        return ((SslContext)this).newEngine((ByteBufAllocator)var1_1, null, -1);
    }

    @Deprecated
    public final long context() {
        return this.sslCtxPointer();
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    @Deprecated
    public void setRejectRemoteInitiatedRenegotiation(boolean rejectRemoteInitiatedRenegotiation) {
        if (!rejectRemoteInitiatedRenegotiation) {
            throw new UnsupportedOperationException("Renegotiation is not supported");
        }
    }

    @Deprecated
    public boolean getRejectRemoteInitiatedRenegotiation() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setBioNonApplicationBufferSize(int bioNonApplicationBufferSize) {
        void var1_1;
        this.bioNonApplicationBufferSize = ObjectUtil.checkPositiveOrZero((int)var1_1, (String)"bioNonApplicationBufferSize");
    }

    public int getBioNonApplicationBufferSize() {
        return this.bioNonApplicationBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void setTicketKeys(byte[] keys) {
        void var1_1;
        this.sessionContext().setTicketKeys((byte[])var1_1);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final long sslCtxPointer() {
        Lock readerLock = this.ctxLock.readLock();
        readerLock.lock();
        try {
            long l = SSLContext.getSslCtx((long)this.ctx);
            readerLock.unlock();
            return l;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void setPrivateKeyMethod(OpenSslPrivateKeyMethod method) {
        ObjectUtil.checkNotNull((Object)method, (String)"method");
        Lock writerLock = this.ctxLock.writeLock();
        writerLock.lock();
        try {
            void var1_1;
            SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new PrivateKeyMethod(this.engineMap, (OpenSslPrivateKeyMethod)var1_1));
            writerLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void setUseTasks(boolean useTasks) {
        Lock writerLock = this.ctxLock.writeLock();
        writerLock.lock();
        try {
            void var1_1;
            SSLContext.setUseTasks((long)this.ctx, (boolean)var1_1);
            writerLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void destroy() {
        Lock writerLock = this.ctxLock.writeLock();
        writerLock.lock();
        try {
            if (this.ctx != 0L) {
                if (this.enableOcsp) {
                    SSLContext.disableOcsp((long)this.ctx);
                }
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
                OpenSslSessionContext context = this.sessionContext();
                if (context != null) {
                    void var2_2;
                    var2_2.destroy();
                }
            }
            writerLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static X509Certificate[] certificates(byte[][] chain) {
        void var1_1;
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new LazyX509Certificate(chain[i]);
        }
        return var1_1;
    }

    @Deprecated
    protected static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        return ReferenceCountedOpenSslContext.chooseTrustManager(managers, null);
    }

    static X509TrustManager chooseTrustManager(TrustManager[] managers, ResumptionController resumptionController) {
        for (TrustManager m : managers) {
            Object object;
            if (!(m instanceof X509TrustManager)) continue;
            Object tm = (X509TrustManager)m;
            if (PlatformDependent.javaVersion() >= 7) {
                if (resumptionController != null) {
                    tm = (X509TrustManager)resumptionController.wrapIfNeeded((TrustManager)tm);
                }
                if (ReferenceCountedOpenSslContext.useExtendedTrustManager((X509TrustManager)(tm = OpenSslX509TrustManagerWrapper.wrapIfNeeded((X509TrustManager)tm)))) {
                    tm = new EnhancingX509ExtendedTrustManager((X509TrustManager)tm);
                }
            }
            return object;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    /*
     * WARNING - void declaration
     */
    protected static X509KeyManager chooseX509KeyManager(KeyManager[] kms) {
        KeyManager[] keyManagerArray = kms;
        int n = kms.length;
        for (int i = 0; i < n; ++i) {
            void var3_3;
            KeyManager km = keyManagerArray[i];
            if (!(km instanceof X509KeyManager)) continue;
            return (X509KeyManager)var3_3;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig config) {
        if (config == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (config.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                ApplicationProtocolConfig applicationProtocolConfig;
                switch (config.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (config.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(config);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)config.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    @SuppressJava6Requirement(reason="Guarded by java version check")
    static boolean useExtendedTrustManager(X509TrustManager trustManager) {
        X509TrustManager x509TrustManager;
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ReferenceCounted retain(int increment) {
        void var1_1;
        this.refCnt.retain((int)var1_1);
        return this;
    }

    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ReferenceCounted touch(Object hint) {
        void var1_1;
        this.refCnt.touch((Object)var1_1);
        return this;
    }

    public final boolean release() {
        return this.refCnt.release();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean release(int decrement) {
        void var1_1;
        return this.refCnt.release((int)var1_1);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setKeyMaterial(long ctx2222222, X509Certificate[] keyCertChain, PrivateKey key, String keyPassword) throws SSLException {
        long keyBio = 0L;
        long keyCertChainBio = 0L;
        long keyCertChainBio2 = 0L;
        PemEncoded encoded = null;
        try {
            void var2_4;
            encoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, (X509Certificate[])var2_4);
            keyCertChainBio = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, encoded.retain());
            keyCertChainBio2 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, encoded.retain());
            if (key != null) {
                void var3_5;
                keyBio = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, (PrivateKey)var3_5);
            }
            SSLContext.setCertificateBio((long)ctx2222222, (long)keyCertChainBio, (long)keyBio, (String)(keyPassword == null ? "" : keyPassword));
            SSLContext.setCertificateChainBio((long)ctx2222222, (long)keyCertChainBio2, (boolean)true);
        }
        catch (SSLException sSLException) {
            try {
                SSLException ctx2222222 = sSLException;
                throw sSLException;
                catch (Exception e) {
                    void var0_2;
                    throw new SSLException("failed to set certificate and key", (Throwable)var0_2);
                }
            }
            catch (Throwable throwable) {
                ReferenceCountedOpenSslContext.freeBio(keyBio);
                ReferenceCountedOpenSslContext.freeBio(keyCertChainBio);
                ReferenceCountedOpenSslContext.freeBio(keyCertChainBio2);
                if (encoded != null) {
                    encoded.release();
                }
                throw throwable;
            }
        }
        ReferenceCountedOpenSslContext.freeBio(keyBio);
        ReferenceCountedOpenSslContext.freeBio(keyCertChainBio);
        ReferenceCountedOpenSslContext.freeBio(keyCertChainBio2);
        if (encoded != null) {
            encoded.release();
            return;
        }
    }

    static void freeBio(long bio) {
        if (bio != 0L) {
            long l;
            SSL.freeBIO((long)l);
        }
    }

    /*
     * WARNING - void declaration
     */
    static long toBIO(ByteBufAllocator allocator, PrivateKey key) throws Exception {
        long l;
        if (key == null) {
            return 0L;
        }
        PemEncoded pem = PemPrivateKey.toPEM(allocator, true, key);
        try {
            ByteBufAllocator byteBufAllocator;
            l = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pem.retain());
        }
        catch (Throwable throwable) {
            void var1_2;
            var1_2.release();
            throw throwable;
        }
        pem.release();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    static long toBIO(ByteBufAllocator allocator, X509Certificate ... certChain) throws Exception {
        long l;
        if (certChain == null) {
            return 0L;
        }
        ObjectUtil.checkNonEmpty((Object[])certChain, (String)"certChain");
        PemEncoded pem = PemX509Certificate.toPEM(allocator, true, certChain);
        try {
            ByteBufAllocator byteBufAllocator;
            l = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pem.retain());
        }
        catch (Throwable throwable) {
            void var1_2;
            var1_2.release();
            throw throwable;
        }
        pem.release();
        return l;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long toBIO(ByteBufAllocator allocator, PemEncoded pem) throws Exception {
        long l;
        ByteBufAllocator byteBufAllocator;
        ByteBuf content;
        block12: {
            content = pem.content();
            if (!content.isDirect()) break block12;
            long l2 = ReferenceCountedOpenSslContext.newBIO(content.retainedSlice());
            {
                catch (Throwable throwable) {
                    void var1_5;
                    var1_5.release();
                    throw throwable;
                }
            }
            pem.release();
            return l2;
        }
        ByteBuf buffer = byteBufAllocator.directBuffer(content.readableBytes());
        try {
            void var2_6;
            ByteBuf byteBuf = content;
            buffer.writeBytes(byteBuf, byteBuf.readerIndex(), var2_6.readableBytes());
            l = ReferenceCountedOpenSslContext.newBIO(buffer.retainedSlice());
        }
        catch (Throwable throwable) {
            block14: {
                try {
                    if (!pem.isSensitive()) break block14;
                    SslUtils.zeroout(buffer);
                }
                catch (Throwable throwable2) {
                    void var3_8;
                    var3_8.release();
                    throw throwable2;
                }
            }
            buffer.release();
            throw throwable;
        }
        try {
            if (pem.isSensitive()) {
                SslUtils.zeroout(buffer);
            }
        }
        finally {
            buffer.release();
        }
        pem.release();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private static long newBIO(ByteBuf buffer) throws Exception {
        void var4_4;
        try {
            void var1_1;
            void var3_3;
            long bio = SSL.newMemBIO();
            int readable = buffer.readableBytes();
            if (SSL.bioWrite((long)bio, (long)(OpenSsl.memoryAddress(buffer) + (long)buffer.readerIndex()), (int)readable) != var3_3) {
                SSL.freeBIO((long)bio);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            var4_4 = var1_1;
        }
        catch (Throwable throwable) {
            ByteBuf byteBuf;
            byteBuf.release();
            throw throwable;
        }
        buffer.release();
        return (long)var4_4;
    }

    /*
     * WARNING - void declaration
     */
    static OpenSslKeyMaterialProvider providerFor(KeyManagerFactory factory, String password) {
        void var1_1;
        KeyManagerFactory keyManagerFactory;
        if (factory instanceof OpenSslX509KeyManagerFactory) {
            return ((OpenSslX509KeyManagerFactory)factory).newProvider();
        }
        if (factory instanceof OpenSslCachingX509KeyManagerFactory) {
            return ((OpenSslCachingX509KeyManagerFactory)factory).newProvider(password);
        }
        return new OpenSslKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers()), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static ReferenceCountedOpenSslEngine retrieveEngine(OpenSslEngineMap engineMap, long ssl) throws SSLException {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine;
        ReferenceCountedOpenSslEngine engine = engineMap.get(ssl);
        if (engine == null) {
            void var1_1;
            throw new SSLException("Could not find a " + StringUtil.simpleClassName(ReferenceCountedOpenSslEngine.class) + " for sslPointer " + (long)var1_1);
        }
        return referenceCountedOpenSslEngine;
    }

    private static byte[] verifyResult(byte[] result) throws SignatureException {
        byte[] byArray;
        if (result == null) {
            throw new SignatureException();
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ReferenceCountedOpenSslEngine access$400(OpenSslEngineMap x0, long x1) throws SSLException {
        void var1_1;
        return ReferenceCountedOpenSslContext.retrieveEngine(x0, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
        DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.handler.ssl.openssl.bioNonApplicationBufferSize", (int)2048));
        USE_TASKS = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.openssl.useTasks", (boolean)true);
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        CLIENT_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean((String)"jdk.tls.client.enableSessionTicketExtension", (boolean)false);
        CLIENT_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean((String)"jdk.tls.client.enableSessionTicketExtension", (boolean)true);
        SERVER_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean((String)"jdk.tls.server.enableSessionTicketExtension", (boolean)false);
        SERVER_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean((String)"jdk.tls.server.enableSessionTicketExtension", (boolean)true);
        SERVER_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.openssl.sessionCacheServer", (boolean)true);
        CLIENT_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.openssl.sessionCacheClient", (boolean)true);
        NONE_PROTOCOL_NEGOTIATOR = new OpenSslApplicationProtocolNegotiator(){

            @Override
            public final ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NONE;
            }

            @Override
            public final List<String> protocols() {
                return Collections.emptyList();
            }

            @Override
            public final ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior() {
                return ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL;
            }

            @Override
            public final ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior() {
                return ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT;
            }
        };
        Integer dhLen = null;
        try {
            String dhKeySize = SystemPropertyUtil.get((String)"jdk.tls.ephemeralDHKeySize");
            if (dhKeySize != null) {
                try {
                    dhLen = Integer.valueOf(dhKeySize);
                }
                catch (NumberFormatException numberFormatException) {
                    void var1_1;
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + (String)var1_1);
                }
            }
        }
        catch (Throwable throwable) {}
        DH_KEY_LENGTH = var0;
    }

    private static final class CompressionAlgorithm
    implements CertificateCompressionAlgo {
        private final OpenSslEngineMap engineMap;
        private final OpenSslCertificateCompressionAlgorithm compressionAlgorithm;

        /*
         * WARNING - void declaration
         */
        CompressionAlgorithm(OpenSslEngineMap engineMap, OpenSslCertificateCompressionAlgorithm compressionAlgorithm) {
            void var2_2;
            void var1_1;
            this.engineMap = var1_1;
            this.compressionAlgorithm = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] compress(long ssl, byte[] bytes) throws Exception {
            void var3_3;
            void var1_2;
            ReferenceCountedOpenSslEngine engine = ReferenceCountedOpenSslContext.access$400(this.engineMap, ssl);
            return this.compressionAlgorithm.compress((SSLEngine)var1_2, (byte[])var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] decompress(long ssl, int len, byte[] bytes) throws Exception {
            void var3_3;
            void var1_2;
            ReferenceCountedOpenSslEngine engine = ReferenceCountedOpenSslContext.access$400(this.engineMap, ssl);
            return this.compressionAlgorithm.decompress((SSLEngine)var1_2, (int)var3_3, bytes);
        }

        public final int algorithmId() {
            return this.compressionAlgorithm.algorithmId();
        }
    }

    private static final class AsyncPrivateKeyMethod
    implements AsyncSSLPrivateKeyMethod {
        private final OpenSslEngineMap engineMap;
        private final OpenSslAsyncPrivateKeyMethod keyMethod;

        /*
         * WARNING - void declaration
         */
        AsyncPrivateKeyMethod(OpenSslEngineMap engineMap, OpenSslAsyncPrivateKeyMethod keyMethod) {
            void var2_2;
            void var1_1;
            this.engineMap = var1_1;
            this.keyMethod = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void sign(long ssl, int signatureAlgorithm, byte[] bytes, ResultCallback<byte[]> resultCallback) {
            try {
                void var3_2;
                ReferenceCountedOpenSslEngine engine = ReferenceCountedOpenSslContext.access$400(this.engineMap, ssl);
                this.keyMethod.sign(engine, (int)var3_2, bytes).addListener((GenericFutureListener)new ResultCallbackListener(engine, ssl, resultCallback));
                return;
            }
            catch (SSLException e) {
                void var1_1;
                resultCallback.onError((long)var1_1, (Throwable)e);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void decrypt(long ssl, byte[] bytes, ResultCallback<byte[]> resultCallback) {
            try {
                void var3_2;
                ReferenceCountedOpenSslEngine engine = ReferenceCountedOpenSslContext.access$400(this.engineMap, ssl);
                this.keyMethod.decrypt(engine, (byte[])var3_2).addListener((GenericFutureListener)new ResultCallbackListener(engine, ssl, resultCallback));
                return;
            }
            catch (SSLException e) {
                void var1_1;
                resultCallback.onError((long)var1_1, (Throwable)e);
                return;
            }
        }

        private static final class ResultCallbackListener
        implements FutureListener<byte[]> {
            private final ReferenceCountedOpenSslEngine engine;
            private final long ssl;
            private final ResultCallback<byte[]> resultCallback;

            /*
             * WARNING - void declaration
             */
            ResultCallbackListener(ReferenceCountedOpenSslEngine engine, long ssl, ResultCallback<byte[]> resultCallback) {
                void var2_2;
                void var1_1;
                this.engine = var1_1;
                this.ssl = var2_2;
                this.resultCallback = resultCallback;
            }

            /*
             * WARNING - void declaration
             */
            public final void operationComplete(Future<byte[]> future) {
                void var2_2;
                Throwable cause = future.cause();
                if (cause == null) {
                    try {
                        byte[] result = ReferenceCountedOpenSslContext.verifyResult((byte[])future.getNow());
                        this.resultCallback.onSuccess(this.ssl, (Object)result);
                        return;
                    }
                    catch (SignatureException signatureException) {
                        void var1_1;
                        SignatureException e = signatureException;
                        cause = signatureException;
                        this.engine.initHandshakeException((Throwable)var1_1);
                    }
                }
                this.resultCallback.onError(this.ssl, (Throwable)var2_2);
            }
        }
    }

    private static final class PrivateKeyMethod
    implements SSLPrivateKeyMethod {
        private final OpenSslEngineMap engineMap;
        private final OpenSslPrivateKeyMethod keyMethod;

        /*
         * WARNING - void declaration
         */
        PrivateKeyMethod(OpenSslEngineMap engineMap, OpenSslPrivateKeyMethod keyMethod) {
            void var2_2;
            void var1_1;
            this.engineMap = var1_1;
            this.keyMethod = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] sign(long ssl, int signatureAlgorithm, byte[] digest) throws Exception {
            ReferenceCountedOpenSslEngine engine = ReferenceCountedOpenSslContext.access$400(this.engineMap, ssl);
            try {
                void var3_3;
                return ReferenceCountedOpenSslContext.verifyResult(this.keyMethod.sign(engine, (int)var3_3, digest));
            }
            catch (Exception e) {
                void var2_5;
                void var1_2;
                var1_2.initHandshakeException(e);
                throw var2_5;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] decrypt(long ssl, byte[] input) throws Exception {
            ReferenceCountedOpenSslEngine engine = ReferenceCountedOpenSslContext.access$400(this.engineMap, ssl);
            try {
                void var3_3;
                return ReferenceCountedOpenSslContext.verifyResult(this.keyMethod.decrypt(engine, (byte[])var3_3));
            }
            catch (Exception e) {
                void var2_4;
                void var1_2;
                var1_2.initHandshakeException(e);
                throw var2_4;
            }
        }
    }

    private static final class DefaultOpenSslEngineMap
    implements OpenSslEngineMap {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines = PlatformDependent.newConcurrentHashMap();

        private DefaultOpenSslEngineMap() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ReferenceCountedOpenSslEngine remove(long ssl) {
            void var1_1;
            return this.engines.remove((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(ReferenceCountedOpenSslEngine engine) {
            void var1_1;
            this.engines.put(engine.sslPointer(), (ReferenceCountedOpenSslEngine)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ReferenceCountedOpenSslEngine get(long ssl) {
            void var1_1;
            return this.engines.get((long)var1_1);
        }
    }

    static abstract class AbstractCertificateVerifier
    extends CertificateVerifier {
        private final OpenSslEngineMap engineMap;

        /*
         * WARNING - void declaration
         */
        AbstractCertificateVerifier(OpenSslEngineMap engineMap) {
            void var1_1;
            this.engineMap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final int verify(long ssl, byte[][] chain, String auth) {
            void var3_3;
            ReferenceCountedOpenSslEngine engine = this.engineMap.get(ssl);
            if (engine == null) {
                return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
            }
            X509Certificate[] peerCerts = ReferenceCountedOpenSslContext.certificates((byte[][])var3_3);
            try {
                this.verify(engine, peerCerts, auth);
                return CertificateVerifier.X509_V_OK;
            }
            catch (Throwable cause) {
                void var1_2;
                logger.debug("verification of certificate failed", cause);
                var1_2.initHandshakeException(cause);
                if (cause instanceof OpenSslCertificateException) {
                    return ((OpenSslCertificateException)cause).errorCode();
                }
                if (cause instanceof CertificateExpiredException) {
                    return CertificateVerifier.X509_V_ERR_CERT_HAS_EXPIRED;
                }
                if (cause instanceof CertificateNotYetValidException) {
                    return CertificateVerifier.X509_V_ERR_CERT_NOT_YET_VALID;
                }
                if (PlatformDependent.javaVersion() >= 7) {
                    void var2_6;
                    return AbstractCertificateVerifier.translateToError((Throwable)var2_6);
                }
                return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
            }
        }

        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        private static int translateToError(Throwable cause) {
            if (cause instanceof CertificateRevokedException) {
                return CertificateVerifier.X509_V_ERR_CERT_REVOKED;
            }
            for (Throwable wrapped = cause.getCause(); wrapped != null; wrapped = wrapped.getCause()) {
                if (!(wrapped instanceof CertPathValidatorException)) continue;
                CertPathValidatorException certPathValidatorException = (CertPathValidatorException)wrapped;
                CertPathValidatorException.Reason reason = certPathValidatorException.getReason();
                if (reason == CertPathValidatorException.BasicReason.EXPIRED) {
                    return CertificateVerifier.X509_V_ERR_CERT_HAS_EXPIRED;
                }
                if (reason == CertPathValidatorException.BasicReason.NOT_YET_VALID) {
                    return CertificateVerifier.X509_V_ERR_CERT_NOT_YET_VALID;
                }
                if (certPathValidatorException != CertPathValidatorException.BasicReason.REVOKED) continue;
                return CertificateVerifier.X509_V_ERR_CERT_REVOKED;
            }
            return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
        }

        abstract void verify(ReferenceCountedOpenSslEngine var1, X509Certificate[] var2, String var3) throws Exception;
    }
}

