/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemValue;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;

public final class PemX509Certificate
extends X509Certificate
implements PemEncoded {
    private static final byte[] BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
    private static final byte[] END_CERT = "\n-----END CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
    private final ByteBuf content;

    /*
     * WARNING - void declaration
     */
    static PemEncoded toPEM(ByteBufAllocator allocator, boolean useDirect, X509Certificate ... chain) throws CertificateEncodingException {
        X509Certificate first;
        ObjectUtil.checkNonEmpty((Object[])chain, (String)"chain");
        if (chain.length == 1 && (first = chain[0]) instanceof PemEncoded) {
            return ((PemEncoded)((Object)first)).retain();
        }
        boolean success = false;
        ByteBuf pem = null;
        try {
            X509Certificate[] x509CertificateArray = chain;
            int n = chain.length;
            for (int i = 0; i < n; ++i) {
                X509Certificate cert = x509CertificateArray[i];
                if (cert == null) {
                    throw new IllegalArgumentException("Null element in chain: " + Arrays.toString(chain));
                }
                pem = cert instanceof PemEncoded ? PemX509Certificate.append(allocator, useDirect, (PemEncoded)((Object)cert), chain.length, pem) : PemX509Certificate.append(allocator, useDirect, cert, chain.length, pem);
            }
            PemValue value = new PemValue(pem, false);
            success = true;
            PemValue pemValue = value;
            return pemValue;
        }
        catch (Throwable throwable) {
            void var3_5;
            if (var3_5 == false && pem != null) {
                pem.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf append(ByteBufAllocator allocator, boolean useDirect, PemEncoded encoded, int count, ByteBuf pem) {
        void var2_2;
        ByteBuf content = encoded.content();
        if (pem == null) {
            void var3_3;
            void var1_1;
            ByteBufAllocator byteBufAllocator;
            pem = PemX509Certificate.newBuffer(byteBufAllocator, (boolean)var1_1, content.readableBytes() * var3_3);
        }
        pem.writeBytes(var2_2.slice());
        return pem;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf append(ByteBufAllocator allocator, boolean useDirect, X509Certificate cert, int count, ByteBuf pem) throws CertificateEncodingException {
        ByteBuf encoded = Unpooled.wrappedBuffer((byte[])cert.getEncoded());
        try {
            ByteBuf base64 = SslUtils.toBase64(allocator, encoded);
            try {
                if (pem == null) {
                    void var3_5;
                    void var1_3;
                    ByteBufAllocator byteBufAllocator;
                    pem = PemX509Certificate.newBuffer(byteBufAllocator, (boolean)var1_3, (BEGIN_CERT.length + base64.readableBytes() + END_CERT.length) * var3_5);
                }
                pem.writeBytes(BEGIN_CERT);
                pem.writeBytes(base64);
                pem.writeBytes(END_CERT);
            }
            finally {
                base64.release();
            }
        }
        catch (Throwable throwable) {
            void var2_4;
            var2_4.release();
            throw throwable;
        }
        encoded.release();
        return pem;
    }

    /*
     * WARNING - void declaration
     */
    private static ByteBuf newBuffer(ByteBufAllocator allocator, boolean useDirect, int initialCapacity) {
        void var2_2;
        ByteBufAllocator byteBufAllocator;
        if (useDirect) {
            return allocator.directBuffer(initialCapacity);
        }
        return byteBufAllocator.buffer((int)var2_2);
    }

    public static PemX509Certificate valueOf(byte[] key) {
        return PemX509Certificate.valueOf(Unpooled.wrappedBuffer((byte[])key));
    }

    public static PemX509Certificate valueOf(ByteBuf key) {
        ByteBuf byteBuf;
        return new PemX509Certificate(byteBuf);
    }

    /*
     * WARNING - void declaration
     */
    private PemX509Certificate(ByteBuf content) {
        void var1_1;
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)var1_1, (String)"content");
    }

    @Override
    public final boolean isSensitive() {
        return false;
    }

    public final int refCnt() {
        return this.content.refCnt();
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf content() {
        int count = this.refCnt();
        if (count <= 0) {
            void var1_1;
            throw new IllegalReferenceCountException((int)var1_1);
        }
        return this.content;
    }

    @Override
    public final PemX509Certificate copy() {
        PemX509Certificate pemX509Certificate = this;
        return pemX509Certificate.replace(pemX509Certificate.content.copy());
    }

    @Override
    public final PemX509Certificate duplicate() {
        PemX509Certificate pemX509Certificate = this;
        return pemX509Certificate.replace(pemX509Certificate.content.duplicate());
    }

    @Override
    public final PemX509Certificate retainedDuplicate() {
        PemX509Certificate pemX509Certificate = this;
        return pemX509Certificate.replace(pemX509Certificate.content.retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PemX509Certificate replace(ByteBuf content) {
        void var1_1;
        return new PemX509Certificate((ByteBuf)var1_1);
    }

    @Override
    public final PemX509Certificate retain() {
        this.content.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PemX509Certificate retain(int increment) {
        void var1_1;
        this.content.retain((int)var1_1);
        return this;
    }

    @Override
    public final PemX509Certificate touch() {
        this.content.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PemX509Certificate touch(Object hint) {
        void var1_1;
        this.content.touch((Object)var1_1);
        return this;
    }

    public final boolean release() {
        return this.content.release();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean release(int decrement) {
        void var1_1;
        return this.content.release((int)var1_1);
    }

    @Override
    public final byte[] getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<String> getCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<String> getNonCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getExtensionValue(String oid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void checkValidity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void checkValidity(Date date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final BigInteger getSerialNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Principal getIssuerDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Principal getSubjectDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Date getNotBefore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Date getNotAfter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getTBSCertificate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getSignature() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getSigAlgName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getSigAlgOID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getSigAlgParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getIssuerUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getSubjectUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getKeyUsage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getBasicConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void verify(PublicKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final PublicKey getPublicKey() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object o) {
        void var1_1;
        if (o == this) {
            return true;
        }
        if (!(o instanceof PemX509Certificate)) {
            return false;
        }
        PemX509Certificate other = (PemX509Certificate)o;
        return this.content.equals((Object)var1_1.content);
    }

    @Override
    public final int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public final String toString() {
        return this.content.toString(CharsetUtil.UTF_8);
    }
}

