/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;

class PemValue
extends AbstractReferenceCounted
implements PemEncoded {
    private final ByteBuf content;
    private final boolean sensitive;

    /*
     * WARNING - void declaration
     */
    PemValue(ByteBuf content, boolean sensitive) {
        void var2_2;
        void var1_1;
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)var1_1, (String)"content");
        this.sensitive = var2_2;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuf content() {
        int count = this.refCnt();
        if (count <= 0) {
            void var1_1;
            throw new IllegalReferenceCountException((int)var1_1);
        }
        return this.content;
    }

    @Override
    public PemValue copy() {
        PemValue pemValue = this;
        return pemValue.replace(pemValue.content.copy());
    }

    @Override
    public PemValue duplicate() {
        PemValue pemValue = this;
        return pemValue.replace(pemValue.content.duplicate());
    }

    @Override
    public PemValue retainedDuplicate() {
        PemValue pemValue = this;
        return pemValue.replace(pemValue.content.retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PemValue replace(ByteBuf content) {
        void var1_1;
        return new PemValue((ByteBuf)var1_1, this.sensitive);
    }

    @Override
    public PemValue touch() {
        return (PemValue)super.touch();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PemValue touch(Object hint) {
        void var1_1;
        this.content.touch((Object)var1_1);
        return this;
    }

    @Override
    public PemValue retain() {
        return (PemValue)super.retain();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PemValue retain(int increment) {
        void var1_1;
        return (PemValue)super.retain((int)var1_1);
    }

    protected void deallocate() {
        if (this.sensitive) {
            SslUtils.zeroout(this.content);
        }
        this.content.release();
    }
}

