/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import java.security.PrivateKey;

public final class PemPrivateKey
extends AbstractReferenceCounted
implements PemEncoded,
PrivateKey {
    private static final long serialVersionUID = 7978017465645018936L;
    private static final byte[] BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----\n".getBytes(CharsetUtil.US_ASCII);
    private static final byte[] END_PRIVATE_KEY = "\n-----END PRIVATE KEY-----\n".getBytes(CharsetUtil.US_ASCII);
    private static final String PKCS8_FORMAT = "PKCS#8";
    private final ByteBuf content;

    /*
     * WARNING - void declaration
     */
    static PemEncoded toPEM(ByteBufAllocator allocator, boolean useDirect, PrivateKey key) {
        void var3_3;
        void var1_1;
        ByteBufAllocator byteBufAllocator;
        if (key instanceof PemEncoded) {
            return ((PemEncoded)((Object)key)).retain();
        }
        byte[] bytes = key.getEncoded();
        if (bytes == null) {
            void var2_2;
            throw new IllegalArgumentException(var2_2.getClass().getName() + " does not support encoding");
        }
        return PemPrivateKey.toPEM(byteBufAllocator, (boolean)var1_1, (byte[])var3_3);
    }

    /*
     * Exception decompiling
     */
    static PemEncoded toPEM(ByteBufAllocator allocator, boolean useDirect, byte[] bytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static PemPrivateKey valueOf(byte[] key) {
        return PemPrivateKey.valueOf(Unpooled.wrappedBuffer((byte[])key));
    }

    public static PemPrivateKey valueOf(ByteBuf key) {
        ByteBuf byteBuf;
        return new PemPrivateKey(byteBuf);
    }

    /*
     * WARNING - void declaration
     */
    private PemPrivateKey(ByteBuf content) {
        void var1_1;
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)var1_1, (String)"content");
    }

    @Override
    public final boolean isSensitive() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteBuf content() {
        int count = this.refCnt();
        if (count <= 0) {
            void var1_1;
            throw new IllegalReferenceCountException((int)var1_1);
        }
        return this.content;
    }

    @Override
    public final PemPrivateKey copy() {
        PemPrivateKey pemPrivateKey = this;
        return pemPrivateKey.replace(pemPrivateKey.content.copy());
    }

    @Override
    public final PemPrivateKey duplicate() {
        PemPrivateKey pemPrivateKey = this;
        return pemPrivateKey.replace(pemPrivateKey.content.duplicate());
    }

    @Override
    public final PemPrivateKey retainedDuplicate() {
        PemPrivateKey pemPrivateKey = this;
        return pemPrivateKey.replace(pemPrivateKey.content.retainedDuplicate());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PemPrivateKey replace(ByteBuf content) {
        void var1_1;
        return new PemPrivateKey((ByteBuf)var1_1);
    }

    @Override
    public final PemPrivateKey touch() {
        this.content.touch();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PemPrivateKey touch(Object hint) {
        void var1_1;
        this.content.touch((Object)var1_1);
        return this;
    }

    @Override
    public final PemPrivateKey retain() {
        return (PemPrivateKey)super.retain();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PemPrivateKey retain(int increment) {
        void var1_1;
        return (PemPrivateKey)super.retain((int)var1_1);
    }

    protected final void deallocate() {
        SslUtils.zerooutAndRelease(this.content);
    }

    @Override
    public final byte[] getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getAlgorithm() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getFormat() {
        return PKCS8_FORMAT;
    }

    @Override
    public final void destroy() {
        PemPrivateKey pemPrivateKey = this;
        pemPrivateKey.release(pemPrivateKey.refCnt());
    }

    @Override
    public final boolean isDestroyed() {
        return this.refCnt() == 0;
    }
}

