/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

@SuppressJava6Requirement(reason="Usage guarded by java version check")
final class OpenSslX509TrustManagerWrapper {
    private static final InternalLogger LOGGER;
    private static final TrustManagerWrapper WRAPPER;

    private OpenSslX509TrustManagerWrapper() {
    }

    static X509TrustManager wrapIfNeeded(X509TrustManager trustManager) {
        X509TrustManager x509TrustManager;
        return WRAPPER.wrapIfNeeded(x509TrustManager);
    }

    private static SSLContext newSSLContext() throws NoSuchAlgorithmException, NoSuchProviderException {
        return SSLContext.getInstance("TLS", "SunJSSE");
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        LOGGER = InternalLoggerFactory.getInstance(OpenSslX509TrustManagerWrapper.class);
        TrustManagerWrapper wrapper = new TrustManagerWrapper(){

            @Override
            public final X509TrustManager wrapIfNeeded(X509TrustManager manager) {
                return manager;
            }
        };
        Object cause = null;
        Throwable throwable = PlatformDependent.getUnsafeUnavailabilityCause();
        if (throwable == null) {
            SSLContext context;
            try {
                context = OpenSslX509TrustManagerWrapper.newSSLContext();
                context.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public final void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        throw new CertificateException();
                    }

                    @Override
                    public final void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        throw new CertificateException();
                    }

                    @Override
                    public final X509Certificate[] getAcceptedIssuers() {
                        return EmptyArrays.EMPTY_X509_CERTIFICATES;
                    }
                }}, null);
            }
            catch (Throwable error) {
                context = null;
                error = error;
            }
            if (error != null) {
                LOGGER.debug("Unable to access wrapped TrustManager", error);
            } else {
                Throwable finalContext = throwable;
                Object maybeWrapper = AccessController.doPrivileged(new PrivilegedAction<Object>((SSLContext)((Object)finalContext)){
                    final /* synthetic */ SSLContext val$finalContext;
                    {
                        this.val$finalContext = sSLContext;
                    }

                    @Override
                    public final Object run() {
                        try {
                            Field field = SSLContext.class.getDeclaredField("contextSpi");
                            long spiOffset = PlatformDependent.objectFieldOffset((Field)field);
                            Object spi = PlatformDependent.getObject((Object)this.val$finalContext, (long)spiOffset);
                            if (spi != null) {
                                Class<?> clazz = spi.getClass();
                                do {
                                    try {
                                        Object object = clazz.getDeclaredField("trustManager");
                                        long tmOffset = PlatformDependent.objectFieldOffset((Field)object);
                                        object = PlatformDependent.getObject((Object)spi, (long)tmOffset);
                                        if (object instanceof X509ExtendedTrustManager) {
                                            return new UnsafeTrustManagerWrapper(spiOffset, tmOffset);
                                        }
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {}
                                } while ((clazz = clazz.getSuperclass()) != null);
                            }
                            throw new NoSuchFieldException();
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                            return noSuchFieldException;
                        }
                        catch (SecurityException securityException) {
                            SecurityException securityException2 = securityException;
                            return securityException;
                        }
                    }
                });
                if (maybeWrapper instanceof Throwable) {
                    LOGGER.debug("Unable to access wrapped TrustManager", (Throwable)maybeWrapper);
                } else {
                    void var1_1;
                    wrapper = (TrustManagerWrapper)var1_1;
                }
            }
        } else {
            LOGGER.debug("Unable to access wrapped TrustManager", null);
        }
        WRAPPER = var0;
    }

    private static final class UnsafeTrustManagerWrapper
    implements TrustManagerWrapper {
        private final long spiOffset;
        private final long tmOffset;

        /*
         * WARNING - void declaration
         */
        UnsafeTrustManagerWrapper(long spiOffset, long tmOffset) {
            void var3_2;
            void var1_1;
            this.spiOffset = var1_1;
            this.tmOffset = var3_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @SuppressJava6Requirement(reason="Usage guarded by java version check")
        public final X509TrustManager wrapIfNeeded(X509TrustManager manager) {
            void var1_1;
            if (!(manager instanceof X509ExtendedTrustManager)) {
                try {
                    Object tm;
                    SSLContext ctx = OpenSslX509TrustManagerWrapper.newSSLContext();
                    ctx.init(null, new TrustManager[]{manager}, null);
                    Object spi = PlatformDependent.getObject((Object)ctx, (long)this.spiOffset);
                    if (spi != null && (tm = PlatformDependent.getObject((Object)spi, (long)this.tmOffset)) instanceof X509ExtendedTrustManager) {
                        void var2_2;
                        return (X509TrustManager)var2_2;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
                    PlatformDependent.throwException((Throwable)noSuchAlgorithmException);
                }
                catch (KeyManagementException keyManagementException) {
                    KeyManagementException keyManagementException2 = keyManagementException;
                    PlatformDependent.throwException((Throwable)keyManagementException);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    NoSuchProviderException noSuchProviderException2 = noSuchProviderException;
                    PlatformDependent.throwException((Throwable)noSuchProviderException);
                }
            }
            return var1_1;
        }
    }

    private static interface TrustManagerWrapper {
        public X509TrustManager wrapIfNeeded(X509TrustManager var1);
    }
}

