/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslPrivateKey;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.internal.tcnative.SSL;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;

public final class OpenSslX509KeyManagerFactory
extends KeyManagerFactory {
    private final OpenSslKeyManagerFactorySpi spi;

    public OpenSslX509KeyManagerFactory() {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(null));
    }

    /*
     * WARNING - void declaration
     */
    public OpenSslX509KeyManagerFactory(Provider provider) {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi((Provider)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public OpenSslX509KeyManagerFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        this(OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi((String)var1_1, (Provider)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private OpenSslX509KeyManagerFactory(OpenSslKeyManagerFactorySpi spi) {
        void var1_1;
        OpenSslKeyManagerFactorySpi openSslKeyManagerFactorySpi = spi;
        super(openSslKeyManagerFactorySpi, openSslKeyManagerFactorySpi.kmf.getProvider(), spi.kmf.getAlgorithm());
        this.spi = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static OpenSslKeyManagerFactorySpi newOpenSslKeyManagerFactorySpi(Provider provider) {
        try {
            return OpenSslX509KeyManagerFactory.newOpenSslKeyManagerFactorySpi(null, provider);
        }
        catch (NoSuchAlgorithmException e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static OpenSslKeyManagerFactorySpi newOpenSslKeyManagerFactorySpi(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        void var1_1;
        String string;
        if (algorithm == null) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        return new OpenSslKeyManagerFactorySpi(provider == null ? KeyManagerFactory.getInstance(algorithm) : KeyManagerFactory.getInstance(string, (Provider)var1_1));
    }

    final OpenSslKeyMaterialProvider newProvider() {
        return this.spi.newProvider();
    }

    /*
     * WARNING - void declaration
     */
    public static OpenSslX509KeyManagerFactory newEngineBased(File certificateChain, String password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        void var1_1;
        return OpenSslX509KeyManagerFactory.newEngineBased(SslContext.toX509Certificates(certificateChain), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static OpenSslX509KeyManagerFactory newEngineBased(X509Certificate[] certificateChain, String password) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        void var2_2;
        void var1_1;
        Object object;
        ObjectUtil.checkNotNull((Object)certificateChain, (String)"certificateChain");
        Object store = new OpenSslKeyStore((X509Certificate[])certificateChain.clone(), false);
        store.load(null, null);
        OpenSslX509KeyManagerFactory factory = new OpenSslX509KeyManagerFactory();
        factory.init((KeyStore)object, password == null ? null : var1_1.toCharArray());
        return var2_2;
    }

    public static OpenSslX509KeyManagerFactory newKeyless(File chain) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return OpenSslX509KeyManagerFactory.newKeyless(SslContext.toX509Certificates(chain));
    }

    public static OpenSslX509KeyManagerFactory newKeyless(InputStream chain) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return OpenSslX509KeyManagerFactory.newKeyless(SslContext.toX509Certificates(chain));
    }

    /*
     * WARNING - void declaration
     */
    public static OpenSslX509KeyManagerFactory newKeyless(X509Certificate ... certificateChain) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        void var1_1;
        Object object;
        ObjectUtil.checkNotNull((Object)certificateChain, (String)"certificateChain");
        Object store = new OpenSslKeyStore((X509Certificate[])certificateChain.clone(), true);
        store.load(null, null);
        OpenSslX509KeyManagerFactory factory = new OpenSslX509KeyManagerFactory();
        factory.init((KeyStore)object, null);
        return var1_1;
    }

    private static final class OpenSslKeyStore
    extends KeyStore {
        /*
         * WARNING - void declaration
         */
        private OpenSslKeyStore(X509Certificate[] certificateChain, boolean keyless) {
            super(new KeyStoreSpi((boolean)var2_2, (X509Certificate[])var1_1){
                private final Date creationDate = new Date();
                final /* synthetic */ boolean val$keyless;
                final /* synthetic */ X509Certificate[] val$certificateChain;
                {
                    this.val$keyless = bl;
                    this.val$certificateChain = x509CertificateArray;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
                    if (this.engineContainsAlias(alias)) {
                        void var3_4;
                        long privateKeyAddress;
                        if (this.val$keyless) {
                            privateKeyAddress = 0L;
                        } else {
                            try {
                                privateKeyAddress = SSL.loadPrivateKeyFromEngine((String)alias, (String)(password == null ? null : new String(password)));
                            }
                            catch (Exception e) {
                                void var2_3;
                                void var1_2;
                                UnrecoverableKeyException keyException = new UnrecoverableKeyException("Unable to load key from engine");
                                keyException.initCause((Throwable)var1_2);
                                throw var2_3;
                            }
                        }
                        return new OpenSslPrivateKey((long)var3_4);
                    }
                    return null;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Certificate[] engineGetCertificateChain(String alias) {
                    void var1_1;
                    if (this.engineContainsAlias((String)var1_1)) {
                        return (X509Certificate[])this.val$certificateChain.clone();
                    }
                    return null;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Certificate engineGetCertificate(String alias) {
                    void var1_1;
                    if (this.engineContainsAlias((String)var1_1)) {
                        return this.val$certificateChain[0];
                    }
                    return null;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Date engineGetCreationDate(String alias) {
                    void var1_1;
                    if (this.engineContainsAlias((String)var1_1)) {
                        return this.creationDate;
                    }
                    return null;
                }

                @Override
                public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
                    throw new KeyStoreException("Not supported");
                }

                @Override
                public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
                    throw new KeyStoreException("Not supported");
                }

                @Override
                public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
                    throw new KeyStoreException("Not supported");
                }

                @Override
                public void engineDeleteEntry(String alias) throws KeyStoreException {
                    throw new KeyStoreException("Not supported");
                }

                @Override
                public Enumeration<String> engineAliases() {
                    return Collections.enumeration(Collections.singleton("key"));
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean engineContainsAlias(String alias) {
                    void var1_1;
                    return "key".equals(var1_1);
                }

                @Override
                public int engineSize() {
                    return 1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean engineIsKeyEntry(String alias) {
                    void var1_1;
                    return this.engineContainsAlias((String)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean engineIsCertificateEntry(String alias) {
                    void var1_1;
                    return this.engineContainsAlias((String)var1_1);
                }

                @Override
                public String engineGetCertificateAlias(Certificate cert) {
                    if (cert instanceof X509Certificate) {
                        X509Certificate[] x509CertificateArray = this.val$certificateChain;
                        int n = this.val$certificateChain.length;
                        for (int i = 0; i < n; ++i) {
                            X509Certificate x509Certificate = x509CertificateArray[i];
                            if (!x509Certificate.equals(cert)) continue;
                            return "key";
                        }
                    }
                    return null;
                }

                @Override
                public void engineStore(OutputStream stream, char[] password) {
                    throw new UnsupportedOperationException();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void engineLoad(InputStream stream, char[] password) {
                    void var2_2;
                    if (stream != null && var2_2 != null) {
                        throw new UnsupportedOperationException();
                    }
                }
            }, null, "native");
            void var1_1;
            void var2_2;
            OpenSsl.ensureAvailability();
        }
    }

    private static final class OpenSslKeyManagerFactorySpi
    extends KeyManagerFactorySpi {
        final KeyManagerFactory kmf;
        private volatile ProviderFactory providerFactory;

        /*
         * WARNING - void declaration
         */
        OpenSslKeyManagerFactorySpi(KeyManagerFactory kmf) {
            void var1_1;
            this.kmf = (KeyManagerFactory)ObjectUtil.checkNotNull((Object)var1_1, (String)"kmf");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final synchronized void engineInit(KeyStore keyStore, char[] chars) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            void var1_1;
            void var2_2;
            if (this.providerFactory != null) {
                throw new KeyStoreException("Already initialized");
            }
            if (!keyStore.aliases().hasMoreElements()) {
                throw new KeyStoreException("No aliases found");
            }
            this.kmf.init(keyStore, chars);
            this.providerFactory = new ProviderFactory(ReferenceCountedOpenSslContext.chooseX509KeyManager(this.kmf.getKeyManagers()), OpenSslKeyManagerFactorySpi.password((char[])var2_2), Collections.list(var1_1.aliases()));
        }

        private static String password(char[] password) {
            char[] cArray;
            if (password == null || password.length == 0) {
                return null;
            }
            return new String(cArray);
        }

        @Override
        protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("Not supported");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final KeyManager[] engineGetKeyManagers() {
            void var1_1;
            ProviderFactory providerFactory = this.providerFactory;
            if (providerFactory == null) {
                throw new IllegalStateException("engineInit(...) not called yet");
            }
            return new KeyManager[]{((ProviderFactory)var1_1).keyManager};
        }

        /*
         * WARNING - void declaration
         */
        final OpenSslKeyMaterialProvider newProvider() {
            void var1_1;
            ProviderFactory providerFactory = this.providerFactory;
            if (providerFactory == null) {
                throw new IllegalStateException("engineInit(...) not called yet");
            }
            return var1_1.newProvider();
        }

        private static final class ProviderFactory {
            private final X509KeyManager keyManager;
            private final String password;
            private final Iterable<String> aliases;

            /*
             * WARNING - void declaration
             */
            ProviderFactory(X509KeyManager keyManager, String password, Iterable<String> aliases) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.keyManager = var1_1;
                this.password = var2_2;
                this.aliases = var3_3;
            }

            final OpenSslKeyMaterialProvider newProvider() {
                return new OpenSslPopulatedKeyMaterialProvider(this.keyManager, this.password, this.aliases);
            }

            private static final class OpenSslPopulatedKeyMaterialProvider
            extends OpenSslKeyMaterialProvider {
                private final Map<String, Object> materialMap = new HashMap<String, Object>();

                /*
                 * WARNING - void declaration
                 */
                OpenSslPopulatedKeyMaterialProvider(X509KeyManager keyManager, String password, Iterable<String> aliases) {
                    super((X509KeyManager)((Object)iterator), password);
                    Iterator<String> iterator;
                    try {
                        for (String alias : aliases) {
                            if (alias == null || this.materialMap.containsKey(alias)) continue;
                            try {
                                this.materialMap.put(alias, super.chooseKeyMaterial((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, alias));
                            }
                            catch (Exception e) {
                                void var3_5;
                                void var2_3;
                                this.materialMap.put((String)var2_3, var3_5);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.destroy();
                        throw throwable;
                    }
                    ObjectUtil.checkNonEmpty(this.materialMap, (String)"materialMap");
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                final OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias) throws Exception {
                    void var1_1;
                    void var2_2;
                    Object value = this.materialMap.get(var2_2);
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof OpenSslKeyMaterial) {
                        return ((OpenSslKeyMaterial)value).retain();
                    }
                    throw (Exception)var1_1;
                }

                @Override
                final void destroy() {
                    for (Object object : this.materialMap.values()) {
                        ReferenceCountUtil.release((Object)object);
                    }
                    this.materialMap.clear();
                }
            }
        }
    }
}

