/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslSession;
import io.netty.handler.ssl.OpenSslSessionCache;
import io.netty.handler.ssl.OpenSslSessionId;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SSLSessionCache;
import io.netty.internal.tcnative.SessionTicketKey;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

public abstract class OpenSslSessionContext
implements SSLSessionContext {
    private final OpenSslSessionStats stats;
    private final OpenSslKeyMaterialProvider provider;
    final ReferenceCountedOpenSslContext context;
    private final OpenSslSessionCache sessionCache;
    private final long mask;

    /*
     * WARNING - void declaration
     */
    OpenSslSessionContext(ReferenceCountedOpenSslContext context, OpenSslKeyMaterialProvider provider, long mask, OpenSslSessionCache cache) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.context = context;
        this.provider = var2_2;
        this.mask = var3_3;
        this.stats = new OpenSslSessionStats(context);
        this.sessionCache = cache;
        SSLContext.setSSLSessionCache((long)var1_1.ctx, (SSLSessionCache)cache);
    }

    final boolean useKeyManager() {
        return this.provider != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSessionCacheSize(int size) {
        void var1_1;
        ObjectUtil.checkPositiveOrZero((int)size, (String)"size");
        this.sessionCache.setSessionCacheSize((int)var1_1);
    }

    @Override
    public int getSessionCacheSize() {
        return this.sessionCache.getSessionCacheSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSessionTimeout(int seconds) {
        ObjectUtil.checkPositiveOrZero((int)seconds, (String)"seconds");
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            void var1_1;
            SSLContext.setSessionCacheTimeout((long)this.context.ctx, (long)seconds);
            this.sessionCache.setSessionTimeout((int)var1_1);
            writerLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.unlock();
            throw throwable;
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionCache.getSessionTimeout();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLSession getSession(byte[] bytes) {
        void var1_1;
        return this.sessionCache.getSession(new OpenSslSessionId((byte[])var1_1));
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return new Enumeration<byte[]>(this){
            private final Iterator<OpenSslSessionId> ids;
            final /* synthetic */ OpenSslSessionContext this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.ids = this.this$0.sessionCache.getIds().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.ids.hasNext();
            }

            @Override
            public byte[] nextElement() {
                return this.ids.next().cloneBytes();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setTicketKeys(byte[] keys) {
        if (keys.length % 48 != 0) {
            throw new IllegalArgumentException("keys.length % 48 != 0");
        }
        SessionTicketKey[] tickets = new SessionTicketKey[keys.length / 48];
        int a = 0;
        for (int i = 0; i < tickets.length; ++i) {
            byte[] name = Arrays.copyOfRange(keys, a, 16);
            byte[] hmacKey = Arrays.copyOfRange(keys, a += 16, 16);
            byte[] aesKey = Arrays.copyOfRange(keys, a, 16);
            a += 16;
            tickets[i += 16] = new SessionTicketKey(name, hmacKey, aesKey);
        }
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            void var2_3;
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])var2_3);
            writerLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var3_5;
            var3_5.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTicketKeys(OpenSslSessionTicketKey ... keys) {
        ObjectUtil.checkNotNull((Object)keys, (String)"keys");
        SessionTicketKey[] ticketKeys = new SessionTicketKey[keys.length];
        for (int i = 0; i < ticketKeys.length; ++i) {
            ticketKeys[i] = keys[i].key;
        }
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            SSLContext.clearOptions((long)this.context.ctx, (int)SSL.SSL_OP_NO_TICKET);
            if (ticketKeys.length > 0) {
                void var2_3;
                SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])var2_3);
            }
            writerLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var3_5;
            var3_5.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionCacheEnabled(boolean enabled) {
        long mode = enabled ? this.mask | SSL.SSL_SESS_CACHE_NO_INTERNAL_LOOKUP | SSL.SSL_SESS_CACHE_NO_INTERNAL_STORE : SSL.SSL_SESS_CACHE_OFF;
        Lock writerLock = this.context.ctxLock.writeLock();
        writerLock.lock();
        try {
            void var1_1;
            void var2_3;
            SSLContext.setSessionCacheMode((long)this.context.ctx, (long)var2_3);
            if (var1_1 == false) {
                this.sessionCache.clear();
            }
            return;
        }
        finally {
            writerLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSessionCacheEnabled() {
        Lock readerLock = this.context.ctxLock.readLock();
        readerLock.lock();
        try {
            boolean bl = (SSLContext.getSessionCacheMode((long)this.context.ctx) & this.mask) != 0L;
            readerLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    public OpenSslSessionStats stats() {
        return this.stats;
    }

    /*
     * WARNING - void declaration
     */
    final void removeFromCache(OpenSslSessionId id) {
        void var1_1;
        this.sessionCache.removeSessionWithId((OpenSslSessionId)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final boolean isInCache(OpenSslSessionId id) {
        void var1_1;
        return this.sessionCache.containsSessionWithId((OpenSslSessionId)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    boolean setSessionFromCache(long ssl, OpenSslSession session, String host, int port) {
        void var3_2;
        void var1_1;
        return this.sessionCache.setSession((long)var1_1, (OpenSslSession)var3_2, host, port);
    }

    final void destroy() {
        if (this.provider != null) {
            this.provider.destroy();
        }
        this.sessionCache.clear();
    }
}

