/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslSession;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionId;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.internal.tcnative.SSLSession;
import io.netty.internal.tcnative.SSLSessionCache;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.SystemPropertyUtil;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.cert.X509Certificate;

class OpenSslSessionCache
implements SSLSessionCache {
    private static final OpenSslSession[] EMPTY_SESSIONS;
    private static final int DEFAULT_CACHE_SIZE;
    private final OpenSslEngineMap engineMap;
    private final Map<OpenSslSessionId, NativeSslSession> sessions = new LinkedHashMap<OpenSslSessionId, NativeSslSession>(this){
        private static final long serialVersionUID = -7773696788135734448L;
        final /* synthetic */ OpenSslSessionCache this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry<OpenSslSessionId, NativeSslSession> eldest) {
            void var2_2;
            int maxSize = this.this$0.maximumCacheSize.get();
            if (maxSize >= 0 && this.size() > var2_2) {
                void var1_1;
                this.this$0.removeSessionWithId((OpenSslSessionId)var1_1.getKey());
            }
            return false;
        }
    };
    private final AtomicInteger maximumCacheSize = new AtomicInteger(DEFAULT_CACHE_SIZE);
    private final AtomicInteger sessionTimeout = new AtomicInteger(300);
    private int sessionCounter;

    /*
     * WARNING - void declaration
     */
    OpenSslSessionCache(OpenSslEngineMap engineMap) {
        void var1_1;
        this.engineMap = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setSessionTimeout(int seconds) {
        void var1_1;
        int n = this.sessionTimeout.getAndSet(seconds);
        if (n > var1_1) {
            this.clear();
        }
    }

    final int getSessionTimeout() {
        return this.sessionTimeout.get();
    }

    protected boolean sessionCreated(NativeSslSession session) {
        return true;
    }

    protected void sessionRemoved(NativeSslSession session) {
    }

    /*
     * WARNING - void declaration
     */
    final void setSessionCacheSize(int size) {
        void var1_1;
        long l = this.maximumCacheSize.getAndSet(size);
        if (l > (long)size || var1_1 == false) {
            this.clear();
        }
    }

    final int getSessionCacheSize() {
        return this.maximumCacheSize.get();
    }

    private void expungeInvalidSessions() {
        NativeSslSession session;
        if (this.sessions.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<OpenSslSessionId, NativeSslSession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext() && !(session = iterator.next().getValue()).isValid(now)) {
            iterator.remove();
            this.notifyRemovalAndFree(session);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean sessionCreated(long ssl, long sslSession) {
        OpenSslSessionCache openSslSessionCache;
        void var3_4;
        ReferenceCountedOpenSslEngine engine = this.engineMap.get(ssl);
        if (engine == null) {
            return false;
        }
        OpenSslSession openSslSession = (OpenSslSession)engine.getSession();
        NativeSslSession session = new NativeSslSession((long)var3_4, engine.getPeerHost(), engine.getPeerPort(), (long)this.getSessionTimeout() * 1000L, openSslSession.keyValueStorage());
        openSslSessionCache.setSessionDetails(session.creationTime, session.lastAccessedTime, session.sessionId(), session.keyValueStorage);
        openSslSessionCache = this;
        synchronized (openSslSessionCache) {
            if (++this.sessionCounter == 255) {
                this.sessionCounter = 0;
                this.expungeInvalidSessions();
            }
            if (!this.sessionCreated(session)) {
                session.close();
                return false;
            }
            NativeSslSession old = this.sessions.put(session.sessionId(), session);
            if (old != null) {
                void var1_2;
                this.notifyRemovalAndFree((NativeSslSession)var1_2);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final long getSession(long ssl, byte[] sessionId) {
        void var3_4;
        void var1_1;
        NativeSslSession session;
        OpenSslSessionId id = new OpenSslSessionId(sessionId);
        OpenSslSessionCache openSslSessionCache = this;
        synchronized (openSslSessionCache) {
            session = this.sessions.get(id);
            if (session == null) {
                return -1L;
            }
            if (!session.isValid() || !session.upRef()) {
                this.removeSessionWithId(session.sessionId());
                return -1L;
            }
            if (session.shouldBeSingleUse()) {
                this.removeSessionWithId(session.sessionId());
            }
        }
        session.setLastAccessedTime(System.currentTimeMillis());
        ReferenceCountedOpenSslEngine engine = this.engineMap.get((long)var1_1);
        if (engine != null) {
            OpenSslSession openSslSession = (OpenSslSession)engine.getSession();
            openSslSession.setSessionDetails(session.getCreationTime(), session.getLastAccessedTime(), session.sessionId(), session.keyValueStorage);
        }
        return var3_4.session();
    }

    boolean setSession(long ssl, OpenSslSession session, String host, int port) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final synchronized void removeSessionWithId(OpenSslSessionId id) {
        NativeSslSession sslSession = this.sessions.remove(id);
        if (sslSession != null) {
            void var1_1;
            this.notifyRemovalAndFree((NativeSslSession)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    final synchronized boolean containsSessionWithId(OpenSslSessionId id) {
        void var1_1;
        return this.sessions.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void notifyRemovalAndFree(NativeSslSession session) {
        void var1_1;
        this.sessionRemoved(session);
        var1_1.free();
    }

    /*
     * WARNING - void declaration
     */
    final synchronized OpenSslSession getSession(OpenSslSessionId id) {
        void var1_1;
        NativeSslSession session = this.sessions.get(id);
        if (session != null && !session.isValid()) {
            this.removeSessionWithId(session.sessionId());
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final List<OpenSslSessionId> getIds() {
        void var1_2;
        OpenSslSession[] sessionsArray;
        OpenSslSessionCache openSslSessionCache = this;
        synchronized (openSslSessionCache) {
            sessionsArray = this.sessions.values().toArray(EMPTY_SESSIONS);
        }
        ArrayList<OpenSslSessionId> ids = new ArrayList<OpenSslSessionId>(sessionsArray.length);
        for (void session : var1_2) {
            if (!session.isValid()) continue;
            ids.add(session.sessionId());
        }
        return openSslSessionCache;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void clear() {
        Iterator<Map.Entry<OpenSslSessionId, NativeSslSession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            void var2_2;
            NativeSslSession session = iterator.next().getValue();
            iterator.remove();
            this.notifyRemovalAndFree((NativeSslSession)var2_2);
        }
    }

    static {
        int n;
        EMPTY_SESSIONS = new OpenSslSession[0];
        int cacheSize = SystemPropertyUtil.getInt((String)"javax.net.ssl.sessionCacheSize", (int)20480);
        DEFAULT_CACHE_SIZE = cacheSize >= 0 ? n : 20480;
    }

    static final class NativeSslSession
    implements OpenSslSession {
        static final ResourceLeakDetector<NativeSslSession> LEAK_DETECTOR = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(NativeSslSession.class);
        private final ResourceLeakTracker<NativeSslSession> leakTracker;
        final Map<String, Object> keyValueStorage;
        private final long session;
        private final String peerHost;
        private final int peerPort;
        private final OpenSslSessionId id;
        private final long timeout;
        private final long creationTime;
        private volatile long lastAccessedTime;
        private volatile boolean valid;
        private boolean freed;

        /*
         * WARNING - void declaration
         */
        NativeSslSession(long session, String peerHost, int peerPort, long timeout, Map<String, Object> keyValueStorage) {
            void var1_1;
            void var3_2;
            this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
            this.valid = true;
            this.session = session;
            this.peerHost = var3_2;
            this.peerPort = peerPort;
            this.timeout = timeout;
            this.id = new OpenSslSessionId(SSLSession.getSessionId((long)var1_1));
            this.keyValueStorage = keyValueStorage;
            this.leakTracker = LEAK_DETECTOR.track((Object)this);
        }

        @Override
        public final Map<String, Object> keyValueStorage() {
            return this.keyValueStorage;
        }

        @Override
        public final void prepareHandshake() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setSessionDetails(long creationTime, long lastAccessedTime, OpenSslSessionId id, Map<String, Object> keyValueStorage) {
            throw new UnsupportedOperationException();
        }

        final boolean shouldBeSingleUse() {
            assert (!this.freed);
            return SSLSession.shouldBeSingleUse((long)this.session);
        }

        final long session() {
            assert (!this.freed);
            return this.session;
        }

        final boolean upRef() {
            assert (!this.freed);
            return SSLSession.upRef((long)this.session);
        }

        final synchronized void free() {
            this.close();
            SSLSession.free((long)this.session);
        }

        final void close() {
            assert (!this.freed);
            this.freed = true;
            this.invalidate();
            if (this.leakTracker != null) {
                this.leakTracker.close((Object)this);
            }
        }

        @Override
        public final OpenSslSessionId sessionId() {
            return this.id;
        }

        /*
         * WARNING - void declaration
         */
        final boolean isValid(long now) {
            void var1_1;
            return this.creationTime + this.timeout >= var1_1 && this.valid;
        }

        @Override
        public final void setLocalCertificate(Certificate[] localCertificate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final OpenSslSessionContext getSessionContext() {
            return null;
        }

        @Override
        public final void tryExpandApplicationBufferSize(int packetLengthDataOnly) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void handshakeFinished(byte[] id, String cipher, String protocol, byte[] peerCertificate, byte[][] peerCertificateChain, long creationTime, long timeout) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final byte[] getId() {
            return this.id.cloneBytes();
        }

        @Override
        public final long getCreationTime() {
            return this.creationTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setLastAccessedTime(long time) {
            void var1_1;
            this.lastAccessedTime = var1_1;
        }

        @Override
        public final long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        @Override
        public final void invalidate() {
            this.valid = false;
        }

        @Override
        public final boolean isValid() {
            return this.isValid(System.currentTimeMillis());
        }

        @Override
        public final void putValue(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Object getValue(String name) {
            return null;
        }

        @Override
        public final void removeValue(String name) {
        }

        @Override
        public final String[] getValueNames() {
            return EmptyArrays.EMPTY_STRINGS;
        }

        @Override
        public final Certificate[] getPeerCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Certificate[] getLocalCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final X509Certificate[] getPeerCertificateChain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Principal getPeerPrincipal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Principal getLocalPrincipal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final String getCipherSuite() {
            return null;
        }

        @Override
        public final String getProtocol() {
            return null;
        }

        @Override
        public final String getPeerHost() {
            return this.peerHost;
        }

        @Override
        public final int getPeerPort() {
            return this.peerPort;
        }

        @Override
        public final int getPacketBufferSize() {
            return ReferenceCountedOpenSslEngine.MAX_RECORD_SIZE;
        }

        @Override
        public final int getApplicationBufferSize() {
            return ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH;
        }

        public final int hashCode() {
            return this.id.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (!(o instanceof OpenSslSession)) {
                return false;
            }
            OpenSslSession session1 = (OpenSslSession)o;
            return this.id.equals(var1_1.sessionId());
        }
    }
}

