/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.internal.tcnative.SSL;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.EmptyArrays;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

final class OpenSslPrivateKey
extends AbstractReferenceCounted
implements PrivateKey {
    private long privateKeyAddress;

    /*
     * WARNING - void declaration
     */
    OpenSslPrivateKey(long privateKeyAddress) {
        void var1_1;
        this.privateKeyAddress = var1_1;
    }

    @Override
    public final String getAlgorithm() {
        return "unknown";
    }

    @Override
    public final String getFormat() {
        return null;
    }

    @Override
    public final byte[] getEncoded() {
        return null;
    }

    private long privateKeyAddress() {
        if (this.refCnt() <= 0) {
            throw new IllegalReferenceCountException();
        }
        return this.privateKeyAddress;
    }

    protected final void deallocate() {
        SSL.freePrivateKey((long)this.privateKeyAddress);
        this.privateKeyAddress = 0L;
    }

    public final OpenSslPrivateKey retain() {
        super.retain();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final OpenSslPrivateKey retain(int increment) {
        void var1_1;
        super.retain((int)var1_1);
        return this;
    }

    public final OpenSslPrivateKey touch() {
        super.touch();
        return this;
    }

    public final OpenSslPrivateKey touch(Object hint) {
        return this;
    }

    @Override
    public final void destroy() {
        OpenSslPrivateKey openSslPrivateKey = this;
        openSslPrivateKey.release(openSslPrivateKey.refCnt());
    }

    @Override
    public final boolean isDestroyed() {
        return this.refCnt() == 0;
    }

    /*
     * WARNING - void declaration
     */
    final OpenSslKeyMaterial newKeyMaterial(long certificateChain, X509Certificate[] chain) {
        void var3_2;
        void var1_1;
        return new OpenSslPrivateKeyMaterial((long)var1_1, (X509Certificate[])var3_2);
    }

    final class OpenSslPrivateKeyMaterial
    extends AbstractReferenceCounted
    implements OpenSslKeyMaterial {
        long certificateChain;
        private final X509Certificate[] x509CertificateChain;

        /*
         * WARNING - void declaration
         */
        OpenSslPrivateKeyMaterial(long certificateChain, X509Certificate[] x509CertificateChain) {
            void var1_1;
            void var2_2;
            this.certificateChain = var2_2;
            this.x509CertificateChain = x509CertificateChain == null ? EmptyArrays.EMPTY_X509_CERTIFICATES : x509CertificateChain;
            var1_1.retain();
        }

        @Override
        public final X509Certificate[] certificateChain() {
            return (X509Certificate[])this.x509CertificateChain.clone();
        }

        @Override
        public final long certificateChainAddress() {
            if (this.refCnt() <= 0) {
                throw new IllegalReferenceCountException();
            }
            return this.certificateChain;
        }

        @Override
        public final long privateKeyAddress() {
            if (this.refCnt() <= 0) {
                throw new IllegalReferenceCountException();
            }
            return OpenSslPrivateKey.this.privateKeyAddress();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final OpenSslKeyMaterial touch(Object hint) {
            void var1_1;
            OpenSslPrivateKey.this.touch(var1_1);
            return this;
        }

        @Override
        public final OpenSslKeyMaterial retain() {
            super.retain();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final OpenSslKeyMaterial retain(int increment) {
            void var1_1;
            super.retain((int)var1_1);
            return this;
        }

        @Override
        public final OpenSslKeyMaterial touch() {
            OpenSslPrivateKey.this.touch();
            return this;
        }

        protected final void deallocate() {
            this.releaseChain();
            OpenSslPrivateKey.this.release();
        }

        private void releaseChain() {
            SSL.freeX509Chain((long)this.certificateChain);
            this.certificateChain = 0L;
        }
    }
}

