/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslPrivateKey;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.internal.tcnative.SSL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    /*
     * WARNING - void declaration
     */
    OpenSslKeyMaterialProvider(X509KeyManager keyManager, String password) {
        void var2_2;
        void var1_1;
        this.keyManager = var1_1;
        this.password = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static void validateKeyMaterialSupported(X509Certificate[] keyCertChain, PrivateKey key, String keyPassword) throws SSLException {
        void var2_2;
        void var1_1;
        OpenSslKeyMaterialProvider.validateSupported(keyCertChain);
        OpenSslKeyMaterialProvider.validateSupported((PrivateKey)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void validateSupported(PrivateKey key, String password) throws SSLException {
        long pkey;
        if (key == null) {
            return;
        }
        long pkeyBio = 0L;
        try {
            pkeyBio = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, key);
            pkey = SSL.parsePrivateKey((long)pkeyBio, (String)password);
        }
        catch (Exception e) {
            try {
                void var1_3;
                PrivateKey privateKey;
                throw new SSLException("PrivateKey type not supported " + privateKey.getFormat(), (Throwable)var1_3);
            }
            catch (Throwable throwable) {
                void var2_4;
                SSL.freeBIO((long)var2_4);
                if (0L != 0L) {
                    SSL.freePrivateKey((long)0L);
                }
                throw throwable;
            }
        }
        SSL.freeBIO((long)pkeyBio);
        if (pkey != 0L) {
            SSL.freePrivateKey((long)pkey);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void validateSupported(X509Certificate[] certificates) throws SSLException {
        long chain;
        if (certificates == null || certificates.length == 0) {
            return;
        }
        long chainBio = 0L;
        PemEncoded encoded = null;
        try {
            encoded = PemX509Certificate.toPEM((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, certificates);
            chainBio = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, encoded.retain());
            chain = SSL.parseX509Chain((long)chainBio);
        }
        catch (Exception e) {
            try {
                void var0_1;
                throw new SSLException("Certificate type not supported", (Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var1_3;
                SSL.freeBIO((long)var1_3);
                if (0L != 0L) {
                    SSL.freeX509Chain((long)0L);
                }
                if (encoded != null) {
                    encoded.release();
                }
                throw throwable;
            }
        }
        SSL.freeBIO((long)chainBio);
        if (chain != 0L) {
            void var3_5;
            SSL.freeX509Chain((long)var3_5);
        }
        if (encoded != null) {
            encoded.release();
            return;
        }
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    /*
     * WARNING - void declaration
     */
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias) throws Exception {
        void var1_1;
        X509Certificate[] certificates = this.keyManager.getCertificateChain(alias);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        PrivateKey key = this.keyManager.getPrivateKey(alias);
        PemEncoded encoded = PemX509Certificate.toPEM(allocator, true, certificates);
        long chainBio = 0L;
        long pkeyBio = 0L;
        long chain = 0L;
        long pkey = 0L;
        try {
            OpenSslKeyMaterial keyMaterial;
            chainBio = ReferenceCountedOpenSslContext.toBIO(allocator, encoded.retain());
            chain = SSL.parseX509Chain((long)chainBio);
            if (key instanceof OpenSslPrivateKey) {
                keyMaterial = ((OpenSslPrivateKey)key).newKeyMaterial(chain, certificates);
            } else {
                void var3_4;
                void var2_3;
                pkeyBio = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)keyMaterial, key);
                pkey = var2_3 == null ? 0L : SSL.parsePrivateKey((long)pkeyBio, (String)this.password);
                keyMaterial = new DefaultOpenSslKeyMaterial(chain, pkey, (X509Certificate[])var3_4);
            }
            chain = 0L;
            pkey = 0L;
        }
        catch (Throwable throwable) {
            SSL.freeBIO((long)chainBio);
            SSL.freeBIO((long)pkeyBio);
            if (chain != 0L) {
                SSL.freeX509Chain((long)chain);
            }
            if (pkey != 0L) {
                SSL.freePrivateKey((long)pkey);
            }
            encoded.release();
            throw throwable;
        }
        SSL.freeBIO((long)chainBio);
        SSL.freeBIO((long)pkeyBio);
        if (0L != 0L) {
            SSL.freeX509Chain((long)0L);
        }
        if (0L != 0L) {
            SSL.freePrivateKey((long)0L);
        }
        encoded.release();
        return var1_1;
    }

    void destroy() {
    }
}

