/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;

final class OpenSslKeyMaterialManager {
    static final String KEY_TYPE_RSA = "RSA";
    static final String KEY_TYPE_DH_RSA = "DH_RSA";
    static final String KEY_TYPE_EC = "EC";
    static final String KEY_TYPE_EC_EC = "EC_EC";
    static final String KEY_TYPE_EC_RSA = "EC_RSA";
    private static final Map<String, String> KEY_TYPES = new HashMap<String, String>();
    private final OpenSslKeyMaterialProvider provider;

    /*
     * WARNING - void declaration
     */
    OpenSslKeyMaterialManager(OpenSslKeyMaterialProvider provider) {
        void var1_1;
        this.provider = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setKeyMaterialServerSide(ReferenceCountedOpenSslEngine engine) throws SSLException {
        void var2_2;
        String[] authMethods = engine.authMethods();
        if (authMethods.length == 0) {
            throw new SSLHandshakeException("Unable to find key material");
        }
        HashSet<String> typeSet = new HashSet<String>(KEY_TYPES.size());
        String[] stringArray = authMethods;
        int n = authMethods.length;
        for (int i = 0; i < n; ++i) {
            String alias;
            String authMethod = stringArray[i];
            String type = KEY_TYPES.get(authMethod);
            if (type == null || !typeSet.add(type) || (alias = this.chooseServerAlias(engine, type)) == null) continue;
            this.setKeyMaterial(engine, alias);
            return;
        }
        throw new SSLHandshakeException("Unable to find key material for auth method(s): " + Arrays.toString((Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    final void setKeyMaterialClientSide(ReferenceCountedOpenSslEngine engine, String[] keyTypes, X500Principal[] issuer) throws SSLException {
        void var3_3;
        String alias = this.chooseClientAlias(engine, keyTypes, (X500Principal[])var3_3);
        if (alias != null) {
            void var2_2;
            void var1_1;
            this.setKeyMaterial((ReferenceCountedOpenSslEngine)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setKeyMaterial(ReferenceCountedOpenSslEngine engine, String alias) throws SSLException {
        OpenSslKeyMaterial keyMaterial = null;
        try {
            void var2_4;
            keyMaterial = this.provider.chooseKeyMaterial(((ReferenceCountedOpenSslEngine)engine).alloc, (String)var2_4);
            if (keyMaterial == null) {
                if (keyMaterial == null) return;
                keyMaterial.release();
                return;
            }
        }
        catch (SSLException sSLException) {
            try {
                engine = sSLException;
                throw sSLException;
                catch (Exception e) {
                    void var1_2;
                    throw new SSLException((Throwable)var1_2);
                }
            }
            catch (Throwable throwable) {
                void var3_5;
                if (keyMaterial == null) throw throwable;
                var3_5.release();
                throw throwable;
            }
        }
        {
            ((ReferenceCountedOpenSslEngine)engine).setKeyMaterial(keyMaterial);
            if (keyMaterial == null) return;
            keyMaterial.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String chooseClientAlias(ReferenceCountedOpenSslEngine engine, String[] keyTypes, X500Principal[] issuer) {
        void var3_3;
        void var2_2;
        X509KeyManager manager = this.provider.keyManager();
        if (manager instanceof X509ExtendedKeyManager) {
            void var1_1;
            return ((X509ExtendedKeyManager)manager).chooseEngineClientAlias(keyTypes, issuer, (SSLEngine)var1_1);
        }
        return manager.chooseClientAlias((String[])var2_2, (Principal[])var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    private String chooseServerAlias(ReferenceCountedOpenSslEngine engine, String type) {
        void var2_2;
        void var3_3;
        X509KeyManager manager = this.provider.keyManager();
        if (manager instanceof X509ExtendedKeyManager) {
            void var1_1;
            return ((X509ExtendedKeyManager)manager).chooseEngineServerAlias(type, null, (SSLEngine)var1_1);
        }
        return var3_3.chooseServerAlias((String)var2_2, null, null);
    }

    static {
        KEY_TYPES.put(KEY_TYPE_RSA, KEY_TYPE_RSA);
        KEY_TYPES.put("DHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_ECDSA", KEY_TYPE_EC);
        KEY_TYPES.put("ECDH_RSA", KEY_TYPE_EC_RSA);
        KEY_TYPES.put("ECDH_ECDSA", KEY_TYPE_EC_EC);
        KEY_TYPES.put(KEY_TYPE_DH_RSA, KEY_TYPE_DH_RSA);
    }
}

