/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslSession;
import io.netty.handler.ssl.OpenSslSessionCache;
import io.netty.internal.tcnative.SSL;
import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class OpenSslClientSessionCache
extends OpenSslSessionCache {
    private final Map<HostPort, Set<OpenSslSessionCache.NativeSslSession>> sessions = new HashMap<HostPort, Set<OpenSslSessionCache.NativeSslSession>>();

    /*
     * WARNING - void declaration
     */
    OpenSslClientSessionCache(OpenSslEngineMap engineMap) {
        super((OpenSslEngineMap)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean sessionCreated(OpenSslSessionCache.NativeSslSession session) {
        void var1_1;
        void var3_3;
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(session.getPeerHost(), session.getPeerPort());
        if (hostPort == null) {
            return false;
        }
        Set<OpenSslSessionCache.NativeSslSession> sessionsForHost = this.sessions.get(hostPort);
        if (sessionsForHost == null) {
            void var2_2;
            sessionsForHost = new HashSet<OpenSslSessionCache.NativeSslSession>(4);
            this.sessions.put((HostPort)var2_2, sessionsForHost);
        }
        var3_3.add(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void sessionRemoved(OpenSslSessionCache.NativeSslSession session) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(session.getPeerHost(), session.getPeerPort());
        if (hostPort == null) {
            return;
        }
        Set<OpenSslSessionCache.NativeSslSession> sessionsForHost = this.sessions.get(hostPort);
        if (sessionsForHost != null) {
            void var3_3;
            void var1_1;
            sessionsForHost.remove(var1_1);
            if (var3_3.isEmpty()) {
                void var2_2;
                this.sessions.remove(var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final boolean setSession(long ssl, OpenSslSession session, String host, int port) {
        void var1_2;
        boolean reused;
        HostPort hostPort = OpenSslClientSessionCache.keyFor(host, port);
        if (hostPort == null) {
            return false;
        }
        OpenSslSessionCache.NativeSslSession nativeSslSession = null;
        boolean singleUsed = false;
        OpenSslClientSessionCache openSslClientSessionCache = this;
        synchronized (openSslClientSessionCache) {
            Set<OpenSslSessionCache.NativeSslSession> sessionsForHost = this.sessions.get(hostPort);
            if (sessionsForHost == null) {
                return false;
            }
            if (sessionsForHost.isEmpty()) {
                this.sessions.remove(hostPort);
                return false;
            }
            ArrayList<OpenSslSessionCache.NativeSslSession> toBeRemoved = null;
            for (OpenSslSessionCache.NativeSslSession sslSession : sessionsForHost) {
                if (sslSession.isValid()) {
                    nativeSslSession = sslSession;
                    break;
                }
                if (toBeRemoved == null) {
                    toBeRemoved = new ArrayList<OpenSslSessionCache.NativeSslSession>(2);
                }
                toBeRemoved.add(sslSession);
            }
            if (toBeRemoved != null) {
                for (OpenSslSessionCache.NativeSslSession sslSession : toBeRemoved) {
                    this.removeSessionWithId(sslSession.sessionId());
                }
            }
            if (nativeSslSession == null) {
                return false;
            }
            reused = SSL.setSession((long)ssl, (long)nativeSslSession.session());
            if (reused) {
                singleUsed = nativeSslSession.shouldBeSingleUse();
            }
        }
        if (reused) {
            void var3_4;
            if (singleUsed) {
                nativeSslSession.invalidate();
                session.invalidate();
            }
            nativeSslSession.setLastAccessedTime(System.currentTimeMillis());
            var3_4.setSessionDetails(nativeSslSession.getCreationTime(), nativeSslSession.getLastAccessedTime(), nativeSslSession.sessionId(), nativeSslSession.keyValueStorage);
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static HostPort keyFor(String host, int port) {
        void var1_1;
        String string;
        if (host == null && port <= 0) {
            return null;
        }
        return new HostPort(string, (int)var1_1);
    }

    @Override
    final synchronized void clear() {
        super.clear();
        this.sessions.clear();
    }

    private static final class HostPort {
        private final int hash;
        private final String host;
        private final int port;

        /*
         * WARNING - void declaration
         */
        HostPort(String host, int port) {
            void var2_2;
            void var1_1;
            this.host = host;
            this.port = port;
            this.hash = 31 * AsciiString.hashCode((CharSequence)var1_1) + var2_2;
        }

        public final int hashCode() {
            return this.hash;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            void var1_1;
            if (!(obj instanceof HostPort)) {
                return false;
            }
            HostPort other = (HostPort)obj;
            return this.port == other.port && this.host.equalsIgnoreCase(var1_1.host);
        }

        public final String toString() {
            return "HostPort{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

