/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSsl;
import io.netty.internal.tcnative.CertificateVerifier;
import java.security.cert.CertificateException;

public final class OpenSslCertificateException
extends CertificateException {
    private static final long serialVersionUID = 5542675253797129798L;
    private final int errorCode;

    /*
     * WARNING - void declaration
     */
    public OpenSslCertificateException(int errorCode) {
        this((String)null, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public OpenSslCertificateException(String msg, int errorCode) {
        super((String)var1_1);
        void var2_2;
        void var1_1;
        this.errorCode = OpenSslCertificateException.checkErrorCode((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public OpenSslCertificateException(String message, Throwable cause, int errorCode) {
        super((String)var1_1, (Throwable)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.errorCode = OpenSslCertificateException.checkErrorCode((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public OpenSslCertificateException(Throwable cause, int errorCode) {
        this(null, (Throwable)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    public final int errorCode() {
        return this.errorCode;
    }

    private static int checkErrorCode(int errorCode) {
        int n;
        if (OpenSsl.isAvailable() && !CertificateVerifier.isValid((int)errorCode)) {
            throw new IllegalArgumentException("errorCode '" + errorCode + "' invalid, see https://www.openssl.org/docs/man1.0.2/apps/verify.html.");
        }
        return n;
    }
}

